/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class SetupCompletePage extends AbstractWizardPage {
	
	public SetupCompletePage() {
		super("");
		setTitle(Messages.SetupCompletePage_PageTitle);
		setDescription(Messages.SetupCompletePage_PageDescription);
		setPageComplete(true);
	}

	protected String getHelpResourceName() {
		return "setup_complete";
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(1, false);
		composite.setLayout(layout);
		createMessageComposite(composite);
		setControl(composite);
	}
	
	private void createMessageComposite(Composite composite) {
		GridLayout layout = new GridLayout(1, false);
		Composite container = new Composite(composite, SWT.NONE);
		
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		container.setLayoutData(data);
		container.setLayout(layout);

		Label msgLabel = new Label(container, SWT.NULL);
		msgLabel.setText(Messages.SetupCompletePage_GuidanceMessage);
	}

	public boolean canFlipToNextPage() {
		return false;
	}

}
