/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core;

import java.util.Observable;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class PersistentPropertyManager extends Observable {
	
	private static final String QUALIFIER_URI = "";
	
	public static final String[] PROPERTY_CONNECTION_ADAPTER
									= {QUALIFIER_URI, "conect_adapter"};
	
	public static final String[] PROPERTY_SERVER_HOSTNAME
									= {QUALIFIER_URI, "hostname"};
	public static final String[] PROPERTY_SERVER_PORT
									= {QUALIFIER_URI, "portno"};

	public static final String[] PROPERTY_VERSION
									= {QUALIFIER_URI, "version"};

	public static final String[] PROPERTY_KNOWN_HOSTS
									= {QUALIFIER_URI, "known_hosts"};

	public static final String[] PROPERTY_LOGIN_USERNAME
									= {QUALIFIER_URI, "username"};	
	
	public static final String[] PROPERTY_PRIVATE_KEY
									= {QUALIFIER_URI, "privatekey"};
	
	public static final String[] PROPERTY_LOGIN_PASSWORD
									= {QUALIFIER_URI, "password"};
	
	public static final String[] PROPERTY_CCS_TOOL_DIRECTORY
									= {QUALIFIER_URI, "ccs_tool"};
	public static final String[] PROPERTY_CCS_DATA_DIRECTORY
									= {QUALIFIER_URI, "ccs_data"};
	
	public static final String[] PROPERTY_GRANTLOG
									= {QUALIFIER_URI, "grant"};
	public static final String[] PROPERTY_REJECTLOG
									= {QUALIFIER_URI, "reject"};
	
	public static final String[] PROPERTY_MANAGER_CONFIRM_CONNECT
									= {QUALIFIER_URI, "confirm_connect"};
	
	private static PersistentPropertyManager instance;

	private PersistentPropertyManager() {
	}
	
	public static PersistentPropertyManager getInstance() {
		if (instance == null)
			instance = new PersistentPropertyManager();
		return instance;
	}
	
	public void setProperty(IResource resource, String[] propertyKey, String value) {
		try {
			resource.setPersistentProperty(new QualifiedName(propertyKey[0], propertyKey[1]), value);
			setChanged();
			notifyObservers();
		} catch (CoreException e) {
			TomoyoCorePlugin.logException(e);
		}
	}
	
	public String getProperty(IResource resource, String[] propertyKey) {
		try {
			return resource.getPersistentProperty(new QualifiedName(propertyKey[0], propertyKey[1]));
		} catch (CoreException e) {
			TomoyoCorePlugin.logException(e);
			return null;
		}
	}

}
