/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model;

import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractPolicyModel extends PolicyElement {

	private IProject project;
	
	public AbstractPolicyModel(IProject project) {
		super(null, 0, 0);
		this.project = project;
	}
	
	public IProject getProject() {
		return project;
	}
	
	private boolean valid = false;
	
	public boolean isValid() {
		return valid;
	}
	
	public void setValid(boolean b) {
		this.valid = b;
	}

	public void initialize() {
		traverse(this);
	}
	
	protected void traverse(PolicyElement element) {
		element.hookTraverse();
		for (int cnt = 0; cnt < element.getChildrenCount(); cnt++) {
			PolicyElement child = element.getChild(cnt);
			traverse(child);
		}
	}

	public PolicyElement[] getElementArray() {
		ArrayList<PolicyElement> list = new ArrayList<PolicyElement>();
		_getElementArray(list, this);
		return list.toArray(new PolicyElement[list.size()]);
	}

	public void _getElementArray(ArrayList<PolicyElement> list, PolicyElement element) {
		for (int cnt = 0; cnt < element.getChildrenCount(); cnt++) {
			PolicyElement child = element.getChild(cnt);
			list.add(child);
			_getElementArray(list, child);
		}
	}

	private int size;
	
	public void setSize(int size) {
		this.size = size;
	}

	public int getSize() {
		return size;
	}

	public abstract String getPolicyModelName();
	
	public abstract ArrayList<PolicyElementDefinition> listElementDefinitions();

	public ArrayList<PolicyElementDefinition> listElementDefinitions(boolean filterOnlySupported) {
		if (filterOnlySupported) {
			ArrayList<PolicyElementDefinition> filterdList = new ArrayList<PolicyElementDefinition>();
			ArrayList<PolicyElementDefinition> definitions = listElementDefinitions();
			for (int cnt = 0; cnt < definitions.size(); cnt++) {
				PolicyElementDefinition definition = definitions.get(cnt);
				if (definition.isAvailableVersion(project))
					filterdList.add(definition);
			}
			return filterdList;
		} else {
			return listElementDefinitions();
		}
	}
	
	public String[] listSupportedDirectives() {
		ArrayList<String> directiveNames = new ArrayList<String>();
		ArrayList<PolicyElementDefinition> definitions = listElementDefinitions(true);
		for (int cnt = 0; cnt < definitions.size(); cnt++) {
			PolicyElementDefinition definition = definitions.get(cnt);
			directiveNames.add(definition.getDirectiveName());
		}
		return directiveNames.toArray(new String[directiveNames.size()]);
	}
	
	public boolean isDirectiveSupported(String directive) {
		String[] directives = listSupportedDirectives();
		for (int cnt = 0; cnt < directives.length; cnt++) {
			if (directives[cnt].equals(directive)) {
				return true;
			}
		}
		return false;
	}

	public PolicyElementDefinition findDefinition(Class elementClass) {
		ArrayList<PolicyElementDefinition> definitions = listElementDefinitions();
		for (int cnt = 0; cnt < definitions.size(); cnt++) {
			PolicyElementDefinition definition = definitions.get(cnt);
			if (elementClass.equals(definition.getElementClass()))
				return definition;
		}
		return null;
	}
	
	public PolicyElementDefinition getDefinitionByDirective(String directive) {
		ArrayList<PolicyElementDefinition> definitions = listElementDefinitions();
		for (int cnt = 0; cnt < definitions.size(); cnt++) {
			PolicyElementDefinition definition = definitions.get(cnt);
			if (directive.equals(definition.getDirectiveName()))
				return definition;
		}
		return null;
	}
	
	public String getDirectiveByElementClass(Class elementClass) {
		ArrayList<PolicyElementDefinition> definitions = listElementDefinitions();
		for (int cnt = 0; cnt < definitions.size(); cnt++) {
			PolicyElementDefinition definition = definitions.get(cnt);
			if (elementClass.equals(definition.getElementClass()))
				return definition.getDirectiveName();
		}
		return null;
	}

	public Image getElementImage(Class elementClass) {
		ArrayList<PolicyElementDefinition> definitions = listElementDefinitions();
		for (int cnt = 0; cnt < definitions.size(); cnt++) {
			PolicyElementDefinition definition = definitions.get(cnt);
			if (elementClass.equals(definition.getElementClass()))
				return definition.getImage();
		}
		return null;
	}

	public abstract Image getImage();

}
