/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class PolicyElementDefinition {
	
	private String directiveName;
	private Class<?> elementClass;
	private String caption;
	private Image image;
	private Class<?> propertySourceClass;
	private String[] versions;
	
	public PolicyElementDefinition(String directiveName, Class<?> elementClass, String caption, Image image, String[] versions) {
		this(directiveName, elementClass, caption, image, null, versions);
	}
	
	public PolicyElementDefinition(String directiveName, Class<?> elementClass, String caption, Image image, Class<?> propertySourceClass, String[] versions) {
		super();
		this.directiveName = directiveName;
		this.elementClass = elementClass;
		this.caption = caption;
		this.image = image;
		this.propertySourceClass = propertySourceClass;
		this.versions = versions;
	}
	
	public String getDirectiveName() {
		return directiveName;
	}
	
	public Class<?> getElementClass() {
		return elementClass;
	}
	
	public String getCaption() {
		return caption;
	}

	public Image getImage() {
		return image;
	}

	public Class<?> getPropertySourceClass() {
		return propertySourceClass;
	}
	
	public boolean isAvailableVersion(IProject project) {
		if (versions == null)
			return false;
		String checkVersion = Utilities.getTomoyoVersion(project);
		for (int cnt = 0; cnt < versions.length; cnt++) {
			if (versions[cnt] != null && versions[cnt].equals(checkVersion))
				return true;
		}
		return false;
	}
	public PolicyElement createElement(String strPerm, String line, int lineno, int column) {
		try {
			Constructor<?> cunstructor = elementClass.getConstructor(new Class[] { String.class, int.class, int.class });
			return (PolicyElement)cunstructor.newInstance(new Object[]{ line, new Integer(lineno), new Integer(column) });
		} catch (SecurityException e) {
			TomoyoCorePlugin.logException(e);
		} catch (NoSuchMethodException e) {
			TomoyoCorePlugin.logException(e);
		} catch (IllegalArgumentException e) {
			TomoyoCorePlugin.logException(e);
		} catch (InstantiationException e) {
			TomoyoCorePlugin.logException(e);
		} catch (IllegalAccessException e) {
			TomoyoCorePlugin.logException(e);
		} catch (InvocationTargetException e) {
			TomoyoCorePlugin.logException(e);
		}
		return null;
	}
	@SuppressWarnings("unchecked")
	public IPropertySource createPropertySource(PolicyElement element) {
		try {
			Constructor cunstructor = propertySourceClass.getConstructor(new Class[] { PolicyElement.class });
			return (IPropertySource)cunstructor.newInstance(new Object[]{ element });
		} catch (SecurityException e) {
			TomoyoCorePlugin.logException(e);
		} catch (NoSuchMethodException e) {
			TomoyoCorePlugin.logException(e);
		} catch (IllegalArgumentException e) {
			TomoyoCorePlugin.logException(e);
		} catch (InstantiationException e) {
			TomoyoCorePlugin.logException(e);
		} catch (IllegalAccessException e) {
			TomoyoCorePlugin.logException(e);
		} catch (InvocationTargetException e) {
			TomoyoCorePlugin.logException(e);
		}
		return null;
	}

	public boolean isInstance(PolicyElement child) {
		if (child == null)
			return false;
		return elementClass.equals(child.getClass());
	}

}