/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model;

import java.util.ArrayList;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.model.system.AllowChroot;
import jp.sourceforge.tomoyo.core.local.model.system.AllowMount;
import jp.sourceforge.tomoyo.core.local.model.system.DenyAutobind;
import jp.sourceforge.tomoyo.core.local.model.system.DenyUnmount;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class SystemPolicyModel extends AbstractPolicyModel {

	public SystemPolicyModel(IProject project) {
		super(project);
	}

	@Override
	public String getPolicyModelName() {
		return Messages.PolicyElementManager_Class_SystemPolicyElement;
	}

	@Override
	public Image getImage() {
		return TomoyoCorePlugin.getImage("system_policy.gif"); //$NON-NLS-1$;
	}

	private static ArrayList<PolicyElementDefinition> definitions = null;
	
	@Override
	public ArrayList<PolicyElementDefinition> listElementDefinitions() {
		if (definitions != null)
			return definitions;
		
		definitions = new ArrayList<PolicyElementDefinition>();
		
		definitions.add(new PolicyElementDefinition(
				"allow_mount", //$NON-NLS-1$
				AllowMount.class,
				"allow_mount", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"deny_unmount", //$NON-NLS-1$
				DenyUnmount.class,
				"deny_unmount", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"allow_chroot", //$NON-NLS-1$
				AllowChroot.class,
				"allow_chroot", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_1x
		));
		definitions.add(new PolicyElementDefinition(
				"deny_autobind", //$NON-NLS-1$
				DenyAutobind.class,
				"deny_autobind", //$NON-NLS-1$
				TomoyoCorePlugin.getImage("policy_element.gif"), //$NON-NLS-1$
				Utilities.T_VER_1x
		));
		
		return definitions;
	}

	@Override
	protected IPropertySource createPropertySource() {
		return null;
	}

}
