/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.status;

public class Profile {

	private int index;
	
	private String originalValue;
	
	public Profile(int index, String value) {
		super();
		this.index = index;
		this.originalValue = value;
	}
	
	public Profile(ProfileMetaData meta) {
		this(ProfileDefinition.getIndexByName(meta.getName()), null);
	}

	public int getIndex() {
		return index;
	}
	
	public void setIndex(int index) {
		this.index = index;
	}
	
	public String getValue() {
		if (updateValue == null)
			return originalValue;
		else
			return updateValue;
	}
	
	public void setValue(String value) {
		this.originalValue = value;
	}

	private String updateValue;
	
	public void setUpdateValue(String string) {
		this.updateValue = string;
	}
	
	public boolean isDirty() {
		if (originalValue == null) {
			return !(updateValue == null);
		} else {
			if (updateValue == null) {
				return false;
			} else {
				return !originalValue.equals(updateValue);
			}
		}
	}

	public void rollback() {
		updateValue = null;
	}

	public boolean needQuate() {
		return (index == 1);
	}
	
}
