/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.status;

import java.util.ArrayList;

import jp.sourceforge.tomoyo.core.Utilities;

public class ProfileDefinition {
	
	public static String[] CHOISES_0to3 = {"0", "1", "2", "3"}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	public static String[] CHOISES_0to3_TEXT = {Messages.ProfileDefinition_ChoiseMacDisabled, Messages.ProfileDefinition_ChoiseMacLearning, Messages.ProfileDefinition_ChoiseMacPermissive, Messages.ProfileDefinition_ChoiseMacEnforcing};
	
	private static String[] CHOISES_ALLOW_ENFORCE = {"0", "1"}; //$NON-NLS-1$ //$NON-NLS-2$
	private static String[] CHOISES_ALLOW_ENFORCE_TEXT = {Messages.ProfileDefinition_ChoiseAllowEnforceOff, Messages.ProfileDefinition_ChoiseAllowEnforceOn};

	private static String[] CHOISES_ENABLE = {"0", "1"}; //$NON-NLS-1$ //$NON-NLS-2$
	private static String[] CHOISES_ENABLE_TEXT = {Messages.ProfileDefinition_ChoiseEnableOff, Messages.ProfileDefinition_ChoiseEnableOn};
	
	public static String[] SIMPLE_CHOISES_01 = {"0", "1"}; //$NON-NLS-1$ //$NON-NLS-2$
	public static String[] SIMPLE_CHOISES_01_TEXT = new String[] {Messages.ProfileDefinition_ChoiseEnableOff, Messages.ProfileDefinition_ChoiseEnableOn};

	public static final String CAPABILITY_PREFIX = "MAC_FOR_CAPABILITY::"; //$NON-NLS-1$

	public static final int PROFILE_COUNT = 48;
	public static final int PROFILE_KIND_COUNT = ProfileKind.getKindCount();

	static {
		ArrayList<ProfileMetaData> metaList = new ArrayList<ProfileMetaData>();
		ProfileMetaData metaData = new ProfileMetaData("MAC_FOR_FILE"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAC_FOR_FILE);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setEditable(false);
		metaData.setVersions(Utilities.T_VER_ALL);
		metaList.add(metaData);
		/*
		 * Do not change orders. COMMENT profile must come second (indexed by 1)
		 * See Profile#needQuate()
		 */
		metaData = new ProfileMetaData("COMMENT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_COMMENT);
		metaData.setKind(ProfileKind.PROFILE_KIND_OTHERS);
		metaData.setType(new ProfileTypeText(48));
		metaData.setEditable(false);
		metaData.setVersions(Utilities.T_VER_ALL);
		metaList.add(metaData);
		metaData = new ProfileMetaData("MAC_FOR_ARGV0"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAC_FOR_ARGV0);
		metaData.setKind(ProfileKind.PROFILE_KIND_OTHERS);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("MAC_FOR_NETWORK"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_NETWORK);
		metaData.setKind(ProfileKind.PROFILE_KIND_NETWORK);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("MAC_FOR_BINDPORT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_BINDPORT);
		metaData.setKind(ProfileKind.PROFILE_KIND_NETWORK);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("MAC_FOR_CONNECTPORT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_CONNECTPORT);
		metaData.setKind(ProfileKind.PROFILE_KIND_NETWORK);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("MAC_FOR_SIGNAL"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAC_FOR_SIGNAL);
		metaData.setKind(ProfileKind.PROFILE_KIND_OTHERS);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("DENY_CONCEAL_MOUNT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_DENY_CONCEAL_MOUNT);
		metaData.setKind(ProfileKind.PROFILE_KIND_FILESYSTEM);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("RESTRICT_CHROOT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_RESTRICT_CHROOT);
		metaData.setKind(ProfileKind.PROFILE_KIND_FILESYSTEM);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("RESTRICT_MOUNT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_RESTRICT_MOUNT);
		metaData.setKind(ProfileKind.PROFILE_KIND_FILESYSTEM);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("RESTRICT_UNMOUNT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_RESTRICT_UNMOUNT);
		metaData.setKind(ProfileKind.PROFILE_KIND_FILESYSTEM);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("DENY_PIVOT_ROOT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_DENY_PIVOT_ROOT);
		metaData.setKind(ProfileKind.PROFILE_KIND_FILESYSTEM);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		{
			metaData = new ProfileMetaData("RESTRICT_PIVOT_ROOT"); //$NON-NLS-1$
			metaData.setDescription("Description is not available.");
			metaData.setKind(ProfileKind.PROFILE_KIND_FILESYSTEM);
			metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
			metaData.setVersions(Utilities.T_VER_1x);
			metaList.add(metaData);
		}
		metaData = new ProfileMetaData("TRACE_READONLY"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_TRACE_READONLY);
		metaData.setKind(ProfileKind.PROFILE_KIND_FILESYSTEM);
		metaData.setType(new ProfileTypeChoise(CHOISES_ENABLE, CHOISES_ENABLE_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("RESTRICT_AUTOBIND"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_RESTRICT_AUTOBIND);
		metaData.setKind(ProfileKind.PROFILE_KIND_NETWORK);
		metaData.setType(new ProfileTypeChoise(CHOISES_ENABLE, CHOISES_ENABLE_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("MAX_ACCEPT_FILES"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_ACCEPT_FILES);
		metaData.setKind(ProfileKind.PROFILE_KIND_LOG);
		metaData.setType(new ProfileTypeRange(0, 2048, 2048));
		metaData.setTranslator(new SimpleLogsizeTranslator(metaData));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		{
			metaData = new ProfileMetaData("MAX_ACCEPT_ENTRY"); //$NON-NLS-1$
			metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_ACCEPT_ENTRY);
			metaData.setKind(ProfileKind.PROFILE_KIND_LOG);
			metaData.setType(new ProfileTypeRange(0, 2048, 2048));
			metaData.setTranslator(new SimpleLogsizeTranslator(metaData));
			metaData.setVersions(Utilities.T_VER_ALL);
			metaList.add(metaData);
		}
		metaData = new ProfileMetaData("MAX_GRANT_LOG"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_GRANT_LOG);
		metaData.setKind(ProfileKind.PROFILE_KIND_LOG);
		metaData.setType(new ProfileTypeRange(0, 1024, 1024));
		metaData.setTranslator(new SimpleLogsizeTranslator(metaData));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("MAX_REJECT_LOG"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_REJECT_LOG);
		metaData.setKind(ProfileKind.PROFILE_KIND_LOG);
		metaData.setType(new ProfileTypeRange(0, 1024, 1024));
		metaData.setTranslator(new SimpleLogsizeTranslator(metaData));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData("TOMOYO_VERBOSE"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_TOMOYO_VERBOSE);
		metaData.setKind(ProfileKind.PROFILE_KIND_LOG);
		metaData.setType(new ProfileTypeChoise(CHOISES_ENABLE, CHOISES_ENABLE_TEXT));
		metaData.setVersions(Utilities.T_VER_ALL);
		metaList.add(metaData);
		metaData = new ProfileMetaData("ALLOW_ENFORCE_GRACE"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_MAX_ENFORCE_GRACE);
		metaData.setKind(ProfileKind.PROFILE_KIND_OTHERS);
		metaData.setType(new ProfileTypeChoise(CHOISES_ALLOW_ENFORCE, CHOISES_ALLOW_ENFORCE_TEXT));
		metaData.setVersions(Utilities.T_VER_ALL);
		metaList.add(metaData);

		metaData = new ProfileMetaData("MAC_FOR_CAPABILITY::inet_tcp_create"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_inet_tcp_create);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "inet_tcp_listen"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_inet_tcp_listen);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "inet_tcp_connect"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_inet_tcp_connect);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "use_inet_udp"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_inet_udp);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "use_inet_ip"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_inet_ip);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "use_route"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_route);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "use_packet"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_packet);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_MOUNT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_MOUNT);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_UMOUNT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_UMOUNT);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_REBOOT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_REBOOT);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_CHROOT"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_CHROOT);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_KILL"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_KILL);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_VHANGUP"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_VHANGUP);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_TIME"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_TIME);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_NICE"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_NICE);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_SETHOSTNAME"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_SETHOSTNAME);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "use_kernel_module"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_use_kernel_module);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "create_fifo"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_create_fifo);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "create_block_dev"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_create_block_dev);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "create_char_dev"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_create_char_dev);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "create_unix_socket"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_create_unix_socket);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_LINK"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_LINK);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_SYMLINK"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_SYMLINK);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_RENAME"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_RENAME);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_UNLINK"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_UNLINK);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_CHMOD"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_CHMOD);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_CHOWN"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_CHOWN);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_IOCTL"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_IOCTL);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_KEXEC_LOAD"); //$NON-NLS-1$
		metaData.setDescription(Messages.ProfileDefinition_ProfileDesc_SYS_KEXEC_LOAD);
		metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
		metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
		metaData.setVersions(Utilities.T_VER_1x);
		metaList.add(metaData);
		{
			metaData = new ProfileMetaData(CAPABILITY_PREFIX + "SYS_PIVOT_ROOT"); //$NON-NLS-1$
			metaData.setDescription("Description is not available.");
			metaData.setKind(ProfileKind.PROFILE_KIND_CAPABILITY);
			metaData.setType(new ProfileTypeChoise(CHOISES_0to3, CHOISES_0to3_TEXT));
			metaData.setVersions(Utilities.T_VER_1x);
			metaList.add(metaData);
		}
		
		meta = (ProfileMetaData[])metaList.toArray(new ProfileMetaData[metaList.size()]);
	}
	
	private static ProfileMetaData[] meta;
	
	public static String getProfileName(int idx) {
		return meta[idx].getName();
	}
	
	public static int getProfileCount() {
		return meta.length;
	}
	
	public static int getIndexByName(String strProfileName) {
		for (int cnt = 0; cnt < meta.length; cnt++) {
			if (meta[cnt].getName().equals(strProfileName))
				return cnt;
		}
		throw new IllegalArgumentException("Profile name '" + strProfileName + "' is not defineed."); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public static boolean isChoseable(int idx) {
		return (meta[idx].getType() instanceof ProfileTypeChoise);
	}
	
	public static boolean isFileAccess(int idx) {
		return (meta[idx].getKind() == ProfileKind.PROFILE_KIND_FILE);
	}
	
	public static boolean isNetwork(int idx) {
		return (meta[idx].getKind() == ProfileKind.PROFILE_KIND_NETWORK);
	}
	
	public static boolean isFilesystem(int idx) {
		return (meta[idx].getKind() == ProfileKind.PROFILE_KIND_FILESYSTEM);
	}
	
	public static boolean isLogFacility(int idx) {
		return (meta[idx].getKind() == ProfileKind.PROFILE_KIND_LOG);
	}
	
	public static boolean isCapability(int idx) {
		return (meta[idx].getKind() == ProfileKind.PROFILE_KIND_CAPABILITY);
	}
	
	public static ProfileType getType(int idx) {
		return meta[idx].getType();
	}
	
	public static String getDescription(int idx) {
		return meta[idx].getDescription();
	}
	
	public static ProfileMetaData[] getMetaData() {
		return meta;
	}
	
	public static ProfileMetaData getMetaData(int idx) {
		return meta[idx];
	}
	
	public static ProfileMetaData[] getProfileMetaData(int kindID) {
		ArrayList<ProfileMetaData> list = new ArrayList<ProfileMetaData>();
		for (int cnt = 0; cnt < meta.length; cnt++) {
			if (meta[cnt].getKind() == kindID)
				list.add(meta[cnt]);
		}
		return list.toArray(new ProfileMetaData[list.size()]);
	}

	public static String tranlateValue(ProfileMetaData data, Profile profile) {
		if (data.getType() instanceof ProfileTypeChoise) {
			ProfileTypeChoise type = (ProfileTypeChoise)data.getType();
			return type.translate(profile.getValue());
		} else {
			return profile.getValue();
		}
	}
	
}
