/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.status;

public class ProfileKind {
	
	public static final int PROFILE_KIND_FILE = 0;
	public static final int PROFILE_KIND_NETWORK = 1;
	public static final int PROFILE_KIND_FILESYSTEM = 2;
	public static final int PROFILE_KIND_LOG = 3;
	public static final int PROFILE_KIND_CAPABILITY = 4;
	public static final int PROFILE_KIND_OTHERS = 5;

	private int id;
	
	public ProfileKind(int id) {
		this.id = id;
		switch (id) {
		case PROFILE_KIND_FILE:
		case PROFILE_KIND_NETWORK:
		case PROFILE_KIND_LOG:
		case PROFILE_KIND_CAPABILITY:
		case PROFILE_KIND_OTHERS:
			break;
		default:
			throw new IllegalArgumentException();
		}
	}
	
	public String getName() {
		return getName(id);
	}
	
	public static String getName(int id) {
		switch (id) {
		case PROFILE_KIND_FILE:
			return Messages.ProfileKind_File;
		case PROFILE_KIND_NETWORK:
			return Messages.ProfileKind_Network;
		case PROFILE_KIND_FILESYSTEM:
			return Messages.ProfileKind_Filesystem;
		case PROFILE_KIND_LOG:
			return Messages.ProfileKind_Log;
		case PROFILE_KIND_CAPABILITY:
			return Messages.ProfileKind_Capability;
		case PROFILE_KIND_OTHERS:
			return Messages.ProfileKind_Others;
		}
		return null;
	}

	public static int getKindCount() {
		return 6;
	}
	
	public static String[] toArray() {
		return new String[] {
				getName(PROFILE_KIND_FILE),
				getName(PROFILE_KIND_NETWORK),
				getName(PROFILE_KIND_FILESYSTEM),
				getName(PROFILE_KIND_LOG),
				getName(PROFILE_KIND_CAPABILITY),
				getName(PROFILE_KIND_OTHERS)
		};
	}
	
}
