/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.status;

import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

import org.eclipse.core.resources.IProject;

public class ProfileManager extends Observable implements Observer {

	private static ProfileManager instance;
	
	private static Hashtable<String, ProjectProfile> projectCache
		= new Hashtable<String, ProjectProfile>();
	
	private ProfileManager() {
	}
	
	public static ProfileManager getInstance() {
		if (instance == null)
			instance = new ProfileManager();
		return instance;
	}
	
	public ProjectProfile getProjectProfile(IProject project) {
		return getProjectProfile(project, true);
	}
		
	public ProjectProfile getProjectProfile(IProject project, boolean useCache) {
		if (!useCache || projectCache.get(project.getName()) == null) {
			ProjectProfile pp = new ProjectProfile(project);
			pp.addObserver(this);
			pp.load();
			projectCache.put(project.getName(), pp);
		}
		return projectCache.get(project.getName());
	}

	public void update(Observable o, Object arg) {
		if (o instanceof ProjectProfile) {
			setChanged();
			notifyObservers(arg);
		}
	}
	
}
