/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.model.status;

public class SimpleLogsizeTranslator implements SimpleTranslator {

	private ProfileMetaData metaData;
	
	public SimpleLogsizeTranslator(ProfileMetaData metaData) {
		this.metaData = metaData;
	}
	
	public Object translate(Object input) {
		if (input == null)
			return null;
		if (metaData.getType() instanceof ProfileTypeRange) {
			ProfileTypeRange range = (ProfileTypeRange)metaData.getType();
			if (input.equals(ProfileDefinition.SIMPLE_CHOISES_01[0])) {
				return String.valueOf(range.min);
			} else {
				return String.valueOf(range.def);
			}
		}
		// no translation is done.
		return input;
	}
	
}