/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.parser;

import java.util.Observable;
import java.util.Observer;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.IPolicy;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import jp.sourceforge.tomoyo.core.local.resource.SystemPolicy;

import org.eclipse.core.resources.IProject;

public class PolicyParserManager extends Observable implements Observer {

	private static PolicyParserManager instance = null;

	private PolicyParserManager() {
	}
	
	public static PolicyParserManager getInstance() {
		if (instance == null) {
			instance = new PolicyParserManager();
			ProcResourceManager.getInstance().addObserver(instance);
		}
		return instance;
	}

	public void preload(IProject project) {
		ProcResourceSet resource = ProcResourceManager.getInstance().getProcResourceSet(project);
		if (resource.hasPolicies()) {
			if (resource.isLoading() || resource.isLoaded())
				return;
			resource.setLoading(true);
			
			if (Utilities.is20(project)) {
				parse(resource.getExceptPolicy());
				parse(resource.getDomainPolicy());
			} else {
				parse(resource.getExceptPolicy());
				parse(resource.getDomainPolicy());
				parse(resource.getSystemPolicy());
			}
			
			resource.setLoading(false);
		}
	}

	private void parse(LocalResource localResource) {
		if (localResource instanceof IPolicy) {
			PolicyParser parser = createParser(localResource);
			boolean isParsed = parser.parse();
			if (isParsed) {
				setChanged();
				notifyObservers(localResource);
			}
		}
	}
	
	private PolicyParser createParser(LocalResource localResource) {
		PolicyParser parser = null;
		if (localResource instanceof DomainPolicy)
			parser = new DomainPolicyParser(localResource);
		if (localResource instanceof ExceptPolicy)
			parser = new ExceptPolicyParser(localResource);
		if (localResource instanceof SystemPolicy)
			parser = new SystemPolicyParser(localResource);
		if (parser == null)
			throw new IllegalArgumentException("invalid resource to parse : " + localResource);
		return parser;
	}

	@Override
	public void update(Observable arg0, Object arg1) {
		if (arg0 instanceof ProcResourceManager) {
			LocalResource localResource = (LocalResource)arg1;
			parse(localResource);
			if (localResource instanceof ExceptPolicy) {
				DomainPolicy domainPolicy = ProcResourceManager.getInstance().getProcResourceSet(localResource.getProject()).getDomainPolicy();
				parse(domainPolicy);
			}
		}
	}

}
