/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.local.resource;

import jp.sourceforge.tomoyo.core.Utilities;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class ProcResourceSet {
	
	private IProject project;
	
	private DomainPolicy domainPolicy;
	private ExceptPolicy exceptPolicy;
	private SystemPolicy systemPolicy;
	
	private Status status;
	
	public ProcResourceSet(IProject project) {
		this.project = project;
	}

	public DomainPolicy getDomainPolicy() {
		if (domainPolicy == null) {
			domainPolicy = new DomainPolicy(project);
		}
		return domainPolicy;
	}

	public ExceptPolicy getExceptPolicy() {
		if (exceptPolicy == null) {
			exceptPolicy = new ExceptPolicy(project);
		}
		return exceptPolicy;
	}

	public SystemPolicy getSystemPolicy() {
		if (systemPolicy == null) {
			systemPolicy = new SystemPolicy(project);
		}
		return systemPolicy;
	}

	public Status getStatus() {
		if (status == null) {
			status = new Status(project);
		}
		return status;
	}

	public IFile getProjectFile() {
		return project.getFile(".project");
	}
	
	public LocalResource[] listLocalResource(IProject project) {
		if (Utilities.is20(project)) {
			LocalResource[] resources = new LocalResource[] {
					getDomainPolicy(),
					getExceptPolicy(),
					getStatus()
				};
				return resources;
		} else {
			LocalResource[] resources = new LocalResource[] {
					getDomainPolicy(),
					getExceptPolicy(),
					getSystemPolicy(),
					getStatus()
				};
				return resources;
		}
	}

	public String[] listLocalResourceNames(IProject project) {
		if (Utilities.is20(project)) {
			String[] resourceNames = new String[] {
					DomainPolicy.NAME,
					ExceptPolicy.NAME,
					Status.NAME,
				};
				return resourceNames;
		} else {
			String[] resourceNames = new String[] {
					DomainPolicy.NAME,
					ExceptPolicy.NAME,
					SystemPolicy.NAME,
					Status.NAME,
				};
				return resourceNames;
		}
	}

	public boolean hasPolicies() {
		if (Utilities.is20(project)) {
			return
			project.findMember(DomainPolicy.LOCAL_FILENAME) != null &&
			project.findMember(ExceptPolicy.LOCAL_FILENAME) != null;
		} else {
			return
			project.findMember(DomainPolicy.LOCAL_FILENAME) != null &&
			project.findMember(ExceptPolicy.LOCAL_FILENAME) != null &&
			project.findMember(SystemPolicy.LOCAL_FILENAME) != null;
		}
	}

	private boolean loading = false;
	
	public void setLoading(boolean b) {
		if (loading && !b)
			setLoaded(true);
		loading = b;
	}

	public boolean isLoading() {
		return loading;
	}

	private boolean loaded = false;
	
	public boolean isLoaded() {
		return loaded;
	}

	private void setLoaded(boolean b) {
		loaded = b;
	}
	
}
