/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.server;

import org.eclipse.core.resources.IProject;

public abstract class AbstractCommand implements ICommand {

	private IProject project = null;
	private int[] okSystemCodes;
	
	public AbstractCommand(IProject project, int[] okSystemCodes) {
		this.project = project;
		this.okSystemCodes = okSystemCodes;
	}

	@Override
	public IProject getProject() {
		return project;
	}

	private int sytemStatusCode = STATUS_INITIAL;

	public void setSystemStatusCode(int code) {
		this.sytemStatusCode = code;
	}
	
	@Override
	public int getSystemStatusCode() {
		return sytemStatusCode;
	}

	@Override
	public boolean isSuccessful() {
		for (int cnt = 0; cnt < okSystemCodes.length; cnt++) {
			if (okSystemCodes[cnt] == sytemStatusCode) {
				return true;
			}
		}
		return false;
	}

	private String stdout;
	
	public void setSTDOut(String string) {
		stdout = string;
	}

	public String getSTDOut() {
		return stdout;
	}

	private String stderr;
	
	public void setSTDErr(String string) {
		stderr = string;
	}

	public String getSTDErr() {
		return stderr;
	}

}
