/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.server;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;

import jp.sourceforge.tomoyo.core.Utilities;
import jp.sourceforge.tomoyo.core.extensions.IConnectionAdapter;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;

public class ConnectionManager extends Observable {
	
	private static ConnectionManager instance;
	
	private ConnectionManager() {
	}
	
	public static ConnectionManager getInstance() {
		if (instance == null)
			instance = new ConnectionManager();
		return instance;
	}

	public boolean connect(IProject project) {
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(project);
		if (connectionMgr == null)
			return false;
		if (connectionMgr.isConnected(project))
			return true;
		return connectionMgr.connect(project);
	}

	public void disConnect(IProject project) {
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(project);
		if (connectionMgr == null)
			return;
		connectionMgr.disconnect(project);
	}

	public boolean isConnected(IProject project) {
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(project);
		if (connectionMgr == null)
			return false;
		return connectionMgr.isConnected(project);
	}

	public void createSettingComposite(IProject project, Composite parent) {
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(project);
		if (connectionMgr == null)
			return;
		connectionMgr.createSettingComposite(project, parent);
	}
	
	public String getErrorMessage(IProject project) {
		IConnectionAdapter connectionMgr = Utilities.getConnectionAdapter(project);
		if (connectionMgr == null)
			return null;
		return connectionMgr.getErrorMessage(project);
	}

	private Hashtable<IProject, ArrayList<ConnectionStatus>> connectionHistoryCache
		= new Hashtable<IProject, ArrayList<ConnectionStatus>>();

	public void updateConnectionState(IProject project, boolean isConnected) {		
		ArrayList<ConnectionStatus> connectionStatusList = null;
		if (connectionHistoryCache.get(project) == null) {
			connectionStatusList = new ArrayList<ConnectionStatus>(1);
			connectionHistoryCache.put(project, connectionStatusList);
		} else {
			connectionStatusList = (ArrayList<ConnectionStatus>)
				connectionHistoryCache.get(project);
		}
		
		boolean wasConnected = wasConnected(project);
		ConnectionStatus connectionStatus = new ConnectionStatus(project, isConnected, wasConnected);
		connectionStatusList.add(connectionStatus);
		
		setChanged();
		notifyObservers(connectionStatus);
	}
	
	private boolean wasConnected(IProject project) {
		ArrayList<ConnectionStatus> connectionHistoryList
			= (ArrayList<ConnectionStatus>)connectionHistoryCache.get(project);
		if (connectionHistoryList.size() == 0)
			return false;
		ConnectionStatus connectionStatus = (ConnectionStatus)connectionHistoryList.get(connectionHistoryList.size() - 1);
		return connectionStatus.isConnected();
	}
	
}
