/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.server;

import org.eclipse.core.resources.IProject;

public class WriteCommand extends AbstractCommand {

	private String target = null;
	private String inputText = null;
	private boolean append = false;
	
	public WriteCommand(IProject project, String target, String inputText, boolean append) {
		super(project, new int[] {0});
		this.target = target;
		this.inputText = inputText;
		this.append = append;
	}

	public String getTarget() {
		return target;
	}

	public String getInputText() {
		return inputText;
	}

	public boolean isAppendMode() {
		return append;
	}
	
	private String filter;

	public String getFilter() {
		return filter;
	}

	public void setFilter(String filter) {
		this.filter = filter;
	}
	
}
