/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();

		// General preferences
		store.setDefault(GeneralPreferenceConstants.MAX_POLLING_HISTORY_CACHE_SIZE, 1000);

		// Server preference
		store.setDefault(ServerPreferenceConstants.P_CCS_TOOL_PATH, "/root/ccstools");
		store.setDefault(ServerPreferenceConstants.P_CCS_DATA_PATH, "/etc/ccs");
		store.setDefault(ServerPreferenceConstants.P_CCS_PROC_PATH, "/proc/ccs");
		
		store.setDefault(ServerAuditPreferenceConstants.CCS_AUDITD_GRANT_LOG_PATH, "/dev/null");
		store.setDefault(ServerAuditPreferenceConstants.CCS_AUDITD_REJECT_LOG_PATH, "/var/log/tomoyo/reject_log.txt");
	}

}
