/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.core.ui.propertysheet;

import java.util.ArrayList;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ElementPropertySource implements IPropertySource {
	
	private static final String PROPERTY_ID_DIRECTIVE = "id.directive"; //$NON-NLS-1$
	private static final String PROPERTY_ID_VALUE = "id.value"; //$NON-NLS-1$

	protected PolicyElement element;
	
	public ElementPropertySource(PolicyElement element) {
		this.element = element;
	}

	public Object getEditableValue() {
		return null;
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		String[] propertyIDs = getPropertyIDs();
		ArrayList<PropertyDescriptor> propertyList = new ArrayList<PropertyDescriptor>();
		for (int cnt = 0; cnt < propertyIDs.length; cnt++) {
			String propertyID = propertyIDs[cnt];
			String propertyName = getPropertyName(propertyID);
			if (propertyName != null)
				propertyList.add(new PropertyDescriptor(propertyID, propertyName));
		}
	    return propertyList.toArray(new PropertyDescriptor[propertyList.size()]);
	}

	protected String[] getPropertyIDs() {
		return new String[] {
				PROPERTY_ID_DIRECTIVE,
				PROPERTY_ID_VALUE
		};
	}

	protected String getPropertyName(String propertyID) {
		if (propertyID.equals(PROPERTY_ID_DIRECTIVE))
			return Messages.Directive;
		if (propertyID.equals(PROPERTY_ID_VALUE))
			return Messages.ElementPropertySource_Value;
		return null;
	}

	public Object getPropertyValue(Object id) {
		if (id == null)
			return null;
		if (id.equals(PROPERTY_ID_DIRECTIVE))
			return element.getText(0);
		if (id.equals(PROPERTY_ID_VALUE))
			return element.getContents();
		return null;
	}

	public boolean isPropertySet(Object id) {
		return false;
	}

	public void resetPropertyValue(Object id) {
	}

	public void setPropertyValue(Object id, Object value) {
	}

}
