/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package test;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

import org.eclipse.core.resources.IProject;

import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import junit.framework.TestCase;

public class ConnectionManagerTest extends TestCase implements Observer {
	
	//---------------------------------------------------------------------------------------------
	// Default generated test methods
	//---------------------------------------------------------------------------------------------
	
	public void testGetInstance() {
		ConnectionManager instance1 = ConnectionManager.getInstance();
		assertTrue(instance1 instanceof ConnectionManager);
		ConnectionManager instance2 = ConnectionManager.getInstance();
		assertEquals(instance1, instance2);
	}

	public void testConnect() {
		IProject testingProject = TomoyoCorePluginTest.getTestingProject();
		ConnectionManager instance = ConnectionManager.getInstance();
		
		instance.disConnect(testingProject);
		
		boolean b = instance.connect(testingProject);
		assertTrue(b);
	}

	public void testDisConnect() {
		IProject testingProject = TomoyoCorePluginTest.getTestingProject();
		ConnectionManager instance = ConnectionManager.getInstance();
		
		assertTrue(instance.isConnected(testingProject));
		instance.disConnect(testingProject);
		assertTrue(!instance.isConnected(testingProject));
	}

	public void testIsConnected() {
		IProject testingProject = TomoyoCorePluginTest.getTestingProject();
		ConnectionManager instance = ConnectionManager.getInstance();
		
		instance.disConnect(testingProject);
		assertTrue(!instance.isConnected(testingProject));
		boolean b = instance.connect(testingProject);
		assertTrue(b);
		assertTrue(instance.isConnected(testingProject));
	}

	public void testGetErrorMessage() {
		IProject testingProject = TomoyoCorePluginTest.getTestingProject();
		ConnectionManager instance = ConnectionManager.getInstance();

		instance.disConnect(testingProject);
		assertTrue(!instance.isConnected(testingProject));

		TomoyoCorePluginTest.setupProperty(
//				TomoyoCorePluginTest.MUST_CHANGE_HOSTNAME,
				"unknownHost",
				TomoyoCorePluginTest.MUST_CHANGE_USERNAME,
				TomoyoCorePluginTest.MUST_CHANGE_PORTNO,
				TomoyoCorePluginTest.MUST_CHANGE_CON_ADAPTER_SSH,
				null,
				TomoyoCorePluginTest.MUST_CHANGE_PASSWORD,
				null);
		
		assertNull(instance.getErrorMessage(testingProject));
		
		boolean b = instance.connect(testingProject);
		assertEquals(false, b);
		
		String errorMessage = instance.getErrorMessage(testingProject);
		assertNotNull(errorMessage);
		assertEquals("com.jcraft.jsch.JSchException: java.net.UnknownHostException: unknownHost", errorMessage);
		
		instance.disConnect(testingProject);
		
		TomoyoCorePluginTest.setupProperty(TomoyoCorePluginTest.MUST_CHANGE_CON_ADAPTER_SSH);
		
		boolean b2 = instance.connect(testingProject);
		assertEquals(true, b2);
		
		assertNull(instance.getErrorMessage(testingProject));
	}

	public void testUpdateConnectionState() {
		IProject testingProject = TomoyoCorePluginTest.getTestingProject();
		ConnectionManager instance = ConnectionManager.getInstance();
		
		try {
			ConnectionManager.getInstance().addObserver(this);
			
			instance.updateConnectionState(testingProject, true);
			instance.updateConnectionState(testingProject, false);
			instance.updateConnectionState(testingProject, true);
			instance.updateConnectionState(testingProject, false);
			instance.updateConnectionState(testingProject, false);
			
			assertEquals(Boolean.TRUE, connectStateList.get(0));
			assertEquals(Boolean.FALSE, connectStateList.get(1));
			assertEquals(Boolean.TRUE, connectStateList.get(2));
			assertEquals(Boolean.FALSE, connectStateList.get(3));
			assertEquals(Boolean.FALSE, connectStateList.get(4));
		} finally {
			ConnectionManager.getInstance().deleteObserver(this);
		}
	}

	private ArrayList<Boolean> connectStateList = new ArrayList<Boolean>();
	
	@Override
	public void update(Observable arg0, Object arg1) {
		IProject testingProject = TomoyoCorePluginTest.getTestingProject();
		
		ConnectionStatus status = (ConnectionStatus)arg1;
		if (testingProject.equals(status.getProject())) {
			connectStateList.add(Boolean.valueOf(status.isConnected()));
		}
	}

	//---------------------------------------------------------------------------------------------
	// Custom test methods
	//---------------------------------------------------------------------------------------------

}
