/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package test;

import org.eclipse.core.resources.IProject;

import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceSet;
import junit.framework.TestCase;

public class LocalResourceManagerTest extends TestCase {

	static ProcResourceManager instance;
	
	static IProject testingProject;
	
	//---------------------------------------------------------------------------------------------
	// Default generated test methods
	//---------------------------------------------------------------------------------------------
	
	public void testGetInstance() {
		ProcResourceManager instance1 = ProcResourceManager.getInstance();
		assertTrue(instance1 instanceof ProcResourceManager);
		ProcResourceManager instance2 = ProcResourceManager.getInstance();
		assertEquals(instance1, instance2);
		
		instance = instance1;
		testingProject = TomoyoCorePluginTest.getTestingProject();
	}

	static ProcResourceSet pr;
	
	public void testGetProjectResource() {
		pr = instance.getProcResourceSet(testingProject);
		assertNotNull(pr);
	}

	final String CCS_DIRECTY = "/etc/ccs/";
	
	public void testSynchronize() {
		assertTrue(ProcResourceManager.getInstance().synchronize(testingProject, pr.getDomainPolicy()));
		assertTrue(ProcResourceManager.getInstance().synchronize(testingProject, pr.getExceptPolicy()));
		assertTrue(ProcResourceManager.getInstance().synchronize(testingProject, pr.getSystemPolicy()));
		assertTrue(ProcResourceManager.getInstance().synchronize(testingProject, pr.getStatus()));
	}

	//---------------------------------------------------------------------------------------------
	// Custom test methods
	//---------------------------------------------------------------------------------------------
	
}
