/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.decorator;

import java.util.Observable;
import java.util.Observer;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.local.resource.DomainPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.Status;
import jp.sourceforge.tomoyo.core.local.resource.SystemPolicy;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;
import jp.sourceforge.tomoyo.ui.editor.Activator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class NavigatorLightweightLabelDecorator implements ILightweightLabelDecorator {	

	public NavigatorLightweightLabelDecorator() {
		super();
		ConnectionManager.getInstance().addObserver(new ConnectionStatusObserver());
	}
	
    private class ConnectionStatusObserver implements Observer {
		public void update(Observable o, Object arg) {
			if (arg instanceof ConnectionStatus) {
				ConnectionStatus connectionStatus = (ConnectionStatus)arg;
		    	try {
		    		connectionStatus.getProject().touch(null);
				} catch (CoreException e) {
					Activator.logException(e);
				}
			}
		}
    }

	public void decorate(Object element, IDecoration decoration) {
		if (element instanceof IProject) {
			IProject project = (IProject)element;
			if (!project.isOpen())
				return;
			if (!Activator.getDefault().isTomoyoCoreProject(project))
				return;

			ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
			String hostname = properties.getProperty(PersistentPropertyManager.PROPERTY_SERVER_HOSTNAME);
			String username = properties.getProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME);
			String suffix = " [" + username + "@" + hostname + "]" + " - " + getConnectionString(project); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			decoration.addSuffix(suffix);
		}
		if (element instanceof IFolder) {
			IFolder folder = (IFolder)element;
			IProject project = folder.getProject();
			ProjectProperty properties = ProjectPropertyManager.getInstance().getProperty(project);
			String ccsDataDir = properties.getProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY);
			if (folder.getName().equals("policy")) { //$NON-NLS-1$
				decoration.addSuffix(" - " + ccsDataDir); //$NON-NLS-1$
			}
			if (folder.getName().equals("system")) { //$NON-NLS-1$
				decoration.addSuffix(" - " + ccsDataDir); //$NON-NLS-1$
			}
		}
		if (element instanceof IFile) {
			IFile file = (IFile)element;
			if (file.getName().equals(DomainPolicy.LOCAL_FILENAME))
				decoration.addPrefix(DomainPolicy.NAME + " - "); //$NON-NLS-1$
			if (file.getName().equals(ExceptPolicy.LOCAL_FILENAME))
				decoration.addPrefix(ExceptPolicy.NAME + " - "); //$NON-NLS-1$
			if (file.getName().equals(SystemPolicy.LOCAL_FILENAME))
				decoration.addPrefix(SystemPolicy.NAME + " - "); //$NON-NLS-1$
			if (file.getName().equals(Status.LOCAL_FILENAME))
				decoration.addPrefix(Status.NAME + " - "); //$NON-NLS-1$
			
//			IFile file = (IFile)element;
//			decoration.addOverlay(Activator.getImageDescriptor("_navigate_dp_overlay.gif"), IDecoration.TOP_LEFT);
//			decoration.addOverlay(Activator.getImageDescriptor("_navigate_ep_overlay.gif"), IDecoration.TOP_RIGHT);
//			decoration.addOverlay(Activator.getImageDescriptor("_navigate_sp_overlay.gif"), IDecoration.BOTTOM_LEFT);
		}
	}
	
	private String getConnectionString(IProject project) {
		if (ConnectionManager.getInstance().isConnected(project)) {
			return Messages.getString("NavigatorLightweightLabelDecorator.SuffixConnecting"); //$NON-NLS-1$
		} else {
			return Messages.getString("NavigatorLightweightLabelDecorator.SuffixDisconnected"); //$NON-NLS-1$
		}
	}
	
	public void addListener(ILabelProviderListener listener) {
	}
	
	public void dispose() {
	}
	
	public boolean isLabelProperty(Object element, String property) {	
		return false;
	}
	
	public void removeListener(ILabelProviderListener listener) {
	}
	
}
