/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.dialog;

import java.util.Observable;
import java.util.Observer;

import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.ui.editor.Activator;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ColoringDialog extends TitleAreaDialog {

	private IProject project;
	
	public ColoringDialog(Shell parentShell, IProject project) {
		super(parentShell);
		this.project = project;
	}

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ColoringDialog_ShellTitle);
    }
    
	protected int getShellStyle() {
//		return SWT.MAX | SWT.RESIZE;
		return SWT.SHELL_TRIM;
	}

	protected Control createDialogArea(Composite parent) {
		setTitle(Messages.ColoringDialog_DialogTitle);
		setTitleImage(Activator.getImage("coloring_wiz.gif")); //$NON-NLS-1$
		
		Composite composite = (Composite)super.createDialogArea(parent);
		createSearchComposite(composite);
		return composite;
	}
	
	protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
		return super.createButton(parent, id, label, defaultButton);
	}

	private Viewer viewer;
	
	protected Control createSearchComposite(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.marginTop = 5;
		layout.marginLeft = 5;
		layout.marginRight = 5;

		container.setLayout(layout);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		viewer = createViewer(container);
	    
		createDefaultButton(container);

		restoreDefault();
		
		/*
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent,
		"jp.sourceforge.tomoyo.doc.open_coloring_dialog");
		*/		

		return container;
	}

	private void restoreDefault() {
	}

	private Viewer createViewer(Composite parent) {

	    TableViewer viewer = new TableViewer(parent, SWT.BORDER);
	    Table table = viewer.getTable();
	    table.setLinesVisible(true);
	    table.setHeaderVisible(true);
	    table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
	    
	    TableColumn column = new TableColumn(table,SWT.CENTER);
	    column.setText(Messages.ColoringDialog_ProfileGroupNo);
	    column.setWidth(50);
	    
	    column = new TableColumn(table,SWT.CENTER);
	    column.setText(Messages.ColoringDialog_CustomDescription);
	    column.setWidth(200);
	    
	    column = new TableColumn(table,SWT.CENTER);
	    column.setText(Messages.ColoringDialog_CustomForecolor);
	    column.setWidth(150);

	    column = new TableColumn(table,SWT.CENTER);
	    column.setText(Messages.ColoringDialog_CustomBackcolor);
	    column.setWidth(150);

	    viewer.setColumnProperties(COLUMN_PROPERTIES); 
	        
	    CellEditor[] editors = new CellEditor[] {
	        new TextCellEditor(table),
	        new TextCellEditor(table),
	        new ColorCellEditor(table),
	        new ColorCellEditor(table)
	    };
	    viewer.setCellEditors(editors);

	    viewer.setCellModifier(new ColoringCellModifier(viewer));
	    
	    viewer.setContentProvider(new ArrayContentProvider());
	    viewer.setLabelProvider(new ColoringLabelProvider());

	    Object input = ProfileManager.getInstance().getProjectProfile(project).toList(true);
	    viewer.setInput(input);
	    
	    return viewer;
	}

	private static final String[] COLUMN_PROPERTIES = new String[] {
		"no", //$NON-NLS-1$
		"name", //$NON-NLS-1$
		"forecolor", //$NON-NLS-1$
		"backcolor" //$NON-NLS-1$
    };
	
	
	private Button defaultButton;
	
	private void createDefaultButton(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		container.setLayout(layout);
	    GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);
	    container.setLayoutData(data);

	    Label spacer = new Label(container, SWT.NULL);
	    spacer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	    
	    defaultButton = new Button(container, SWT.NULL);
	    defaultButton.setText(Messages.ColoringDialog_DefaultButton);
	    defaultButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				handleDefaultButtonSelected();
			}
	    });
	}

	private void handleDefaultButtonSelected() {
		ProfileGroup[] groups = ProfileManager.getInstance().getProjectProfile(project).toArray(true);
		for (int cnt = 0; cnt < groups.length; cnt++) {
			ProfileGroup group = groups[cnt];
			group.saveForecolor(new RGB(0, 0, 0));
			group.saveBackcolor(new RGB(255, 255, 255));
		}
		viewer.refresh();
		observable.notifyObservers();
	}

	protected Point getInitialSize() {
		return new Point(700, 500);
	}

	//---------------------------------------------------------------------------------------
	// LabelProvider
	//---------------------------------------------------------------------------------------

	private class ColoringLabelProvider extends LabelProvider implements ITableLabelProvider, ITableColorProvider {

		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}

		public String getColumnText(Object element, int columnIndex) {
			ProfileGroup group = (ProfileGroup)element;
			String result = ""; //$NON-NLS-1$
			switch (columnIndex) {
			case 0:
				result = String.valueOf(group.getNo());
				break;
			case 1:
				result = group.getLongName();
				break;
			case 2:
				RGB rgb = group.getForecolor();
				if (rgb != null)
					result = "RGB[" + rgb.red + "," + rgb.green + "," + rgb.blue + "]"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				break;
			case 3:
				rgb = group.getBackcolor();
				if (rgb != null)
					result = "RGB[" + rgb.red + "," + rgb.green + "," + rgb.blue + "]"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				break;
			default:
				result = "?"; //$NON-NLS-1$
				break;
			}
			return result;
		}

		public Color getBackground(Object element, int columnIndex) {
			ProfileGroup group = (ProfileGroup)element;
			switch (columnIndex) {
			case 0:
			case 1:
			case 2:
			case 3:
				RGB rgb = group.getBackcolor();
				if (rgb != null)
					return Activator.getDefault().getColor(rgb);
			}
			return null;
		}

		public Color getForeground(Object element, int columnIndex) {
			ProfileGroup group = (ProfileGroup)element;
			switch (columnIndex) {
			case 0:
			case 1:
			case 2:
			case 3:
				RGB rgb = group.getForecolor();
				if (rgb != null)
					return Activator.getDefault().getColor(rgb);
			}
			return null;
		}
	}
	
	//---------------------------------------------------------------------------------------
	// CellModifier
	//---------------------------------------------------------------------------------------

	public class ColoringCellModifier implements ICellModifier {

		private TableViewer viewer;

		public ColoringCellModifier(TableViewer viewer) {
			this.viewer = viewer;
		}

		public boolean canModify(Object element, String property) {
			if (property.equals(COLUMN_PROPERTIES[2])) 
				return true;
			if (property.equals(COLUMN_PROPERTIES[3])) 
				return true;
			return false;
		}

		public Object getValue(Object element, String property) {
			ProfileGroup group = (ProfileGroup)element;
			if (property == COLUMN_PROPERTIES[0])
				return String.valueOf(group.getNo());
			if (property == COLUMN_PROPERTIES[1])
				return group.getName();
			if (property == COLUMN_PROPERTIES[2])
				return group.getForecolor();
			if (property == COLUMN_PROPERTIES[3])
				return group.getBackcolor();
		    return null;
		}

		public void modify(Object element, String property, Object value) {
			TableItem item = (TableItem)element;
			ProfileGroup group = (ProfileGroup)item.getData();
			if (property == COLUMN_PROPERTIES[0])
				;
			if (property == COLUMN_PROPERTIES[1])
				;
			if (property == COLUMN_PROPERTIES[2]) {
				if (value != null)
					group.saveForecolor((RGB)value);
			}
			if (property == COLUMN_PROPERTIES[3]) {
				if (value != null)
					group.saveBackcolor((RGB)value);
			}
			
			viewer.refresh();
			observable.notifyObservers();
		}
	}
		  
	//---------------------------------------------------------------------------------------
	// Observable object
	//---------------------------------------------------------------------------------------

	private Observable observable = new Observable() {
		public void notifyObservers() {
			super.setChanged();
			super.notifyObservers();
		}
	};
	
	public void addObserver(Observer o) {
		observable.addObserver(o);
	}
	
}
