/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.dialog;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.AccessPermission;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.ICommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewAccessPermissionDialog extends TitleAreaDialog {

	private IProject project;
	private Domain domain;
	private String strAccessPermission;
	
	public NewAccessPermissionDialog(Shell parentShell, IProject project, Domain domain) {
		this(parentShell, project, domain, null);
	}
	
	public NewAccessPermissionDialog(Shell parentShell, IProject project, Domain domain, String argAccessPermission) {
		super(parentShell);
		this.project = project;
		this.domain = domain;
		this.strAccessPermission = argAccessPermission;
	}

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.NewAccessPermissionDialog_ShellTitle);
    }
    
	protected int getShellStyle() {
//		return SWT.MAX | SWT.RESIZE;
		return SWT.SHELL_TRIM;
	}

	protected Point getInitialSize() {
		return new Point(500, 250);
	}

	@Override
	protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
		if (id == IDialogConstants.OK_ID) {
			Button okButton = super.createButton(parent, id, label, defaultButton);
			okButton.setEnabled(false);
			return okButton;
		} else {
			return super.createButton(parent, id, label, defaultButton);
		}
	}

	protected Control createDialogArea(Composite parent) {
		setTitle(Messages.NewAccessPermissionDialog_DialogTitle);
		setTitleImage(Activator.getImage("coloring_wiz.gif")); //$NON-NLS-1$
		
		Composite composite = (Composite)super.createDialogArea(parent);
		createComposite(composite);

//		accessPermissionText.setText(argDomain);
		
		initializeUI();

		/*
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent,
		"jp.sourceforge.tomoyo.doc.open_coloring_dialog");		 //$NON-NLS-1$
		*/

	    return composite;
	}
	
	private final String INPUT_NEW_ACCESS_PERMISSION = Messages.NewAccessPermissionDialog_InputNewAccessPermissionMessage;
		
	private void initializeUI() {
		if (strAccessPermission == null) {
			accessPermissionText.setText(INPUT_NEW_ACCESS_PERMISSION);
		} else {
			accessPermissionText.setText(strAccessPermission);
		}
		accessPermissionText.selectAll();
//		accessPermissionText.setSelection(accessPermissionText.getText().length());
	}

	private Text accessPermissionText;
	
	private void createComposite(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		container.setBackground(parent.getBackground());
		GridLayout layout = new GridLayout(2, false);
		container.setLayout(layout);
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);
		data.horizontalSpan = 2;
		data.horizontalIndent = 0;
		container.setLayoutData(data);
		
		Label domainIconLabel = new Label(container, SWT.NULL);
		domainIconLabel.setLayoutData(new GridData(GridData.BEGINNING));
		domainIconLabel.setImage(Activator.getImage("domain.gif")); //$NON-NLS-1$
		
		Label domainLabel = new Label(container, SWT.NULL | SWT.WRAP);
		domainLabel.setText(domain.getText());
		domainLabel.setToolTipText(domainLabel.getText());
		
		Label accessPermissionIconLabel = new Label(container, SWT.NULL);
		accessPermissionIconLabel.setLayoutData(new GridData(GridData.BEGINNING));
		accessPermissionIconLabel.setImage(Activator.getImage("resource.gif")); //$NON-NLS-1$
		
		accessPermissionText = createText(container, SWT.BORDER);
		accessPermissionText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	}
	
	private Text createText(Composite parent, int style) {
		Text text = new Text(parent, style);
		text.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				handleModifyText((Text)e.getSource());
			}
        });
		GridData data = new GridData();
//		data.horizontalIndent = 0;
//		data.verticalIndent = 0;
		text.setLayoutData(data);
		return text;
    }

	private void handleModifyText(Text eventText) {
		if (eventText == accessPermissionText) {
			handleModifyAccessPermissionText();
		}
	}

	private void handleModifyAccessPermissionText() {
		if (getButton(IDialogConstants.OK_ID) != null) {
			getButton(IDialogConstants.OK_ID).setEnabled(canSave(accessPermissionText.getText()));
		}
	}

	private boolean canSave(String argText) {
		String checkText = argText.trim();
		String[] strs = checkText.split("[\\s]+"); //$NON-NLS-1$
		if (strs.length < 2) {
			setErrorMessage(Messages.NewAccessPermissionDialog_InvalidFormatErrorMessage);
			return false;
		}
		String directive = strs[0];
		if (!getLocalResource().getModel().isDirectiveSupported(directive)) {
			setErrorMessage(Messages.NewAccessPermissionDialog_InvalidDirectiveMessage);
			return false;
		}
		if (hasDuplicateContent(domain, checkText, true)) {
			setErrorMessage(Messages.NewAccessPermissionDialog_AlreadyExistsMessage);
			return false;
		}
		setErrorMessage(null);
		setMessage(Messages.NewAccessPermissionDialog_InputOKMessage, IMessageProvider.INFORMATION);
		return true;
	}

	private boolean hasDuplicateContent(Domain domain, String strAccessPermission, boolean ignoreDeleted) {
		if (domain == null || strAccessPermission == null)
			return true;
		AccessPermission element = PolicyCacheManager.getInstance().findAccessPermission(project, domain, strAccessPermission);
		if (element == null)
			return false;
		if (element.isDeleted())
			return false;
		return true;
	}

	private boolean checkSaved(String newDomainText, String newAccessText) {
		PolicyElement savedElement = PolicyCacheManager.getInstance().findElement(project, AccessPermission.class, newAccessText);
		if (savedElement != null && savedElement.getParent() instanceof Domain) {
			Domain domain = (Domain)savedElement.getParent();
			if (domain != null) {
				return domain.getText().equals(newDomainText);
			}
		}
		return false;
	}
	protected void okPressed() {
		if (save()) {
			super.okPressed();
		} else {
			super.okPressed();
		}
	}

	private boolean save() {
		String newDomainText = domain.getText();
		String newAccessText = accessPermissionText.getText();
		LocalResource localResource = getLocalResource();
		ICommand command = CommandManager.getInstance().write(project, localResource, getInput(newDomainText, newAccessText));
		if (command.isSuccessful()) {
			if (ProcResourceManager.getInstance().synchronize(project, localResource)) {
				if (checkSaved(newDomainText, newAccessText)) {
					String message = Messages.NewAccessPermissionDialog_SaveOKMessage + " : " + newAccessText; //$NON-NLS-2$
					TomoyoCorePlugin.getDefault().setStatusMessage(message);
					return true;
				} else {
					String message = Messages.NewAccessPermissionDialog_SaveNGMessage + " : " + newAccessText; //$NON-NLS-2$
					TomoyoCorePlugin.getDefault().setStatusErrorMessage(message);
					return false;
				}
			}
		}	
		return false;
	}
	
	private String getInput(String newDomainText, String newAccessText) {
		StringBuffer input = new StringBuffer();

		input.append(newDomainText);
		input.append("\n"); //$NON-NLS-1$
		input.append(" "); //$NON-NLS-1$
		input.append(newAccessText);
		input.append("\n"); //$NON-NLS-1$
		
		return input.toString();
	}
	
	private LocalResource getLocalResource() {
		LocalResource localResource = ProcResourceManager.getInstance().getProcResourceSet(project).getDomainPolicy();
		return localResource;
	}

}
