/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form;

import java.util.Iterator;

import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.core.server.CommandManager;
import jp.sourceforge.tomoyo.core.server.WriteCommand;
import jp.sourceforge.tomoyo.ui.editor.Activator;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewDefinitionDialog extends TitleAreaDialog {

	private IProject project;
	private LocalResource localResource;
	private String directive;
	private String context;
	
	public NewDefinitionDialog(Shell parentShell, IProject project, LocalResource localResource, String directive, String context) {
		super(parentShell);
		this.project = project;
		this.localResource = localResource;
		this.directive = directive;
		this.context = context;
	}

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.NewDefinitionDialog_ShellTitle);
    }
    
	protected int getShellStyle() {
//		return SWT.MAX | SWT.RESIZE;
		return SWT.SHELL_TRIM;
	}

	protected Point getInitialSize() {
		return new Point(500, 250);
	}

	@Override
	protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
		if (id == IDialogConstants.OK_ID) {
			Button okButton = super.createButton(parent, id, label, defaultButton);
			okButton.setEnabled(false);
			return okButton;
		} else {
			return super.createButton(parent, id, label, defaultButton);
		}
	}

	protected Control createDialogArea(Composite parent) {
		setTitle(Messages.NewDefinitionDialog_DialogTitle);
		setTitleImage(Activator.getImage("coloring_wiz.gif")); //$NON-NLS-1$
		
		Composite composite = (Composite)super.createDialogArea(parent);
		createComposite(composite);

//		accessPermissionText.setText(argDomain);
		
		initializeUI();

		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent,
		"jp.sourceforge.tomoyo.doc.open_coloring_dialog");		 //$NON-NLS-1$

	    return composite;
	}
	
	private final String CHANGE_HERE = Messages.NewDefinitionDialog_InputNewDefitionMessage;

	private void initializeUI() {
		if (directive == null) {
			newElementText.setText(CHANGE_HERE);
			newElementText.selectAll();
		} else {
			if (context == null) {
				newElementText.setText(directive + " " + CHANGE_HERE);
				newElementText.setSelection(directive.length() + 1, newElementText.getText().length());
			} else {
				newElementText.setText(directive + " " + context);
				newElementText.setSelection(newElementText.getText().length());
			}
		}
	}

	private Text newElementText;
	
	private void createComposite(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		container.setBackground(parent.getBackground());
		GridLayout layout = new GridLayout(2, false);
		container.setLayout(layout);
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);
		data.horizontalSpan = 2;
		data.horizontalIndent = 0;
		container.setLayoutData(data);
		
		Label iconLabel = new Label(container, SWT.NULL);
		iconLabel.setLayoutData(new GridData(GridData.BEGINNING));
		iconLabel.setImage(Activator.getImage("resource.gif")); //$NON-NLS-1$
		
		newElementText = createText(container, SWT.BORDER);
		newElementText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	}
	
	private Text createText(Composite parent, int style) {
		Text text = new Text(parent, style);
		text.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				handleModifyText((Text)e.getSource());
			}
        });
		GridData data = new GridData();
//		data.horizontalIndent = 0;
//		data.verticalIndent = 0;
		text.setLayoutData(data);
		return text;
    }

	private void handleModifyText(Text eventText) {
		if (eventText == newElementText) {
			handleModifyElementText();
		}
	}

	private void handleModifyElementText() {
		if (getButton(IDialogConstants.OK_ID) != null) {
			getButton(IDialogConstants.OK_ID).setEnabled(canSave(newElementText.getText()));
		}
	}

	private boolean canSave(String argText) {
		String checkText = argText.trim();
		String[] strs = checkText.split("[\\s]+"); //$NON-NLS-1$
		if (strs.length < 2)
			return false;
		String directive = strs[0];
		
		if (!localResource.getModel().isDirectiveSupported(directive))
			return false;
		if (hasDuplicateContent(localResource.getModel().getDefinitionByDirective(directive), checkText, true))
			return false;

		return true;
	}

	protected boolean hasDuplicateContent(PolicyElementDefinition policyElementDefinition, String text, boolean ignoreDeleted) {
		if (policyElementDefinition == null || text == null)
			return true;
		Iterator<PolicyElement> it = PolicyCacheManager.getInstance().findElementList(project, policyElementDefinition.getElementClass()).iterator();
		while (it.hasNext()) {
			PolicyElement element = it.next();
			if (ignoreDeleted && element.isDeleted())
				continue;
			if (element.getText().equals(text))
				return true;
		}
		return false;
	}

	protected void okPressed() {
		if (save()) {
			super.okPressed();
		} else {
			super.okPressed();
		}
	}

	private boolean save() {
		String saveText = newElementText.getText();
		WriteCommand command = CommandManager.getInstance().write(project, localResource, getInput(saveText));
		if (command.isSuccessful()) {
			if (ProcResourceManager.getInstance().synchronize(project, localResource)) {
				if (checkSaved(saveText)) {
					String message = Messages.NewDefinitionDialog_SaveOKMessage + " : " + saveText; //$NON-NLS-2$
					TomoyoCorePlugin.getDefault().setStatusMessage(message);
					return true;
				} else {
					String message = Messages.NewDefinitionDialog_SaveNGMessage + " : " + saveText; //$NON-NLS-2$
					TomoyoCorePlugin.getDefault().setStatusErrorMessage(message);
					return false;
				}
			}
		}	
		return false;
	}

	private String getInput(String saveText) {
		StringBuffer input = new StringBuffer();

		input.append(saveText);
		input.append("\n"); //$NON-NLS-1$
		
		return input.toString();
	}

	private boolean checkSaved(String savingText) {
		String checkText = savingText.trim();
		String[] strs = checkText.split("[\\s]+"); //$NON-NLS-1$
		if (strs.length < 2)
			return false;
		String directive = strs[0];
		PolicyElement savedElement = PolicyCacheManager.getInstance().findElement(
				project, localResource.getModel().getDefinitionByDirective(directive).getElementClass(), savingText);
		return savedElement != null && !savedElement.isDeleted();
	}

}
