/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.domain;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.ui.editor.form.domain.DomainSearchDialog;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DomainSearchDialogObserver implements Observer {

	private TreeViewer viewer;
	
	private DomainSearchDialog dialog;
	
	public DomainSearchDialogObserver() {
	}
	
	public void setDialog(DomainSearchDialog dialog) {
		this.dialog = dialog;
		connect();
	}

	public void setViewer(TreeViewer viewer) {
		this.viewer = viewer;
	}

	private void connect() {
		if (dialog != null)
			dialog.addObserver(this);
	}

	/*	
	public void keyPressed(KeyEvent e) {
        if (e.keyCode == SWT.F2 || ((e.stateMask & SWT.CTRL) != 0 && e.keyCode == 'f')) {
        	dialog = new DomainSearchDialog(Activator.getStandardDisplay().getActiveShell());
        	dialog.addObserver(this);
        	dialog.open();
        }
        if (e.keyCode == SWT.F3) {
        	notifySearchConditionChanged(cacheText, true, cacheMatch);
        }
        if (e.keyCode == SWT.F4) {
        	notifySearchConditionChanged(cacheText, true, cacheMatch);
        }
	}

	public void keyReleased(KeyEvent e) {
	}
*/
	public void update(Observable o, Object arg) {
        Hashtable<?, ?> table = (Hashtable<?, ?>)arg;
        String search = (String)table.get("search"); //$NON-NLS-1$
        String method = (String)table.get("method"); //$NON-NLS-1$
        Boolean orient = (Boolean)table.get("orient"); //$NON-NLS-1$
        notifySearchConditionChanged(search, method, !orient.booleanValue());
	}

	private String searchText;
	private String matchingMethod;

    public String getSearchText() {
		return searchText;
	}
	
    public void notifySearchConditionChanged(boolean orientation) {
    	notifySearchConditionChanged(getSearchText(), matchingMethod, orientation);
    }
    
    public void notifySearchConditionChanged(String searchText, String method, boolean orientation) {
    	if (viewer == null || viewer.getTree().isDisposed())
    		return;
    	if (searchText == null)
    		return;
    	
    	Domain selectedDomain = null;
    	StructuredSelection selections = (StructuredSelection)viewer.getSelection();
    	if (selections.getFirstElement() instanceof Domain) {
    		selectedDomain = (Domain)selections.getFirstElement();
    	}

    	this.searchText = searchText;
    	this.matchingMethod = method;

        Object model = viewer.getInput();
        if (!(model instanceof PolicyElement))
                return;
        PolicyElement element = (PolicyElement)model;

        ArrayList<Domain> matchedDomains = new ArrayList<Domain>();

        boolean foundSelected = false;

        int childCount = element.getChildrenCount();

        for (int cnt = 0; cnt < childCount; cnt++) {
        	int childIndex;
        	if (orientation)
        		childIndex = cnt;
        	else
        		childIndex = childCount - cnt - 1;
        	PolicyElement child = element.getChild(childIndex);
        	if (child instanceof Domain) {
        		Domain domain = (Domain)child;
        		String filePath = domain.getProcessName();
        		String fileName = getFileName(filePath);
        		
        		if (method.equals("fullpath")) {
        			if (searchText.equals(filePath)) {
        				if (selectedDomain == null || foundSelected) {
        					setSelection(domain);
        					return;
        				} else {
        					matchedDomains.add(domain);
        				}
        			}
        		}
        		if (method.equals("execpath")) {
        			if (searchText.equals(fileName)) {
        				if (selectedDomain == null || foundSelected) {
        					setSelection(domain);
        					return;
        				} else {
        					matchedDomains.add(domain);
        				}
        			}
        		}
        		if (method.equals("includes")) {
        			if (filePath.indexOf(searchText) > -1 ) {
        				if (selectedDomain == null || foundSelected) {
        					setSelection(domain);
        					return;
        				} else {
        					matchedDomains.add(domain);
        				}
        			}
        		}
                
        		if (selectedDomain != null && selectedDomain.equals(domain))
        			foundSelected = true;
        	}
        }
        
        if (matchedDomains.size() > 0) {
            setSelection((Domain)matchedDomains.get(0));
        }

    	if (dialog != null)
    		dialog.notifyFound(matchedDomains.size());
    };

	public void setSelection(Domain domain) {
		StructuredSelection selection = new StructuredSelection(domain);
		viewer.setSelection(selection);
		viewer.reveal(selection.getFirstElement());
		viewer.refresh();
	}
	
    private String getFileName(String filePath) {
    	int lastidx = filePath.lastIndexOf("/"); //$NON-NLS-1$
        if (lastidx > 0)
        	return filePath.substring(lastidx + 1);
        else
        	return filePath;
    }

}
