/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.outline;

import java.util.ArrayList;

public class ProjectOutlineElement {
	
	private ProjectOutlineElement parent = null;
	private ArrayList<ProjectOutlineElement> children = new ArrayList<ProjectOutlineElement>();

	private ArrayList<Integer> countList = new ArrayList<Integer>();
	
	public void setCount(int count) {
		if (countList.size() == 0) {
			countList.add(new Integer(count));
		} else {
			Integer oldcnt = (Integer)countList.get(countList.size() - 1);
			if (oldcnt.intValue() != count) {
				countList.add(new Integer(count));
			}
		}
	};

	public int getOldCount() {
		if (countList.size() > 1) {
			Integer oldCount = (Integer)countList.get(countList.size() - 2);
			return oldCount.intValue();
		} else {
			return 0;
		}
	}

	public void resetLocalUpdated() {
		countList.clear();
	}

	public boolean isLocalUpdated() {
		return countList.size() > 1;
	}

	private int serverUpdatedCount = 0;
	
	public void setServerUpdatedCount(int count) {
		if (count > 0)
			this.serverUpdatedCount = count;
	}

	public void clearServerUpdatedCount() {
		this.serverUpdatedCount = 0;
	}
	
	public boolean isServerUpdated() {
		return (serverUpdatedCount > 0);
	}

	public int getServerUpdatedCount() {
		return serverUpdatedCount;
	}
	
	public ProjectOutlineElement() {	
	}
	
	private Object object;
	
	public ProjectOutlineElement(Object object) {
		this.object = object;
	}

	public Object getObject() {
		return object;
	}
	
	public void addChild(ProjectOutlineElement child) {
		children.add(child);
		child.setParent(this);
	}

	public void removeChild(ProjectOutlineElement child) {
		children.remove(child);
		if (child != null)
			child.setParent(null);
	}
	
	public int getChildCount() {
		return children.size();
	}

	public ProjectOutlineElement getChild(int index) {
		return children.get(index);
	}

	public ProjectOutlineElement[] getChildren() {
		return children.toArray(new ProjectOutlineElement[children.size()]);
	}
	
	public boolean hasChildren() {
		return children.size() > 0;
	}
	
	public void setParent(ProjectOutlineElement parent) {
		this.parent = parent;
	}
	
	public ProjectOutlineElement getParent() {
		return parent;
	}
	
	public void removeChildren() {
		children.clear();
	}

}