/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.form.profile;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

import jp.sourceforge.tomoyo.core.local.model.status.Profile;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileDefinition;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileGroup;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileKind;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileManager;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileMetaData;
import jp.sourceforge.tomoyo.core.local.model.status.ProfileTypeChoise;
import jp.sourceforge.tomoyo.core.local.model.status.ProjectProfile;
import jp.sourceforge.tomoyo.ui.editor.Activator;

public class ProfileViewerLabelProvider implements ITableLabelProvider, ITableColorProvider, ITableFontProvider {

	private IProject project;
	private TreeViewer viewer;

	public ProfileViewerLabelProvider(IProject project, TreeViewer viewer) {
		super();
		this.project = project;
		this.viewer = viewer;
	}

	protected void cacheImages() {
	}

	//----------------------------------------------------------------------------------------------
	// Implements ITableLabelProvider
	//----------------------------------------------------------------------------------------------

	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		if (columnIndex == 0) {
			if (element instanceof Integer) {
				Integer id = (Integer)element;
				return ProfileKind.getName(id.intValue());
			}
			if (element instanceof ProfileMetaData) {
				ProfileMetaData meta = (ProfileMetaData)element;
				return meta.getShortName();
			}
			if (element instanceof String) {
				return Messages.ProfileViewerLabelProvider_Customized;
			}
			if (element instanceof Class) {
				Class elementClass = (Class)element;
				if (elementClass.equals(String.class)) {
					return Messages.ProfileViewerLabelProvider_CustomizedDescription;
				}
				if (elementClass.equals(ForeColor.class)) {
					return Messages.ProfileViewerLabelProvider_CustomizedForecolor;
				}
				if (elementClass.equals(BackColor.class)) {
					return Messages.ProfileViewerLabelProvider_CustomizedBackcolor;
				}
			}
		} else {
			if (element instanceof ProfileMetaData) {
				ProfileMetaData meta = (ProfileMetaData)element;
				ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(project);
				if (pp.getGroupCount() >= columnIndex) {
					ProfileGroup group = pp.toArray(true)[columnIndex - 1];
					Profile profile = group.getProfile(meta);
					if (profile != null) {
						return ProfileDefinition.tranlateValue(meta, profile);
					}
				}
			}
			if (element instanceof Class) {
				Class elementClass = (Class)element;
				ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(project);
				if (pp.getGroupCount() >= columnIndex) {
					ProfileGroup group = pp.getGroup(column2no(columnIndex));
					if (elementClass.equals(ForeColor.class)) {
						RGB rgb = group.getForecolor();
						if (rgb != null)
							return "RGB[" + rgb.red + "," + rgb.green + "," + rgb.blue + "]"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					}
					if (elementClass.equals(BackColor.class)) {
						RGB rgb = group.getBackcolor();
						if (rgb != null)
							return "RGB[" + rgb.red + "," + rgb.green + "," + rgb.blue + "]"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
					}
					if (elementClass.equals(String.class)) {
						String username = group.getDescription();
						if (username == null)
							return ""; //$NON-NLS-1$
						else
							return username;
					}
				}
			}
		}
		return null;
	}

	private int column2no(int columnIndex) {
		try {
			Object[] properties = viewer.getColumnProperties();
			int column = Integer.parseInt(properties[columnIndex].toString());
			return column;
		} catch (NumberFormatException e) {
			return -1;
		}
		/*
		TableColumn tableColumn = viewer.getTableTree().getTable().getColumn(columnIndex);
		Integer columnInteger = (Integer)tableColumn.getData();
		return columnInteger.intValue();
		*/
	}

	public Color getBackground(Object element, int columnIndex) {
		if (columnIndex > 0) {
			if (element instanceof ProfileMetaData) {
				ProfileMetaData meta = (ProfileMetaData)element;
				ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(project);
				ProfileGroup group = pp.toArray(true)[columnIndex - 1];
				Profile profile = group.getProfile(meta);
				if (profile != null) {
					if (profile.isDirty()) {
						return Activator.getStandardDisplay().getSystemColor(SWT.COLOR_GRAY);
					}
				}
			}
		}
		return null;
	}

	public Color getForeground(Object element, int columnIndex) {
		if (columnIndex > 0) {
			if (element instanceof ProfileMetaData) {
				ProfileMetaData meta = (ProfileMetaData)element;
				ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(project);
				ProfileGroup group = pp.toArray(true)[columnIndex - 1];
				Profile profile = group.getProfile(meta);
				if (profile != null) {
					if (meta.getType() instanceof ProfileTypeChoise) {
						if (profile.getValue() == null)
							return null;
						int value = Integer.parseInt(profile.getValue());
						switch (value) {
						case 0:
							return Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLACK);
						case 1:
							return Activator.getStandardDisplay().getSystemColor(SWT.COLOR_BLUE);
						case 2:
							return Activator.getStandardDisplay().getSystemColor(SWT.COLOR_MAGENTA);
						case 3:
							return Activator.getStandardDisplay().getSystemColor(SWT.COLOR_RED);
						}
					}
				}
			}
		}
		return null;
	}

	public void addListener(ILabelProviderListener listener) {
	}

	public void dispose() {
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
	}

	//----------------------------------------------------------------------------------------------
	// Implements ITableFontProvider
	//----------------------------------------------------------------------------------------------
	
	public Font getFont(Object element, int columnIndex) {
		if (columnIndex == 0) {
		} else {
			if (element instanceof ProfileMetaData) {
				ProfileMetaData meta = (ProfileMetaData)element;
				ProjectProfile pp = ProfileManager.getInstance().getProjectProfile(project);
				ProfileGroup group = pp.toArray(true)[columnIndex - 1];
				Profile profile = group.getProfile(meta);
				if (profile != null) {
					if (profile.isDirty()) {
						Font defaultFont = viewer.getTree().getFont();
				   		FontData fontData = defaultFont.getFontData()[0];
						fontData.setStyle(SWT.ITALIC);
//				   		fontData.setStyle(SWT.BOLD);
						return new Font(Activator.getStandardDisplay(), fontData);
					}
				}
			}
		}
		return null;
	}

}
