/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import jp.sourceforge.tomoyo.ui.editor.Activator;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.EditorActionBarContributor;

public class DomainPolicyEditorActionBarContributor extends EditorActionBarContributor {

	private ExpandCollapseAction action;
	
	public DomainPolicyEditorActionBarContributor() {
		action = new ExpandCollapseAction();
	}

	public void contributeToToolBar(IToolBarManager toolBarManager) {
		toolBarManager.add(action);
		// slot for adding other actions
		toolBarManager.add(new GroupMarker("toolBar_group"));
	}
	
	public void contributeToMenu(IMenuManager menuManager) {
		// menu path for adding other actions
		MenuManager manager = new MenuManager("DomainEditorAction","menuManager");
		manager.add(action);
		// slot for adding other actions
		manager.add(new Separator("menu_slot"));
		menuManager.add(manager);
	}
	
	private class ExpandCollapseAction extends Action {
		public ExpandCollapseAction(){
			super("Expand / Collapse editor foldings", SWT.TOGGLE);
			setToolTipText(getText());
			setImageDescriptor(Activator.getImageDescriptor("folding.gif"));
		}
		public void run() {
			IEditorPart editorPart = getPage().getActiveEditor();
			if (editorPart instanceof CoreEditor) {
//				CoreEditor editor = (CoreEditor)editorPart;
			}
		}
	}
	  
}
