/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.domain;

import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.PolicySourceViewerConfiguration;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.FileEditorInput;

public class DomainPolicySourceViewerConfiguration extends PolicySourceViewerConfiguration {

	public DomainPolicySourceViewerConfiguration(PolicyEditor editor) {
		super(editor);
	}	

	public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
		return new String[] {
			IDocument.DEFAULT_CONTENT_TYPE
		};
	}
	
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
		PresentationReconciler reconciler = new PresentationReconciler();

		// create damager and repairer.
		DefaultDamagerRepairer dr = new DefaultDamagerRepairer(
			new DomainPolicyKeywordScanner(
					((FileEditorInput)getEditor().getEditorInput()).getFile().getProject()
			)
		);
		reconciler.setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);

		return reconciler;
	}

	public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
		// Create content assistant
		ContentAssistant assistant = new ContentAssistant();
		assistant.enableAutoInsert(true);

		assistant.setInformationControlCreator(getInformationControlCreator(sourceViewer));
		
		assistant.enableAutoActivation(true); 
		assistant.setAutoActivationDelay(500);
		assistant.setProposalPopupOrientation(IContentAssistant.PROPOSAL_OVERLAY);
		assistant.setContextInformationPopupOrientation(IContentAssistant.CONTEXT_INFO_ABOVE);
		assistant.setContextInformationPopupBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));

		// Return the content assistant   
		return assistant;
	}
    
	/* (non-Javadoc)
     * @see org.eclipse.jface.text.source.SourceViewerConfiguration#getReconciler(org.eclipse.jface.text.source.ISourceViewer)
     */
    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        DomainPolicyReconcilingStrategy strategy = new DomainPolicyReconcilingStrategy();
        strategy.setEditor(getEditor());
        
        MonoReconciler reconciler = new MonoReconciler(strategy,false);
        
        return reconciler;
    }
    
	public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
		return new TEAnnotationHover();
	}
	
	public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
		return new PolicyTextHover();
	}

	public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
		return new PolicyTextHover();
	}    
	
	public class PolicyTextHover implements ITextHover {
		public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
			return new Region(offset, 0);
		}

		public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
			StringBuffer message = new StringBuffer();
			if (hoverRegion != null) {				
//					SimpleNode[] nodes = ParserManager.getInstance().findDefinition(
//							((FileEditorInput)editor.getEditorInput()).getFile().getProject(),
//							selection
//					);				
					
//					message.append(nodes[0].getToken().image + " : " + nodes[0].getName());
	//				message.append("\n");
//					message.append("File : " + nodes[0].getToken().file);
	//				message.append("\n");
//					message.append("Line : " + nodes[0].getToken().beginLine);
	//				message.append(" ");
//					message.append("Column : " + nodes[0].getToken().beginColumn);
					
//					if (selection.getToken() == null)
//						return "";
//					else
						return message.toString();
			}
			return "Can't locate definition. Sorry. --;"; 
		}
	}
	
	private class TEAnnotationHover implements IAnnotationHover {
		public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
			IDocument document = sourceViewer.getDocument();
			try {
				IRegion info = document.getLineInformation(lineNumber);
				return document.get(info.getOffset(), info.getLength());
			} catch (BadLocationException x) {
			}
			return null;
		}
	}

}
