/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.except;

import java.util.Hashtable;

import jp.sourceforge.tomoyo.core.local.model.domain.Domain;
import jp.sourceforge.tomoyo.core.local.resource.ExceptPolicy;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.CoreEditor;
import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlinePage;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.Position;

/**
 * This class implements the User editor.
 */
public class ExceptPolicyEditor extends PolicyEditor {

	public ExceptPolicyEditor(CoreEditor editor) {
		super(editor);
		
		setSourceViewerConfiguration(new ExceptPolicySourceViewerConfiguration(this));
	}

	//------------------------------------------------------------------------------------------------
	// Adapters
	//------------------------------------------------------------------------------------------------

	/**
     * Returns the content outline.
     */
    protected PolicyOutlinePage getContentOutline() {
    	if (outline == null) {
			outline = new ExceptPolicyOutlinePage(this);
        }
    	return outline;
    }
    
	//------------------------------------------------------------------------------------------------
	// Document model
	//------------------------------------------------------------------------------------------------
	
    public IAdaptable getDocumentModel() {
    	ExceptPolicy exceptPolicy = ProcResourceManager.getInstance().getProcResourceSet(getProject()).getExceptPolicy();
		return exceptPolicy.getModel();
    }

	@Override
	public void updateFoldingStructure(Hashtable<Domain, Position> positions) {
	}

}
