/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.eclipse.core.resources.IProject;

import jp.sourceforge.tomoyo.core.local.model.PolicyCacheManager;
import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.model.AbstractPolicyModel;
import jp.sourceforge.tomoyo.ui.editor.text.outline.ExceptPolicyOutlineContentProvider;

public class ExceptPolicyOutlineContentProvider extends PolicyOutlineContentProvider {

	private IProject project;
	
	public ExceptPolicyOutlineContentProvider(IProject project) {
		this.project = project;
	}
	
	public Object[] getChildren(Object parent) {
		if (parent instanceof AbstractPolicyModel) {
			ArrayList<Object> children = new ArrayList<Object>();
			AbstractPolicyModel model = (AbstractPolicyModel)parent;
			ArrayList<PolicyElementDefinition> elementDefinitions = model.listElementDefinitions(true);
	    	for (int cnt = 0; cnt < elementDefinitions.size(); cnt++) {
	    		PolicyElementDefinition definition = elementDefinitions.get(cnt);
    			children.add(definition);
	    	}
			Collections.sort(children, sorter);
			return children.toArray();
		}
		if (parent instanceof PolicyElementDefinition[]) {
			ArrayList<PolicyElement> children = new ArrayList<PolicyElement>();
			PolicyElementDefinition[] defArray = (PolicyElementDefinition[])parent;
			for (int cnt = 0; cnt < defArray.length; cnt++) {
				PolicyElementDefinition definition = defArray[cnt];
				List<PolicyElement> retlist = PolicyCacheManager.getInstance().findElementList(project, definition.getElementClass());
				filterDeleted(retlist, children);
			}
			Collections.sort(children, sorter);
			return children.toArray();
		}
		if (parent instanceof PolicyElementDefinition) {
			ArrayList<PolicyElement> children = new ArrayList<PolicyElement>();
			PolicyElementDefinition definition = (PolicyElementDefinition)parent;
			if (definitionVisible) {
				ArrayList<PolicyElement> list = (ArrayList<PolicyElement>)PolicyCacheManager.getInstance().findElementList(project, definition.getElementClass());
				filterDeleted(list, children);
			}
			Collections.sort(children, sorter);
			return children.toArray();
		}
		return new Object[0];
	}
	
	private Comparator<Object> sorter = new Comparator<Object>() {
		public int compare(Object obj1, Object obj2) {
			String str1 = toString(obj1);
			String str2 = toString(obj2);
			try {
				return str1.compareTo(str2);
			} catch (NullPointerException e) {
				return 0;
			}
		}
		private String toString(Object obj) {
			if (obj instanceof PolicyElementDefinition) {
				PolicyElementDefinition definition = (PolicyElementDefinition)obj;
				return definition.getDirectiveName();
			}
			if (obj instanceof PolicyElement) {
				PolicyElement element = (PolicyElement)obj;
				return element.getText();
			}
			return obj.toString();
		}
	};

	private void filterDeleted(List<PolicyElement> elementList, ArrayList<PolicyElement> retlist) {
		for (int cnt = 0; cnt < elementList.size(); cnt++) {
			PolicyElement child = (PolicyElement)elementList.get(cnt);
			if (child.isDeleted())
				continue;
			retlist.add(child);
		}
	}

	//----------------------------------------------------------------------------------
	// Decorating
	//----------------------------------------------------------------------------------
	
	private boolean definitionVisible = false;
	
	public void setDefinitionVisible(boolean b) {
		definitionVisible = b;
	}

}
