/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.ui.editor.text.system;

import jp.sourceforge.tomoyo.core.local.model.PolicyElement;
import jp.sourceforge.tomoyo.core.local.model.PolicyElementDefinition;
import jp.sourceforge.tomoyo.core.local.resource.LocalResource;
import jp.sourceforge.tomoyo.core.local.resource.ProcResourceManager;
import jp.sourceforge.tomoyo.ui.editor.form.DefinitionPolicyViewerKeyListener;
import jp.sourceforge.tomoyo.ui.editor.text.PolicyEditor;
import jp.sourceforge.tomoyo.ui.editor.text.outline.ExceptPolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.ExceptPolicyOutlineLabelProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineContentProvider;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlineMenuListener;
import jp.sourceforge.tomoyo.ui.editor.text.outline.PolicyOutlinePage;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SystemPolicyOutlinePage extends PolicyOutlinePage {

	public SystemPolicyOutlinePage(PolicyEditor editor) {
		super(editor);
	}

	protected PolicyOutlineContentProvider createContentProvider() {
		ExceptPolicyOutlineContentProvider labelProvider = new ExceptPolicyOutlineContentProvider(getProject());
		labelProvider.setDefinitionVisible(true);
		return labelProvider;
	}

	protected IBaseLabelProvider createLabelProvider() {
		return new ExceptPolicyOutlineLabelProvider(getProject());
	}

	protected void handleInputChanged() {
		getTreeViewer().collapseAll();
	}

	@Override
	protected void setupViewer() {
		super.setupViewer();
		
		getTreeViewer().getControl().addKeyListener(
				new DefinitionPolicyViewerKeyListener(getProject(), getTreeViewer(), 
						ProcResourceManager.getInstance().getProcResourceSet(getProject()).getSystemPolicy()));
	}

	@Override
	protected IMenuListener createMenuListener() {
		return new PolicyOutlineMenuListener(editor.getProject(), getTreeViewer()) {
			@Override
			public void menuAboutToShow(IMenuManager manager) {

				String directive = null;
				String context = null;
				IStructuredSelection selection = getSelection(viewer);
				if (selection.getFirstElement() instanceof PolicyElement) {
					PolicyElement policyElement = (PolicyElement)selection.getFirstElement();
					directive = policyElement.getDirective();
				}
				if (selection.getFirstElement() instanceof PolicyElementDefinition) {
					PolicyElementDefinition definition = (PolicyElementDefinition)selection.getFirstElement();
					directive = definition.getDirectiveName();
				}
				
				manager.add(createCreateDefinitionAction(getLocalResource(), directive, context));
				manager.add(new Separator());
				
				super.menuAboutToShow(manager);
			}
			;
		};
	}

	private LocalResource getLocalResource() {
		return ProcResourceManager.getInstance().getProcResourceSet(getProject()).getSystemPolicy();
	}
	
}
