#! /bin/sh
#
# This is a kernel build script for Fedora Core 5's 2.6.20 kernel.
#

die () {
    echo $1
    exit 1
}

cd /tmp/ || die "Can't chdir to /tmp/ ."

if [ ! -r kernel-2.6.20-1.2320.fc5.src.rpm ]
then
    wget http://ftp.riken.jp/Linux/fedora/core/updates/5/SRPMS/kernel-2.6.20-1.2320.fc5.src.rpm || die "Can't download source package."
fi
rpm --checksig kernel-2.6.20-1.2320.fc5.src.rpm || die "Can't verify signature."
rpm -ivh kernel-2.6.20-1.2320.fc5.src.rpm || die "Can't install source package."

cd /usr/src/redhat/SOURCES/ || die "Can't chdir to /usr/src/redhat/SOURCES/ ."
if [ ! -r ccs-patch-1.7.2-20100412.tar.gz ]
then
    wget http://sourceforge.jp/frs/redir.php?f=/tomoyo/43375/ccs-patch-1.7.2-20100412.tar.gz || die "Can't download patch."
fi

cd /tmp/ || die "Can't chdir to /tmp/ ."
cp -p /usr/src/redhat/SPECS/kernel-2.6.spec . || die "Can't copy spec file."
patch << "EOF" || die "Can't patch spec file."
--- kernel-2.6.spec	2007-06-13 05:34:55.000000000 +0900
+++ kernel-2.6.spec	2008-04-16 12:09:56.000000000 +0900
@@ -33,7 +33,7 @@
 %define sublevel 20
 %define kversion 2.6.%{sublevel}
 %define rpmversion 2.6.%{sublevel}
-%define release %(R="$Revision: 1.2320 $"; RR="${R##: }"; echo ${RR%%?})%{?dist}
+%define release %(R="$Revision: 1.2320 $"; RR="${R##: }"; echo ${RR%%?})%{?dist}.fc5_tomoyo_1.7.2
 %define signmodules 0
 %define xen_hv_cset 11774
 %define make_target bzImage
@@ -196,6 +196,9 @@
 # to versions below the minimum
 #
 
+# TOMOYO Linux
+%define signmodules 0
+
 #
 # First the general kernel 2.6 required versions as per
 # Documentation/Changes
@@ -221,7 +224,7 @@
 #
 %define kernel_prereq  fileutils, module-init-tools, initscripts >= 8.11.1-1, mkinitrd >= 4.2.21-1
 
-Name: kernel
+Name: ccs-kernel
 Group: System Environment/Kernel
 License: GPLv2
 Version: %{rpmversion}
@@ -1208,6 +1211,11 @@
 
 # END OF PATCH APPLICATIONS
 
+# TOMOYO Linux
+tar -zxf $RPM_SOURCE_DIR/ccs-patch-1.7.2-20100412.tar.gz
+# sed -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = -1.2320.fc5/" -- Makefile
+patch -sp1 < patches/ccs-patch-2.6.20-fedora-core-5.diff
+
 cp %{SOURCE10} Documentation/
 
 mkdir configs
@@ -1226,6 +1234,9 @@
 for i in *.config
 do
   mv $i .config
+  # TOMOYO Linux
+  cat config.ccs >> .config
+  sed -i -e "s/^CONFIG_DEBUG_INFO=.*/# CONFIG_DEBUG_INFO is not set/" -- .config
   Arch=`head -1 .config | cut -b 3-`
   make ARCH=$Arch nonint_oldconfig > /dev/null
   echo "# $Arch" > configs/$i
EOF
mv kernel-2.6.spec ccs-kernel.spec || die "Can't rename spec file."
echo ""
echo ""
echo ""
echo "Edit /tmp/ccs-kernel.spec if needed, and run"
echo "rpmbuild -bb /tmp/ccs-kernel.spec"
echo "to build kernel rpm packages."
echo ""
echo "I'll start 'rpmbuild -bb --target i586 /tmp/ccs-kernel.spec' in 30 seconds. Press Ctrl-C to stop."
sleep 30
patch << "EOF" || die "Can't patch spec file."
--- /tmp/ccs-kernel.spec
+++ /tmp/ccs-kernel.spec
@@ -3,16 +3,16 @@
 # What parts do we want to build?  We must build at least one kernel.
 # These are the kernels that are built IF the architecture allows it.
 
-%define buildup 1
+%define buildup 0
 # Only used on archs without run-time support (ie ppc, sparc64)
-%define buildsmp 0
+%define buildsmp 1
 %define buildpae 0
 # Whether to apply the Xen patches, leave this enabled.
 %define includexen 1
 # Whether to build the Xen kernels, disable if you want.
-%define buildxen 1
+%define buildxen 0
 %define builddoc 0
-%define buildkdump 1
+%define buildkdump 0
 %define buildheaders 0
 %define builddebug 0
 
EOF
exec rpmbuild -bb --target i586 /tmp/ccs-kernel.spec
exit 0
