// Paq32.dll
// $Id: CArchiver.cpp,v 1.4 2006/03/28 07:35:29 sirakaba Exp $

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "StdAfx.h"
#include "Classes.h"
#include "CArchiver.h"
#include "function.h"
#include "inuse.h"
#include "resource.h"

#include "PAQAR.cpp"

//******************************************************************************
//    }N`
//******************************************************************************

// G[
#define err_chkt(a, b)     if ((a))        return (b);
#define err_true(a, b, c)  if ((a) == (b)) return (c);
#define err_chkf(a, b)     if (! (a))      return (b);
#define err_false(a, b, c) if ((a) != (b)) return (c);

//******************************************************************************
//    o֐ (Archive)
//******************************************************************************

// fXgN^B
API_NAME(Archive)::~API_NAME(Archive)()
{
	if (this->fp)
	{
		// G[B
		fclose(this->fp);
	}
}

// ݉\ŊJB
int API_NAME(Archive)::Open(API_NAME(ArchiveInfo) pai)
{
	// ݒeRs[B
	this->paiInfo = pai;

	// ɂtpXŎ擾B
	{
		char szArchiveFull[sizeof(this->paiInfo.szArchiveName)];
		_fullpath(szArchiveFull, this->paiInfo.szArchiveName, sizeof(szArchiveFull) - 1);
		memset(this->paiInfo.szArchiveName, 0, sizeof(this->paiInfo.szArchiveName));
		strncpy(this->paiInfo.szArchiveName, szArchiveFull, sizeof(this->paiInfo.szArchiveName) - 1);
	}

	// ɂɑ݂邩mFB
	struct _stati64 stInfo;
	if (_stati64(this->paiInfo.szArchiveName, & stInfo) == 0)
	{
		// Note :
		// ɂɑ݂ꍇ́AǂݏpŊJB
		// ĉʏ̓ł邪A`̎dlƂĒǉi[͂łȂB
		// āAi[ړIƂďɂJꍇɂ͏㏑mFsB
		//
		// ł΂łOwnerWindowɓnĊmF߂Ƃł邪A
		// ŏɂ̑݃`FbNsĂ\ɂ߂ĒႭAdlł肪邱ƂA
		// GW̑Ń_CAO\dlɂȂĂB
		PAQ_ENUM_MEMBER_INFO64 pemi;
		memset(& pemi, 0, sizeof(PAQ_ENUM_MEMBER_INFO64));
		strncpy(pemi.szAddFileName, this->paiInfo.szArchiveName, sizeof(pemi.szAddFileName) - 1);
		pemi.llCompressedSize = stInfo.st_size;
		pemi.llOriginalSize = 0;

		// ㏑mF_CAOŏ𒆒fIsꍇ́AŏIB
		err_chkf(DialogBoxParam(hDLL, MAKEINTRESOURCE(ID_DLG_CONFIRM), this->cbProc.sProgress.hwDialog, ConfirmDialogProc, (LPARAM) & pemi), -1L)
		strncpy(this->paiInfo.szArchiveName, pemi.szAddFileName, sizeof(this->paiInfo.szArchiveName) - 1);
	}

	// UDA ł͏ݑ̑SĂɑΉĂȂ̂ŁAŒeB
	err_chkt(ARCHIVETYPE_UDA0213 <= this->paiInfo.dwArchiveType && this->paiInfo.dwArchiveType < ARCHIVETYPE_EMILCONT01, ERROR_UNKNOWN_LEVEL)

	// ŁAǂݏpŃt@C쐬B
	//
	// ̏ŝ́Ȁꍇł :
	//	1. ɂ݂AVKɃt@C쐬ꍇB
	//	2. ɂɑ݂ĂāAɂ㏑ꍇB
	//
	this->fp = fopen(this->paiInfo.szArchiveName, "w+b");
	if (! this->fp)
	{
		// ɂǂݎpȂG[ύXB
		struct _stati64 stInfo;
		return (_stati64(this->paiInfo.szArchiveName, & stInfo) == 0 && ! (stInfo.st_mode & _S_IWRITE)) ? ERROR_ARC_READ_ONLY : ERROR_ARC_FILE_OPEN;
	}

	// ɂ̓eB
	{
		char szBuffer[30];
		GetArchiveString(this->paiInfo.dwArchiveType, szBuffer, sizeof(szBuffer) - 1);
		err_chkt(fprintf(this->fp, "%s", szBuffer) <= 0, ERROR_CANNOT_WRITE)
		// PAQ6ȍ~ł͈kx݁B
		if (this->paiInfo.dwArchiveType >= ARCHIVETYPE_PAQ6)
		{
			err_chkt(fprintf(this->fp, " -%d", this->paiInfo.nCompressionLevel) <= 0, ERROR_CANNOT_WRITE)
		}
	}
	// PAQAR, AXPAQ̏ꍇB
	if (this->paiInfo.dwArchiveType >= ARCHIVETYPE_PAQAR10 && this->paiInfo.dwArchiveType <= ARCHIVETYPE_AXPAQ20 && this->paiInfo.bEnableX86Optimize)
	{
		err_false(fputc('e', this->fp), 'e', ERROR_CANNOT_WRITE)
	}
	err_chkt(fprintf(this->fp, "\r\n\032") <= 0, ERROR_CANNOT_WRITE)

	// wb_擪ɈړBKKvȏł͂ȂAmF̈ӖłꉞB
	err_false(fseek(this->fp, 0, SEEK_SET), 0, ERROR_SET_POINT)

	// JgoNULLɁB
	this->bReaded = false;
	this->llTotalOriginalSize = 0;
	this->paiInfo.nSFXModuleType = SFX_NOT;
	this->szWildName = NULL;

	return 0;
}

// ǂݎpŊJB
BOOL API_NAME(Archive)::Open(const char * szArchiveName)
{
	this->fp = fopen(szArchiveName, "rb");
	strcpy(this->paiInfo.szArchiveName, szArchiveName);

	// ɂtpXŎ擾B
	{
		char szArchiveFull[FNAME_MAX32 + 1];
		_fullpath(szArchiveFull, this->paiInfo.szArchiveName, sizeof(szArchiveFull) - 1);
		memset(this->paiInfo.szArchiveName, 0, sizeof(this->paiInfo.szArchiveName));
		strncpy(this->paiInfo.szArchiveName, szArchiveFull, sizeof(this->paiInfo.szArchiveName) - 1);
	}

	// JgoNULLɁB
	this->bReaded = false;
	this->llTotalOriginalSize = 0;
	this->paiInfo.nSFXModuleType = SFX_NOT;
	this->szWildName = NULL;

	return this->fp != NULL;
}

// JĂ鏑ɂB
BOOL API_NAME(Archive)::Close()
{
    return fclose(this->fp) == 0;
}

// i[t@C̏擾B
int API_NAME(Archive)::FindFile(BOOL bFirst, API_NAME(FileInfo) * pfi)
{
	// ꎞϐBg͕K邱ƁB
	int i;

	// FindFirst
	if (bFirst)
	{
		// IɃ|C^擪ɁB
		err_false(fseek(this->fp, 0, SEEK_SET), 0, ERROR_SET_POINT)
		int nHeaderBegin = 0;

		// SFXʏ̏ɂB
		if (SHGetFileInfo(this->paiInfo.szArchiveName, 0, NULL, 0, SHGFI_EXETYPE) != 0)
		{
			// DOSwb_ǂݍ݁B
			IMAGE_DOS_HEADER idhDOSHeader;
			err_false(fread(& idhDOSHeader, 1, sizeof(IMAGE_DOS_HEADER), this->fp), sizeof(IMAGE_DOS_HEADER), ERROR_FILE_STYLE)
			err_false(idhDOSHeader.e_magic, IMAGE_DOS_SIGNATURE, ERROR_FILE_STYLE)
			err_false(fseek(this->fp, idhDOSHeader.e_lfanew, SEEK_SET), 0, ERROR_SET_POINT)

			// wb_̉dB
			// 0.221l ` 0.231 : 0
			// 0.240  ` 0.281 : 1
			// 0.290  ` 0.291 : 2
			// KGB             : 3
			int nHeaderVersion;
//			if (idhDOSHeader.e_cblp == 'U\r'  && idhDOSHeader.e_cp == 'AD'   && idhDOSHeader.e_crlc == '.0')
			if (idhDOSHeader.e_cblp == 0x550D && idhDOSHeader.e_cp == 0x4144 && idhDOSHeader.e_crlc == 0x2E30)
			{
				nHeaderVersion = 1;

				// ڍ׃o[WB
				char szVersion[4];
				memset(szVersion, 0, sizeof(szVersion));
				strncpy(szVersion, (char *) & idhDOSHeader.e_cparhdr, sizeof(szVersion) - 1);
				switch (szVersion[1])
				{
					case '4':
						switch (szVersion[2])
						{
							case '0': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0240; break;
							case '1': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0241; break;
							case '2': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0242; break;
						}
						break;
					case '5':
						switch (szVersion[2])
						{
							case '0': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0250; break;
						}
						break;
					case '6':
						switch (szVersion[2])
						{
							case '0': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0260; break;
							case '1': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0261; break;
						}
						break;
					case '7':
						switch (szVersion[2])
						{
							case '0': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0270; break;
							case '1': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0271; break;
						}
						break;
					case '8':
						switch (szVersion[2])
						{
							case '0': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0280; break;
							case '1': this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0281; break;
						}
						break;
				}
			}
//			else if (idhDOSHeader.e_cblp == 'PU')
			else if (idhDOSHeader.e_cblp == 0x5055)
			{
				// 0.221`0.230nBׂʂ͏ɂɂǂ蒅ĂB
				nHeaderVersion = 0;
				this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0221L;
			}
//			else if (idhDOSHeader.e_cblp == 'EK')
			else if (idhDOSHeader.e_cblp == 0x454B)
			{
				// 0.290nBׂʂ͌قǁB
				nHeaderVersion = 2;
			}
			else
			{
				// KGBnB
				nHeaderVersion = 3;
				this->paiInfo.nSFXModuleType = SFX_WIN32_KGB_10;
			}

			// PEwb_ǂݍ݁B
			IMAGE_NT_HEADERS inhNTHeaders;
			err_false(fread(& inhNTHeaders, 1, sizeof(IMAGE_NT_HEADERS), this->fp), sizeof(IMAGE_NT_HEADERS), ERROR_FILE_STYLE)
			err_false(inhNTHeaders.Signature, IMAGE_NT_SIGNATURE, ERROR_FILE_STYLE)

			// PEZNVǂݍ݁B
			{
				IMAGE_SECTION_HEADER * ishSections = (IMAGE_SECTION_HEADER *) calloc(inhNTHeaders.FileHeader.NumberOfSections, sizeof(IMAGE_SECTION_HEADER));
				err_true(ishSections, NULL, ERROR_MORE_HEAP_MEMORY)

				// ZNV̐f[^ǂݍ݁B
				for (int i = 0; i < inhNTHeaders.FileHeader.NumberOfSections; i++)
				{
					if (fread(& ishSections[i], 1, sizeof(IMAGE_SECTION_HEADER), this->fp) != sizeof(IMAGE_SECTION_HEADER))
					{
						free(ishSections);
						return ERROR_FILE_STYLE;
					}
				}

				// ꂼ̃ZNVɈړB
				fpos_t poSection;
				for (int i = 0; i < inhNTHeaders.FileHeader.NumberOfSections; i++)
				{
					// ݈ʒu擾B
					if (fgetpos(this->fp, & poSection) != 0)
					{
						free(ishSections);
						return ERROR_GET_POINT;
					}

					// ZNV̌ɈʒuZbgB
					poSection += ishSections[i].SizeOfRawData;
					if (fsetpos(this->fp, & poSection) != 0)
					{
						free(ishSections);
						return ERROR_SET_POINT;
					}

					// NULLŎn܂ZNV͖ƉB
					// 0.221l ` 0.230n܂łɑ΂΍B
					if (nHeaderVersion == 0 && i + 2 == inhNTHeaders.FileHeader.NumberOfSections)
					{
						poSection = max(poSection, ishSections[i].PointerToRawData + ishSections[i].SizeOfRawData);
						if (fsetpos(this->fp, & poSection) != 0)
						{
							free(ishSections);
							return ERROR_SET_POINT;
						}
						if (fgetc(this->fp) == 0)
						{
							nHeaderBegin += 160;
							break;
						}
					}

					// ʒuB
					poSection = max(poSection, ishSections[i].PointerToRawData + ishSections[i].SizeOfRawData);
				}
				free(ishSections);
				err_false(fsetpos(this->fp, & poSection), 0, ERROR_SET_POINT)
			}
			nHeaderBegin += ftell(this->fp);

			switch (nHeaderVersion)
			{
			case 1:
			{
				int cNextChar = fgetc(this->fp);
				if (cNextChar == '-')
				{
					err_false(fseek(this->fp, 46, SEEK_CUR), 0, ERROR_SET_POINT)
					// 0.270nł637bytesړA0.280ł22bytesړB
					nHeaderBegin += fgetc(this->fp) == '>' ? 637 : 22;
				}
				else if (cNextChar == 'W')
				{
					// 0.281B
					nHeaderBegin += 6;
				}
				break;
			}
			case 2:
			{
				// 0.290ñwb_𔻕ʁB
				if (fgetc(this->fp) == 0)
				{
					// 0.290B
					this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0290;
					nHeaderBegin += 2;
				}
				else
				{
					// 0.291B
					this->paiInfo.nSFXModuleType = SFX_WIN32_UDA_0291;
					nHeaderBegin -= 61;
				}
				break;
			}
			case 3:
				// KGBł512bytesړB
				nHeaderBegin += fgetc(this->fp) == 'K' ? 0 : 512;
				break;
			}

			// IɃ|C^wb_JnʒuɁB
			err_false(fseek(this->fp, nHeaderBegin, SEEK_SET), 0, ERROR_SET_POINT)

		}

		// Ƃ肠wb_Iʒu𒲂ׂB
		{
			for (int i = 0; i != '\n' && i != EOF; i = fgetc(this->fp));
		}

		// UDAł͓KpłȂR[hȂ̂ŃRgAEgB
		// {ɌiȔsȂKvȃR[hB
		//	err_true(i, EOF, ERROR_FILE_STYLE)
		int nHeaderSize = ftell(this->fp) - nHeaderBegin;

		// IɃ|C^wb_JnʒuɁB
		err_false(fseek(this->fp, nHeaderBegin, SEEK_SET), 0, ERROR_SET_POINT)

		// wb_S擾B
		BufferStream bsHeader;
		err_chkf(bsHeader.Allocate(nHeaderSize + 1), ERROR_MORE_HEAP_MEMORY)
		err_false(fread(bsHeader.lpBuffer, 1, nHeaderSize, this->fp), (unsigned) nHeaderSize, ERROR_CANNOT_READ)

		// sȃwb_TCY̏ꍇɂ̓G[IB
		err_chkt(bsHeader.BufferSize <= 3, ERROR_HEADER_BROKEN)

		// UDA mFB
		if (bsHeader.lpBuffer[0] == 'Z' && bsHeader.lpBuffer[1] == 'D')
		{
			BufferStream bsArchiveType;
			err_chkf(bsArchiveType.Allocate(3 + 1), ERROR_MORE_HEAP_MEMORY)
			strncpy(bsArchiveType.lpBuffer, bsHeader.lpBuffer, 3);
			this->paiInfo.dwArchiveType = GetArchiveType(bsArchiveType.lpBuffer);
			err_chkf(bsArchiveType.Free(), ERROR_HEAP_MEMORY);

			// UDA 0.221L ` 0.230nSFXɑ΂tH[B
			if (this->paiInfo.nSFXModuleType == SFX_WIN32_UDA_0221L)
			{
				this->paiInfo.nSFXModuleType =
					this->paiInfo.dwArchiveType == ARCHIVETYPE_UDA0221L ? SFX_WIN32_UDA_0221L :
					this->paiInfo.dwArchiveType == ARCHIVETYPE_UDA0230  ? SFX_WIN32_UDA_0230  :
					this->paiInfo.dwArchiveType == ARCHIVETYPE_UDA0231  ? SFX_WIN32_UDA_0231  : SFX_WIN32_UNKNOWN;
			}

			// kx擾
			this->paiInfo.nCompressionLevel = bsHeader.lpBuffer[3] + '0';
			err_chkt(this->paiInfo.nCompressionLevel < '0' || this->paiInfo.nCompressionLevel > '7', ERROR_HEADER_BROKEN)

			if (pfi != NULL)
			{
				// FileInfoB
				memset(pfi, 0, sizeof(API_NAME(FileInfo)));

				// UDA o[WB
				if (this->paiInfo.dwArchiveType == ARCHIVETYPE_UDA0283 || this->paiInfo.dwArchiveType == ARCHIVETYPE_UDA0284)
				{
					// 0.2830.284͒Pt@Ĉ݂ł̂ŁÃt@CóB
					pfi->llFileSize = (bsHeader.lpBuffer[4] + (bsHeader.lpBuffer[5] << 8)) + 256;
					char * pStripPath = strrchr(this->paiInfo.szArchiveName, '\\') + 1;
					if (pStripPath == NULL)
					{
						pStripPath = this->paiInfo.szArchiveName;
					}
					char * pStripExt = strrchr(this->paiInfo.szArchiveName, '.');
					if (pStripExt == NULL)
					{
						pStripExt = (char *) strlen(this->paiInfo.szArchiveName);
					}
					strncpy(pfi->szFileName, pStripPath, pStripExt - pStripPath);
				}
				else
				{
					// ȊOłA_~[f[^óB
					strcpy(pfi->szFileName, "(null)");
				}

				this->pfiCurrent = * pfi;
				this->llTotalOriginalSize += pfi->llFileSize;
			}

			// ㏈B
			this->bReaded = true;
			return 0;
		}
		else if (bsHeader.lpBuffer[0] == 'E' && bsHeader.lpBuffer[1] == 'N' && bsHeader.lpBuffer[2] == 'C')
		{
			this->paiInfo.dwArchiveType = ARCHIVETYPE_KGB10_ENCRYPTED;
			// KGBÍɂ̃o\ɂ͑ΉĂȂ߁A-1ԂB
			return -1;
		}

		// wb_珑ɂ̎ނ擾B
		unsigned int i;
		for (i = 0; i < bsHeader.BufferSize; i++)
		{
			if (bsHeader.lpBuffer[i] == ' ')
			{
				{
					BufferStream bsArchiveType;
					err_chkf(bsArchiveType.Allocate(i + 1), ERROR_MORE_HEAP_MEMORY)
					strncpy(bsArchiveType.lpBuffer, bsHeader.lpBuffer, i);
					bsArchiveType.lpBuffer[i] = '\0';
					this->paiInfo.dwArchiveType = GetArchiveType(bsArchiveType.lpBuffer);
					err_chkf(bsArchiveType.Free(), ERROR_HEAP_MEMORY);
				}

				err_false(bsHeader.lpBuffer[++i], '-', ERROR_HEADER_BROKEN)

				// kx擾
				this->paiInfo.nCompressionLevel = bsHeader.lpBuffer[++i];
				err_chkt(bsHeader.lpBuffer[i] < '0' || bsHeader.lpBuffer[i] > '9', ERROR_HEADER_BROKEN)

				// x86œKB
				this->paiInfo.bEnableX86Optimize = bsHeader.lpBuffer[++i] == 'e';
				if (this->paiInfo.bEnableX86Optimize)
				{
					i++;
				}

				err_false(bsHeader.lpBuffer[i], '\r', ERROR_HEADER_BROKEN)
				break;
			}
			// P5 ` PAQ5ł͂B
			else if (bsHeader.lpBuffer[i] == '\r')
			{
				BufferStream bsArchiveType;
				err_chkf(bsArchiveType.Allocate(i + 1), ERROR_MORE_HEAP_MEMORY)
				strncpy(bsArchiveType.lpBuffer, bsHeader.lpBuffer, i);
				bsArchiveType.lpBuffer[i] = '\0';
				this->paiInfo.dwArchiveType = GetArchiveType(bsArchiveType.lpBuffer);
				err_chkf(bsArchiveType.Free(), ERROR_HEAP_MEMORY);

				// ݒ肪̂ŏlB
				this->paiInfo.nCompressionLevel = '0';
				this->paiInfo.bEnableX86Optimize = FALSE;
				break;
			}
		}

		// Ɍ`ُ(GetArchiveType0Ԃ)𔻒B
		err_true(this->paiInfo.dwArchiveType, 0, ERROR_FILE_STYLE)

		// CfbNXJnO̍ŏImFB
		err_false(bsHeader.lpBuffer[++i], '\n', ERROR_HEADER_BROKEN)
		err_false(i + 1, (unsigned) nHeaderSize, ERROR_HEADER_BROKEN)
		err_chkf(bsHeader.Free(), ERROR_HEAP_MEMORY)
	}

	// UDA ł̓t@Cf[^ǂݍ߂Ȃ̂ŁAŌIB
	err_chkt(ARCHIVETYPE_UDA0213 <= this->paiInfo.dwArchiveType && this->paiInfo.dwArchiveType < ARCHIVETYPE_EMILCONT01, -1)

	// t@C(ChJ[h)擾Bt@CXg̍ŌNULLŏIB
	int nFileNames = 0;
	for (; this->szWildName != NULL && this->szWildName[nFileNames] != NULL; nFileNames++);

	// t@CChJ[hɃ}b`܂ŌJԂB
	for (; ; )
	{
		// FileInfoB
		if (pfi != NULL)
		{
			memset(pfi, 0, sizeof(API_NAME(FileInfo)));
		}

		// ăt@C擾B
		long lOriginalPointer = ftell(this->fp);
		for (i = 0; i != '\r' && i != 0x1a && i != EOF; i = fgetc(this->fp));
		err_true(i, EOF, ERROR_EOF)

		// MS-DOS EOFmŏIB
		if (i == 0x1a)
		{
			// PAQ6ȑOł\f\0tĂ̂B
			if (this->paiInfo.dwArchiveType < ARCHIVETYPE_PAQ6)
			{
				err_false(fgetc(this->fp), '\f', ERROR_HEADER_BROKEN)
				err_false(fgetc(this->fp), '\0', ERROR_HEADER_BROKEN)
			}
			return -1;
		}

		int nIndexSize = ftell(this->fp) - lOriginalPointer - 1;

		// ړ|C^߂B
		err_false(fseek(this->fp, lOriginalPointer, SEEK_SET), 0, ERROR_SET_POINT)

		// CfbNX擾ɉ́B
		{
			BufferStream bsLine;
			err_chkf(bsLine.Allocate(nIndexSize + 1), ERROR_MORE_HEAP_MEMORY)
			err_false(fread(bsLine.lpBuffer, 1, nIndexSize, this->fp), (unsigned) nIndexSize, ERROR_CANNOT_READ)
			if (pfi != NULL)
			{
				pfi->llFileSize = _atoi64(bsLine.lpBuffer);
				// PAQ2ȑOł' 'gpB
				char * szFileNameBegin =
					this->paiInfo.dwArchiveType < ARCHIVETYPE_PAQ1  ? bsLine.lpBuffer + 9 :
					this->paiInfo.dwArchiveType < ARCHIVETYPE_PAQ3 ? bsLine.lpBuffer + 10 :
					strchr(bsLine.lpBuffer, '\t');
				strncpy(pfi->szFileName, szFileNameBegin + 1, sizeof(pfi->szFileName) - 1);
				pfi->szFileName[nIndexSize - (szFileNameBegin - bsLine.lpBuffer) - 1] = '\0';
			}
			err_chkf(bsLine.Free(), ERROR_HEAP_MEMORY)
		}

		// CfbNXJnO̍ŏImFB
		err_false(fgetc(this->fp), '\r', ERROR_HEADER_BROKEN)
		err_false(fgetc(this->fp), '\n', ERROR_HEADER_BROKEN)

		// t@CChJ[hɃ}b`Ă邩mFB
		// do ... while; ł͂GȏłȂ̂ȂƂB
		int encount;
		for (encount = 0; encount < nFileNames && ! ismatchwildcard(this->szWildName[encount], pfi->szFileName); encount++);
		if (encount != nFileNames || nFileNames == 0)
		{
			// }b`Ă΃[v甲oB
			break;
		}
	}

	// ㏈B
	this->bReaded = true;
	if (pfi != NULL)
	{
		this->pfiCurrent = * pfi;
		this->llTotalOriginalSize += pfi->llFileSize;
	}

	return 0;
}

// ɂt@CWJB
int API_NAME(Archive)::Extract(char * * szFileNames, API_NAME(Switch) * ps)
{
	// ŏɏ𑗐MB
	strncpy(this->cbProc.sArchiveInfo.szSourceFileName, this->paiInfo.szArchiveName, sizeof(this->cbProc.sArchiveInfo.szSourceFileName) - 1);
	this->cbProc.sArchiveInfo.dummy1[0] = 'x';
	err_chkf(this->cbProc.SendProgress(ARCEXTRACT_OPEN), ERROR_USER_CANCEL)

	// t@C(ChJ[h)擾Bt@CXg̍ŌNULLŏIB
	int nFileNames = 0;
	for (; szFileNames[nFileNames] != NULL; nFileNames++);

	// ̈mۂ̂߃t@C擾B
	ArrayStream asIndex;
	int nIndex = 0, value;
	if ((value = this->FindFile(TRUE, NULL)) == 0)
	{
		for (nIndex = 1; (value = this->FindFile(FALSE, NULL)) == 0; nIndex++);
	}

	// G[mB̔ŏIꍇAvalue͊ɃG[R[hłB
	err_false(value, -1, value)

	// 擾t@Cɂė̈mہB
	err_chkf(asIndex.Allocate(nIndex + 1, sizeof(API_NAME(FileInfo))), ERROR_MORE_HEAP_MEMORY)
	API_NAME(FileInfo) * pfiIndex = (API_NAME(FileInfo) *) asIndex.lpBuffer;

	nIndex = 0;
	if ((value = this->FindFile(TRUE, & pfiIndex[nIndex])) == 0)
	{
		// wb_ΉĂȂ`(PAQAR4.0ȊO)ǂ`FbNB
		err_false(this->paiInfo.dwArchiveType, ARCHIVETYPE_PAQAR40, ERROR_UNKNOWN_LEVEL)

		do
		{
			// 𑗐MB
			strncpy(this->cbProc.sArchiveInfo.szSourceFileName, pfiIndex[nIndex].szFileName, sizeof(this->cbProc.sArchiveInfo.szSourceFileName) - 1);
			this->cbProc.sArchiveInfo.llFileSize = pfiIndex[nIndex].llFileSize;
			err_chkf(this->cbProc.SendProgress(5), ERROR_USER_CANCEL)
		}
		while ((value = this->FindFile(FALSE, & pfiIndex[++nIndex])) == 0);
	}

	// G[mB̔ŏIꍇAvalue͊ɃG[R[hłB
	err_false(value, -1, value)

	// WJ悪݂Ȃꍇɂ́Aō쐬B
	char szDestFullPath[FNAME_MAX32 + 1];
	if (strcmp(ps->szBaseDirectory, "") == 0)
	{
		getcwd(ps->szBaseDirectory, sizeof(ps->szBaseDirectory) - 1);
	}
	_fullpath(szDestFullPath, ps->szBaseDirectory, sizeof(szDestFullPath) - 1);
	if (szDestFullPath[strlen(szDestFullPath) - 1] != '\\')
	{
		// \ȗp̕⊮B
		strncat(szDestFullPath, "\\", sizeof(szDestFullPath) - strlen(szDestFullPath) - 1);
	}
	err_chkf(MakeSureDirectoryPathExists(szDestFullPath), ERROR_MAKEDIRECTORY)

	// ܂ł̓G[ɂȂȂ͂B
	chdir(szDestFullPath);

	// ݒɔfB
	exe = this->paiInfo.bEnableX86Optimize;
	MEM = this->paiInfo.nCompressionLevel - '0';

	// TransformerNB
	Transformer e(DECOMPRESS, this->fp);

	// WJJnB
	for (int i = 0; i < nIndex; i++)
	{
		// t@CWJΏۂǂB
		int encount;
		for (encount = 0; encount < nFileNames && ! ismatchwildcard(szFileNames[encount], pfiIndex[i].szFileName); encount++);

		// ̔encount̒ĺABOOLɏB
		//
		//	TRUE(1)		:	~b^[BBWJΏہB
		//	FALSE(0)	:	~b^[BB  WJΏۂłȂB
		//
		// ܂AnFileNames == 0̔́AΏۃt@Cw肳ĂȂꍇA
		// SẴt@CWJΏۂƂȂĂꍇɁATRUEԂ߂̔łB
		encount = nFileNames == 0 ? TRUE : encount != nFileNames;

		FILE * fpDest = NULL;
		memset(& this->cbProc.sArchiveInfo, 0, sizeof(Callback::ArchiveInfo));
		memset(& this->cbProc.sMemberInfo, 0, sizeof(Callback::MemberInfo));
		// t@CtpXŊi[ϐB
		char szDestFile[FNAME_MAX32 + 1];

		if (encount)
		{
			// t@C쐬BIɊmۂ̂]܂񂾂ǂ˂B
			// rŐ؂ꂿm(_ _)m(w
			strncpy(szDestFile, szDestFullPath, sizeof(szDestFile) - 1);

			// "/"ׂ"\"ɒuB
			for (size_t n = 0; n < strlen(pfiIndex[i].szFileName); n++)
			{
				if (pfiIndex[i].szFileName[n] == '/')
				{
					pfiIndex[i].szFileName[n] = '\\';
				}
			}

			if (ps->bDestoryPath)
			{
				// pXj󂷂B
				char * pFile = strrchr(pfiIndex[i].szFileName, '\\');
				if (pFile != NULL)
				{
					strcpy(pfiIndex[i].szFileName, ++pFile);
				}
			}

			// DTV֘AB
			if (ps->sActionMode.fDenyPath & BPL_DENY_TOO_MANY_PARENTS)
			{
				// fBNgkpX̏ꍇ͕sƂ݂ȂB
				// fBNg̃tpXo͐悪PĂ邩ǂB
				_fullpath(szDestFile, pfiIndex[i].szFileName, sizeof(szDestFile));
				err_true(strstr(szDestFile, szDestFullPath), NULL, ERROR_INVALID_PATH)

				// gp̓NA[B
				memset(szDestFile, 0, sizeof(szDestFile));
			}
			if (ps->sActionMode.fDenyPath & BPL_DENY_ABS_PATH)
			{
				// ΃pXSĕsƂ݂ȂB́A
				// x:\yyy\zzz.ext ̂ƂA2ڂ":"3ڂ"\"B
				// \\hogenet\\... ̂ƂA1ڂ"\"2ڂ"\"B
				// \\?\ȂǂUNĆAɑ̂΃pXł̂łɊ܂ށB
				//
				// Note:
				// āAu\yyy\zzz.extv͐΃pX΃pXƂŁA
				// unixVXeł/usr/bin/sh͐΃pXł邪A
				// windowsVXeł\yyy\zzz.ext͑΃pXł͗lB
				// vunix/[gł邪Awindowsłx:\hCu[gł邱ƂɋN悤B
				//
				// ŁAǂׂƂbɈڂ킯ł邪A
				// WJVXewindowsȊOł邱Ƃ͑z肵ȂƂA
				// "/""\"Ŏn܂pX͑΃pXƂĈׂ낤B
				err_chkt(strlen(pfiIndex[i].szFileName) >= 3 && pfiIndex[i].szFileName[1] == ':' && pfiIndex[i].szFileName[2] == '\\', ERROR_INVALID_PATH)
				err_chkt(strlen(pfiIndex[i].szFileName) >= 2 && pfiIndex[i].szFileName[0] == '\\' && pfiIndex[i].szFileName[1] == '\\', ERROR_INVALID_PATH)
			}
			if (ps->sActionMode.fDenyPath & BPL_DENY_PARENTS)
			{
				// fBNgkpX"..\"SĕsƂ݂ȂB
				err_false(strstr(pfiIndex[i].szFileName, "..\\"), NULL, ERROR_INVALID_PATH)
			}
			_fullpath(szDestFile, pfiIndex[i].szFileName, sizeof(szDestFile));

			// 𑗐M(EnumMembersProc)B
			strncpy(this->cbProc.sMemberInfo.szFileName, pfiIndex[i].szFileName, sizeof(this->cbProc.sMemberInfo.szFileName) - 1);
			strncpy(this->cbProc.sMemberInfo.szAddFileName, szDestFile, sizeof(this->cbProc.sMemberInfo.szAddFileName) - 1);
			this->cbProc.sMemberInfo.llOriginalSize = pfiIndex[i].llFileSize;
			this->cbProc.sMemberInfo.uCommand = PAQ_EXTRACT_COMMAND;

			// EnumMembersProcœo^ꂽ֐Ɍď𑗐M邪A
			// 󂯂鑊葤t@C邱ƂI񂾏ꍇɂ́A
			//   ,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
			// wႦt@C݂ĂĂ㏑mFsȂx_ɒӁB
			//   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			// EnumMembersProcɊ֐o^ĂȂꍇ́AOŃt@C̑݊mFsāA
			// WJɃt@C݂Ăꍇɂ͏㏑mF_CAOo悤ɂĂ܂B
			// ɂ悤łÁ̗A
			//	SendStartProcessInfo();
			//
			// SetEnumMembersProcݒ肳Ăꍇ :
			//	->	(ݒ肳Ă֐);
			//
			// SetEnumMembersProcݒ肳ĂȂꍇ :
			//	->	ProcessEnumMembersProc(); (function.cpp)
			//	->	t@C݂Ăꍇ :
			//		->	ConfirmDialogProc(); (function.cpp)
			//
			// ̎dĺA葤AvP[Vɂăt@C̏sƑIꂽꍇɁA
			// ɓWJɃt@C݂ď㏑mFsďsȂꍇɁA
			// 葤AvP[VɌ듮Ȃǂ̖肪Ȃ悤ɂ邽߂̑[ułB
			if (! this->cbProc.SendFileInfo())
			{
				// g_CanceltruełꍇB
				// ㏑mF_CAOŁwLZxIꍇz肵ĂB
				err_chkt(g_Cancel, ERROR_USER_CANCEL)

				// ł̏́AYt@CXLbv邽߂̏łB
				encount = FALSE;
			}
		}

		// EnumMembersPročʂɂčĕ򂷂B
		// ŁAStartProcessInfo.szAddFileNameύXĂꍇlB
		if (encount)
		{
			// WJt@C擾B̎ɂA͖ŏ㏑B
			strncpy(szDestFile, this->cbProc.sMemberInfo.szAddFileName, sizeof(szDestFile) - 1);

			// WJfBNg܂ł̃fBNgċAIɍ쐬B
			char szDestFullFile[FNAME_MAX32 + 1];
			_fullpath(szDestFullFile, szDestFile, sizeof(szDestFullFile) - 1);
			err_chkf(MakeSureDirectoryPathExists(szDestFullFile), ERROR_MAKEDIRECTORY)

			// WJ̃t@Cnh擾B
			fpDest = fopen(szDestFile, "wb");
			if (! fpDest)
			{
				// G[̌𒲍B
				// ɂǂݎp̏ꍇ͕ʂ̃G[ԂB
				struct _stati64 stInfo;
				int nErrorCode = (_stati64(szDestFile, & stInfo) == 0 && ! (stInfo.st_mode & _S_IWRITE)) ? ERROR_READ_ONLY : ERROR_FILE_OPEN;

				// xG[Ƃ邩B
				switch (ps->sQuietInfo.eWarningAsError)
				{
					case '2':
						return nErrorCode;
					case '1':
						if (ps->sQuietInfo.bShowErrorDialog)
						{
							// FALSEȂG[IB
							err_chkf(ErrorConfirmDialog(this->cbProc.sProgress.hwDialog, nErrorCode, FALSE), nErrorCode)
						}
					default:
//						encount = FALSE;
						break;
				}
			}
		}

		// 𑗐M(SetOwnerWindow)B
		if (fpDest)
		{
			strncpy(this->cbProc.sArchiveInfo.szSourceFileName, pfiIndex[i].szFileName, sizeof(this->cbProc.sArchiveInfo.szSourceFileName) - 1);
			strncpy(this->cbProc.sArchiveInfo.szDestFileName, szDestFile, sizeof(this->cbProc.sArchiveInfo.szDestFileName) - 1);
			this->cbProc.sArchiveInfo.llFileSize = pfiIndex[i].llFileSize;
			err_chkf(this->cbProc.SendProgress(ARCEXTRACT_BEGIN), ERROR_USER_CANCEL)
		}

		// ŁAt@CɓWJꍇƂȂꍇōB
		// ȍ~́AfpDestNULLłȂꍇɂ̓t@CɓWJB

		// ULONGLONG -> int
		fsize = pfiIndex[i].llFileSize - 513216;

		// x86œK̎OB
		if(this->paiInfo.bEnableX86Optimize && pfiIndex[i].llFileSize > 0)
		{
			int c = e.decode();
			if (fpDest)
			{
				err_false(fputc(c, fpDest), c, ERROR_CANNOT_WRITE)
			}
			if (c)
			{
				c -= 23;
				if((c < 0 && ((c + 8) & 1)) || (c >= 0 && ((c + 2) & 1)))
				{
					int c = e.decode();
					int d = e.decode();
					if (fpDest)
					{
						err_false(fputc(c, fpDest), c, ERROR_CANNOT_WRITE)
						err_false(fputc(d, fpDest), d, ERROR_CANNOT_WRITE)
					}
					d = d * 256 + c;
					for (n = 0; n < d * 3; ++n)
					{
						fputc(e.decode(), fpDest);
					}
				}
			}
		}

		// ۂ̓WJJnB
		for (ULONGLONG ll = 0; ll < pfiIndex[i].llFileSize; )
		{
			int c = e.decode();
			this->cbProc.sArchiveInfo.llWriteSize = ++ll;
			if (fpDest)
			{
				err_false(fputc(c, fpDest), c, ERROR_CANNOT_WRITE)

				// 𑗐MB
				err_chkf(this->cbProc.SendProgress(ARCEXTRACT_INPROCESS), ERROR_USER_CANCEL)
			}
			else
			{
				DoEvents();
				err_chkt(g_Cancel, ERROR_USER_CANCEL)
			}
		}

		if (fpDest)
		{
			// Ώۃt@C̏IƂ𑗐MB
			err_chkf(this->cbProc.SendProgress(6), ERROR_USER_CANCEL)

			// x86œK̎㏈B
			if (this->paiInfo.bEnableX86Optimize && pfiIndex[i].llFileSize > 0)
			{
				int data2write[4] = {0, 0, 0, 0};
				err_false(fclose(fpDest), 0, ERROR_CLOSE_FILE)

				// G[ďɂȂĂ܂B
				// ̏́A
				//	1. xWJt@CJA
				//	2. t@CTCY擾āA
				//	3. t@C|C^擪ɖ߂B
				fpDest = fopen(pfiIndex[i].szFileName, "rb");
				err_true(fpDest, NULL, ERROR_FILE_OPEN)
				err_false(fseek(fpDest, 0L, SEEK_END), 0, ERROR_SET_POINT)
				fpos_t poTemp = 0;
				err_false(fgetpos(fpDest, & poTemp), 0, ERROR_GET_POINT)
				err_false(fseek(fpDest, 0L, SEEK_SET), 0, ERROR_SET_POINT)

				// fpos_t -> long
				long flen = poTemp;

				// ̏́A
				//	1. 擾āA
				//	2. WJ̃t@C̓eSďoāA
				//	3. t@CnhB
				BufferStream bsBuffer0;
				err_chkf(bsBuffer0.Allocate(CONSTA + 2 * flen + 256), ERROR_MORE_HEAP_MEMORY)
				char * st = bsBuffer0.lpBuffer + 256 - ((int) bsBuffer0.lpBuffer & 255);	// 256-byte-alignment
				flen = fread(st + CONSTA - 32768, 1, flen, fpDest);
				err_false(fclose(fpDest), 0, ERROR_CLOSE_FILE)

				// ̏́A
				//	1. WJt@C̓eāA
				//	2. te8e9sāA
				//	3. ̓et@Cɏ݁A
				//	4. mۂB
				fpDest = fopen(pfiIndex[i].szFileName, "wb");
				if (! fpDest)
				{
					// xG[Ƃ邩B
					switch (ps->sQuietInfo.eWarningAsError)
					{
						case '2':
							return ERROR_FILE_OPEN;
						case '1':
							if (ps->sQuietInfo.bShowErrorDialog)
							{
								// FALSEȂG[IB
								err_chkf(ErrorConfirmDialog(this->cbProc.sProgress.hwDialog, ERROR_FILE_OPEN, FALSE), ERROR_FILE_OPEN)
							}
						default:
							break;
					}
				}

				if (flen)
				{
					te8e9(st, 4, flen, & data2write[0]);
				}
				if (data2write[0])
				{
					err_false(fwrite((char *) data2write[1], 1, data2write[0], fpDest), (unsigned) data2write[0], ERROR_CANNOT_WRITE)
				}
				err_chkf(bsBuffer0.Free(), ERROR_HEAP_MEMORY)
			}

			// ŌɃt@CnhB
			err_false(fclose(fpDest), 0, ERROR_CLOSE_FILE)
		}
	}

	// Ȉ𑗐MB
	// ŃLZӖȂ񂾂ǂꉞĂ܂B
	err_chkf(this->cbProc.SendProgress(ARCEXTRACT_END), ERROR_USER_CANCEL)

	return 0;
}

// ɂɃt@Ci[B
int API_NAME(Archive)::Add(char * * szFileNames, API_NAME(Switch) * ps)
{
	// ŏɏ𑗐MB
	strncpy(this->cbProc.sArchiveInfo.szSourceFileName, this->paiInfo.szArchiveName, sizeof(this->cbProc.sArchiveInfo.szSourceFileName) - 1);
	this->cbProc.sArchiveInfo.dummy1[0] = 'a';
	err_chkf(this->cbProc.SendProgress(ARCEXTRACT_OPEN), ERROR_USER_CANCEL)

	// ƃfBNgݒB
	char szTempFullPath[FNAME_MAX32 + 1];
	if (_fullpath(szTempFullPath, ps->szWorkDirectory, sizeof(szTempFullPath) - 1) == NULL)
	{
		// ƃfBNgȂꍇB
		//
		// ̏ꍇAϐTEMPĎ擾Aݒ肷B
		// ϐTEMPsłꍇERROR_TMP_OPENԂ͂B
		strncpy(szTempFullPath, getenv("TEMP"), sizeof(szTempFullPath) - 1);
	}
	if (szTempFullPath[strlen(szTempFullPath) - 1] != '\\')
	{
		// \ȗp̕⊮B
		strncat(szTempFullPath, "\\", sizeof(szTempFullPath) - strlen(szTempFullPath) - 1);
	}

	// fBNgݒB
	char szBaseFullPath[FNAME_MAX32 + 1];
	if (strcmp(ps->szBaseDirectory, "") == 0)
	{
		getcwd(ps->szBaseDirectory, sizeof(ps->szBaseDirectory) - 1);
	}
	_fullpath(szBaseFullPath, ps->szBaseDirectory, sizeof(szBaseFullPath) - 1);
	if (szBaseFullPath[strlen(szBaseFullPath) - 1] != '\\')
	{
		// \ȗp̕⊮B
		strncat(szBaseFullPath, "\\", sizeof(szBaseFullPath) - strlen(szBaseFullPath) - 1);
	}

	// ݂ȂfBNgɎw肳ꂽꍇB
	//
	// ̏ꍇAꑊ̃G[Ԃׂł邪Aunlha32ł0ԂB
	// ́A炭݂ȂfBNgɎw肳ꂽƂA
	// _~[fBNgłAt@Ci[KvƉ߂ĂƎvB
	// łunlha32̎dlƓ悤0ԂB
	err_false(chdir(szBaseFullPath), 0, 0)

	// t@C(ChJ[h)擾Bt@CXg̍ŌNULLŏIB
	// ChJ[h́B
	int nFileNames = 0;
	for (int i = 0; szFileNames[i] != NULL; i++)
	{
		int nReturnCode = MakeFileList(szFileNames[i], "", NULL, TRUE, nFileNames);
		err_false(nReturnCode, 0, nReturnCode)
	}

	// ̈mۂÄɃf[^B
	ArrayStream asFileNames;
	err_chkf(asFileNames.Allocate(nFileNames, sizeof(AddList)), ERROR_MORE_HEAP_MEMORY)
	AddList * alFileNames = (AddList *) asFileNames.lpBuffer;
	nFileNames = 0;
	for (int i = 0; szFileNames[i] != NULL; i++)
	{
		int nReturnCode = MakeFileList(szFileNames[i], "", alFileNames, TRUE, nFileNames);
		err_false(nReturnCode, 0, nReturnCode)
	}

	// |C^K؂ȈʒuɈړB
	{
		int value;
		if ((value = this->FindFile(true, NULL)) == 0)
		{
			for (; (value = this->FindFile(false, NULL)) == 0; );
		}

		// G[mB
		// ̏ꍇAvalue͊ɃG[R[hłB
		err_false(value, -1, value)
	}

	// w肳ꂽԃtH_ɁAԏɂ쐬B
	// ł̒ԏɂ܂߂ԃt@C̖ḰAuuuu16i̗ƂPQAuuuu.tmpłB
	//
	// ܂AGetTempFileName݂Ȃt@CԂƂۏ؂Ă邱ƂA
	// ł͊Ƀt@C݂邩ǂ͍̌sĂ炸AIɏ㏑B
	//
	// XɁAȍ~̃G[ł͒ʏnhăt@C폜鑀삪Kvł邪A
	// ̓PaqTempFile鎞ɍsĂ邽߂ɂł͕KvȂB
	FileStream fsWorkFile, fsX86File;
	memset(& fsWorkFile, 0, sizeof(FileStream));
	GetTempFileName(szTempFullPath, "PQA", 0, fsWorkFile.szFileName);
	err_chkf(fsWorkFile.Open(NULL, "wb"), ERROR_TMP_OPEN)
	fsWorkFile.bRemove = TRUE;

	// ԏɂɃwb_Rs[B
	// -1Ă̂́ARs[eMS-DOS EOF(\032)܂܂Ȃ悤ɂ邽߁B
	long nHeaderSize = ftell(this->fp) - 1;
	err_true(nHeaderSize, -1L, ERROR_GET_POINT)
	err_false(fseek(this->fp, 0, SEEK_SET), 0, ERROR_SET_POINT)

	// 擾TCY݁B
	{
		BufferStream bsData;
		err_chkf(bsData.Allocate(nHeaderSize + 1), ERROR_MORE_HEAP_MEMORY)
		err_false(fread(bsData.lpBuffer, 1, nHeaderSize, this->fp), (unsigned) nHeaderSize, ERROR_CANNOT_READ)
		err_false(fwrite(bsData.lpBuffer, 1, nHeaderSize, fsWorkFile.fpFile), (unsigned) nHeaderSize, ERROR_CANNOT_WRITE)
		err_chkf(bsData.Free(), ERROR_HEAP_MEMORY)
	}

	// CfbNXɃt@CǉB
	for (int i = 0; i < nFileNames; i++)
	{
		// 𑗐M(EnumMembersProc)B
		//
		// ŏ𑗐M̂́A܂łȂCfbNXɏރt@CɂĂ̏擾邽߂łB
		// {Ȃۂ̊i[JnOɑMׂł邪Ał͂ꂪdlłB
		strncpy(this->cbProc.sMemberInfo.szFileName, alFileNames[i].savename, sizeof(this->cbProc.sMemberInfo.szFileName) - 1);
		strncpy(this->cbProc.sMemberInfo.szAddFileName, alFileNames[i].filename, sizeof(this->cbProc.sMemberInfo.szAddFileName) - 1);
		this->cbProc.sMemberInfo.uCommand = PAQ_ADD_COMMAND;
		if (! this->cbProc.SendFileInfo())
		{
			// Yt@CCfbNX폜A1OɃVtgB
			int l;
			for (l = i--; l < nFileNames - 1; l++)
			{
				strcpy(alFileNames[l].filename, alFileNames[l + 1].filename);
				strcpy(alFileNames[l].savename, alFileNames[l + 1].savename);
			}
			strcpy(alFileNames[l].filename, "");
			strcpy(alFileNames[l].savename, "");
			nFileNames--;

			// ł̏́AYt@CXLbv邽߂̏łB
			continue;
		}

		// ύXꂽf[^擾B
		strncpy(alFileNames[i].savename, this->cbProc.sMemberInfo.szFileName, sizeof(alFileNames[i].savename) - 1);
		strncpy(alFileNames[i].filename, this->cbProc.sMemberInfo.szAddFileName, sizeof(alFileNames[i].filename) - 1);

		// t@CJ邩mFƓɁAt@CTCY擾B
		{
			// t@C݂̑mFB
			struct _stati64 stInfo;
			err_false(_stati64(alFileNames[i].filename, & stInfo), 0, ERROR_SHARING)
			alFileNames[i].size = stInfo.st_size;

			if (ps->bDestoryPath && strrchr(alFileNames[i].savename, '/'))
			{
				// pXjB
				char szStripped[FNAME_MAX32 + 1];
				strncpy(szStripped, strrchr(alFileNames[i].savename, '/') + 1, sizeof(szStripped));
				memset(alFileNames[i].savename, 0, sizeof(alFileNames[i].savename));
				strncpy(alFileNames[i].savename, szStripped, sizeof(alFileNames[i].savename));
			}

			// dt@Ci[`FbN[`B
			if (ps->sQuietInfo.eCheckSameFileName != '0')
			{
				for (int n = 0; n < i; n++)
				{
					if (stricmp(alFileNames[i].savename, alFileNames[n].savename) == 0)
					{
						// t@C̏dłꍇB
						if (ps->sQuietInfo.eCheckSameFileName == '1')
						{
							// _CAO\B
							err_chkf(ErrorConfirmDialog(this->cbProc.sProgress.hwDialog, ERROR_SAME_NAME_FILE, FALSE), ERROR_SAME_NAME_FILE)
						}
						else
						{
							// 0łȂ1łȂȂKRI2B
							return ERROR_SAME_NAME_FILE;
						}
					}
				}
			}

			// CfbNXɒǉ݁B
			err_chkt(fprintf(fsWorkFile.fpFile, "%I64u\t%s\r\n", alFileNames[i].size, alFileNames[i].savename) <= 0, ERROR_CANNOT_WRITE)
		}
	}

	// CfbNXI032݁B
	err_true(fputc(032, fsWorkFile.fpFile), EOF, ERROR_CANNOT_WRITE)

	// ̃f[^邩ǂ𔻒B
	// fread/fwritegΑȂ悤ȋC邯Ǎ̂ƂCɂȂȂ̂ł낵B
	{
		int cChar = fgetc(this->fp);
		if (cChar == 032)
		{
			// ̃f[^ǉB
			while ((cChar = fgetc(this->fp)) != EOF)
			{
				fputc(cChar, fsWorkFile.fpFile);
			}
		}
	}

	// ݒɔfB
	exe = this->paiInfo.bEnableX86Optimize;
	MEM = this->paiInfo.nCompressionLevel - '0';

	// TransformerNB
	Transformer e(COMPRESS, fsWorkFile.fpFile);

	// t@CƂɏJn
	for (int i = 0; i < nFileNames; i++)
	{
		// 𑗐M(SetOwnerWindow)B
		strncpy(this->cbProc.sArchiveInfo.szSourceFileName, alFileNames[i].filename, sizeof(this->cbProc.sArchiveInfo.szSourceFileName) - 1);
		strncpy(this->cbProc.sArchiveInfo.szDestFileName, alFileNames[i].savename, sizeof(this->cbProc.sArchiveInfo.szDestFileName) - 1);
		this->cbProc.sArchiveInfo.llFileSize = alFileNames[i].size;
		err_chkf(this->cbProc.SendProgress(ARCEXTRACT_BEGIN), ERROR_USER_CANCEL)

		// t@CJ
		FileStream fsFile;
		err_chkf(fsFile.Open(alFileNames[i].filename, "rb"), ERROR_NOT_FIND_FILE)
		fsize = alFileNames[i].size - 513216;

		// x86œK
		if (fsFile.fpFile && this->paiInfo.bEnableX86Optimize && alFileNames[i].size > 0)
		{
			int data2write[4] = {0, 0, 0, 0};

			// G[ďɂȂĂ܂BWJƂ͔ɏႢ܂B
			// ̏́A
			//	1. t@CTCY擾āA
			//	2. t@C|C^擪ɖ߂B
			err_false(fseek(fsFile.fpFile, 0L, SEEK_END), 0, ERROR_SET_POINT)
			fpos_t poTemp = 0;
			err_false(fgetpos(fsFile.fpFile, & poTemp), 0, ERROR_GET_POINT)
			// fpos_t -> long
			long flen = poTemp;
			err_false(fseek(fsFile.fpFile, 0L, 0), 0, ERROR_SET_POINT)

			// ̏́A
			//	1. 擾āA
			//	2. i[̃t@C̓eSēǂݍŁA
			//	3. te8e9sāA
			//	4. t@CnhB
			BufferStream bsBuffer0;
			err_chkf(bsBuffer0.Allocate(CONSTA + 2 * flen + 256), ERROR_MORE_HEAP_MEMORY)
			char * st = bsBuffer0.lpBuffer + 256 - ((int) bsBuffer0.lpBuffer & 255);// 256-byte-alignment
			flen = fread(st + CONSTA - 32768, 1, flen, fsFile.fpFile);
			if (n)
			{
				te8e9(st, 3, flen, & data2write[0]);
			}
			err_false(fclose(fsFile.fpFile), 0, ERROR_CLOSE_FILE)

			// ̏́A
			//	1. ԃt@C쐬āA
			//	2. ̓et@Cɏ݁A
			//	3. mۂA
			//	4. ŌɃt@C|C^擪ɖ߂B
			memset(& fsX86File, 0, sizeof(FileStream));
			GetTempFileName(szTempFullPath, "PQA", 0, fsX86File.szFileName);
			fsX86File.bRemove = TRUE;
			err_chkf(fsX86File.Open(NULL, "w+b"), ERROR_TMP_OPEN);
			fsFile.fpFile = fsX86File.fpFile;
			alFileNames[i].size = 0;
			if (data2write[0])
			{
				alFileNames[i].size += data2write[0];
				err_false(fwrite((char *) data2write[1], 1, data2write[0], fsFile.fpFile), (unsigned) data2write[0], ERROR_CANNOT_WRITE)
			}
			if (data2write[2])
			{
				alFileNames[i].size += data2write[2];
				err_false(fwrite((char *) data2write[3], 1, data2write[2], fsFile.fpFile), (unsigned) data2write[2], ERROR_CANNOT_WRITE)
			}
			err_chkf(bsBuffer0.Free(), ERROR_HEAP_MEMORY);
			err_false(fseek(fsFile.fpFile, 0L, SEEK_SET), 0, ERROR_SET_POINT)
		}

		// ɂ݈̌ʒu擾B
		fpos_t poBefore = 0;
		err_false(fgetpos(fsWorkFile.fpFile, & poBefore), 0, ERROR_GET_POINT)

		// ۂ̈kJnB
		for (ULONGLONG ll = 0; ll < alFileNames[i].size; ++ll)
		{
			int c = fgetc(fsFile.fpFile);
			err_true(c, EOF, ERROR_CANNOT_READ)
			e.encode(c);

			// 𑗐M
			this->cbProc.sArchiveInfo.llWriteSize = ll;
			err_chkf(this->cbProc.SendProgress(ARCEXTRACT_INPROCESS), ERROR_USER_CANCEL)
		}

		// Ώۃt@C̏IƂ𑗐MB
		fpos_t poAfter = 0;
		err_false(fgetpos(fsWorkFile.fpFile, & poAfter), 0, ERROR_GET_POINT)
		this->cbProc.sArchiveInfo.llCompressedSize = poAfter - poBefore;
		this->cbProc.sArchiveInfo.wRatio = WORD(this->cbProc.sArchiveInfo.llCompressedSize / (alFileNames[i].size * 0.01));
		err_chkf(this->cbProc.SendProgress(6), ERROR_USER_CANCEL)

		// I
		if (fsFile.fpFile)
		{
			err_false(fclose(fsFile.fpFile), 0, ERROR_CLOSE_FILE)

			if (this->paiInfo.bEnableX86Optimize && alFileNames[i].size > 0)
			{
				err_false(remove(fsX86File.szFileName), 0, ERROR_TMP_COPY)
			}
		}
	}

	// IB
	e.flush();
	err_false(fclose(fsWorkFile.fpFile), 0, ERROR_CLOSE_FILE)

	// ̏ɂޔB
	err_false(fclose(this->fp), 0, ERROR_CLOSE_FILE)
	FileStream fsOriginal;
	memset(& fsOriginal, 0, sizeof(FileStream));
	GetTempFileName(szTempFullPath, "PQA", 0, fsOriginal.szFileName);
	err_false(remove(fsOriginal.szFileName), 0, ERROR_TMP_COPY)
	err_false(rename(this->paiInfo.szArchiveName, fsOriginal.szFileName), 0, ERROR_TMP_COPY)

	// ԏɂ̏ɂƒuB
	if (rename(fsWorkFile.szFileName, this->paiInfo.szArchiveName) != 0)
	{
		// Ő̏ɂ߂Błrename̓G[sȂB
		rename(fsOriginal.szFileName, this->paiInfo.szArchiveName);
		return ERROR_TMP_COPY;
	}

	// ̏ɂ̑ޔ폜Bۂ͕KvȂ(^^;
	err_false(remove(fsOriginal.szFileName), 0, ERROR_TMP_COPY)

	// nhw肵ĊJȂB
	this->fp = fopen(this->paiInfo.szArchiveName, "rb");
	err_true(this->fp, NULL, ERROR_ARC_FILE_OPEN)

	// ̏I𑗐MB
	err_chkf(this->cbProc.SendProgress(ARCEXTRACT_END), ERROR_USER_CANCEL)
	return 0;
}


// ɂ̃t@C̖OύXB
int API_NAME(Archive)::Rename(char * * szFileNames, API_NAME(Switch) * ps)
{
	// ŏɏ𑗐MB
	strncpy(this->cbProc.sArchiveInfo.szSourceFileName, this->paiInfo.szArchiveName, sizeof(this->cbProc.sArchiveInfo.szSourceFileName) - 1);
	this->cbProc.sArchiveInfo.dummy1[0] = 'n';
	err_chkf(this->cbProc.SendProgress(ARCEXTRACT_OPEN), ERROR_USER_CANCEL)

	// ƃfBNgݒB
	char szTempFullPath[FNAME_MAX32 + 1];
	if (_fullpath(szTempFullPath, ps->szWorkDirectory, sizeof(szTempFullPath) - 1) == NULL)
	{
		// ƃfBNgȂꍇB
		//
		// ̏ꍇAϐTEMPĎ擾Aݒ肷B
		// ϐTEMPsłꍇERROR_TMP_OPENԂ͂B
		strncpy(szTempFullPath, getenv("TEMP"), sizeof(szTempFullPath) - 1);
	}
	if (szTempFullPath[strlen(szTempFullPath) - 1] != '\\')
	{
		// \ȗp̕⊮B
		strncat(szTempFullPath, "\\", sizeof(szTempFullPath) - strlen(szTempFullPath) - 1);
	}

	// t@C(ChJ[h)擾Bt@CXg̍ŌNULLŏIB
	int nFileNames = 0;
	for (; szFileNames[nFileNames] != NULL; nFileNames++);

	// w肳ꂽԃtH_ɁAԏɂ쐬B
	// ł̒ԏɂ܂߂ԃt@C̖ḰAuuuu16i̗ƂPQAuuuu.tmpłB
	//
	// ܂AGetTempFileName݂Ȃt@CԂƂۏ؂Ă邱ƂA
	// ł͊Ƀt@C݂邩ǂ͍̌sĂ炸AIɏ㏑B
	//
	// XɁAȍ~̃G[ł͒ʏnhăt@C폜鑀삪Kvł邪A
	// ̓PaqTempFile鎞ɍsĂ邽߂ɂł͕KvȂB
	FileStream fsWorkFile;
	memset(& fsWorkFile, 0, sizeof(FileStream));
	GetTempFileName(szTempFullPath, "PQA", 0, fsWorkFile.szFileName);
	err_chkf(fsWorkFile.Open(NULL, "wb"), ERROR_TMP_OPEN)
	fsWorkFile.bRemove = TRUE;

	// CfbNXɃt@CǉB
	API_NAME(FileInfo) pfiInfo;
	int value = this->FindFile(TRUE, & pfiInfo);

	// UDA ł͏ݑ̑SĂɑΉĂȂ̂ŁAŒeB
	err_chkt(ARCHIVETYPE_UDA0213 <= this->paiInfo.dwArchiveType && this->paiInfo.dwArchiveType < ARCHIVETYPE_EMILCONT01, ERROR_UNKNOWN_LEVEL)

	if (value == 0)
	{
		// ɂ̓eB
		{
			char szBuffer[30];
			GetArchiveString(this->paiInfo.dwArchiveType, szBuffer, sizeof(szBuffer) - 1);
			// PAQ2ȑOł' 'gpB
			err_chkt(fprintf(fsWorkFile.fpFile, "%s", szBuffer) <= 0, ERROR_CANNOT_WRITE)
			if (this->paiInfo.dwArchiveType >= ARCHIVETYPE_PAQ3)
			{
				err_chkt(fprintf(fsWorkFile.fpFile, " -%d", this->paiInfo.nCompressionLevel - '0') <= 0, ERROR_CANNOT_WRITE)
			}
		}
		// PAQAR, AXPAQ̏ꍇB
		if (this->paiInfo.dwArchiveType >= ARCHIVETYPE_PAQAR10 && this->paiInfo.dwArchiveType <= ARCHIVETYPE_AXPAQ20 && this->paiInfo.bEnableX86Optimize)
		{
			err_false(fputc('e', fsWorkFile.fpFile), 'e', ERROR_CANNOT_WRITE)
		}
		err_chkt(fprintf(fsWorkFile.fpFile, "\r\n") <= 0, ERROR_CANNOT_WRITE)

		do
		{
			// t@CΏۂǂB
			int encount;
			for (encount = 0; encount < nFileNames && ! ismatchwildcard(szFileNames[encount], pfiInfo.szFileName); encount++);

			// ̔encount̒ĺABOOLɏB
			//
			//	TRUE(1)		:	~b^[BBΏہB
			//	FALSE(0)	:	~b^[BB  ΏۂłȂB
			//
			// ܂AnFileNames == 0̔́AΏۃt@Cw肳ĂȂꍇA
			// SẴt@CWJΏۂƂȂĂꍇɁATRUEԂ߂̔łB
			encount = nFileNames == 0 ? TRUE : encount != nFileNames;

			// Ώۂ̏ꍇEnumMembersProc𑗐MB
			// łȂ΃CfbNXɒǉ̂݁B
			if (encount)
			{
				// 𑗐M(EnumMembersProc)B
				//
				// ŏ𑗐M̂́A܂łȂCfbNXɏރt@CɂĂ̏擾邽߂łB
				strncpy(this->cbProc.sMemberInfo.szFileName, pfiInfo.szFileName, sizeof(this->cbProc.sMemberInfo.szFileName) - 1);
				strncpy(this->cbProc.sMemberInfo.szAddFileName, pfiInfo.szFileName, sizeof(this->cbProc.sMemberInfo.szAddFileName) - 1);
				this->cbProc.sMemberInfo.llOriginalSize = pfiInfo.llFileSize;
				this->cbProc.sMemberInfo.uCommand = PAQ_RENAME_COMMAND;

				// TRUEԂꂽꍇAt@Cl[ăCfbNXɏށB
				if (this->cbProc.SendFileInfo())
				{
					// ύXꂽf[^擾B
					strncpy(pfiInfo.szFileName, this->cbProc.sMemberInfo.szFileName, sizeof(pfiInfo.szFileName) - 1);
				}
			}

			// 𑗐M(SetOwnerWindow)B
			strncpy(this->cbProc.sArchiveInfo.szSourceFileName, this->cbProc.sMemberInfo.szAddFileName, sizeof(this->cbProc.sArchiveInfo.szSourceFileName) - 1);
			strncpy(this->cbProc.sArchiveInfo.szDestFileName, pfiInfo.szFileName, sizeof(this->cbProc.sArchiveInfo.szDestFileName) - 1);
			this->cbProc.sArchiveInfo.llFileSize = pfiInfo.llFileSize;
			err_chkf(this->cbProc.SendProgress(ARCEXTRACT_BEGIN), ERROR_USER_CANCEL)

			// CfbNXɒǉ݁B
			err_chkt(fprintf(fsWorkFile.fpFile, this->paiInfo.dwArchiveType < ARCHIVETYPE_PAQ1 ? "%9ld " : this->paiInfo.dwArchiveType < ARCHIVETYPE_PAQ3 ? "%10ld " : "%I64u\t", pfiInfo.llFileSize) <= 0, ERROR_CANNOT_WRITE)
			err_chkt(fprintf(fsWorkFile.fpFile, "%s\r\n", pfiInfo.szFileName) <= 0, ERROR_CANNOT_WRITE)

			// 𑗐M(SetOwnerWindow)B
			err_chkf(this->cbProc.SendProgress(6), ERROR_USER_CANCEL)
		}
		while ((value = this->FindFile(FALSE, & pfiInfo)) == 0);
	}

	// G[oB
	err_false(value, -1, value)

	// CfbNXI032݁B
	err_true(fputc(032, fsWorkFile.fpFile), EOF, ERROR_CANNOT_WRITE)
	// PAQ6ȑO
	if (this->paiInfo.dwArchiveType < ARCHIVETYPE_PAQ6)
	{
		err_true(fputc('\f', fsWorkFile.fpFile), EOF, ERROR_CANNOT_WRITE)
		err_true(fputc('\0', fsWorkFile.fpFile), EOF, ERROR_CANNOT_WRITE)
	}

	// ̃f[^𒆊ԏɂɃRs[B
	// fread/fwritegΑȂ悤ȋC邯Ǎ̂ƂCɂȂȂ̂ł낵B
	int cChar;
	while ((cChar = fgetc(this->fp)) != EOF)
	{
		fputc(cChar, fsWorkFile.fpFile);
	}

	// IB
	err_false(fclose(fsWorkFile.fpFile), 0, ERROR_CLOSE_FILE)

	// ̏ɂޔB
	err_false(fclose(this->fp), 0, ERROR_CLOSE_FILE)
	FileStream fsOriginal;
	memset(& fsOriginal, 0, sizeof(FileStream));
	GetTempFileName(szTempFullPath, "PQA", 0, fsOriginal.szFileName);
	err_false(remove(fsOriginal.szFileName), 0, ERROR_TMP_COPY)
	err_false(rename(this->paiInfo.szArchiveName, fsOriginal.szFileName), 0, ERROR_TMP_COPY)

	// ԏɂ̏ɂƒuB
	if (rename(fsWorkFile.szFileName, this->paiInfo.szArchiveName) != 0)
	{
		// Ő̏ɂ߂Błrename̓G[sȂB
		rename(fsOriginal.szFileName, this->paiInfo.szArchiveName);
		return ERROR_TMP_COPY;
	}

	// ̏ɂ̑ޔ폜Bۂ͕KvȂ(^^;
	err_false(remove(fsOriginal.szFileName), 0, ERROR_TMP_COPY)

	// nhw肵ĊJȂB
	this->fp = fopen(this->paiInfo.szArchiveName, "rb");
	err_true(this->fp, NULL, ERROR_ARC_FILE_OPEN)

	// ̏I𑗐MB
	err_chkf(this->cbProc.SendProgress(ARCEXTRACT_END), ERROR_USER_CANCEL)
	return 0;
}
