// Paq32.dll
// $Id: Classes.h,v 1.1 2006/03/07 08:29:03 sirakaba Exp $

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "Paq32.h"

//******************************************************************************
//    萔`
//******************************************************************************

#ifndef FNAME_MAX32
#define FNAME_MAX32 512
#endif

#ifndef H_LOADED_CLASSES
#define H_LOADED_CLASSES

//******************************************************************************
//    NX` (BufferStream)
//******************************************************************************

class BufferStream
{
	public:
		BufferStream(void);
		~BufferStream(void);
		BOOL Allocate(size_t);
		BOOL Free(void);

		char * lpBuffer;
		size_t BufferSize;
};

//******************************************************************************
//    NX` (ArrayStream)
//******************************************************************************

class ArrayStream
{
	public:
		ArrayStream(void);
		~ArrayStream(void);
		BOOL Allocate(size_t, size_t);
		BOOL ChangeSize(size_t);
		BOOL Free(void);

		void * lpBuffer;
		size_t BufferSize;
		size_t ItemCount;
};

//******************************************************************************
//    NX` (FileStream)
//******************************************************************************

class FileStream
{
	public:
		FileStream(void);
		~FileStream(void);
		BOOL Open(const char *, const char *);

		FILE * fpFile;
		char szFileName[FNAME_MAX32 + 1];
		BOOL bRemove;
};

//******************************************************************************
//    NX` (Callback)
//******************************************************************************

class Callback
{
	public:
		Callback(void);

		BOOL SendFileInfo(void);
		BOOL SendProgress(UINT);

		struct ArchiveInfo
		{
			ULONGLONG llFileSize;
			ULONGLONG llCompressedSize;
			UINT64 llWriteSize;
			DWORD dwAttributes;
			DWORD dwCRC;
			WORD wRatio;
			WORD wDate;
			WORD wTime;
			FILETIME ftCreateTime;
			FILETIME ftAccessTime;
			FILETIME ftWriteTime;
			char szMode[8];
			char szSourceFileName[FNAME_MAX32 + 1];
			char szDestFileName[FNAME_MAX32 + 1];
			char dummy1[3];
		}	sArchiveInfo;

		struct MemberInfo
		{
			UINT uCommand;
			ULONGLONG llOriginalSize;
			ULONGLONG llCompressedSize;
			DWORD dwAttributes;
			DWORD dwCRC;
			WORD wRatio;
			FILETIME ftCreateTime;
			FILETIME ftAccessTime;
			FILETIME ftWriteTime;
			char szFileName[FNAME_MAX32 + 1];
			char szAddFileName[FNAME_MAX32 + 1];
		}	sMemberInfo;

		struct Progress
		{
			UINT uID_Progress;
			HWND hwDialog;
			ARCHIVERPROC apCallbackProc;
			DWORD dwStructureSize;
		}	sProgress;

		struct FileInfo
		{
			PAQ_WND_ENUMMEMBPROC epCallbackProc;
			DWORD dwStructureSize;
		}	sFileInfo;
};

#include "CArchiver.h"

//******************************************************************************
//    NX` (RegistryConfig)
//******************************************************************************

class RegistryConfig
{
	public:
		RegistryConfig();
		~RegistryConfig();

		BOOL SetConfig(API_NAME(ArchiveInfo) * pai);
		BOOL GetConfig(API_NAME(ArchiveInfo) * pai);

		struct CommonConfig
		{
			BOOL bExtractAttribute;
			BOOL bJunkDirectory;
			DWORD dwBadPathLevel;
			DWORD dwDirectoryMode;
			DWORD dwOverWriteMode;
			char szDefaultDir[_MAX_PATH];
		};

		BOOL GetConfig(API_NAME(ArchiveInfo) * pai, RegistryConfig::CommonConfig * cc);

	private:
		HKEY hKey;
};

#endif
