// Paq32.dll
// $Id: function.cpp,v 1.4 2006/03/20 09:57:58 sirakaba Exp $

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "StdAfx.h"
#include <windowsx.h>
#include "Classes.h"
#include "function.h"
#include "inuse.h"
#include "resource.h"

//******************************************************************************
//    ֐錾
//******************************************************************************

int isJMS(const char *str, size_t nPos){
	int state = 0;
	for(size_t i = 0; i < strlen(str); i++){
		state = ((state == 0) && (jms1(*(str + i))) ? 1
			:	((state == 1) && (jms2(*(str + i))) ? 2
			:	((state == 2) && (jms1(*(str + i))) ? 1
			:	0)));
		if(i == nPos) return state;
	}
	return 0;
}

int cmdline2array(char **argv, const char *cmdline){
	int len = 0, r, argc = 0;
	char src[10000], temp[512];
	snprintf(src, sizeof(src) - 1, cmdline);
	for (size_t i = 0; i < strlen(src); i++)
	{
		if (isJMS(src, i) == 0 && src[i] == '\\')
		{
			src[i] = '/';
		}
	}
	while(isJMS(src, len) == 0 && src[len] != '\0'){
		while(isJMS(src, len) == 0 && (src[len] == ' ' || src[len] == '\n' || src[len] == '\r')) len++;
		if(isJMS(src,len) == 0 && src[len] == '\0'){
			argv[argc] = "\0";
			return argc;
		}
		if(isJMS(src, len) == 0 && src[len] == '\"'){
			len++;
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argv[argc] = "\0";
				return argc;
			}
			r = 0;
			while(src[len] != '\"' && src[len] != '\0'){
r1:
				temp[r] = src[len];
				len++;
				r++;
			}
			if(isJMS(src, len) != 0) goto r1;
			temp[r] = '\0';
			argv[argc] = strdup(temp);
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argc++;
				argv[argc] = "\0";
				return argc;
			}
			len++;
		}else{
			r = 0;
			while(src[len] != ' ' && src[len] != '\n' && src[len] != '\r' && src[len] != '\0'){
r2:
				temp[r] = src[len];
				len++;
				r++;
			}
			if(isJMS(src, len) != 0) goto r2;
			temp[r] = '\0';
			argv[argc] = strdup(temp);
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argc++;
				argv[argc] = "\0";
				return argc;
			}
		}
		argc++;
	}
	argv[argc] = "\0";
	return argc;
}

char * jmsnext(const char * p){
	return (char*)(p + ( *p == '\0' ? 0 : (jms1(p[0]) && '\0' != p[1]) ? 2 : 1));
}

int jmscode(const char * p){
	return (jms1(p[0]) && ('\0' != p[1])) ? ((WORD)(((BYTE)(p[1]) & 0xFF) | (((BYTE)(p[0]) & 0xFF) << 8))) : (unsigned char)p[0];
}

int jmsmatch(const char *ptn, const char *str){
	switch (jmscode(ptn)){
		case '\0': return *str == '\0';
		case '*':  return jmsmatch(jmsnext(ptn),str) || ((*str != '\0')	&& jmsmatch(		ptn,	jmsnext(str)));
		case '?':  return								 (*str != '\0')	&& jmsmatch(jmsnext(ptn),	jmsnext(str));
		default:   return jmscode(ptn) == jmscode(str)					&& jmsmatch(jmsnext(ptn),	jmsnext(str));
	}
}

int ismatchwildcard(const char *wildcard, const char *string){
	char ptn[513], str[513];
	size_t i, length;
	if(wildcard == NULL || string == NULL) return 0;
	strcpy(ptn, wildcard);
	strcpy(str, string);
	length = strlen(ptn);
	for(i = 0; i < length;i++) if(isJMS(ptn,i) == 0){
		ptn[i] = toupper(ptn[i]);
		if (ptn[i] == '\\') ptn[i] = '/';
	}
	length = strlen(str);
	for(i = 0;i < length; i++) if(isJMS(str,i) == 0){
		str[i] = toupper(str[i]);
		if (str[i] == '\\') str[i] = '/';
	}
	return jmsmatch(ptn,str);
}

void DoEvents(void)
{
	for (MSG msg; PeekMessage(& msg, 0, 0, 0, PM_REMOVE); )
	{
		TranslateMessage(& msg);
		DispatchMessage(& msg);
	}
}

void AddStatusText(HWND hWnd, const TCHAR * str)
{
	HWND hEditBox = ::GetDlgItem(hWnd, ID_DLG_PROCESS_EDIT);
	int idx = Edit_LineIndex(hEditBox, Edit_GetLineCount(hEditBox) - 1);
	if(idx < 0) return;
	int pos = Edit_LineLength(hEditBox, idx) + idx;
	Edit_SetSel(hEditBox, pos, pos);
	Edit_ReplaceSel(hEditBox, str);
}

BOOL GetMinimizeName(char * szBuffer, const char * szBase, size_t nBufferSize)
{
	memset(szBuffer, 0, nBufferSize);
    if (! szBuffer || ! szBase || nBufferSize < 4)
    {
        return FALSE;
    }
    if (strlen(szBase) < nBufferSize)
    {
        strncpy(szBuffer, szBase, nBufferSize);
        return TRUE;
    }
	strncpy(szBuffer, szBase, size_t(nBufferSize / 2));
	snprintf(szBuffer, nBufferSize, "%s...%s", szBuffer, szBase + (strlen(szBase) - size_t(nBufferSize / 2) + 3));

	return TRUE;
}

DWORD FileTimeToTimet(const FILETIME * ft)
{
	SYSTEMTIME stTime;
	FileTimeToSystemTime(ft, & stTime);

	tm tmTime;
	tmTime.tm_year = stTime.wYear - 1900;
	tmTime.tm_mon = stTime.wMonth - 1;
	tmTime.tm_mday = stTime.wDay;
	tmTime.tm_hour = stTime.wHour;
	tmTime.tm_min = stTime.wMinute;
	tmTime.tm_sec = stTime.wSecond;
	tmTime.tm_isdst = -1;
	return (DWORD) mktime(& tmTime);
}

FILETIME TimetToFileTime(const __time64_t & tTime)
{
	// 1601/01/01 00:00:001970/01/01 00:00:00܂ł̕b𑫂ĂH
#ifdef __GNUC__
	LONGLONG ll = Int32x32To64(tTime, 10000000) + 116444736 * 1000000000;
#else
	LONGLONG ll = Int32x32To64(tTime, 10000000) + 116444736000000000;
#endif
	FILETIME ft;
	ft.dwLowDateTime = (DWORD) ll;
	ft.dwHighDateTime = ll >> 32;
	return ft;
}

#undef LoadString
int LoadString(HINSTANCE hInstance, UINT uID, LPSTR lpBuffer, int nBufferMax)
{
	// WXg當擾B
	{
		DWORD dwType;
		DWORD dwBufferSize = nBufferMax;
		char szSubKey[100];
		HKEY hStringKey;

		// HKEY_CURRENT_USERJB
		sprintf(szSubKey, "Software\\ArchiverDll\\Paq32\\String\\%04X", g_LanguageID);
		if (RegOpenKeyEx(HKEY_CURRENT_USER, szSubKey, 0, KEY_READ, & hStringKey) == ERROR_SUCCESS)
		{
			// 擾B
			sprintf(szSubKey, "%u", uID);
			if (RegQueryValueEx(hStringKey, szSubKey, NULL, & dwType, (LPBYTE) lpBuffer, & dwBufferSize) == ERROR_SUCCESS)
			{
				RegCloseKey(hStringKey);
				return dwBufferSize;
			}
			RegCloseKey(hStringKey);
		}

		// HKEY_LOCAL_MACHINEJB
		sprintf(szSubKey, "Software\\ArchiverDll\\Paq32\\String\\%04X", g_LanguageID);
		if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, szSubKey, 0, KEY_READ, & hStringKey) == ERROR_SUCCESS)
		{
			// 擾B
			sprintf(szSubKey, "%u", uID);
			if (RegQueryValueEx(hStringKey, szSubKey, NULL, & dwType, (LPBYTE) lpBuffer, & dwBufferSize) == ERROR_SUCCESS)
			{
				RegCloseKey(hStringKey);
				return dwBufferSize;
			}
			RegCloseKey(hStringKey);
		}
	}

	char * pData = (char *) LockResource(LoadResource(hInstance, FindResourceEx(hInstance, RT_STRING, MAKEINTRESOURCE((uID >> 4) + 1), g_LanguageID)));
	if (pData == NULL)
	{
		// ꃊ\[XȂꍇ́Apꃊ\[Xǂݍ݁B
		pData = (char *) LockResource(LoadResource(hInstance, FindResourceEx(hInstance, RT_STRING, MAKEINTRESOURCE((uID >> 4) + 1), MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US))));
		if (pData == NULL)
		{
			return 0;
		}
	}

	for (unsigned int i = 0; i < (uID & 15); i++)
	{
		pData += * (LPWORD) pData * 2 + 2;
	}
	int nLen = * (LPWORD) pData;
	pData += 2;

	nBufferMax = WideCharToMultiByte(0, 0, (WCHAR *) pData, nLen, lpBuffer, nBufferMax, 0, 0);
	lpBuffer[nBufferMax] = 0;
	return nBufferMax;
}

int MakeFileList(const char * key, char * basedir, AddList * addlist, BOOL r, int & current)
{
	intptr_t hSearch;
    struct _finddata_t fdata;
    char fulldir[513];
    char savename[513];
    char fullpath[513];
    AddList al;
    if ((hSearch = _findfirst((char *) key, & fdata)) == -1)
    {
        if (errno == ENOENT)
        {
            return 0;
        }
        return ERROR_GET_INFORMATION;
    }
    do
    {
		if (strcmp(fdata.name,".") != 0 && strcmp(fdata.name,"..") != 0)
        {
            if (fdata.attrib & _A_SUBDIR)
            {
                if (r == TRUE)
                {
                    /* fBNg */
					sprintf(savename,"%s%s/",basedir,fdata.name);
                    strcpy(fulldir,key);
					char * pLastSlash = strrchr(fulldir,'/');
					// "/"܂łȂ炻̌폜B
					(pLastSlash != NULL ? *(pLastSlash + 1) : fulldir[0]) = '\0';
                    sprintf(fullpath,"%s%s/*",fulldir,fdata.name);
					int nReturnCode = MakeFileList(fullpath,savename,addlist,r,current);
					if (nReturnCode != 0)
                    {
                        _findclose(hSearch);
                        return nReturnCode;
                    }
                }
            }
            else
            {
                /* t@C */
                if (addlist != NULL)
                {
					sprintf(savename,"%s%s",basedir,fdata.name);
					if (strrchr(key, '/'))
					{
						strcpy(fulldir,key);
						*(strrchr(fulldir,'/') + 1) = '\0';
					}
					else
					{
						strcpy(fulldir, "");
					}
                    sprintf(fullpath,"%s%s",fulldir,fdata.name);
                    strcpy(al.savename,savename);
                    strcpy(al.filename,fullpath);
					addlist[current++] = al;
                }
                else
                {
                    current++;
                }
            }
        }
    }
	while (_findnext(hSearch, & fdata) == 0);
	return _findclose(hSearch) == 0 ? 0 : ERROR_HANDLE;
}

int MakeSeparatedList(int argc, const char * * argv, char * * szFiles)
{
	int nFiles = 0;
	for (int nArg = 0; nArg < argc; nArg++)
	{
		if (argv[nArg][0] == '@')
		{
			// X|Xt@Cf[^ǂݍ݁B
			FILE * f = fopen(argv[nArg] + 1, "r");
			if (! f)
			{
				return ERROR_RESPONSE_READ;
			}
			fseek(f, 0L, SEEK_END);
			int nResBuf = ftell(f);
			fseek(f, 0L, SEEK_SET);
			// +2mۂ̂́Ả͂NULL|C^ǂ܂邽߁B
			char * szResBuf = (char *) malloc(nResBuf + 2);
			if (szResBuf == NULL)
			{
				return ERROR_MORE_HEAP_MEMORY;
			}
			memset(szResBuf, 0, nResBuf);
			fread(szResBuf, 1, nResBuf, f);
			fclose(f);

			// ǂݍ񂾃f[^́B
			char * pBefore = szResBuf;
			size_t uLen = strlen(szResBuf);
			for (size_t i = 0; i < uLen; i++)
			{
				if (szResBuf[i] == '\n' || szResBuf[i] == 0)
				{
					szResBuf[i] = 0;
					if (strcmp(pBefore, "") != 0)
					{
						szFiles[nFiles++] = strdup(pBefore);
						pBefore = szResBuf + i + 1;
					}
				}
			}
			free(szResBuf);
		}
		else
		{
			szFiles[nFiles++] = strdup(argv[nArg]);
		}
	}
	szFiles[nFiles] = NULL;

	return 0;
}

BOOL MakeSureDirectoryPathExists(const char * szDirPath)
{
	char szCopied[MAX_PATH];
	strncpy(szCopied, szDirPath, sizeof(szCopied) - 1);

	// UNC͍lĂȂB
	for (size_t t = 0; t < strlen(szCopied); t++)
	{
		// "\""/"ɕϊB
		if (isJMS(szCopied, t) == 0 && szCopied[t] == '\\')
		{
			szCopied[t] = '/';
		}

		if (szCopied[t] == '/')
		{
			char szDevided[MAX_PATH];
			memset(szDevided, 0, sizeof(szDevided));
			strncpy(szDevided, szCopied, t);
			if (mkdir(szDevided) == -1)
			{
				if (errno == EEXIST)
				{
					struct _stati64 stInfo;
					if (_stati64(szDevided, & stInfo) == 0 && stInfo.st_mode & _S_IFDIR)
					{
						// fBNg݂ꍇɂ͏𑱍sB
						continue;
					}
				}

				if (szDevided[t - 1] == ':')
				{
					// hCuw肳ĂꍇB
					continue;
				}
				return FALSE;
			}
		}
	}
	return TRUE;
}

void CenteringWindow(HWND _hwnd, HWND _hwParent)
{
	if (_hwParent == NULL)
	{
		_hwParent = GetDesktopWindow();
	}
	RECT rc;
	GetWindowRect(_hwnd, & rc);
	int nWidth = rc.right - rc.left, nHeight = rc.bottom - rc.top;
	GetWindowRect(_hwParent, & rc);
	MoveWindow(_hwnd, ((rc.right + rc.left) - nWidth) / 2, ((rc.bottom + rc.top) - nHeight) / 2, nWidth, nHeight, TRUE);
	ShowWindow(_hwnd, SW_SHOW);
	DoEvents();
}

BOOL ErrorConfirmDialog(HWND _hWnd, int nErrorCode, BOOL bIsError)
{
	// eLXgǂݍ݁B
	char szString[1024 + 1], szString2[1024 + 1], szString3[1024 + 1];
	LoadString(hDLL, (bIsError || pps->sQuietInfo.eWarningAsError == '2') ? IDS_DLG_ERROR_TEXT : IDS_DLG_WARNING_TEXT, szString, sizeof(szString) - 1);
	sprintf(szString3, szString, nErrorCode);
	LoadString(hDLL, IDS_STATIC_DLLNAME, szString2, sizeof(szString) - 1);

	// _CAO\B
	return ::MessageBoxEx(_hWnd, szString3, szString2, (bIsError || pps->sQuietInfo.eWarningAsError == '2') ? (MB_OK | MB_ICONERROR) : (MB_YESNO | MB_ICONWARNING), g_LanguageID) == IDYES;
}

BOOL CancelConfirmDialog(HWND _hWnd)
{
	// eLXgǂݍ݁B
	char szString[1024 + 1], szString2[1024 + 1];
	LoadString(hDLL, IDS_DLG_CANCEL_CONFIRM, szString,  sizeof(szString)  - 1);
	LoadString(hDLL, IDS_STATIC_DLLNAME,     szString2, sizeof(szString2) - 1);

	// _CAO\B
	g_Cancel = ::MessageBoxEx(_hWnd, szString, szString2, MB_YESNO | MB_ICONWARNING, g_LanguageID) == IDYES;
	return g_Cancel;
}

BOOL CALLBACK RenameDialogProc(HWND _hwnd, UINT in_message, WPARAM in_wp, LPARAM in_lp)
{
	LPPAQ_ENUM_MEMBER_INFO64 lpInfo = (LPPAQ_ENUM_MEMBER_INFO64) in_lp;
	switch (in_message)
	{
		case WM_INITDIALOG:
		{
			// eLXgǂݍ݁B
			char szString[1024 + 1], szString2[1024 + 1];

			LoadString(hDLL, IDS_DLG_RENAME, szString, sizeof(szString) - 1);
			SendMessage(_hwnd, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_RENAME_LABEL, szString, 1024 - 1);
			snprintf(szString2, sizeof(szString2) - 1, szString, lpInfo->uCommand == PAQ_RENAME_COMMAND ? lpInfo->szFileName : lpInfo->szAddFileName);
			SendDlgItemMessage(_hwnd, ID_DLG_RENAME_LABEL, WM_SETTEXT, 0, (LPARAM) szString2);

			// t@CݒB
			HWND hEditBox = ::GetDlgItem(_hwnd, ID_DLG_RENAME_NEWNAME);
			::SendMessage(hEditBox, WM_SETTEXT, 0, (LPARAM) (lpInfo->uCommand == PAQ_RENAME_COMMAND ? lpInfo->szFileName : lpInfo->szAddFileName));
			Edit_LimitText(hEditBox, (lpInfo->uCommand == PAQ_RENAME_COMMAND ? sizeof(lpInfo->szFileName) : sizeof(lpInfo->szAddFileName)) - 1);

			LoadString(hDLL, IDS_BUTTON_OK, szString, sizeof(szString) - 1);
			::SendDlgItemMessage(_hwnd, ID_BUTTON_OK, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_CANCEL, szString, sizeof(szString) - 1);
			::SendDlgItemMessage(_hwnd, ID_BUTTON_CANCEL, WM_SETTEXT, 0, (LPARAM) szString);

			// O[oϐɃRs[B
			pEnum = lpInfo;

			// \
			CenteringWindow(_hwnd, cbProc.sProgress.hwDialog);
			return true;
		}
		case WM_COMMAND:
			switch (in_wp)
			{
				case ID_BUTTON_OK:
				{
					// t@C擾B
					char szString[1024 + 1];
					SendDlgItemMessage(_hwnd, ID_DLG_RENAME_NEWNAME, WM_GETTEXT, sizeof(szString) - 1, (LPARAM) szString);

					// s̃R}hɂ蕪B
					if (pEnum->uCommand == PAQ_EXTRACT_COMMAND)
					{
						// t@C݂ꍇɂ́B
						FILE * fpTemp = fopen(szString, "rb");
						if (fpTemp)
						{
							fclose(fpTemp);

							LoadString(hDLL, IDS_DLG_RENAME_WARNING, szString, sizeof(szString) - 1);
							char szString2[1024 + 1];
							LoadString(hDLL, IDS_STATIC_DLLNAME, szString2, sizeof(szString2) - 1);
							::MessageBoxEx(_hwnd, szString, szString2, MB_OK | MB_ICONERROR, g_LanguageID);
							return true;
						}
					}

					// t@C݂Ȃꍇ邢͓WJȊÓAIB
					strncpy(pEnum->uCommand == PAQ_RENAME_COMMAND ? pEnum->szFileName : pEnum->szAddFileName, szString, (pEnum->uCommand == PAQ_RENAME_COMMAND ? sizeof(pEnum->szFileName) : sizeof(pEnum->szAddFileName)) - 1);
					EndDialog(_hwnd, TRUE);
					return true;
				}
				case ID_BUTTON_CANCEL:
					// LZ̏ꍇFALSEԂB
					EndDialog(_hwnd, FALSE);
					return true;
			}
			break;
		case WM_CLOSE:
			EndDialog(_hwnd, FALSE);
			return true;
	}
	return false;
}

BOOL CALLBACK ConfirmDialogProc(HWND _hwnd, UINT in_message, WPARAM in_wp, LPARAM in_lp)
{
	switch (in_message)
	{
		case WM_INITDIALOG:
		{
			pEnum = (LPPAQ_ENUM_MEMBER_INFO64) in_lp;

			// ݒmF
			if(pps->sQuietInfo.eRewritingFile != '0')
			{
				EndDialog(_hwnd, pps->sQuietInfo.eRewritingFile == '1');
				return true;
			}

			// eLXgǂݍ݁B
			char szString[1024 + 1];

			LoadString(hDLL, IDS_DLG_CONFIRM_CAPTION, szString, sizeof(szString) - 1);
			SendMessage(_hwnd, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_CONFIRM_ASK, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIRM_ASK, WM_SETTEXT, 0, (LPARAM) szString);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIRM_FILE, WM_SETTEXT, 0, (LPARAM) pEnum->szAddFileName);

			LoadString(hDLL, IDS_BUTTON_YES, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_YES, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_ALWAYS, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_ALWAYS, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_NO, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_NO, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_NONE, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_NONE, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_CANCEL, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_CANCEL, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_RENAME, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_RENAME, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_CONFIRM_ORIGINAL, szString, sizeof(szString) - 1);
			snprintf(szString, 1024 - 1, szString, pEnum->llCompressedSize);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIRM_ORIGINAL, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_CONFIRM_NEW, szString, sizeof(szString) - 1);
			snprintf(szString, 1024 - 1, szString, pEnum->llOriginalSize);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIRM_NEW, WM_SETTEXT, 0, (LPARAM) szString);

			// \
			CenteringWindow(_hwnd, cbProc.sProgress.hwDialog);
			return true;
		}
		case WM_COMMAND:
			switch (in_wp)
			{
				case ID_BUTTON_ALWAYS:
					pps->sQuietInfo.eRewritingFile = '1';
				case ID_BUTTON_YES:
					EndDialog(_hwnd, true);
					return true;
				case ID_BUTTON_NONE:
					pps->sQuietInfo.eRewritingFile = '2';
				case ID_BUTTON_NO:
					EndDialog(_hwnd, false);
					return true;
				case ID_BUTTON_CANCEL:
					if (CancelConfirmDialog(_hwnd))
					{
						EndDialog(_hwnd, false);
					}
					return true;
				case ID_BUTTON_RENAME:
					// l[_CAONB[ OK ]{^TRUEB
					if (DialogBoxParam(hDLL, MAKEINTRESOURCE(ID_DLG_RENAME), _hwnd, RenameDialogProc, (LPARAM) pEnum))
					{
						EndDialog(_hwnd, true);
					}

					// Note :
					// R_CAOgp@B
					// gpɂ͂قږȂAg_OwnerWindoŵXĂ܂߁AgpĂȂB
					// ̂߁Ai󋵂\_CAOꂽɖɂȂĂ܂B
					// ԐړIɂ́Ag_OwnerWindow._hwndNULLǂ`FbNDoEvents()sĂ̂ł邪A
					// CƂŃoȌCɂ͂ȂȂ̂Ō̂܂܂ɂĂB
					//
					//	// l[_CAOĂяoB
					//	OPENFILENAME ofn;
					//	memset(& ofn, 0, sizeof(OPENFILENAME));
					//	ofn.lStructSize = sizeof(OPENFILENAME);
					//	ofn.hwndOwner = _hwnd;
					//	ofn.lpstrFile = pEnum->szAddFileName;
					//	ofn.nMaxFile = sizeof(pEnum->szAddFileName) - 1;
					//	ofn.Flags = OFN_OVERWRITEPROMPT | OFN_NOTESTFILECREATE;
					//	
					//	// [ OK ]{^ΏIB
					//	if (GetSaveFileName(& ofn) != 0)
					//	{
					//		EndDialog(_hwnd, true);
					//	}
					return true;
			}
			return false;
		case WM_CLOSE:
			EndDialog(_hwnd, false);
			return true;
	}
	return false;
}

BOOL CALLBACK ProcessDialogProc(HWND _hwnd, UINT in_message, WPARAM in_wp, LPARAM in_lp)
{
	switch (in_message)
	{
		case WM_INITDIALOG:
			g_Cancel = false;

			// eLXgǂݍ݁B
			char szString[1024 + 1];

			LoadString(hDLL, IDS_DLG_PROCESS_CAPTION, szString, sizeof(szString) - 1);
			SendMessage(_hwnd, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_PROCESS_TARGET, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_DLG_PROCESS_TARGET_LABEL, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_PROCESS_ARCHIVE, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_DLG_PROCESS_ARCHIVE_LABEL, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_CANCEL, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_CANCEL, WM_SETTEXT, 0, (LPARAM) szString);

			return true;
		case WM_COMMAND:
			if (in_wp != ID_BUTTON_CANCEL)
			{
				break;
			}
		case WM_CLOSE:
			return CancelConfirmDialog(_hwnd);
		default:
			if (in_message != cbProc.sProgress.uID_Progress)
			{
				return false;
			}
			LPEXTRACTINGINFOEX64 lpInfo = (LPEXTRACTINGINFOEX64) in_lp;

			switch (in_wp)
			{
				case ARCEXTRACT_BEGIN:
				{
					// t@CJn (3) (4)
					char szString[1024 + 1];
					GetMinimizeName(szString, lpInfo->szDestFileName, 39);
					SendDlgItemMessage(_hwnd, ID_DLG_PROCESS_TARGET_FILE, WM_SETTEXT, 0, (LPARAM) szString);
					SendDlgItemMessage(_hwnd, ID_DLG_PROCESS_PROGRESS, PBM_SETPOS, 0, 0);

					LoadString(hDLL, lpInfo->dummy1[0] == 'a' ? IDS_DLG_PROCESS_PERFILE_ADD : lpInfo->dummy1[0] == 'n' ? IDS_DLG_PROCESS_PERFILE_OPERATE : IDS_DLG_PROCESS_PERFILE_EXTRACT, szString, sizeof(szString) - 1);
					char szString2[1024 + 1];
					snprintf(szString2, sizeof(szString2) - 1, szString, lpInfo->szSourceFileName, lpInfo->llFileSize);
					AddStatusText(_hwnd, szString2);
					break;
				}
				case ARCEXTRACT_INPROCESS:
					// t@C (5) (8) (10)
					SendDlgItemMessage(_hwnd, ID_DLG_PROCESS_PROGRESS, PBM_SETPOS, int(lpInfo->llWriteSize / (lpInfo->llFileSize * 0.01)), 0);
					break;
				case ARCEXTRACT_END:
					// I (11)
					break;
				case ARCEXTRACT_OPEN:
				{
					// ɖݒ (1)
					char szString[1024 + 1];
					GetMinimizeName(szString, lpInfo->szSourceFileName, 39);
					SendDlgItemMessage(_hwnd, ID_DLG_PROCESS_ARCHIVE_FILE, WM_SETTEXT, 0, (LPARAM) szString);
					LoadString(hDLL, lpInfo->dummy1[0] == 'a' ? IDS_DLG_PROCESS_BEGIN_ADD : lpInfo->dummy1[0] == 'n' ? IDS_DLG_PROCESS_BEGIN_OPERATE : IDS_DLG_PROCESS_BEGIN_EXTRACT, szString, sizeof(szString) - 1);
					AddStatusText(_hwnd, szString);
					break;
				}
				case ARCEXTRACT_COPY:
					// ƃt@C߂ (9)
				case 5:
					// t@C (2)
					break;
				case 6:
				{
					// t@CI (6)
					char szString[1024 + 1];
					LoadString(hDLL, lpInfo->dummy1[0] == 'n' ? IDS_DLG_PROCESS_PERFILE_OPERATE_END : IDS_DLG_PROCESS_PERFILE_END, szString, sizeof(szString) - 1);
					char szString2[1024 + 1];
					if (lpInfo->dummy1[0] == 'n')
					{
						snprintf(szString2, sizeof(szString2) - 1, szString, lpInfo->szDestFileName);
					}
					else
					{
						snprintf(szString2, sizeof(szString2) - 1, szString, lpInfo->dummy1[0] == 'a' ? lpInfo->llCompressedSize : lpInfo->llFileSize);
					}
					AddStatusText(_hwnd, szString2);
					break;
				}
				case 7:
					// Jn (7)
					break;
			}

			return g_Cancel == false;
	}
	return false;
}

BOOL CALLBACK ProcessEnumMembersProc(LPVOID _lpInfo)
{
	LPPAQ_ENUM_MEMBER_INFO64 lpInfo = (LPPAQ_ENUM_MEMBER_INFO64) _lpInfo;

	switch (lpInfo->uCommand)
	{
		case PAQ_EXTRACT_COMMAND:
		{
			fpos_t ll;
			FILE * f = fopen(lpInfo->szFileName, "rb");
			if(! f) return true;
			fseek(f, 0, SEEK_END);
			fgetpos(f, & ll);
			lpInfo->llCompressedSize = ll;
			fclose(f);
			return DialogBoxParam(hDLL, MAKEINTRESOURCE(ID_DLG_CONFIRM), cbProc.sProgress.hwDialog, ConfirmDialogProc, (LPARAM) lpInfo);
		}
		case PAQ_RENAME_COMMAND:
			return DialogBoxParam(hDLL, MAKEINTRESOURCE(ID_DLG_RENAME), cbProc.sProgress.hwDialog, RenameDialogProc, (LPARAM) lpInfo);
	}

	return true;
}

char * pszConfigBuffer = NULL;

BOOL CALLBACK ConfigDialogProc(HWND _hwnd, UINT in_message, WPARAM in_wp, LPARAM in_lp)
{
	switch (in_message)
	{
		case WM_INITDIALOG:
		{
			char szString[1024 + 1], szString2[1024 + 1];

			// eLXgǂݍ݁B
			LoadString(hDLL, IDS_DLG_CONFIG_CAPTION, szString, sizeof(szString) - 1);
			SendMessage(_hwnd, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_CONFIG_METHOD, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIG_METHOD, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_CONFIG_X86OPT, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIG_CHECK_X86OPT, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_OK, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_OK, WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_BUTTON_CANCEL, szString, sizeof(szString) - 1);
			SendDlgItemMessage(_hwnd, ID_BUTTON_CANCEL,	WM_SETTEXT, 0, (LPARAM) szString);

			LoadString(hDLL, IDS_DLG_CONFIG_VERSION, szString, sizeof(szString) - 1);
			sprintf(szString2, szString, (double) API_NAME(GetVersion)() / 100, (int) API_NAME(GetSubVersion)());
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIG_VERSION, WM_SETTEXT, 0, (LPARAM) szString2);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIG_SLIDER, TBM_SETRANGE, (WPARAM) TRUE, MAKELPARAM(0, 9));

			// WXgݒǂݍ݁B
			API_NAME(ArchiveInfo) pai;
			RegistryConfig rc;
			rc.GetConfig(& pai);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIG_SLIDER, TBM_SETPOS, (WPARAM) TRUE, (LPARAM) pai.nCompressionLevel);
			SendDlgItemMessage(_hwnd, ID_DLG_CONFIG_CHECK_X86OPT, BM_SETCHECK, (WPARAM) pai.bEnableX86Optimize, 0L);

			// |C^ۑB
			pszConfigBuffer = (char *) in_lp;

			// \
			CenteringWindow(_hwnd, NULL);
			return true;
		}
		case WM_COMMAND:
			switch (in_wp)
			{
				case ID_BUTTON_OK:
				{
					// WXgɐݒ݁B
					API_NAME(ArchiveInfo) pai;
					pai.nCompressionLevel = SendDlgItemMessage(_hwnd, ID_DLG_CONFIG_SLIDER, TBM_GETPOS, 0L, 0L);
					pai.bEnableX86Optimize = SendDlgItemMessage(_hwnd, ID_DLG_CONFIG_CHECK_X86OPT, BM_GETCHECK, 0L, 0L);
					RegistryConfig rc;
					rc.SetConfig(& pai);

					// |C^ɐݒ݁B
					if (pszConfigBuffer != NULL)
					{
						sprintf(pszConfigBuffer, "-m%d -x%d", pai.nCompressionLevel, pai.bEnableX86Optimize);
						pszConfigBuffer = NULL;
					}

					EndDialog(_hwnd, true);
					return true;
				}
				case ID_BUTTON_CANCEL:
					EndDialog(_hwnd, false);
					return true;
			}
			return true;
		case WM_CLOSE:
			EndDialog(_hwnd, false);
			return true;
	}
	return false;
}

// XCb`ϊB
BOOL ConvertSwitchToStruct(char * * argv, int & nPos, int argc, DWORD dwMode, API_NAME(ArchiveInfo) & pai, API_NAME(Switch) & ps)
{
	// ݒB
	pai.dwArchiveType = ARCHIVETYPE_PAQAR40;

	// |C^ۑB
	pps = & ps;

	// lݒB
	{
		pai.bEnableX86Optimize             = FALSE;
		pai.nCompressionLevel              = 2;

		ps.sActionMode.fDenyPath           = BPL_DENY_TOO_MANY_PARENTS;
		ps.bDestoryPath                    = FALSE;
		ps.sQuietInfo.bOutputLog           = TRUE;
		ps.sQuietInfo.bShowStatusDialog    = TRUE;
		ps.sQuietInfo.bShowErrorDialog     = TRUE;
		ps.sQuietInfo.eRewritingFile       = '0';
		ps.sQuietInfo.eWarningAsError      = '0';
		ps.sQuietInfo.eCheckSameFileName   = '0';
		strcpy(ps.szBaseDirectory, "");
		strncpy(ps.szWorkDirectory, getenv("TEMP"),  sizeof(ps.szWorkDirectory) - 1);
	}

	// WXgݒǂݍ݁B+XCb`Ŗ邱Ƃ\B
	if (dwMode == 0 || dwMode & M_INIT_FILE_USE)
	{
		RegistryConfig rc;
		RegistryConfig::CommonConfig cc;
		rc.GetConfig(& pai, & cc);

		ps.sActionMode.fDenyPath = cc.dwBadPathLevel;
		ps.bDestoryPath = cc.bJunkDirectory;
		switch (cc.dwOverWriteMode)
		{
			case 0: ps.sQuietInfo.eRewritingFile = '1'; break;
			case 1: ps.sQuietInfo.eRewritingFile = '0'; break;
			case 2: ps.sQuietInfo.eRewritingFile = '2'; break;
		}
		strncpy(ps.szBaseDirectory, cc.szDefaultDir, sizeof(ps.szBaseDirectory) - 1);
	}

	// R}hCݒǂݍ݁B
	int i;
	for (i = nPos; (i <= argc && (argv[i][0] == '-' || argv[i][0] == '/')); )
	{
		switch (tolower(argv[i][1]))
		{
			case '+':// WXgݒ
				if(argv[i][2] == '1')
				{
					// WXg̐ݒjďlɖ߂B
					pai.bEnableX86Optimize       = FALSE;
					pai.nCompressionLevel        = 2;
					ps.sActionMode.fDenyPath     = BPL_DENY_TOO_MANY_PARENTS;
					ps.bDestoryPath              = FALSE;
					ps.sQuietInfo.eRewritingFile = '0';
					strcpy(ps.szBaseDirectory, "");
				}
				break;
			case 'a':// 샂[h
				switch (tolower(argv[i][2]))
				{
					case 'a':	ps.sActionMode.fDenyPath = atoi(argv[i] + 3);	break;
					case 'b':	g_LanguageID = atoi(argv[i] + 3);				break;
					case 'c':	SetThreadPriority(GetCurrentThread(), atoi(argv[i] + 3));	break;
				}
				break;
			case 'b':// fBNgݒ
				strncpy(ps.szBaseDirectory, argv[i] + 2, sizeof(ps.szBaseDirectory) - 1);
				break;
			case 'm':// kxݒ
				pai.nCompressionLevel = argv[i][2] - '0';
				break;
			case 'p':// pX񖳌ݒ
				ps.bDestoryPath = argv[i][2] == '1';
				break;
			case 'q':// ÓI[h
				switch (tolower(argv[i][2]))
				{
					case 'a':	ps.sQuietInfo.bShowStatusDialog    = (argv[i][3] == '0');  break;
					case 'b':	ps.sQuietInfo.bOutputLog           = (argv[i][3] == '0');  break;
					case 'c':	ps.sQuietInfo.bShowErrorDialog     = (argv[i][3] == '0');  break;
					case 'd':	ps.sQuietInfo.eRewritingFile       =  argv[i][3];          break;
					case 'e':	ps.sQuietInfo.eWarningAsError      =  argv[i][3];          break;
					case 'f':	ps.sQuietInfo.eCheckSameFileName   =  argv[i][3];          break;
					default:
						if (argv[i][2] <= 2 && argv[i][2] >= 0)
						{
							ps.sQuietInfo.bShowStatusDialog    =
							ps.sQuietInfo.bOutputLog           =
							ps.sQuietInfo.bShowErrorDialog     =
							ps.sQuietInfo.eRewritingFile       =
							ps.sQuietInfo.eWarningAsError      =
							ps.sQuietInfo.eCheckSameFileName   = argv[i][2];
						}
						break;
				}
				break;
			case 'w':// ԃt@C쐬fBNgݒ
				strncpy(ps.szWorkDirectory, argv[i] + 2, sizeof(ps.szWorkDirectory) - 1);
				break;
			case 'x':// x86kݒ
				pai.bEnableX86Optimize = (argv[i][2] == '1');
				break;
		}
		i++;
		if(argv[i-1][1] == '-')
		{
			break;
		}
	}
	nPos = i;

	// tOݒǂݍ݁B
	{
		// WXg̐ݒ𖳎B
		if (dwMode & M_REGARDLESS_INIT_FILE)
		{
			// WXg̐ݒjďlɖ߂B
			pai.bEnableX86Optimize       = FALSE;
			pai.nCompressionLevel        = 2;
			ps.sActionMode.fDenyPath     = BPL_DENY_TOO_MANY_PARENTS;
			ps.bDestoryPath              = FALSE;
			ps.sQuietInfo.eRewritingFile = '0';
			strcpy(ps.szBaseDirectory, "");
		}

		// WJɓt@C݂ꍇ̏B
		if (dwMode & M_EXTRACT_REPLACE_FILE)
		{
			// ɏ㏑B
			// Note :
			//	dlł́At@C݂VꍇƂĂ邪A
			//	^CX^vL^Ȃߐ̂悤ȏƂȂB
			ps.sQuietInfo.eRewritingFile = 1;
		}
		if (dwMode & M_EXTRACT_NEW_FILE)
		{
			// ƓB
			// Note :
			//	dlł́AVKt@ĈݓWJB
			ps.sQuietInfo.eRewritingFile = 1;
		}
		if (dwMode & M_EXTRACT_UPDATE_FILE)
		{
			// ƓB
			// Note :
			//	dlł́AVKt@C̃t@CVꍇɓWJB
			ps.sQuietInfo.eRewritingFile = 1;
		}

		// ㏑mFsǂB
		if (dwMode & M_INQUIRE_WRITE)
		{
			ps.sQuietInfo.eRewritingFile = 0;
		}
		else if (dwMode & M_NOT_INQUIRE_WRITE)
		{
			ps.sQuietInfo.eRewritingFile = 2;
		}

		// WJɃpXj邩B
		if (dwMode & M_REGARD_E_COMMAND)
		{
			ps.bDestoryPath = TRUE;
		}
		else if (dwMode & M_REGARD_E_COMMAND)
		{
			ps.bDestoryPath = FALSE;
		}

		// G[bZ[W_CAO̕\B
		if (dwMode & M_ERROR_MESSAGE_ON)
		{
			ps.sQuietInfo.bShowErrorDialog = TRUE;
		}
		else if (dwMode & M_ERROR_MESSAGE_OFF)
		{
			ps.sQuietInfo.bShowErrorDialog = FALSE;
		}

		// WJ󋵃_CAO̕\B
		if (dwMode & M_BAR_WINDOW_ON)
		{
			ps.sQuietInfo.bShowStatusDialog = TRUE;
		}
		else if (dwMode & M_BAR_WINDOW_OFF)
		{
			ps.sQuietInfo.bShowStatusDialog = FALSE;
		}
	}

	return TRUE;
}

// Ɍ`𒲂ׂ܂B񂩂萔ւ̃Ro[^̂݁B
DWORD GetArchiveType(const char * szBuffer)
{
	return 
		strcmp(szBuffer, "P5"						) == 0 ? ARCHIVETYPE_P5			:
		strcmp(szBuffer, "P6"						) == 0 ? ARCHIVETYPE_P6			:
		strcmp(szBuffer, "P12"						) == 0 ? ARCHIVETYPE_P12		:
		strcmp(szBuffer, "PAQ1"						) == 0 ? ARCHIVETYPE_PAQ1		:
//		strcmp(szBuffer, "PAQ1"						) == 0 ? ARCHIVETYPE_PAQ1SSE	:
		strcmp(szBuffer, "PAQ2"						) == 0 ? ARCHIVETYPE_PAQ2		:
		strcmp(szBuffer, "PAQ3"						) == 0 ? ARCHIVETYPE_PAQ3		:
		strcmp(szBuffer, "PAQ3N"					) == 0 ? ARCHIVETYPE_PAQ3N		:
		strcmp(szBuffer, "PAQ4"						) == 0 ? ARCHIVETYPE_PAQ4		:
//		strcmp(szBuffer, "PAQ4"						) == 0 ? ARCHIVETYPE_PAQ4EMILCONT_DURITIUM:
		strcmp(szBuffer, "PAQ5"						) == 0 ? ARCHIVETYPE_PAQ5		:
		strcmp(szBuffer, "PAQ5-EMILCONT-DEUTERIUM"	) == 0 ? ARCHIVETYPE_PAQ5EMILCONT_DEUTERIUM:

		strcmp(szBuffer, "PAQ6"						) == 0 ? ARCHIVETYPE_PAQ6		:
		strcmp(szBuffer, "PAQ6v2ds"					) == 0 ? ARCHIVETYPE_PAQ6DS		:
/*		strcmp(szBuffer, "PAQ6"						) == 0 ? ARCHIVETYPE_PAQ6FB		:
		strcmp(szBuffer, "PAQ6fdj"					) == 0 ? ARCHIVETYPE_PAQ6FDJ	:
		strcmp(szBuffer, "PAQ6fdj"					) == 0 ? ARCHIVETYPE_PAQ6FDJ2	:*/
		strcmp(szBuffer, "PAQ6fdj"					) == 0 ? ARCHIVETYPE_PAQ32		:
//		strcmp(szBuffer, "PAQ6"						) == 0 ? ARCHIVETYPE_PAQ601		:
		strcmp(szBuffer, "PAQ602"					) == 0 ? ARCHIVETYPE_PAQ602		:
		strcmp(szBuffer, "PAQ603"					) == 0 ? ARCHIVETYPE_PAQ603		:
		strcmp(szBuffer, "PAQ604"					) == 0 ? ARCHIVETYPE_PAQ604		:
/*		strcmp(szBuffer, "PAQ605fb"					) == 0 ? ARCHIVETYPE_PAQ605FB	:
		strcmp(szBuffer, "PAQ605fb"					) == 0 ? ARCHIVETYPE_PAQ605FBJ	:
		strcmp(szBuffer, "PAQ605fb"					) == 0 ? ARCHIVETYPE_PAQ6FBJ8	:*/
		strcmp(szBuffer, "PAQ605fb"					) == 0 ? ARCHIVETYPE_PAQ6FBJ9	:
//		strcmp(szBuffer, "PAQ606fb"					) == 0 ? ARCHIVETYPE_PAQ606FB	:
		strcmp(szBuffer, "PAQ606fb"					) == 0 ? ARCHIVETYPE_PAQ607FB	:

		strcmp(szBuffer, "PAQ6-EMILCONT-JACKDAMARIOUM") == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_JACKDAMARIOUM:
		strcmp(szBuffer, "PAQ6-EmilCont-Febas"		) == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_FEBAS:
/*		strcmp(szBuffer, "PAQ6-EmilCont-Febas"		) == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_ANNY:
		strcmp(szBuffer, "PAQ6-EmilCont-Anny-607fb"	) == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_ANNY607FB:
		strcmp(szBuffer, "PAQ6-EmilCont-Anny-607fb"	) == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_BLASTER:
		strcmp(szBuffer, "PAQ6-EmilCont-Anny-607fb"	) == 0 ? ARCHIVETYPE_PAQ6EB		:*/
		strcmp(szBuffer, "PAQ6-EmilCont-Anny-607fb"	) == 0 ? ARCHIVETYPE_PAQ6EBB	:
		strcmp(szBuffer, "PAQ6-EmilCont-Destroyer"	) == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_DESTROYER:
		strcmp(szBuffer, "PAQ6-EmilCont-Annyhilator") == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_ANNYHILATOR:
		strcmp(szBuffer, "PAQ6-EmilCont-Harlock"	) == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_HARLOCK:
		strcmp(szBuffer, "PAQ6-EmilCont-Italia"		) == 0 ? ARCHIVETYPE_PAQ6_EMILCONT_ITALIA:
		strcmp(szBuffer, "PAQ6ED-SchmidtVarA"		) == 0 ? ARCHIVETYPE_PAQ6ED_SCHMIDT_A:
		strcmp(szBuffer, "PAQ6ED-SchmidtVarB"		) == 0 ? ARCHIVETYPE_PAQ6ED_SCHMIDT_B:

		strcmp(szBuffer, "PAQC"						) == 0 ? ARCHIVETYPE_PAQC		:

		strcmp(szBuffer, "paq7"						) == 0 ? ARCHIVETYPE_PAQ7		:
		strcmp(szBuffer, "paq7"						) == 0 ? ARCHIVETYPE_PAQ7STAR	:
		strcmp(szBuffer, "paq7"						) == 0 ? ARCHIVETYPE_PAQ7PLUS111:
		strcmp(szBuffer, "paq7"						) == 0 ? ARCHIVETYPE_PAQ7PLUS119:

		strcmp(szBuffer, "paq8a"					) == 0 ? ARCHIVETYPE_PAQ8A		:
//		strcmp(szBuffer, "paq8a"					) == 0 ? ARCHIVETYPE_PAQ8A2		:
		strcmp(szBuffer, "paq8b"					) == 0 ? ARCHIVETYPE_PAQ8B		:
		strcmp(szBuffer, "paq8c"					) == 0 ? ARCHIVETYPE_PAQ8C		:
		strcmp(szBuffer, "paq8d"					) == 0 ? ARCHIVETYPE_PAQ8D		:
		strcmp(szBuffer, "paq8e"					) == 0 ? ARCHIVETYPE_PAQ8E		:
		strcmp(szBuffer, "paq8f"					) == 0 ? ARCHIVETYPE_PAQ8F		:
		strcmp(szBuffer, "paq8g"					) == 0 ? ARCHIVETYPE_PAQ8G		:

		strcmp(szBuffer, "KGB_arch"					) == 0 ? ARCHIVETYPE_KGB10		:

/*		strcmp(szBuffer, "PAQAR"					) == 0 ? ARCHIVETYPE_PAQAR10	:
		strcmp(szBuffer, "PAQAR"					) == 0 ? ARCHIVETYPE_PAQAR11	:
		strcmp(szBuffer, "PAQAR"					) == 0 ? ARCHIVETYPE_PAQAR12	:
		strcmp(szBuffer, "PAQAR"					) == 0 ? ARCHIVETYPE_PAQAR13	:
		strcmp(szBuffer, "PAQAR"					) == 0 ? ARCHIVETYPE_PAQAR20	:
		strcmp(szBuffer, "PAQAR"					) == 0 ? ARCHIVETYPE_PAQAR30	:*/
		strcmp(szBuffer, "PAQAR"					) == 0 ? ARCHIVETYPE_PAQAR40	:
		strcmp(szBuffer, "PAQAR"					) == 0 ? ARCHIVETYPE_PAQAR45	:

		strcmp(szBuffer, "PAQARCC"					) == 0 ? ARCHIVETYPE_PAQARCC45	:

		strcmp(szBuffer, "axPAQ2"					) == 0 ? ARCHIVETYPE_AXPAQ20	:

/*		strcmp(szBuffer, "ZD\x02"					) == 0 ? ARCHIVETYPE_UDA0213	:
		strcmp(szBuffer, "ZD\x02"					) == 0 ? ARCHIVETYPE_UDA0215	:*/
		strcmp(szBuffer, "ZD\x02"					) == 0 ? ARCHIVETYPE_UDA0220	:
//		strcmp(szBuffer, "ZD\x03"					) == 0 ? ARCHIVETYPE_UDA0220L	:
		strcmp(szBuffer, "ZD\x03"					) == 0 ? ARCHIVETYPE_UDA0221L	:
		strcmp(szBuffer, "ZD\x04"					) == 0 ? ARCHIVETYPE_UDA0230	:
		strcmp(szBuffer, "ZD\x05"					) == 0 ? ARCHIVETYPE_UDA0231	:
		strcmp(szBuffer, "ZD\x06"					) == 0 ? ARCHIVETYPE_UDA0240	:
		strcmp(szBuffer, "ZD\x07"					) == 0 ? ARCHIVETYPE_UDA0250	:
/*		strcmp(szBuffer, "ZD\x08"					) == 0 ? ARCHIVETYPE_UDA0260	:
		strcmp(szBuffer, "ZD\x08"					) == 0 ? ARCHIVETYPE_UDA0270	:*/
		strcmp(szBuffer, "ZD\x08"					) == 0 ? ARCHIVETYPE_UDA0271	:
//		strcmp(szBuffer, "ZD\x0A"					) == 0 ? ARCHIVETYPE_UDA0280	:
		strcmp(szBuffer, "ZD\x0A"					) == 0 ? ARCHIVETYPE_UDA0281	:
		strcmp(szBuffer, "ZD\x0B"					) == 0 ? ARCHIVETYPE_UDA0283	:
		strcmp(szBuffer, "ZD\x0C"					) == 0 ? ARCHIVETYPE_UDA0284	:
		strcmp(szBuffer, "ZD\x0D"					) == 0 ? ARCHIVETYPE_UDA0290	:

/*		strcmp(szBuffer, "Emilcont"					) == 0 ? ARCHIVETYPE_EMILCONT01	:
		strcmp(szBuffer, "Emilcont"					) == 0 ? ARCHIVETYPE_EMILCONT02	:
		strcmp(szBuffer, "Emilcont"					) == 0 ? ARCHIVETYPE_EMILCONT02X:*/
		strcmp(szBuffer, "Emilcont"					) == 0 ? ARCHIVETYPE_EMILCONT03:

/*		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA10	:
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA20	:
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA21	:
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA30	:
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA39	:
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA40	:
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA41	:
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA42	:
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA43	:*/
		strcmp(szBuffer, "PAsQDa"					) == 0 ? ARCHIVETYPE_PASQDA44	:

/*		strcmp(szBuffer, "PAsQDaCC"					) == 0 ? ARCHIVETYPE_PASQDACC41	:
		strcmp(szBuffer, "PAsQDaCC"					) == 0 ? ARCHIVETYPE_PASQDACC42	:
		strcmp(szBuffer, "PAsQDaCC"					) == 0 ? ARCHIVETYPE_PASQDACC43	:*/
		strcmp(szBuffer, "PAsQDaCC"					) == 0 ? ARCHIVETYPE_PASQDACC44	:	0;
}

BOOL GetArchiveString(DWORD dwArchiveType, char * szBuffer, int nLength)
{
	strncpy(szBuffer, 
		dwArchiveType == ARCHIVETYPE_P5						? "P5" :
		dwArchiveType == ARCHIVETYPE_P6						? "P6" :
		dwArchiveType == ARCHIVETYPE_P12					? "P12" :
		dwArchiveType == ARCHIVETYPE_PAQ1					? "PAQ1" :
		dwArchiveType == ARCHIVETYPE_PAQ1SSE				? "PAQ1" :
		dwArchiveType == ARCHIVETYPE_PAQ2					? "PAQ2" :
		dwArchiveType == ARCHIVETYPE_PAQ3					? "PAQ3" :
		dwArchiveType == ARCHIVETYPE_PAQ3N					? "PAQ3N" :
		dwArchiveType == ARCHIVETYPE_PAQ4					? "PAQ4" :
		dwArchiveType == ARCHIVETYPE_PAQ4EMILCONT_DURITIUM	? "PAQ4" :
		dwArchiveType == ARCHIVETYPE_PAQ5					? "PAQ5" :
		dwArchiveType == ARCHIVETYPE_PAQ5EMILCONT_DEUTERIUM	? "PAQ5-EMILCONT-DEUTERIUM" :

		dwArchiveType == ARCHIVETYPE_PAQ6					? "PAQ6" :
		dwArchiveType == ARCHIVETYPE_PAQ6DS					? "PAQ6v2ds" :
		dwArchiveType == ARCHIVETYPE_PAQ6FB					? "PAQ6" :
		dwArchiveType == ARCHIVETYPE_PAQ6FDJ				? "PAQ6fdj" :
		dwArchiveType == ARCHIVETYPE_PAQ6FDJ2				? "PAQ6fdj" :
		dwArchiveType == ARCHIVETYPE_PAQ32					? "PAQ6fdj" :
		dwArchiveType == ARCHIVETYPE_PAQ601					? "PAQ6" :
		dwArchiveType == ARCHIVETYPE_PAQ602					? "PAQ602" :
		dwArchiveType == ARCHIVETYPE_PAQ603					? "PAQ603" :
		dwArchiveType == ARCHIVETYPE_PAQ604					? "PAQ604" :
		dwArchiveType == ARCHIVETYPE_PAQ605FB				? "PAQ605fb" :
		dwArchiveType == ARCHIVETYPE_PAQ605FBJ				? "PAQ605fb" :
		dwArchiveType == ARCHIVETYPE_PAQ6FBJ8				? "PAQ605fb" :
		dwArchiveType == ARCHIVETYPE_PAQ6FBJ9				? "PAQ605fb" :
		dwArchiveType == ARCHIVETYPE_PAQ606FB				? "PAQ606fb" :
		dwArchiveType == ARCHIVETYPE_PAQ607FB				? "PAQ606fb" :

		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_JACKDAMARIOUM ? "PAQ6-EMILCONT-JACKDAMARIOUM" :
		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_FEBAS	? "PAQ6-EmilCont-Febas" :
		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_ANNY		? "PAQ6-EmilCont-Febas" :
		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_ANNY607FB? "PAQ6-EmilCont-Anny-607fb" :
		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_BLASTER	? "PAQ6-EmilCont-Anny-607fb" :
		dwArchiveType == ARCHIVETYPE_PAQ6EB					? "PAQ6-EmilCont-Anny-607fb" :
		dwArchiveType == ARCHIVETYPE_PAQ6EBB				? "PAQ6-EmilCont-Anny-607fb" :
		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_DESTROYER? "PAQ6-EmilCont-Destroyer" :
		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_ANNYHILATOR ? "PAQ6-EmilCont-Annyhilator" :
		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_HARLOCK	? "PAQ6-EmilCont-Harlock" :
		dwArchiveType == ARCHIVETYPE_PAQ6_EMILCONT_ITALIA	? "PAQ6-EmilCont-Italia" :
		dwArchiveType == ARCHIVETYPE_PAQ6ED_SCHMIDT_A		? "PAQ6ED-SchmidtVarA" :
		dwArchiveType == ARCHIVETYPE_PAQ6ED_SCHMIDT_B		? "PAQ6ED-SchmidtVarB" :

		dwArchiveType == ARCHIVETYPE_PAQC					? "PAQC" :

		dwArchiveType == ARCHIVETYPE_PAQ7					? "paq7" :
		dwArchiveType == ARCHIVETYPE_PAQ7STAR				? "paq7" :
		dwArchiveType == ARCHIVETYPE_PAQ7PLUS111			? "paq7" :
		dwArchiveType == ARCHIVETYPE_PAQ7PLUS119			? "paq7" :

		dwArchiveType == ARCHIVETYPE_PAQ8A					? "paq8a" :
		dwArchiveType == ARCHIVETYPE_PAQ8A2					? "paq8a" :
		dwArchiveType == ARCHIVETYPE_PAQ8B					? "paq8b" :
		dwArchiveType == ARCHIVETYPE_PAQ8C					? "paq8c" :
		dwArchiveType == ARCHIVETYPE_PAQ8D					? "paq8d" :
		dwArchiveType == ARCHIVETYPE_PAQ8E					? "paq8e" :
		dwArchiveType == ARCHIVETYPE_PAQ8F					? "paq8f" :
		dwArchiveType == ARCHIVETYPE_PAQ8G					? "paq8g" :

		dwArchiveType == ARCHIVETYPE_KGB10					? "KGB_arch" :
		dwArchiveType == ARCHIVETYPE_KGB10_ENCRYPTED		? "KGB_enc" :

		dwArchiveType == ARCHIVETYPE_PAQAR10				? "PAQAR" :
		dwArchiveType == ARCHIVETYPE_PAQAR11				? "PAQAR" :
		dwArchiveType == ARCHIVETYPE_PAQAR12				? "PAQAR" :
		dwArchiveType == ARCHIVETYPE_PAQAR13				? "PAQAR" :
		dwArchiveType == ARCHIVETYPE_PAQAR20				? "PAQAR" :
		dwArchiveType == ARCHIVETYPE_PAQAR30				? "PAQAR" :
		dwArchiveType == ARCHIVETYPE_PAQAR40				? "PAQAR" :
		dwArchiveType == ARCHIVETYPE_PAQAR45				? "PAQAR" :

		dwArchiveType == ARCHIVETYPE_PAQARCC45				? "PAQARCC" :

		dwArchiveType == ARCHIVETYPE_AXPAQ20				? "axPAQ2" :

		// UDA ͏ݔΉȂ̂Ńwb_ԂKv͂ȂB
		dwArchiveType == ARCHIVETYPE_UDA0213				? "UDA 0.213" :
		dwArchiveType == ARCHIVETYPE_UDA0215				? "UDA 0.215" :
		dwArchiveType == ARCHIVETYPE_UDA0220				? "UDA 0.220" :
		dwArchiveType == ARCHIVETYPE_UDA0220L				? "UDA 0.220l" :
		dwArchiveType == ARCHIVETYPE_UDA0221L				? "UDA 0.221l" :
		dwArchiveType == ARCHIVETYPE_UDA0230				? "UDA 0.230" :
		dwArchiveType == ARCHIVETYPE_UDA0231				? "UDA 0.231" :
		dwArchiveType == ARCHIVETYPE_UDA0240				? "UDA 0.240" :
		dwArchiveType == ARCHIVETYPE_UDA0250				? "UDA 0.250" :
		dwArchiveType == ARCHIVETYPE_UDA0260				? "UDA 0.260" :
		dwArchiveType == ARCHIVETYPE_UDA0270				? "UDA 0.270" :
		dwArchiveType == ARCHIVETYPE_UDA0271				? "UDA 0.271" :
		dwArchiveType == ARCHIVETYPE_UDA0280				? "UDA 0.280" :
		dwArchiveType == ARCHIVETYPE_UDA0281				? "UDA 0.281" :
		dwArchiveType == ARCHIVETYPE_UDA0283				? "UDA 0.283" :
		dwArchiveType == ARCHIVETYPE_UDA0284				? "UDA 0.284" :
		dwArchiveType == ARCHIVETYPE_UDA0290				? "UDA 0.290" :
		dwArchiveType == ARCHIVETYPE_UDA0291				? "UDA 0.291" :

		dwArchiveType == ARCHIVETYPE_EMILCONT01				? "Emilcont" :
		dwArchiveType == ARCHIVETYPE_EMILCONT02				? "Emilcont" :
		dwArchiveType == ARCHIVETYPE_EMILCONT02X			? "Emilcont" :
		dwArchiveType == ARCHIVETYPE_EMILCONT03				? "Emilcont" :

		dwArchiveType == ARCHIVETYPE_PASQDA10				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA20				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA21				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA30				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA39				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA40				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA41				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA42				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA43				? "PAsQDa" :
		dwArchiveType == ARCHIVETYPE_PASQDA44				? "PAsQDa" :

		dwArchiveType == ARCHIVETYPE_PASQDACC41				? "PAsQDaCC" :
		dwArchiveType == ARCHIVETYPE_PASQDACC42				? "PAsQDaCC" :
		dwArchiveType == ARCHIVETYPE_PASQDACC43				? "PAsQDaCC" :
		dwArchiveType == ARCHIVETYPE_PASQDACC44				? "PAsQDaCC" : NULL
	, nLength);
	return szBuffer != NULL;
}
