// Paqar32.dll
// $Id: shell.cpp,v 1.2 2004/12/02 12:57:20 sirakaba Exp $

int Extract(Paqar32Info p){
	char *tmpString="";
	int i;
	long n;
	vector<string> FileList;// t@CXg
	long FileSize[FNAME_MAX32+1];// t@CTCYXg
	FILE *fa=fopen(p.Archive,"rb");
	if(!fa) return ERROR_NOT_ARC_FILE;
	if(strcmp(p.CurrentDir,"")!=0&&!SetCurrentDirectory(p.CurrentDir)){
		if(!CreateDirectory(p.CurrentDir,NULL)) return ERROR_MAKEDIRECTORY;
		else SetCurrentDirectory(p.CurrentDir);
	}
	// kxx86œKݒǂݍ
	p.x86Compress=false;
	string s=getline(fa);
	if(s.size()>2){
		if(s[s.size()-2]=='-'){
			int c=s[s.size()-1];
			if(c>='0'&&c<='9') p.CompressLevel=c-'0';
		}else if(s[s.size()-3]=='-'){
			int c=s[s.size()-2];
			if(c>='0'&&c<='9') p.CompressLevel=c-'0';
			c=s[s.size()-1];
			if(c=='e') p.x86Compress=true;
		}
	}
	MEM=p.CompressLevel;
	exe=p.x86Compress?1:0;
	AddStatusText(p.hDialog,"Extracting archive ...\n");

	// t@CTCYƃt@Cǂݍ
	for(i=0;;++i){
		s=getline(fa);
		if(s.size()>1){
			string::iterator tab=find(s.begin(),s.end(),'\t');
			if(tab==s.end()) break;
			FileSize[i]=atol(string(s.begin()+(i==0?i:lstrlen(FileList[i-1].c_str())),tab).c_str());
			FileList.push_back(ExplodeByStr(string(tab+1,s.end()),p.ExtractPath?"..\\":"\\"));
		}else break;
	}

	// ɂf[^
	Transformer e(DECOMPRESS,fa);
	for(i=0;i<int(FileList.size());++i){
	// 𓀑ΏۂȂ
		for(n=0;n<p.FileCount;++n){
			if(strcmp(FileList[i].c_str(),p.FileList[n])==0){
				n=0;
				break;
			}
		}
		SendDlgItemMessage(p.hDialog,IDC_PROGRESS1,PBM_SETPOS,0,0);
		SetDlgItemText(p.hDialog,IDC_STATIC_TARGET2,FileList[i].c_str());
		DoEvents();
		if(g_Cancel) break;
		sprintf(tmpString,"%10ld %s: ",FileSize[i],FileList[i].c_str());
		AddStatusText(p.hDialog,tmpString);

		FILE *f=0;
		if(n!=0){
			AddStatusText(p.hDialog,"skipping...\n");
			goto Skip;
		}
	// t@C݂Ȃ
		f=fopen(FileList[i].c_str(),"rb");
		if(f){
			if(fclose(f)!=0) return ERROR_CLOSE_FILE;
			if(p.Quiet==0x32||MessageBox(p.hDialog,LJ?"t@Cɑ݂܂B㏑܂H":"File has already existed. Do you want to write over this file?","Paqar32.dll",MB_YESNO)==IDYES) goto Rewrite;
			else{
				AddStatusText(p.hDialog,"cannot create, skipping...\n");
				goto Skip;
			}
	// 𓀂I
		}else{
Rewrite:
			f=fopen(FileList[i].c_str(),"wb");
			if(!f) AddStatusText(p.hDialog,"cannot create, skipping...\n");
Skip:
			fsize=FileSize[i]-513216;
			if(p.x86Compress&&FileSize[i]>0){
				int c=e.decode();
				if(f&&putc(c,f)!=c) return ERROR_CANNOT_WRITE;
				if(c){
					c-=23;
					if((c<0&&((c+8)&1))||(c>=0&&((c+2)&1))){
						int c=e.decode(); if(f&&putc(c,f)!=c) return ERROR_CANNOT_WRITE;
						int d=e.decode(); if(f&&putc(d,f)!=c) return ERROR_CANNOT_WRITE;
						d=d*256+c;
						for(n=0;n<d*3;++n) putc(e.decode(),f);
					}
				}
			}
			double per=FileSize[i]/100;
			for(n=0;n<FileSize[i];++n){
				DoEvents();
				if(g_Cancel) break;
				SendDlgItemMessage(p.hDialog,IDC_PROGRESS1,PBM_SETPOS,int(n/per),0);
				if(f) putc(e.decode(),f);
			}

			if(f){
				AddStatusText(p.hDialog,"extracted\n");
				if(p.x86Compress&&FileSize[i]>0){
					int data2write[4]={0,0,0,0};
					if(fclose(f)!=0) return ERROR_CLOSE_FILE;
					f=fopen(FileList[i].c_str(),"rb");
					if(fseek(f,0L,SEEK_END)!=0)	return ERROR_SET_POINT;
					if((n=ftell(f))==-1L)		return ERROR_GET_POINT;
					if(fseek(f,0L,0)!=0)		return ERROR_SET_POINT;

					if((st0=(char*)GlobalAllocPtr(GHND,CONSTA+2*n+256))==NULL) return ERROR_MORE_HEAP_MEMORY;
					st=st0+256-((int)st0&255);	// 256-byte-alignment
					n=fread(st+CONSTA-32768,1,n,f);
					if(fclose(f)!=0) return ERROR_CLOSE_FILE;
					f=fopen(FileList[i].c_str(),"wb");
					if(n) te8e9(st,4,n,&data2write[0]);
					if(data2write[0]) if(fwrite((char*)data2write[1],1,data2write[0],f)!=data2write[0]) return ERROR_CANNOT_WRITE;
					if(!GlobalUnlock(st0)||GlobalFree(st0)!=NULL) return ERROR_HEAP_MEMORY;
				}
				if(fclose(f)!=0) return ERROR_CLOSE_FILE;
			}
		}
	}
	if(fclose(fa)!=0) return ERROR_CLOSE_FILE;
	AddStatusText(p.hDialog,"\n");
	return 0;
}

int Compress(Paqar32Info p){
	char *tmpString="";
	int i;
	long n;
	long FileSize[FNAME_MAX32+1];// t@CTCYXg
	MEM=p.CompressLevel;
	exe=p.x86Compress?1:0;
	FILE *fa=fopen(p.Archive,"rb"),*f;
	if(fa) return 0;// {͒ǉkł邪Ał̓pX(--;
	AddStatusText(p.hDialog,"Compressing files to archive ...\n");
	SetCurrentDirectory(p.CurrentDir);

	// t@CTCY擾
	for(i=0;strcmp(p.FileList[i],"")!=0;++i){
		if(!(f=fopen(p.FileList[i],"rb"))){
			sprintf(tmpString,"File not found : %s\n",p.FileList[i]);
			AddStatusText(p.hDialog,tmpString);
			return ERROR_SHARING;
		}else{
			if(fseek(f,0L,SEEK_END)!=0)		return ERROR_SET_POINT;
			if((FileSize[i]=ftell(f))==-1L)	return ERROR_GET_POINT;
			if(fclose(f)!=0)				return ERROR_CLOSE_FILE;
		}
	}

	// wb_
    if(!(fa=fopen(p.Archive,"wb"))){
		sprintf(tmpString,"Cannot create archive: %s\n",p.Archive);
		AddStatusText(p.hDialog,tmpString);
		return ERROR_ARC_FILE_OPEN;
	}
	if(	fprintf(fa,"%s -%d","PAQAR",p.CompressLevel)<=0
		|| (p.x86Compress&&fprintf(fa,"e")<=0) || fprintf(fa,"\r\n")<=0) return ERROR_CANNOT_WRITE;
	for(i=0;i<p.FileCount;++i) if(FileSize[i]>=0) if(fprintf(fa,"%ld\t%s\r\n",FileSize[i],ExplodeByStr(p.FileList[i],"/"))<=0) return ERROR_CANNOT_WRITE;
	if(putc(032,fa)!=032) return ERROR_CANNOT_WRITE;// MS-DOS EOF݁B

	// f[^
	Transformer e(COMPRESS,fa);
	long file_start=ftell(fa);
	if(file_start==-1L) return ERROR_GET_POINT;
	for(i=0;i<p.FileCount;++i){
		if(FileSize[i]>=0){
			DoEvents();
			SendDlgItemMessage(p.hDialog,IDC_PROGRESS1,PBM_SETPOS,0,0);
			if(g_Cancel) break;
			tmpString=ExplodeByStr(p.FileList[i],"/");
			SetDlgItemText(p.hDialog,IDC_STATIC_TARGET2,tmpString);
			sprintf(tmpString,"%-23s %10ld -> ",tmpString,FileSize[i]);
			AddStatusText(p.hDialog,tmpString);
			if(!(f=fopen(p.FileList[i],"rb"))) return ERROR_NOT_FIND_FILE;
			fsize=FileSize[i]-513216;
			// x86œK
			if(f&&p.x86Compress&&FileSize[i]>0){
				int data2write[4]={0,0,0,0};
				FILE *fw=fopen(p.WorkingDir,"wb");
				if(!fw)						return ERROR_TMP_OPEN;
				if(fseek(f,0L,SEEK_END)!=0)	return ERROR_SET_POINT;
				if((n=ftell(f))==-1L)		return ERROR_GET_POINT;
				if(fseek(f,0L,0)!=0)		return ERROR_SET_POINT;
				if((st0=(char*)GlobalAllocPtr(GHND,CONSTA+2*n+256))==NULL) return ERROR_MORE_HEAP_MEMORY;
				st=st0+256-((int)st0&255);// 256-byte-alignment
				if((n=fread(st+CONSTA-32768,1,n,f))) te8e9(st,3,n,&data2write[0]);
				FileSize[i]=0;
				if(data2write[0]){
					FileSize[i]+=data2write[0];
					if(fwrite((char*)data2write[1],1,data2write[0],fw)!=data2write[0]) return ERROR_CANNOT_WRITE;
				}
				if(data2write[2]){
					FileSize[i]+=data2write[2];
					if(fwrite((char*)data2write[3],1,data2write[2],fw)!=data2write[2]) return ERROR_CANNOT_WRITE;
				}
				if(!GlobalUnlock(st0)||GlobalFree(st0)!=NULL) return ERROR_HEAP_MEMORY;
				if(fclose(fw)!=0||fclose(f)!=0) return ERROR_CLOSE_FILE;
				f=fopen(p.WorkingDir,"rb");
			}

			double per=FileSize[i]/100;
			for(n=0;n<FileSize[i];++n){
				e.encode(getc(f));
				DoEvents();
				if(g_Cancel) break;
				SendDlgItemMessage(p.hDialog,IDC_PROGRESS1,PBM_SETPOS,floor(n/per),0);
			}
			if(g_Cancel) break;
			if(f&&fclose(f)!=0) return ERROR_CLOSE_FILE;
			if(f&&p.x86Compress&&FileSize[i]>0&&!DeleteFile(p.WorkingDir)) return ERROR_TMP_OPEN;
			sprintf(tmpString,"%ld\n",ftell(fa)-file_start);
			AddStatusText(p.hDialog,tmpString);
			if((file_start=ftell(fa))==-1L) return ERROR_GET_POINT;
		}
	}
	e.flush();
	if(fclose(fa)!=0) return ERROR_CLOSE_FILE;
	AddStatusText(p.hDialog,"\n");
	return 0;
}

int Test(Paqar32Info p){
	char head[6];
	FILE *f=fopen(p.Archive,"rb");
	if(!f) return ERROR_NOT_ARC_FILE;
	fgets(head,6,f);
	if(fclose(f)!=0) return ERROR_CLOSE_FILE;
// wb_݂̂̊ȈՃ`FbNB
	return strcmp(head,"PAQAR")==0?0:ERROR_FILE_STYLE;
}

int List(Paqar32Info p){
	char *tmpString="";
	int i=0;
	long n=0;
	FILE *f=fopen(p.Archive,"rb");
	if(!f) return ERROR_NOT_ARC_FILE;
	vector<string> filename;
	vector<long> filesize;
	string::iterator sep;
	string s=getline(f);
	p.x86Compress=false;
	if(s.size()>2){
		if(s[s.size()-2]=='-'){
			i=s[s.size()-1];
			if(i>='0'&&i<='9') p.CompressLevel=i-'0';
		}else if(s[s.size()-3]=='-'){
			i=s[s.size()-2];
			if(i>='0'&&i<='9') p.CompressLevel=i-'0';
			i=s[s.size()-1];
			if(i=='e') p.x86Compress=true;
		}
	}
	while(true){
		s=getline(f);
		if(s.size()>1){
			filesize.push_back(atol(s.c_str()));
			sep=find(s.begin(),s.end(),'\t');
			if(sep!=s.end()) filename.push_back(string(sep+1,s.end()));
			else filename.push_back("");
		}else break;
	}
	if(fclose(f)!=0) return ERROR_CLOSE_FILE;
	sprintf(tmpString,
		"===============================================================================\n"
		"                Paqar32.dll v.%1.2f Build %d\n"
		"===============================================================================\n\n"
		"        Listing of archive:        %s\n"
		"        Archive info:\n"
		"               Compression Level:  %d\n"
		"               x86Compress:        %s\n\n"
		"  Name                          Original\n"
		"--------------------------  ------------\n"
		,(double)PAQAR_VERSION/100,(int)PAQAR_SUBVERSION,p.Archive,p.CompressLevel,p.x86Compress?"TRUE":"FALSE");
	AddStatusText(p.hDialog,tmpString);
	for(i=0;i<int(filename.size());i++){
		sprintf(tmpString,"%-26s  %12d\n",filename[i].c_str(),filesize[i]);
		AddStatusText(p.hDialog,tmpString);
		n+=filesize[i];
	}
	sprintf(tmpString,
		"--------------------------  ------------\n"
		"%20d files  %12d\n"
		"===============================================================================\n"
		,i,n);
	AddStatusText(p.hDialog,tmpString);
	return 0;
}
