// Paqar32.dll
// $Id: class.cpp,v 1.2 2005/01/05 08:42:14 sirakaba Exp $

typedef struct{
	DWORD iFileSize;
	char szDummy1[2];
	char *szFileName;
	char szDummy2[3];
} Paqar_FileHeader;

typedef struct{
	char *szMethod;
	char szDummy1[2];
	int  iLevel;
	char *szMethod2;
	char szDummy2[3];
} Paqar_Header;

class CPaqar{
	public:
		// Jn/I
		 CPaqar();
		~CPaqar();
		// ֐
		void Init();
		// R}h֐
		int Compress();
		int Extract();
		int Join();
		int List();
		int Test();
		// G[擾֐
		int GetLastError();
		// Oϐ
		bool bX86Compress;
		bool bExtractPath;
		char *szArchive;
		char *szCurrentDirectory;
		char *szWorkingDirectory;
		char *szFileList[FNAME_MAX32 + 1];
		int  iCompressLevel;
		int  iQuiet;
		int  iFileCount;
		HWND hDialog;
	private:
		// G[ݒ֐
		int SetLastError(int);
		// G[i[ϐ
		int iLastError;
		// wb_\
		Paqar_Header		lpHeader;
		Paqar_FileHeader	lpFile;
		// p̈
		FILE *fp[3];
		char *szList[FNAME_MAX32 + 1];
		unsigned long iList[FNAME_MAX32 + 1];
		// ėpϐ
		char *sz;
};

// Jn
CPaqar::CPaqar(){
	Init();
}

// I
CPaqar::~CPaqar(){

	// t@Cnh
	if(fp[0]) fclose(fp[0]);
	if(fp[1]) fclose(fp[1]);
	if(fp[2]) fclose(fp[2]);

	// mۗ̈
	for(int i = 0; lstrcmp(szList[i], "\0") != 0; ++i) GlobalFree(szList[i]);
}

// ֐
void CPaqar::Init(void){
	bX86Compress		= false;
	bExtractPath		= true;
	iCompressLevel		= 2;
	szArchive = szCurrentDirectory = szWorkingDirectory = sz = "";
	iQuiet = iFileCount = iLastError =  0;
	fp[0] = fp[1] = fp[2] = 0;
	szList[0]			= "\0";
	szWorkingDirectory	= getenv("TEMP");
}

// G[擾֐
int CPaqar::GetLastError(void){
	return iLastError;
}

// G[ݒ֐
int CPaqar::SetLastError(int iError){
	iLastError = iError;
	return 1;
}

// R}h֐

// k
int CPaqar::Compress(void){

	// ݒ
	MEM = iCompressLevel;
	exe = bX86Compress ? 1 : 0;
	SetCurrentDirectory(szCurrentDirectory);
	int i = 0;

	// ɂ݂̑`FbN
	fp[0] = fopen(szArchive, "rb");
	if(fp[0]) return fclose(fp[0]) != 0 ? ERROR_CLOSE_FILE : 0;// {͒ǉkł邪Ał̓pX(--;

	// JnbZ[WM
	AddStatusText(hDialog, "Compressing files to archive ...\n");

	// ɂ쐬
	fp[0] = fopen(szArchive, "wb");
	if(! fp[0]){
		sprintf(sz, "Cannot create archive: %s\n", szArchive);
		AddStatusText(hDialog, sz);
		return ERROR_ARC_FILE_OPEN;
	}

	// 	wb_
	if(	fprintf(fp[0], "%s -%d", "PAQAR", iCompressLevel)	<= 0
		|| ( bX86Compress && fprintf(fp[0], "e")			<= 0 )
		|| fprintf(fp[0], "\r\n")							<= 0 ) return ERROR_CANNOT_WRITE;

	// CfbNX
	for(i = 0; i < iFileCount; ++i){

		// t@C΃G[I
		fp[1] = fopen(szFileList[i], "rb");
		if(! fp[1]){
			sprintf(sz, "File not found : %s\n", szFileList[i]);
			AddStatusText(hDialog, sz);
			return ERROR_SHARING;

		// ݂΃wb_ɏ
		} else {
			if(fseek(fp[1], 0L, SEEK_END)	!= 0  )			return ERROR_SET_POINT;
			iList[i] = ftell(fp[1]);
			if(iList[i]						== -1L)			return ERROR_GET_POINT;
			if(fclose(fp[1])				!= 0  )			return ERROR_CLOSE_FILE;
			if(fprintf(fp[0], "%ld\t%s\r\n", iList[i], ExplodeByStr(szFileList[i], "/")) <= 0)
															return ERROR_CANNOT_WRITE;
		}
	}

	// CfbNXI(MS-DOS EOF)
	if(putc(032, fp[0]) != 032)								return ERROR_CANNOT_WRITE;

	// 
	Transformer e(COMPRESS, fp[0]);
	unsigned long l = ftell(fp[0]), n;
	if(l == -1L)											return ERROR_GET_POINT;

	// t@Cf[^
	for(i = 0; i < iFileCount; ++i){

		// GUIXV֘A
		DoEvents();
		SendDlgItemMessage(hDialog, IDC_PROGRESS1, PBM_SETPOS, 0, 0);
		if(g_Cancel) break;
		sz = ExplodeByStr(szFileList[i], "/");
		SetDlgItemText(hDialog, IDC_STATIC_TARGET2, sz);
		sprintf(sz, "%-23s %10ld -> ", sz, iList[i]);
		AddStatusText(hDialog, sz);

		// t@CJ
		fp[1] = fopen(szFileList[i], "rb");
		if(! fp[1])											return ERROR_NOT_FIND_FILE;
		fsize = iList[i] - 513216;

		// x86œK
		if(fp[1] && bX86Compress && iList[i] > 0){
			int data2write[4] = {0, 0, 0, 0};
			if(fseek(fp[1], 0L, SEEK_END)	!= 0  )			return ERROR_SET_POINT;
			n = ftell(fp[1]);
			if(n							== -1L)			return ERROR_GET_POINT;
			if(fseek(fp[1], 0L, 0)			!= 0  )			return ERROR_SET_POINT;
			st0 = (char*)GlobalAlloc(GPTR, CONSTA + 2 * n + 256);
			if(st0 == NULL)									return ERROR_MORE_HEAP_MEMORY;
			st = st0 + 256 - ((int)st0 & 255);// 256-byte-alignment
			n  = fread(st + CONSTA - 32768, 1, n, fp[1]);
			if(n) te8e9(st, 3, n, &data2write[0]);
			if(fclose(fp[1]) != 0)							return ERROR_CLOSE_FILE;

			wsprintf(sz, "%s\\paqar11tmp.tmp", szWorkingDirectory);
			fp[1] = fopen(sz, "wb");
			if(! fp[1])										return ERROR_TMP_OPEN;
			iList[i] = 0;
			if(data2write[0]){
				iList[i] += data2write[0];
				if( fwrite((char*)data2write[1], 1, data2write[0], fp[1]) != data2write[0])
															return ERROR_CANNOT_WRITE;
			}
			if(data2write[2]){
				iList[i] += data2write[2];
				if( fwrite((char*)data2write[3], 1, data2write[2], fp[1]) != data2write[2])
															return ERROR_CANNOT_WRITE;
			}
			if(GlobalFree(st0)	!= NULL)					return ERROR_HEAP_MEMORY;
			if(fclose(fp[1])	!= 0)						return ERROR_CLOSE_FILE;
			fp[1] = fopen(sz, "rb");
			if(! fp[1])										return ERROR_TMP_OPEN;
		}

		// k
		double per = iList[i] / 100;
		for(n = 0; n < iList[i]; ++n){
			e.encode(getc(fp[1]));
			// vOXo[֘A
			DoEvents();
			if(g_Cancel) break;
			SendDlgItemMessage(hDialog, IDC_PROGRESS1, PBM_SETPOS, floor(n / per), 0);
		}
		if(g_Cancel) break;
		if(fp[1]){
			if(fclose(fp[1]) != 0)							return ERROR_CLOSE_FILE;
			if(bX86Compress && iList[i] > 0 && ! DeleteFile(sz))
															return ERROR_TMP_OPEN;
		}
		sprintf(sz,"%ld\n", ftell(fp[0]) - l);
		AddStatusText(hDialog, sz);
		l = ftell(fp[0]);
		if(l == -1L)										return ERROR_GET_POINT;
	}

	// I
	e.flush();
	if( fclose(fp[0]) != 0 )								return ERROR_CLOSE_FILE;
	AddStatusText(hDialog, "\n");
	return 0;
}

// 
int CPaqar::Extract(void){
	// ɂJ
	fp[0] = fopen(szArchive, "rb");
	if(! fp[0])											return ERROR_NOT_ARC_FILE;

	// JgfBNgݒ
	if(strcmp(szCurrentDirectory, "") != 0 && ! SetCurrentDirectory(szCurrentDirectory)){
		if(! CreateDirectory(szCurrentDirectory, NULL))	return ERROR_MAKEDIRECTORY;
		else SetCurrentDirectory(szCurrentDirectory);
	}
	// kxx86œKݒǂݍ
	bX86Compress = false;
	std::string s = getline(fp[0]);
	if(s.size() > 2){
		if(s[s.size() - 2] == '-'){
			int c = s[s.size() - 1];
			if(c >= '0' && c <= '9') iCompressLevel = c - '0';
		}else if(s[s.size() - 3] == '-'){
			int c = s[s.size() - 2];
			if(c >= '0' && c <= '9') iCompressLevel = c - '0';
			c = s[s.size() - 1];
			if(c == 'e') bX86Compress = true;
		}
	}
	AddStatusText(hDialog, "Extracting archive ...\n");

	// ݒ
	MEM = iCompressLevel;
	exe = bX86Compress ? 1 : 0;
	unsigned long n = 0;

	// t@CTCYƃt@Cǂݍ
	for(int j = 0; ; ++j){
		s = getline(fp[0]);
		if(s.size() > 1){
			std::string::iterator tab = std::find(s.begin(), s.end(), '\t');
			if(tab == s.end()) break;
			iList[j]	= atol(std::string(s.begin(), tab).c_str());
			szList[j]	= lstrdup(ExplodeByStr(std::string(tab + 1, s.end()), bExtractPath ? "..\\" : "\\"));
		}else break;
	}
	szList[j] = "\0";

	// ɂf[^
	Transformer e(DECOMPRESS, fp[0]);
	for(int i = 0; i < j; ++i){

		// 𓀑ΏۂȂ
		for(int k = 0; k < iFileCount; ++k){
			if(lstrcmp(szList[i], szFileList[k]) == 0){
				k = 0;
				break;
			}
		}
		SendDlgItemMessage(hDialog, IDC_PROGRESS1, PBM_SETPOS, 0, 0);
		SetDlgItemText(hDialog, IDC_STATIC_TARGET2, szList[i]);
		DoEvents();
		if(g_Cancel) break;
		sprintf(sz, "%10ld %s: ", iList[i], szList[i]);
		AddStatusText(hDialog, sz);

		fp[1] = 0;
		if(k != 0){
			AddStatusText(hDialog, "skipping...\n");
			goto Skip;
		}

		// t@C݂Ȃ
		fp[1] = fopen(szList[i], "rb");
		if(fp[1]){
			if(fclose(fp[1]) != 0)								return ERROR_CLOSE_FILE;
			if(iQuiet == 0x32 || MessageBox(hDialog, LJ ? "t@Cɑ݂܂B㏑܂H" : "File has already existed. Do you want to write over this file?", "Paqar32.dll", MB_YESNO) == IDYES) goto Rewrite;
			else{
				AddStatusText(hDialog, "cannot create, skipping...\n");
				fp[1] = 0;
				goto Skip;
			}

		// 𓀂I
		}else{
Rewrite:
			fp[1] = fopen(szList[i], "wb");
			if(! fp[1]) AddStatusText(hDialog, "cannot create, skipping...\n");
Skip:
			fsize = iList[i] - 513216;

			// x86œKO
			if(bX86Compress && iList[i] > 0){
				int c = e.decode();
				if(fp[1] && putc(c, fp[1]) != c)				return ERROR_CANNOT_WRITE;
				if(c){
					c -= 23;
					if((c < 0 && ((c + 8) & 1)) || (c >= 0 && ((c + 2) & 1))){
						int c = e.decode();
						if(fp[1] && putc(c, fp[1]) != c)		return ERROR_CANNOT_WRITE;
						int d = e.decode();
						if(fp[1] && putc(d, fp[1]) != c)		return ERROR_CANNOT_WRITE;
						d = d * 256 + c;
						for(n = 0; n < d * 3; ++n) putc(e.decode(), fp[1]);
					}
				}
			}

			// 𓀒I
			sz = "";
			double per = iList[i] / 100;
			for(n = 0; n < iList[i]; ++n){
				DoEvents();
				if(g_Cancel) break;
				SendDlgItemMessage(hDialog, IDC_PROGRESS1, PBM_SETPOS, int(n / per), 0);
				int c = e.decode();
				if(fp[1] && putc(c, fp[1]) != c)				return ERROR_CANNOT_WRITE;
//				sz[n] = e.decode();
			}
//			if(fp[1] && fwrite(sz, 1, n, fp[1]) != n)			return ERROR_CANNOT_WRITE;

			// 𓀌㏈
			if(fp[1]){
				AddStatusText(hDialog, "extracted\n");

				// x86œK
				if(bX86Compress && iList[i] > 0){
					int data2write[4] = {0, 0, 0, 0};
					if(fclose(fp[1]) != 0)						return ERROR_CLOSE_FILE;
					fp[1] = fopen(szList[i], "rb");
					if(! fp[1])									return ERROR_FILE_OPEN;
					if(fseek(fp[1], 0L, SEEK_END) != 0)			return ERROR_SET_POINT;
					n = ftell(fp[1]);
					if(n == -1L)								return ERROR_GET_POINT;
					if(fseek(fp[1], 0L, 0) != 0)				return ERROR_SET_POINT;
					st0 = (char*)GlobalAlloc(GPTR, CONSTA + 2 * n + 256);
					if(st0 == NULL)								return ERROR_MORE_HEAP_MEMORY;
					st = st0 + 256 - ((int)st0 & 255);	// 256-byte-alignment
					n = fread(st + CONSTA - 32768, 1, n, fp[1]);
					if(fclose(fp[1]) != 0)						return ERROR_CLOSE_FILE;
					fp[1] = fopen(szList[i], "wb");
					if(! fp[1])									return ERROR_FILE_OPEN;
					if(n) te8e9(st, 4, n, &data2write[0]);
					if(data2write[0] && fwrite((char*)data2write[1], 1, data2write[0], fp[1]) != data2write[0])
																return ERROR_CANNOT_WRITE;
					if(GlobalFree(st0) != NULL)					return ERROR_HEAP_MEMORY;
				}
				if(fclose(fp[1]) != 0)							return ERROR_CLOSE_FILE;
			}
		}
	}
	if(fclose(fp[0]) != 0)										return ERROR_CLOSE_FILE;
	for(i = 0; i < j; ++i) if(GlobalFree(szList[i]) != NULL)	return ERROR_HEAP_MEMORY;
	AddStatusText(hDialog, "\n");
	return 0;
}

int CPaqar::Test(void){
	// ɂwb_擾
	fp[0] = fopen(szArchive, "rb");
	if(! fp[0]) return ERROR_NOT_ARC_FILE;
	fgets(sz, 6, fp[0]);
	if(fclose(fp[0]) != 0) return ERROR_CLOSE_FILE;

	// wb_݂̂̊ȈՃ`FbNB
	return strcmp(sz, "PAQAR") == 0 ? 0 : ERROR_FILE_STYLE;
}

int CPaqar::List(void){

	// ݒ
	int i;

	// ɂJ
	fp[0] = fopen(szArchive, "rb");
	if(! fp[0]) return ERROR_NOT_ARC_FILE;

	// kxx86œKݒǂݍ
	bX86Compress = false;
	std::string s = getline(fp[0]);
	if(s.size() > 2){
		if(s[s.size() - 2] == '-'){
			int c = s[s.size() - 1];
			if(c >= '0' && c <= '9') iCompressLevel = c - '0';
		}else if(s[s.size() - 3] == '-'){
			int c = s[s.size() - 2];
			if(c >= '0' && c <= '9') iCompressLevel = c - '0';
			c = s[s.size() - 1];
			if(c == 'e') bX86Compress = true;
		}
	}

	// t@CTCYƃt@Cǂݍ
	for(int j = 0; ; ++j){
		s = getline(fp[0]);
		if(s.size() > 1){
			std::string::iterator tab = std::find(s.begin(), s.end(), '\t');
			if(tab == s.end()) break;
			iList[j]	= atol(std::string(s.begin(), tab).c_str());
			szList[j]	= lstrdup(ExplodeByStr(std::string(tab + 1, s.end()), bExtractPath ? "..\\" : "\\"));
		}else break;
	}
	szList[j] = "\0";

	// ɂ
	if(fclose(fp[0]) != 0)	return ERROR_CLOSE_FILE;
	sprintf(sz,
		"===============================================================================\n"
		"                Paqar32.dll v.%1.2f Build %d\n"
		"===============================================================================\n\n"
		"        Listing of archive:        %s\n"
		"        Archive info:\n"
		"               Compression Level:  %d\n"
		"               x86Compress:        %s\n\n"
		"  Name                          Original\n"
		"--------------------------  ------------\n"
		, (double)PAQAR_VERSION/100, (int)PAQAR_SUBVERSION, szArchive, iCompressLevel, bX86Compress ? "TRUE" : "FALSE");
	AddStatusText(hDialog, sz);
	unsigned long ul = 0;
	for(i = 0; i < j; i++){
		sprintf(sz, "%-26s  %12d\n", szList[i], iList[i]);
		AddStatusText(hDialog, sz);
		ul += iList[i];
	}
	sprintf(sz,
		"--------------------------  ------------\n"
		"%20d files  %12d\n"
		"===============================================================================\n"
		, i, ul);
	AddStatusText(hDialog, sz);
	for(i = 0; i < j; ++i) if(GlobalFree(szList[i])!=NULL)			return ERROR_HEAP_MEMORY;
	return 0;
}
