// Paqar32.dll
// $Id: Paqar32.cpp,v 1.8 2005/01/22 06:17:55 sirakaba Exp $

#include <windows.h>
#include <commctrl.h>
#include <string>
#include <stdio.h>
#include "Paqar32.h"
#include "inuse.h"
#include "resource.h"
#include "PAQAR.cpp"
#include "registry.cpp"
#include "function.cpp"
#include "class.cpp"

BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved){
	g_Running = false;
	ManageOwnerWindow(false, 0, NULL, NULL);
	ManageEnum(false, 0, 0);
	LJ = (GetACP() == 932);// VXeݒ擾B
	hDLL = (HINSTANCE)hModule;//Rs[B
	uMsg = RegisterWindowMessage(WM_ARCEXTRACT);
	return true;
}

int WINAPI Paqar(const HWND _hwnd, LPCSTR _szCmdLine, LPSTR _szOutput, const DWORD _dwSize){
	Process_Sta(ERROR_ALREADY_RUNNING);

	// ϐ`
	int argc, i, n = 0, ret = 0;
	char *argv[1024], *sz = "";

	// B
	CPaqar cp;
	QuietInfo qi;
	qi.bOutputLog = qi.bShowErrorDialog = qi.bShowStatusWindow = true;
	qi.uShowRewriteDialog = 0;

	// R}hC
	argv[0] = "";
	argc = cmdline2array((char**)argv + 1, _szCmdLine) + 1;

	// R}hݒ
	if(strcmp(argv[1], "") == 0){
		for(i = 1; i < argc; i++) GlobalFree(argv[i]); 
		Process_End(ERROR_COMMAND_NAME);
	}

	// WXgǂݍ
	DWORD dwType, dwData;
	if(GetRegistryKeyValue(HKEY_CURRENT_USER, "Software\\ArchiverDll\\Paqar32\\Config", "CompressLevel", &dwType, (LPBYTE)&dwData) && dwType == REG_DWORD) cp.iCompressLevel = dwData;
	if(GetRegistryKeyValue(HKEY_CURRENT_USER, "Software\\ArchiverDll\\Paqar32\\Config", "x86Compress",   &dwType, (LPBYTE)&dwData) && dwType == REG_DWORD) cp.bX86Compress   = (dwData == 1);

	// XCb`ݒ
	for(i = 2; (i <= argc && (argv[i][0] == '-' || argv[i][0] == '/')); ){
		switch(tolower(argv[i][1])){
			case '+':// WXgݒ
				if(argv[i][2] == '1') cp.Init();
				break;
			case 'b':// fBNgݒ
				cp.szCurrentDirectory = argv[i] + 2;
				break;
			case 'm':// kxݒ
				cp.iCompressLevel = argv[i][2] - '0';
				break;
			case 'q':// ÓI[h
				switch(tolower(argv[i][2])){
					case 'a':	qi.bShowStatusWindow	= (argv[i][3] == '0');	break;
					case 'b':	qi.bOutputLog			= (argv[i][3] == '0');	break;
					case 'c':	qi.bShowErrorDialog		= (argv[i][3] == '0');	break;
					case 'd':	qi.uShowRewriteDialog	=  argv[i][3] -  '0';	break;
					default:
						if(argv[i][2] <= 2 && argv[i][2] >= 0){
							qi.bShowStatusWindow	= (argv[i][3] == '0');
							qi.bOutputLog			= (argv[i][3] == '0');
							qi.bShowErrorDialog		= (argv[i][3] == '0');
							qi.uShowRewriteDialog	=  argv[i][3] -  '0';
						}
						break;
				}
				break;
			case 'w':// ԃt@C쐬fBNgݒ
				cp.szWorkingDirectory = argv[i] + 2;
				break;
			case 'x':// x86kݒ
				cp.bX86Compress = (argv[i][2] == '1');
				break;
		}
		i++;
		if(argv[i-1][1] == '-') break;
	}

	// ɐݒ
	if(strcmp(argv[i], "") == 0){
		for(i = 1; i < argc; i++) GlobalFree(argv[i]); 
		Process_End(ERROR_NOT_ARC_FILE);
	}
	cp.szArchive = argv[i++];

	// Ώۃt@Cݒ
	for(; i <= argc; i++){
		if(argv[i][0] == '@'){
			FILE* f = fopen(argv[i] + 1, "r");
			if(! f){
				for(i = 1; i < argc; i++) GlobalFree(argv[i]); 
				Process_End(ERROR_RESPONSE_READ);
			}
			fseek(f, 0L, SEEK_END);
			ret = ftell(f);
			fseek(f, 0L, 0);
			fread(sz, 1, ret, f);
			fclose(f);
			sz[ret] = '\0';
			n += cmdline2array(cp.szFileList + n, sz);
			ret=0;// 
		}else cp.szFileList[n++] = (char*)argv[i];
	}
	cp.szFileList[n] = "";
	cp.iFileCount = n - 1;

	// O
	cp.hDialog = CreateDialog(hDLL, (LPCTSTR)IDD_PROCESS, _hwnd, ProcessDialogProc);
	if(g_OwnerWindow._proc == NULL) ManageOwnerWindow(false, 6, (ARCHIVERPROC)ProcessDialogProc, cp.hDialog);
	DoEvents();

	// 
	i = tolower(argv[1][0]);
	if(qi.bShowStatusWindow && (i == 'a' || i == 'e' || i == 'x')) CenteringWindow(cp.hDialog, _hwnd);
	switch(i){
		case 'a':	ret = cp.Compress();				break;// k
		default :	ret = cp.Test(); if(ret != 0)		break;
					switch(i){
						case 'e': cp.bExtractPath	=	false;//  (pX)
						case 'x': ret = cp.Extract();	break;//  (pXL)
						case 'l': ret = cp.List();		break;// {
//						case 'n': ret = cp.Rename();	break;// l[
//						case 's': ret = cp.Convert();	break;// SFXϊ
						case 't': default:				break;//  (ftHg)
					}
					break;
	}

	// I
	if(qi.bOutputLog) SendDlgItemMessage(cp.hDialog, IDC_EDIT1, WM_GETTEXT, _dwSize > lstrlen(_szOutput) - 1 ? lstrlen(_szOutput) - 1 : _dwSize, (LPARAM)_szOutput);
	DestroyWindow(cp.hDialog);
	for(i = 1; i < argc; i++) GlobalFree(argv[i]); 
	Process_End(g_Cancel ? ERROR_USER_CANCEL : ret);
}

WORD WINAPI PaqarGetVersion(void){								return PAQAR_VERSION;	}
WORD WINAPI PaqarGetSubVersion(void){							return PAQAR_SUBVERSION;}
WORD WINAPI PaqarGetBuild(void){								return PAQAR_SUBVERSION;}
BOOL WINAPI PaqarGetRunning(void){								return g_Running;		}
BOOL WINAPI PaqarGetBackGroundMode(void){						return false;			}
BOOL WINAPI PaqarSetBackGroundMode(const BOOL _bBackGroundMode){return false;			}
BOOL WINAPI PaqarGetCursorMode(void){							return true;			}
BOOL WINAPI PaqarSetCursorMode(const BOOL _CursorMode){			return false;			}
WORD WINAPI PaqarGetCursorInterval(void){						return 80;				}
BOOL WINAPI PaqarSetCursorInterval(const WORD _Interval){		return false;			}
BOOL WINAPI PaqarConfigDialog(const HWND _hwnd, LPSTR _szOptionBuffer, const int _iMode){
	Process(false, DialogBoxParam(hDLL, MAKEINTRESOURCE(IDD_CONFIG), _hwnd, ConfigDialogProc, 0L) ? true : false);
}

BOOL WINAPI PaqarCheckArchive(LPCSTR _szFileName, const int _iMode){
	Process_Sta(ERROR_ALREADY_RUNNING);
	CPaqar cp;
	wsprintf(cp.szArchive, "%s", _szFileName);
	Process_End(cp.Test() == 0);
}

int WINAPI PaqarGetFileCount(LPCSTR _szArcFile){
	Process_Sta(-1);
	CPaqar cp;
	wsprintf(cp.szArchive, "%s", _szArcFile);
	if(cp.Test() != 0) Process_End(-1);

	FILE *f = fopen(_szArcFile, "rb");
	int n, count = 0;
	while(n = fgetc(f)) if(n == '\t') count++; else if(n == '\032') break;
	fclose(f);
	Process_End(count);
}

BOOL WINAPI PaqarQueryFunctionList(const int _iFunction){
	switch(_iFunction){
		case ISARC:
		case ISARC_GET_VERSION:
		case ISARC_GET_RUNNING:
		case ISARC_GET_CURSOR_INTERVAL:
		case ISARC_SET_CURSOR_INTERVAL:
		case ISARC_GET_BACK_GROUND_MODE:
		case ISARC_SET_BACK_GROUND_MODE:
		case ISARC_GET_CURSOR_MODE:
		case ISARC_SET_CURSOR_MODE:
		case ISARC_CHECK_ARCHIVE:
		case ISARC_CONFIG_DIALOG:
		case ISARC_GET_FILE_COUNT:
		case ISARC_QUERY_FUNCTION_LIST:
		case ISARC_SETOWNERWINDOW:
		case ISARC_CLEAROWNERWINDOW:
		case ISARC_SETOWNERWINDOWEX:
		case ISARC_KILLOWNERWINDOWEX:
		case ISARC_SETOWNERWINDOWEX64:
		case ISARC_KILLOWNERWINDOWEX64:
			return true;
	}
	return false;
}

BOOL WINAPI PaqarSetOwnerWindowEx(HWND _hwnd,LPARCHIVERPROC _lpArcProc){Process(false, ManageOwnerWindow(_lpArcProc == NULL && _hwnd == NULL, _lpArcProc == NULL ? 2 : 4, *_lpArcProc, _hwnd));}
BOOL WINAPI PaqarKillOwnerWindowEx(HWND _hwnd){							Process(false, ManageOwnerWindow((g_OwnerWindow._type != 2 && g_OwnerWindow._type != 4) || g_OwnerWindow._hwnd != _hwnd, 0, NULL, NULL));}
BOOL WINAPI PaqarSetOwnerWindow(HWND _hwnd){							Process(false, ManageOwnerWindow(_hwnd == NULL, 1, NULL, _hwnd));}
BOOL WINAPI PaqarClearOwnerWindow(void){								Process(false, ManageOwnerWindow(g_OwnerWindow._type != 1, 0, NULL, NULL));}

BOOL WINAPI PaqarSetOwnerWindowEx64(HWND _hwnd, LPARCHIVERPROC _lpArcProc, DWORD _dwStructSize){
	Process_Sta(false);
	int i =	(_dwStructSize == sizeof(EXTRACTINGINFO)	? 3
		 :	(_dwStructSize == sizeof(EXTRACTINGINFOEX)	? 4
		 :	(_dwStructSize == sizeof(EXTRACTINGINFOEX32)? 5
		 :	(_dwStructSize == sizeof(EXTRACTINGINFOEX64)? 6
		 :	0))));
	Process_End(ManageOwnerWindow(_lpArcProc == NULL || i == 0, i, *_lpArcProc, _hwnd));
}

BOOL WINAPI PaqarKillOwnerWindowEx64(HWND _hwnd){						Process(false, ManageOwnerWindow(g_OwnerWindow._type < 3 || g_OwnerWindow._type > 6 || g_OwnerWindow._hwnd != _hwnd, 0, NULL, NULL));}
BOOL WINAPI PaqarSetEnumMembersProc(PAQAR_WND_ENUMMEMBPROC _lpEnumProc){Process(false, ManageEnum(_lpEnumProc == NULL, 1, _lpEnumProc));}
BOOL WINAPI PaqarClearEnumMembersProc(void){							Process(false, ManageEnum(g_Enum._type != 1, 0, NULL));}

BOOL WINAPI PaqarSetEnumMembersProc64(PAQAR_WND_ENUMMEMBPROC _lpEnumProc, DWORD _dwStructSize){
	Process_Sta(false);
	int i =	(_dwStructSize == sizeof(PAQAR_ENUM_MEMBER_INFO)	? 3
		 :	(_dwStructSize == sizeof(PAQAR_ENUM_MEMBER_INFO64)	? 4
		 :	0));
	Process_End(ManageEnum(_lpEnumProc == NULL || i == 0, i, _lpEnumProc));
}

BOOL WINAPI PaqarClearEnumMembersProc64(void){							Process(false, ManageEnum(g_Enum._type != 2 && g_Enum._type != 3, 0, NULL));}
