// Paqar32.dll
// $Id: class.cpp,v 1.7 2005/02/10 13:00:38 sirakaba Exp $

class CPaqar{
	public:
		// Jn/I
		 CPaqar();
		~CPaqar();
		// ֐
		void Init();
		// R}h֐
		int Compress();
		int Extract();
		int Join();
		int List();
		int Test();
		// Oϐ
		BOOL bX86Compress;
		BOOL bExtractPath;
		char *szArchive;
		char *szCurrentDirectory;
		char *szWorkingDirectory;
		char *szFileList[FNAME_MAX32 + 1];
		int  iCompressLevel;
		int  iFileCount;
		HWND hDialog;
	private:
		// p̈
		FILE *fp[3];
		char *szList[FNAME_MAX32 + 1];
		unsigned __int64 iList[FNAME_MAX32 + 1];
		ExtractInfo ei;
		StartProcessInfo si;
		// ėpϐ
		char *sz;
};

// Jn
CPaqar::CPaqar(){
	Init();
}

// I
CPaqar::~CPaqar(){

	// t@Cnh
	if(fp[0]) fclose(fp[0]);
	if(fp[1]) fclose(fp[1]);
	if(fp[2]) fclose(fp[2]);

	// mۗ̈
	for(int i = 0; lstrcmp(szList[i], "\0") != 0; ++i) GlobalFree(szList[i]);
}

// ֐
void CPaqar::Init(void){
	bX86Compress		= false;
	bExtractPath		= true;
	iCompressLevel		= 2;
	szArchive = szCurrentDirectory = szWorkingDirectory = sz = "";
	iFileCount			=  0;
	fp[0] = fp[1] = fp[2] = 0;
	szList[0]			= "\0";
	szWorkingDirectory	= getenv("TEMP");
	ZeroMemory(&ei, sizeof(ExtractInfo));
	ZeroMemory(&si, sizeof(StartProcessInfo));
}

// R}h֐

// k
int CPaqar::Compress(void){

	// ݒ
	MEM = iCompressLevel;
	exe = bX86Compress ? 1 : 0;
	SetCurrentDirectory(szCurrentDirectory);
	int i;
	__int64 ll, ll1;
	ZeroMemory(&ei, sizeof(ExtractInfo));
	ei.dummy1[0] = 'a';
	BOOL bExistArchive = false;

	// ɂ݂̑`FbN
	fp[0] = fopen(szArchive, "rb");

	// {͒ǉkł邪Ał̓pX(--;
	if(fp[0])																	return fclose(fp[0]) != 0 ? ERROR_CLOSE_FILE : 0;

	// ɂ쐬
	fp[0] = fopen(szArchive, "wb");
	if(! fp[0]){
		sprintf(sz, "Cannot create archive: %s\n", szArchive);
		AddStatusText(hDialog, sz);
		return ERROR_ARC_FILE_OPEN;
	}

	// ɖ𑗐M
	lstrcpyn(ei.szSourceFileName, szArchive, FNAME_MAX32);
	if(! SendStatusInfo(uMsg, ARCEXTRACT_OPEN, &ei))							return ERROR_USER_CANCEL;

	// 	wb_
	if(	fprintf(fp[0], "%s -%d", "PAQAR", iCompressLevel)	<= 0
		|| ( bX86Compress && fprintf(fp[0], "e")			<= 0 )
		|| fprintf(fp[0], "\r\n")							<= 0 )				return ERROR_CANNOT_WRITE;

	// CfbNX
	for(i = 0; i < iFileCount; ++i){

		// t@C΃G[I
		fp[1] = fopen(szFileList[i], "rb");
		if(! fp[1]){
			sprintf(sz, "File not found : %s\n", szFileList[i]);
			AddStatusText(hDialog, sz);
			return ERROR_SHARING;
		}

		// Ώۃt@CM
		lstrcpyn(ei.szSourceFileName, szFileList[i], FNAME_MAX32);
		if(! SendStatusInfo(uMsg, 5, &ei))										return ERROR_USER_CANCEL;

		// wb_ɏ
		if(fseek(fp[1], 0L, SEEK_END)	!= 0  )									return ERROR_SET_POINT;
		if(fgetpos(fp[1], &ll)			!= 0  )									return ERROR_GET_POINT;
		iList[i] = ll;
		if(fclose(fp[1])				!= 0  )									return ERROR_CLOSE_FILE;
		if(fprintf(fp[0], "%I64u\t%s\r\n", iList[i], strrstr(szFileList[i], "/")) <= 0)
																				return ERROR_CANNOT_WRITE;
	}

	// CfbNXI(MS-DOS EOF)
	if(putc(032, fp[0]) != 032)													return ERROR_CANNOT_WRITE;

	// 
	Transformer e(COMPRESS, fp[0]);
	unsigned __int64 l, n;

	// t@Cf[^
	for(i = 0; i < iFileCount; ++i){

		// ݊Jnʒu擾
		if(fgetpos(fp[0], &ll) != 0)											return ERROR_GET_POINT;

		// Ώۃt@C񑗐M
		lstrcpyn(ei.szSourceFileName,	szFileList[i], FNAME_MAX32);
		lstrcpyn(ei.szDestFileName,		strrstr(szFileList[i], "/"), FNAME_MAX32);
		ei.llFileSize = iList[i];
		if(! SendStatusInfo(uMsg, ARCEXTRACT_BEGIN, &ei))						return ERROR_USER_CANCEL;

		// t@CJ
		fp[1] = fopen(szFileList[i], "rb");
		if(! fp[1])																return ERROR_NOT_FIND_FILE;
		fsize = iList[i] - 513216;

		// x86œK
		if(fp[1] && bX86Compress && iList[i] > 0){
			int data2write[4] = {0, 0, 0, 0};
			if(fseek(fp[1], 0L, SEEK_END)	!= 0  )								return ERROR_SET_POINT;
			if(fgetpos(fp[1], &ll1)			!= 0  )								return ERROR_GET_POINT;
			n = ll1;
			if(fseek(fp[1], 0L, 0)			!= 0  )								return ERROR_SET_POINT;
			st0 = (char*)GlobalAlloc(GPTR, CONSTA + 2 * n + 256);
			if(st0 == NULL)														return ERROR_MORE_HEAP_MEMORY;
			st = st0 + 256 - ((int)st0 & 255);// 256-byte-alignment
			n  = fread(st + CONSTA - 32768, 1, n, fp[1]);
			if(n) te8e9(st, 3, n, &data2write[0]);
			if(fclose(fp[1]) != 0)												return ERROR_CLOSE_FILE;

			wsprintf(sz, "%s\\paqar11tmp.tmp", szWorkingDirectory);
			fp[1] = fopen(sz, "wb");
			if(! fp[1])															return ERROR_TMP_OPEN;
			iList[i] = 0;
			if(data2write[0]){
				iList[i] += data2write[0];
				if( fwrite((char*)data2write[1], 1, data2write[0], fp[1]) != data2write[0])
																				return ERROR_CANNOT_WRITE;
			}
			if(data2write[2]){
				iList[i] += data2write[2];
				if( fwrite((char*)data2write[3], 1, data2write[2], fp[1]) != data2write[2])
																				return ERROR_CANNOT_WRITE;
			}
			if(GlobalFree(st0)	!= NULL)										return ERROR_HEAP_MEMORY;
			if(fclose(fp[1])	!= 0)											return ERROR_CLOSE_FILE;
/*** Attention ! ***/
			fp[1] = fopen(sz, "rb");
			if(! fp[1])															return ERROR_TMP_OPEN;
		}

		// k
		for(n = 0; n < iList[i]; ++n){
			int c = getc(fp[1]);
			if(c == EOF)														return ERROR_CANNOT_READ;
			e.encode(c);
			// 󋵂𑗐M
			ei.llWriteSize = n;
			if(! SendStatusInfo(uMsg, ARCEXTRACT_INPROCESS, &ei))				return ERROR_USER_CANCEL;
		}

		// Ώۃt@C̏I𑗐M
		if(fgetpos(fp[0], &ll1) != 0)											return ERROR_GET_POINT;
		ei.llCompressedSize = ll1 - ll;
		ei.wRatio			= ei.llCompressedSize / (iList[i] * 0.01);
		if(! SendStatusInfo(uMsg, 6, &ei))										return ERROR_USER_CANCEL;

		// I
		if(fp[1]){
			if(fclose(fp[1]) != 0)												return ERROR_CLOSE_FILE;
			if(bX86Compress && iList[i] > 0 && ! DeleteFile(sz))				return ERROR_TMP_OPEN;
		}
	}

	// I
	e.flush();
	if( fclose(fp[0]) != 0 )													return ERROR_CLOSE_FILE;

	// I𑗐M
	if(! SendStatusInfo(uMsg, ARCEXTRACT_END, &ei))								return ERROR_USER_CANCEL;
	return 0;
}

// 
int CPaqar::Extract(void){

	// ݒ
	ZeroMemory(&ei, sizeof(ExtractInfo));
	ZeroMemory(&si, sizeof(StartProcessInfo));
	ei.dummy1[0] = 'e';
	si.uCommand  = PAQAR_EXTRACT_COMMAND;

	// ɂJ
	fp[0] = fopen(szArchive, "rb");
	if(! fp[0])																	return ERROR_NOT_ARC_FILE;

	// ɖ𑗐M
	lstrcpyn(ei.szSourceFileName, szArchive, FNAME_MAX32);
	if(! SendStatusInfo(uMsg, ARCEXTRACT_OPEN, &ei))							return ERROR_USER_CANCEL;

	// JgfBNgݒ
	if(strcmp(szCurrentDirectory, "") != 0 && ! SetCurrentDirectory(szCurrentDirectory)){
		if(! CreateDirectory(szCurrentDirectory, NULL))							return ERROR_MAKEDIRECTORY;
		SetCurrentDirectory(szCurrentDirectory);
	}

	// kxx86œKݒǂݍ
	bX86Compress = false;
	std::string s = getline(fp[0]);
	if(s.size() > 2){
		if(s[s.size() - 2] == '-'){
			int c = s[s.size() - 1];
			if(c >= '0' && c <= '9') iCompressLevel = c - '0';
		}else if(s[s.size() - 3] == '-'){
			int c = s[s.size() - 2];
			if(c >= '0' && c <= '9') iCompressLevel = c - '0';
			c = s[s.size() - 1];
			if(c == 'e') bX86Compress = true;
		}
	}

	// ݒ
	MEM = iCompressLevel;
	exe = bX86Compress ? 1 : 0;
	unsigned __int64 n = 0, l = 0;
	__int64 ll, ll1;

	// t@CTCYƃt@Cǂݍ
	for(int j = 0; ; ++j){
		s = getline(fp[0]);
		if(s.size() > 1){
			std::string::iterator tab = std::find(s.begin(), s.end(), '\t');
			if(tab == s.end()) break;
			iList[j]	= _atoi64(std::string(s.begin(), tab).c_str());
			szList[j]	= lstrdup(strrstr(std::string(tab + 1, s.end()).c_str(), bExtractPath ? "..\\" : "\\"));
		}else break;

		// Ώۃt@CM
		lstrcpyn(ei.szSourceFileName, szList[j], FNAME_MAX32);
		ei.llFileSize = iList[j];
		if(! SendStatusInfo(uMsg, 5, &ei))										return ERROR_USER_CANCEL;
	}
	szList[j] = "\0";

	// ɂf[^
	Transformer e(DECOMPRESS, fp[0]);
	for(int i = 0; i < j; ++i){

		// ݊Jnʒu擾
		if(fgetpos(fp[0], &ll) != 0)											return ERROR_GET_POINT;
		l = ll;

		// 𓀑ΏۂȂ
		for(int k = 0; k < iFileCount; ++k) if(lstrcmp(szList[i], szFileList[k]) == 0){
			k = 0;
			break;
		}

		// Ώۃt@C񑗐M(OwnerWindow)
		lstrcpyn(ei.szSourceFileName,	szList[i], FNAME_MAX32);
		lstrcpyn(ei.szDestFileName,		szList[i], FNAME_MAX32);
		ei.llFileSize = iList[i];
		if(! SendStatusInfo(uMsg, ARCEXTRACT_BEGIN, &ei))						return ERROR_USER_CANCEL;

		// Ώۃt@C񑗐M(EnumMembersProc)
		lstrcpyn(si.szFileName,			szList[i], FNAME_MAX32);
		lstrcpyn(si.szAddFileName,		szList[i], FNAME_MAX32);
		si.llOriginalSize = iList[i];
		fp[1] = 0;
		if(k == 0 && SendStartProcessInfo(&si)) fp[1] = fopen(szList[i], "wb");
		fsize = iList[i] - 513216;

		// x86œKO
		if(bX86Compress && iList[i] > 0){
			int c = e.decode();
			if(fp[1] && putc(c, fp[1]) != c)									return ERROR_CANNOT_WRITE;
			if(c){
				c -= 23;
				if((c < 0 && ((c + 8) & 1)) || (c >= 0 && ((c + 2) & 1))){
					int c = e.decode();
					if(fp[1] && putc(c, fp[1]) != c)							return ERROR_CANNOT_WRITE;
					int d = e.decode();
					if(fp[1] && putc(d, fp[1]) != c)							return ERROR_CANNOT_WRITE;
					d = d * 256 + c;
					for(n = 0; n < d * 3; ++n) putc(e.decode(), fp[1]);
				}
			}
		}

		// 𓀒I
		for(n = 0; n < iList[i]; ++n){
			int c = e.decode();
			if(fp[1] && putc(c, fp[1]) != c)									return ERROR_CANNOT_WRITE;

			// 󋵂𑗐M
			ei.llWriteSize = n + 1;
			if(! SendStatusInfo(uMsg, ARCEXTRACT_INPROCESS, &ei))				return ERROR_USER_CANCEL;
		}

		// Ώۃt@C̏I𑗐M
		if(fgetpos(fp[0], &ll1) != 0)											return ERROR_GET_POINT;
		ei.llCompressedSize			= ll1 - ll;
		ei.wRatio					= ei.llCompressedSize / (iList[i] * 0.01);
		if(! fp[1]) ei.llFileSize	= 0;
		if(! SendStatusInfo(uMsg, 6, &ei))										return ERROR_USER_CANCEL;

		// 𓀌㏈
		if(fp[1]){

			// x86œK
			if(bX86Compress && iList[i] > 0){
				int data2write[4] = {0, 0, 0, 0};
				if(fclose(fp[1]) != 0)											return ERROR_CLOSE_FILE;
				fp[1] = fopen(szList[i], "rb");
				if(! fp[1])														return ERROR_FILE_OPEN;
				if(fseek(fp[1], 0L, SEEK_END) != 0)								return ERROR_SET_POINT;
				if(fgetpos(fp[0], &ll) != 0)									return ERROR_GET_POINT;
				n = ll;
				if(fseek(fp[1], 0L, 0) != 0)									return ERROR_SET_POINT;
				st0 = (char*)GlobalAlloc(GPTR, CONSTA + 2 * n + 256);
				if(st0 == NULL)													return ERROR_MORE_HEAP_MEMORY;
				st = st0 + 256 - ((int)st0 & 255);	// 256-byte-alignment
				n = fread(st + CONSTA - 32768, 1, n, fp[1]);
				if(fclose(fp[1]) != 0)											return ERROR_CLOSE_FILE;
				fp[1] = fopen(szList[i], "wb");
				if(! fp[1])														return ERROR_FILE_OPEN;
				if(n) te8e9(st, 4, n, &data2write[0]);
				if(data2write[0] && fwrite((char*)data2write[1], 1, data2write[0], fp[1]) != data2write[0])
																				return ERROR_CANNOT_WRITE;
				if(GlobalFree(st0) != NULL)										return ERROR_HEAP_MEMORY;
			}
			if(fclose(fp[1]) != 0)												return ERROR_CLOSE_FILE;
		}
	}

	// Gh}[N̐퐫B
	if(ei.llWriteSize != ei.llFileSize)											return ERROR_INVALID_END_MARK;

	// ɂ
	if(fclose(fp[0]) != 0)														return ERROR_CLOSE_FILE;
	for(i = 0; i < j; ++i) if(GlobalFree(szList[i]) != NULL)					return ERROR_HEAP_MEMORY;

	// I𑗐M
	if(! SendStatusInfo(uMsg, ARCEXTRACT_END, &ei))								return ERROR_USER_CANCEL;
	return 0;
}

int CPaqar::Test(void){

	// ɂwb_擾
	fp[0] = fopen(szArchive, "rb");
	if(! fp[0])																	return ERROR_NOT_ARC_FILE;
	fgets(sz, 6, fp[0]);
	if(fclose(fp[0]) != 0)														return ERROR_CLOSE_FILE;

	// wb_݂̂̊ȈՃ`FbNB
	return strcmp(sz, "PAQAR") == 0 ? 0 : ERROR_FILE_STYLE;
}

int CPaqar::List(void){

	// ݒ
	int i;

	// ɂJ
	fp[0] = fopen(szArchive, "rb");
	if(! fp[0])																	return ERROR_NOT_ARC_FILE;

	// kxx86œKݒǂݍ
	bX86Compress = false;
	std::string s = getline(fp[0]);
	if(s.size() > 2){
		if(s[s.size() - 2] == '-'){
			int c = s[s.size() - 1];
			if(c >= '0' && c <= '9') iCompressLevel = c - '0';
		}else if(s[s.size() - 3] == '-'){
			int c = s[s.size() - 2];
			if(c >= '0' && c <= '9') iCompressLevel = c - '0';
			c = s[s.size() - 1];
			if(c == 'e') bX86Compress = true;
		}
	}

	// t@CTCYƃt@Cǂݍ
	for(int j = 0; ; ++j){
		s = getline(fp[0]);
		if(s.size() > 1){
			std::string::iterator tab = std::find(s.begin(), s.end(), '\t');
			if(tab == s.end()) break;
			iList[j]	= _atoi64(std::string(s.begin(), tab).c_str());
			szList[j]	= lstrdup(strrstr(std::string(tab + 1, s.end()).c_str(), bExtractPath ? "..\\" : "\\"));
		}else break;
	}
	szList[j] = "\0";

	// ɂ
	if(fclose(fp[0]) != 0)	return ERROR_CLOSE_FILE;
	sprintf(sz,
		"===============================================================================\n"
		"                Paqar32.dll v.%1.2f Build %d\n"
		"===============================================================================\n\n"
		"        Listing of archive:        %s\n"
		"        Archive info:\n"
		"               Compression Level:  %d\n"
		"               x86Compress:        %s\n\n"
		"  Name                          Original\n"
		"--------------------------  ------------\n"
		, (double)PAQAR_VERSION/100, (int)PAQAR_SUBVERSION, szArchive, iCompressLevel, bX86Compress ? "TRUE" : "FALSE");
	AddStatusText(hDialog, sz);
	unsigned __int64 ul = 0;
	for(i = 0; i < j; i++){
		sprintf(sz, "%-26s  %12I64u\n", szList[i], iList[i]);
		AddStatusText(hDialog, sz);
		ul += iList[i];
	}
	sprintf(sz,
		"--------------------------  ------------\n"
		"%20d files  %12I64u\n"
		"===============================================================================\n"
		, i, ul);
	AddStatusText(hDialog, sz);
	for(i = 0; i < j; ++i) if(GlobalFree(szList[i]) != NULL)			return ERROR_HEAP_MEMORY;
	return 0;
}
