// Independent class
// $Id: TPIHandle.h,v 1.3 2006/06/18 13:28:57 sirakaba Exp $

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

//******************************************************************************
//    萔`
//******************************************************************************

#ifndef H_LOADED_TPI_HANDLE
#define H_LOADED_TPI_HANDLE

//******************************************************************************
//    Class (TPIHandle)
//******************************************************************************

class TPIHandle
{
	public:
		~TPIHandle(void);
		int GetPluginInformation(unsigned int, ULONGLONG, void *);
		BOOL InitLibrary(const char *, const char *, ULONGLONG);
		BOOL FreeLibrary(void);

		int CheckArchive(const char *, int *);
		int OpenArchive(const char *, void * *);
		int CloseArchive(void *);
		int GetFileInformation(void *, TPI_FILEINFO *, BOOL);
		int GetArchiveInformation(void *, TPI_ARCHIVEINFO *);

		int Command(unsigned int, TPI_SWITCHES *, const char *, const char *);

		int SetCallbackProc(TPI_PROC);
	private:
		HMODULE hPlugin;
};

#endif
