// Independent Class
// $Id: Classes.cpp,v 1.1 2006/06/03 07:22:52 sirakaba Exp $

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "stdafx.h"
#include "Classes.h"

//******************************************************************************
//    o֐ (BufferStream)
//******************************************************************************

// RXgN^B
BufferStream::BufferStream(void)
{
	this->BufferSize = 0;
	this->lpBuffer = NULL;
}

// fXgN^B
BufferStream::~BufferStream(void)
{
	if (this->lpBuffer != NULL)
	{
		free(this->lpBuffer);
	}
}

// w肳ꂽTCŸmہB
BOOL BufferStream::Allocate(size_t _stSize)
{
	if (this->lpBuffer != NULL)
	{
		return FALSE;
	}

	this->BufferSize = _stSize;
	this->lpBuffer = (char *) malloc(_stSize);
	return this->lpBuffer != NULL;
}

// mۂ̈JB
BOOL BufferStream::Free(void)
{
	if (this->lpBuffer == NULL)
	{
		return FALSE;
	}
	free(this->lpBuffer);
	this->lpBuffer = NULL;
	return TRUE;
}

//******************************************************************************
//    o֐ (ArrayStream)
//******************************************************************************

ArrayStream::ArrayStream(void)
{
	this->BufferSize = 0;
	this->nItemCount = 0;
	this->lpBuffer = NULL;
}

ArrayStream::~ArrayStream(void)
{
	if (this->lpBuffer != NULL)
	{
		free(this->lpBuffer);
	}
}

BOOL ArrayStream::Allocate(int _nCount, size_t _stSize)
{
	if (this->lpBuffer != NULL)
	{
		return FALSE;
	}

	this->BufferSize = _stSize;
	this->nItemCount = _nCount;
	this->lpBuffer = (void *) calloc(_nCount, _stSize);

	return this->lpBuffer != NULL;
}

BOOL ArrayStream::Reallocate(int _nCount)
{
	if (this->lpBuffer != NULL)
	{
		return FALSE;
	}

	this->nItemCount = _nCount;
	this->lpBuffer = (void *) realloc(this->lpBuffer, _nCount * this->BufferSize);
	return this->lpBuffer != NULL;
}

BOOL ArrayStream::Free(void)
{
	if (this->lpBuffer == NULL)
	{
		return FALSE;
	}
	free(this->lpBuffer);
	this->lpBuffer = NULL;
	return TRUE;
}

