// frontend
// $Id: frontend.cpp,v 1.36 2006/09/17 13:03:17 sirakaba Exp $

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "stdafx.h"
#include "Classes.h"
#include "..\common\header\plugin.h"
#include "..\common\handle\TPIHandle.h"
#include "interface.h"
#include "frontend.h"
#include "functions.h"
#include "resource.h"

//******************************************************************************
//    O[oϐ
//******************************************************************************

HINSTANCE g_hInst;          // ݂̃C^[tFCX
ArrayStream g_asListViewItem; // Xgr[̃ACeꗗB
TPIHandle tpi;              // TPI vOC̋pnhB

int g_eSortingColumn;
BOOL g_fSortingDirection;

// ėpAvB
TCHAR g_szAppTitle[30];
char g_szIniFileName[MAX_PATH * 2 + 1];

//******************************************************************************
//    Gg[|Cg
//******************************************************************************

int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE /*hPrevInstance*/, LPTSTR /*lpCmdLine*/, int nCmdShow)
{
	// B
	g_hInst = hInstance;
	TCHAR szWindowClass[256];
	::LoadString(hInstance, IDS_APP_TITLE, g_szAppTitle, sizeof(g_szAppTitle) - 1);

	// InipX擾B
	::GetModuleFileName(hInstance, g_szIniFileName, sizeof(g_szIniFileName) - 1);
	* (strrchr(g_szIniFileName, '\\') + 1) = 0;
	strcat(g_szIniFileName, "frontend.ini");

	// dN}~B
	::LoadString(hInstance, IDC_FRONTEND, szWindowClass, sizeof(szWindowClass) - 1);
	if (::GetPrivateProfileInt(g_szAppTitle, "Window-Single", TRUE, g_szIniFileName))
	{
		HWND hExistWnd = ::FindWindow(szWindowClass, g_szAppTitle);
		if (hExistWnd != NULL)
		{
			::SendMessage(hExistWnd, WM_CLOSE, 0, 0);
		}
	}

	// EChENXo^B
	{
		WNDCLASSEX wcex;
		memset(& wcex, 0, sizeof(WNDCLASSEX));
		wcex.cbSize         = sizeof(WNDCLASSEX); 
		wcex.style          = CS_HREDRAW | CS_VREDRAW;
		wcex.lpfnWndProc    = (WNDPROC) WndProc;
		wcex.hInstance      = hInstance;
		wcex.hIcon          = (HICON)   ::LoadImage(hInstance, MAKEINTRESOURCE(IDI_FRONTEND), IMAGE_ICON, 0, 0, LR_DEFAULTSIZE | LR_SHARED);
		wcex.hCursor        = (HCURSOR) ::LoadImage(NULL,      MAKEINTRESOURCE(OCR_NORMAL), IMAGE_CURSOR, 0, 0, LR_DEFAULTSIZE | LR_SHARED);
		wcex.hbrBackground  = (HBRUSH) (COLOR_BTNFACE + 1);
		wcex.lpszMenuName   = MAKEINTRESOURCE(IDC_FRONTEND);
		wcex.lpszClassName  = szWindowClass;
		wcex.hIconSm        = (HICON)   ::LoadImage(hInstance, MAKEINTRESOURCE(IDI_FRONTEND), IMAGE_ICON, 0, 0, LR_DEFAULTSIZE | LR_SHARED);
		::RegisterClassEx(& wcex);
	}

	// EChE쐬B
	{
		RECT rcRect;
		rcRect.left     = ::GetPrivateProfileInt(g_szAppTitle, "Window-X",      200, g_szIniFileName);
		rcRect.top      = ::GetPrivateProfileInt(g_szAppTitle, "Window-Y",      200, g_szIniFileName);
		rcRect.right    = ::GetPrivateProfileInt(g_szAppTitle, "Window-Width",  940, g_szIniFileName);
		rcRect.bottom   = ::GetPrivateProfileInt(g_szAppTitle, "Window-Height", 340, g_szIniFileName);

		HWND hWnd = ::CreateWindowEx(0L, szWindowClass, g_szAppTitle, WS_OVERLAPPEDWINDOW, rcRect.left, rcRect.top, rcRect.right, rcRect.bottom, NULL, NULL, hInstance, NULL);
		if (! hWnd)
		{
			return FALSE;
		}
		::ShowWindow(hWnd, nCmdShow);
		::UpdateWindow(hWnd);

		// bZ[W[v񂷁B
		MSG msg;
		HACCEL hAccel = ::LoadAccelerators(hInstance, MAKEINTRESOURCE(IDR_ACCELERATOR));
		while (BOOL bRet = ::GetMessage(& msg, NULL, 0, 0))
		{
			if (bRet == -1)
			{
				break;
			}

			if (! ::TranslateAccelerator(hWnd, hAccel, & msg))
			{
				::TranslateMessage(& msg);
				::DispatchMessage(& msg);
			}
		}

		return (int) msg.wParam;
	}
}

//******************************************************************************
//    EChEvV[W
//******************************************************************************

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	// [Xvb^B
	static BOOL s_fSplitter;
	static HMENU s_hListViewPopupMenu;

	switch (message)
	{
	case WM_CREATE:
	{
		// e평B
		::InitCommonControls();
		::OleInitialize(NULL);

		// c[o[쐬B
		{
			int nToolBarIconSize = ::GetPrivateProfileInt(g_szAppTitle, "ToolBar-IconSize", 24, g_szIniFileName);
			HIMAGELIST hImgToolBar = ::ImageList_Create(nToolBarIconSize, nToolBarIconSize, ILC_COLOR16, 4, 4);
			::ImageList_SetBkColor(hImgToolBar, RGB(255, 255, 255));
			HWND hToolBar = ::CreateWindowEx(0, TOOLBARCLASSNAME, NULL, WS_CHILD | WS_VISIBLE | CCS_TOP, 0, 0, 0, 0, hWnd, (HMENU) IDO_MA_TOOLBAR, g_hInst, NULL);
			::SendMessage(hToolBar, TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON), 0);
			::SendMessage(hToolBar, TB_SETIMAGELIST, 0, (LPARAM) hImgToolBar);

			// {^쐬B
			char szString[1024];
			TBBUTTON tbButton;
			memset(& tbButton, 0, sizeof(TBBUTTON));
			tbButton.fsState = TBSTATE_ENABLED;
			tbButton.fsStyle = TBSTYLE_BUTTON;
			tbButton.iString = (INT_PTR) szString;

			// Create
			::LoadString(g_hInst, IDS_TB_CREATE, szString, sizeof(szString) - 1);
			tbButton.idCommand = ID_CREATE_ARCHIVE;
			tbButton.iBitmap = ImageList_AddIcon(hImgToolBar, (HICON) ::LoadImage(g_hInst, MAKEINTRESOURCE(IDI_TB_CREATE), IMAGE_ICON, 0, 0, LR_LOADTRANSPARENT | LR_SHARED));
			::SendMessage(hToolBar, TB_INSERTBUTTON, 0, (LPARAM) & tbButton);
			// Open
			::LoadString(g_hInst, IDS_TB_OPEN, szString, sizeof(szString) - 1);
			tbButton.idCommand = ID_OPEN_ARCHIVE;
			tbButton.iBitmap = ImageList_AddIcon(hImgToolBar, (HICON) ::LoadImage(g_hInst, MAKEINTRESOURCE(IDI_TB_OPEN), IMAGE_ICON, 0, 0, LR_LOADTRANSPARENT | LR_SHARED));
			::SendMessage(hToolBar, TB_INSERTBUTTON, 1, (LPARAM) & tbButton);
			// Close
			::LoadString(g_hInst, IDS_TB_CLOSE, szString, sizeof(szString) - 1);
			tbButton.idCommand = ID_CLOSE_ARCHIVE;
			tbButton.iBitmap = ImageList_AddIcon(hImgToolBar, (HICON) ::LoadImage(g_hInst, MAKEINTRESOURCE(IDI_TB_CLOSE), IMAGE_ICON, 0, 0, LR_LOADTRANSPARENT | LR_SHARED));
			tbButton.fsState = TBSTATE_INDETERMINATE;
			::SendMessage(hToolBar, TB_INSERTBUTTON, 2, (LPARAM) & tbButton);
			// Extract
			::LoadString(g_hInst, IDS_TB_EXTRACT, szString, sizeof(szString) - 1);
			tbButton.idCommand = ID_EXTRACT_ARCHIVE;
			tbButton.iBitmap = ImageList_AddIcon(hImgToolBar, (HICON) ::LoadImage(g_hInst, MAKEINTRESOURCE(IDI_TB_EXTRACT), IMAGE_ICON, 0, 0, LR_LOADTRANSPARENT | LR_SHARED));
			::SendMessage(hToolBar, TB_INSERTBUTTON, 3, (LPARAM) & tbButton);

			// TCYB
			::SendMessage(hToolBar, TB_AUTOSIZE, 0, 0);
		}

		// Xe[^Xo[쐬B
		{
			HWND hStatusBar = ::CreateWindowEx(0, STATUSCLASSNAME, NULL, WS_CHILD | WS_VISIBLE | CCS_BOTTOM | SBS_SIZEGRIP, 0, 0, 0, 0, hWnd, (HMENU) IDO_MA_STATUSBAR, g_hInst, 0);
			int nStatusBarParts[] = {0, 0, 0, 0, 0, 0};
			::SendMessage(hStatusBar, SB_SETPARTS, (WPARAM) 6, (LPARAM) nStatusBarParts);
			::SendMessage(hStatusBar, SB_SIMPLE, TRUE, 0);
		}

		// c[r[쐬B
		{
			HWND hTreeView = ::CreateWindowEx(0, WC_TREEVIEW, NULL, WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL | TVS_HASLINES | TVS_HASBUTTONS | TVS_LINESATROOT, 0, 0, 0, 0, hWnd, (HMENU) IDO_MA_TREEVIEW, g_hInst, 0);

			// zFB
			TreeView_SetBkColor(hTreeView, ::GetPrivateProfileInt(g_szAppTitle, "TreeView-BackGroundColor", RGB(255, 255, 255), g_szIniFileName));
			TreeView_SetTextColor(hTreeView, ::GetPrivateProfileInt(g_szAppTitle, "TreeView-TextColor", RGB(0, 0, 0), g_szIniFileName));
		}

		// Xgr[쐬B
		{
			HWND hListView = ::CreateWindowEx(0, WC_LISTVIEW, NULL, WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL | LVS_REPORT | LVS_SHOWSELALWAYS, 0, 0, 0, 0, hWnd, (HMENU) IDO_MA_LISTVIEW, g_hInst, 0);
			ListView_SetExtendedListViewStyle(hListView, LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

			// Xgr[̍𒲐߂邽߂Ƀ_~[̉摜XgݒB
			HIMAGELIST hIconS = ::ImageList_Create(16, 16, ILC_COLOR16, 1, 0);
			ListView_SetImageList(hListView, hIconS, LVSIL_SMALL);
			::ImageList_Destroy(hIconS);

			// \`ݒB
			int nFileView = ::GetPrivateProfileInt(g_szAppTitle, "ListView-Style", IDM_VI_DETAILS, g_szIniFileName);
			::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(nFileView, 0), 0);

			// \`ɍ킹ăj[Ƀ`FbNB
			HMENU hMenu = ::GetMenu(hWnd);
			MENUITEMINFO mii;
			memset(& mii, 0, sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_STATE;
			mii.fState = MFS_CHECKED;
			::SetMenuItemInfo(hMenu, nFileView, FALSE, & mii);

			// c[o[̕\Ԃɍ킹ăj[Ƀ`FbNB
			mii.fState = ::GetPrivateProfileInt(g_szAppTitle, "ToolBar-Visible", TRUE, g_szIniFileName) ? MFS_UNCHECKED : MFS_CHECKED;
			::SetMenuItemInfo(hMenu, IDM_VI_TOOLBAR, FALSE, & mii);
			::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(IDM_VI_TOOLBAR, 0), 0);

			// Xe[^Xo[̕\Ԃɍ킹ăj[Ƀ`FbNB
			mii.fState = ::GetPrivateProfileInt(g_szAppTitle, "StatusBar-Visible", TRUE, g_szIniFileName) ? MFS_UNCHECKED : MFS_CHECKED;
			::SetMenuItemInfo(hMenu, IDM_VI_STATUSBAR, FALSE, & mii);
			::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(IDM_VI_STATUSBAR, 0), 0);

			// EChE̍őOʕ\̏Ԃɍ킹ăj[Ƀ`FbNB
			mii.fState = ::GetPrivateProfileInt(g_szAppTitle, "Window-AlwaysOnTop", FALSE, g_szIniFileName) ? MFS_UNCHECKED : MFS_CHECKED;
			::SetMenuItemInfo(hMenu, IDM_VI_ALWAYSONTOP, FALSE, & mii);
			::DrawMenuBar(hWnd);
			::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(IDM_VI_ALWAYSONTOP, 0), 0);

			// J쐬B
			char szString[256];
			LVCOLUMN lvcCol;
			lvcCol.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
			lvcCol.fmt = LVCFMT_LEFT;
			lvcCol.iSubItem = 0;
			lvcCol.pszText = szString;

			// Filename
			lvcCol.cx = 150;
			::LoadString(g_hInst, IDS_LVC_FILENAME, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 0, & lvcCol);
			// Unpacked
			lvcCol.fmt = LVCFMT_RIGHT;
			lvcCol.cx = 90;
			::LoadString(g_hInst, IDS_LVC_UNPACKED, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 1, & lvcCol);
			// Packed
			::LoadString(g_hInst, IDS_LVC_PACKED, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 2, & lvcCol);
			// Ratio
			lvcCol.cx = 60;
			::LoadString(g_hInst, IDS_LVC_RATIO, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 3, & lvcCol);
			// Method
			lvcCol.cx = 55;
			::LoadString(g_hInst, IDS_LVC_METHOD, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 4, & lvcCol);
			// Attribute
			lvcCol.fmt = LVCFMT_LEFT;
			lvcCol.cx = 50;
			::LoadString(g_hInst, IDS_LVC_ATTR, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 5, & lvcCol);
			// Date/Time
			lvcCol.cx = 120;
			::LoadString(g_hInst, IDS_LVC_DATETIME, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 6, & lvcCol);
			// Path
			lvcCol.cx = 150;
			::LoadString(g_hInst, IDS_LVC_PATH, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 7, & lvcCol);
			// Type
			::LoadString(g_hInst, IDS_LVC_TYPE, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 8, & lvcCol);
			// No.
			lvcCol.cx = 35;
			::LoadString(g_hInst, IDS_LVC_NO, szString, sizeof(szString) - 1);
			ListView_InsertColumn(hListView, 9, & lvcCol);

			// \[gݒ擾B
			g_eSortingColumn      = ::GetPrivateProfileInt(g_szAppTitle, "ListView-SortingColumn",    9, g_szIniFileName);
			g_fSortingDirection   = ::GetPrivateProfileInt(g_szAppTitle, "ListView-SortingDirection", 1, g_szIniFileName);
			ListView_SortingWith(NULL, hListView);

			// |bvAbvj[쐬B
			s_hListViewPopupMenu = ::CreatePopupMenu();

			mii.cbSize = sizeof(MENUITEMINFO);
			mii.dwTypeData = szString;
			mii.cch = sizeof(szString) - 1;
			mii.fMask = MIIM_ID | MIIM_STATE | MIIM_STRING | MIIM_SUBMENU;

			HMENU hSubMenu = ::GetMenu(hWnd);
			::GetMenuItemInfo(hSubMenu, 1, TRUE, & mii);
			::InsertMenuItem(s_hListViewPopupMenu, 0, TRUE, & mii);
			::GetMenuItemInfo(hSubMenu, 2, TRUE, & mii);
			::InsertMenuItem(s_hListViewPopupMenu, 1, TRUE, & mii);

			::DrawMenuBar(hWnd);

			// zFB
			COLORREF crBkColor = ::GetPrivateProfileInt(g_szAppTitle, "ListView-BackGroundColor", RGB(255, 255, 255), g_szIniFileName);
			ListView_SetBkColor(hListView, crBkColor);
			ListView_SetTextBkColor(hListView, crBkColor);
			ListView_SetTextColor(hListView, ::GetPrivateProfileInt(g_szAppTitle, "ListView-TextColor", RGB(0, 0, 0), g_szIniFileName));
		}

		// DnDB
		::DragAcceptFiles(hWnd, TRUE);

		// R}hĆB
		char * argv[1024];
		if (cmdline2array(argv, ::GetCommandLine()) == 2)
		{
			LoadArchive(hWnd, argv[1], tpi, IDO_MA_TREEVIEW);
		}

		break;
	}
	case WM_DROPFILES:
	{
		char szFileName[MAX_PATH * 2 + 1];
		::DragQueryFile((HDROP) wParam, 0, szFileName, sizeof(szFileName) - 1);
		LoadArchive(hWnd, szFileName, tpi, IDO_MA_TREEVIEW);
		break;
	}
	case WM_COMMAND:
		// Iꂽj[̉ :
		switch (LOWORD(wParam))
		{
		case ID_CREATE_ARCHIVE:
		{
			// ɂ쐬B
			CreateDialogInfo cdiInfo;
			memset(& cdiInfo, 0, sizeof(CreateDialogInfo));

			// Ώۃt@C擾B
			char szFileNames[MAX_PATH * 200 + 1];
			{
				OPENFILENAME ofn;
				memset(& ofn, 0, sizeof(OPENFILENAME));
				ofn.lStructSize = sizeof(OPENFILENAME);
				ofn.hwndOwner = hWnd;
				ofn.lpstrFilter = "All files(*)\0*.*\0\0";
				ofn.nFilterIndex = 1;
				ofn.lpstrFile = szFileNames;
				ofn.nMaxFile = sizeof(szFileNames) - 1;
				ofn.Flags = OFN_ALLOWMULTISELECT | OFN_EXPLORER | OFN_FILEMUSTEXIST;
				if (! ::GetOpenFileName(& ofn))
				{
					break;
				}

				strncpy(cdiInfo.szDestinationPath, szFileNames, sizeof(cdiInfo.szDestinationPath) - 1);
			}

			BOOL bIsOneFile = TRUE;
			if (::GetFileAttributes(cdiInfo.szDestinationPath) & FILE_ATTRIBUTE_DIRECTORY)
			{
				bIsOneFile = FALSE;
				strcat(cdiInfo.szDestinationPath, "\\");
			}

			if (::DialogBoxParam(g_hInst, MAKEINTRESOURCE(IDD_CREATE), hWnd, CreateDialogProc, (LPARAM) & cdiInfo))
			{
				char szArchiveName[MAX_PATH * 2 + 1], szBaseDirPath[MAX_PATH + 1];
				sprintf(szArchiveName, "%s\\%s", cdiInfo.szDestinationPath, cdiInfo.szArchiveName);
				strncpy(szBaseDirPath, szFileNames, sizeof(szBaseDirPath) - 1);
				if (bIsOneFile)
				{
					* (strrchr(szBaseDirPath, '\\') + 1) = 0;
				}

				// t@CXgHANULLsɏB
				char * pFileNames = bIsOneFile ? szFileNames : szFileNames + strlen(szFileNames) + 1;
				BOOL bIsPastNull = FALSE;
				for (size_t s = 0; s < sizeof(szFileNames); s++)
				{
					if (pFileNames[s] == 0)
					{
						if (bIsPastNull)
						{
							pFileNames[++s] = 0;
							break;
						}
						else
						{
							pFileNames[s] = '\n';
							bIsPastNull = TRUE;
						}
					}
					else if (bIsPastNull)
					{
						bIsPastNull = FALSE;
					}
				}

				if (! tpi.InitLibrary(cdiInfo.szLibName, szArchiveName, cdiInfo.eArchiveType))
				{
					::MessageBox(hWnd, "Fault : InitLibrary()!", NULL, MB_OK);
					break;
				}

				// _CAO쐬B
				HWND hDialog = ::CreateDialogParam(g_hInst, MAKEINTRESOURCE(IDD_PROCESS), hWnd, ProcessDialogProc, 0L);

				// Ƃ肠ɂ쐬B
				TPI_SWITCHES swInfo;
				memset(& swInfo, 0, sizeof(TPI_SWITCHES));
				swInfo.fStoreDirectoryPathes = ! cdiInfo.bIgnorePath;
				swInfo.eArchiveType = cdiInfo.eArchiveType;
				swInfo.pCustomSwitches = NULL;
				strncpy(swInfo.szDestinationDirectory, szBaseDirPath, sizeof(swInfo.szDestinationDirectory) - 1);
				int nErrorCode = tpi.Command(TPI_COMMAND_ADD, & swInfo, szArchiveName, pFileNames);
				::DestroyWindow(hDialog);
				tpi.FreeLibrary();
				if (nErrorCode != TPI_ERROR_SUCCESS)
				{
					ErrorCodeDialog(hWnd, nErrorCode);
					break;
				}

				// 쐬JB
				if (cdiInfo.bOpenDirectory)
				{
					::ShellExecute(hWnd, NULL, cdiInfo.szDestinationPath, NULL, NULL, SW_SHOWNOACTIVATE);
				}

				// 쐬ɃAvP[VIB
				if (cdiInfo.bExitAfter)
				{
					::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(IDM_FI_EXIT, 0), 0);
					break;
				}

				// IȂꍇ͏ɂJB
				LoadArchive(hWnd, szArchiveName, tpi, IDO_MA_TREEVIEW);
			}
			break;
		}
		case ID_OPEN_ARCHIVE:
		{
			// ɂJB
			char szFilter[] = "All files(*)\0*\0", szFileName[1024];
			szFileName[0] = 0;
			OPENFILENAME ofn;
			memset(& ofn, 0, sizeof(OPENFILENAME));
			ofn.lStructSize = sizeof(OPENFILENAME);
			ofn.hwndOwner = hWnd;
			ofn.lpstrFilter = szFilter;
			ofn.lpstrFile = szFileName;
			ofn.nMaxFile = sizeof(szFileName) - 1;
			ofn.Flags = OFN_FILEMUSTEXIST;
			if (::GetOpenFileName(& ofn))
			{
				LoadArchive(hWnd, szFileName, tpi, IDO_MA_TREEVIEW);
			}
			break;
		}
		case ID_CLOSE_ARCHIVE:
		{
			// ɂB
			::SendDlgItemMessage(hWnd, IDO_MA_TREEVIEW, TVM_DELETEITEM, 0, (LPARAM) TVI_ROOT);
			::SendDlgItemMessage(hWnd, IDO_MA_LISTVIEW, LVM_DELETEALLITEMS, 0, 0);
			HWND hItem = ::GetDlgItem(hWnd, IDO_MA_TOOLBAR);
			::SendMessage(hItem, TB_SETSTATE, ID_CLOSE_ARCHIVE,   (LPARAM) MAKELONG(TBSTATE_INDETERMINATE, 0));
			::SendMessage(hItem, TB_SETSTATE, ID_EXTRACT_ARCHIVE, (LPARAM) MAKELONG(TBSTATE_INDETERMINATE, 0));

			::SendMessage(::GetDlgItem(hWnd, IDO_MA_STATUSBAR), SB_SIMPLE, TRUE, 0);

			// j[ݒB
			HMENU hMenu = ::GetMenu(hWnd);
			MENUITEMINFO mii;
			memset(& mii, 0, sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_STATE;
			mii.fState = MFS_DISABLED;
			::SetMenuItemInfo(hMenu, ID_CLOSE_ARCHIVE,   FALSE, & mii);
			::SetMenuItemInfo(hMenu, ID_EXTRACT_ARCHIVE, FALSE, & mii);

			g_asListViewItem.Free();
			tpi.FreeLibrary();
			break;
		}
		case ID_EXTRACT_ARCHIVE:
		{
			// ɂWJB
			ExtractDialogInfo ediInfo;

			// ɂ̃pX擾B
			char szArchiveName[MAX_PATH * 2 + 1];
			::SendDlgItemMessage(hWnd, IDO_MA_STATUSBAR, SB_GETTEXT, 5 | 0, (LPARAM) szArchiveName);
			strncpy(ediInfo.szDestinationPath, szArchiveName, sizeof(ediInfo.szDestinationPath) - 1);

			if (::DialogBoxParam(g_hInst, MAKEINTRESOURCE(IDD_EXTRACT), hWnd, ExtractDialogProc, (LPARAM) & ediInfo))
			{
				// _CAO쐬B
				HWND hDialog = ::CreateDialogParam(g_hInst, MAKEINTRESOURCE(IDD_PROCESS), hWnd, ProcessDialogProc, 0L);
				::EnableWindow(hWnd, FALSE);

				// Ƃ肠SWJB
				TPI_SWITCHES swInfo;
				memset(& swInfo, 0, sizeof(TPI_SWITCHES));
				swInfo.fStoreDirectoryPathes = ! ediInfo.bIgnorePath;
				swInfo.pCustomSwitches = NULL;
				strncpy(swInfo.szDestinationDirectory, ediInfo.szDestinationPath, sizeof(swInfo.szDestinationDirectory) - 1);
				if (ediInfo.eMakeDirectory != IDO_EX_RADIO_NOMAKE)
				{
					BOOL fIsMakeDirNeeded = ediInfo.eMakeDirectory == IDO_EX_RADIO_MAKEBYNAME;
					if (ediInfo.eMakeDirectory == IDO_EX_RADIO_IFNEEDED)
					{
						// c[r[烋[gȉ̃ACetH_ȉł邱Ƃ擾B

						// \̂B
						HWND hTreeView = ::GetDlgItem(hWnd, IDO_MA_TREEVIEW);
						// Ƀ[g̉̃ACe擾B
						HTREEITEM htiItem = TreeView_GetChild(hTreeView, TreeView_GetNextSibling(hTreeView, TreeView_GetRoot(hTreeView)));
						// YACe݂Ȃ(Kw0)ꍇB
						if (htiItem == NULL)
						{
							// Xgr[Ń[g̃ACet@Cȉł邱Ƃ擾B
							BOOL fOnceBool = FALSE;
							for (int i = 0; i < g_asListViewItem.nItemCount; i++)
							{
								char * pBuffer = ((TPI_FILEINFO *) g_asListViewItem.lpBuffer)[i].szFileName;
								if (strrchr(pBuffer, '/') == NULL || strchr(pBuffer, '/') == pBuffer)
								{
									if (fOnceBool)
									{
										fIsMakeDirNeeded = TRUE;
										break;
									}

									fOnceBool = TRUE;
								}
							}
						}
						// YACěZACe݂Ȃ(Kw1ȏ)ꍇB
						else if (TreeView_GetNextSibling(hTreeView, htiItem) == NULL)
						{
							// Xgr[Ń[g̃ACe݂ȂƂ擾B
							for (int i = 0; i < g_asListViewItem.nItemCount; i++)
							{
								char * pBuffer = ((TPI_FILEINFO *) g_asListViewItem.lpBuffer)[i].szFileName;
								if (strrchr(pBuffer, '/') == NULL || strchr(pBuffer, '/') == pBuffer)
								{
									fIsMakeDirNeeded = TRUE;
									break;
								}
							}
						}
						else
						{
							// łȂꍇɂ͎IɓWJ쐬B
							fIsMakeDirNeeded = TRUE;
						}
					}

					SlashToBackSlash(swInfo.szDestinationDirectory);
					if (fIsMakeDirNeeded)
					{
						// tH_쐬Kv([gȉɃtH_/t@CɊւ炸ACe2ȏ)ꍇB

						// ɖfBNg擾AWJɕtB
						strncat(swInfo.szDestinationDirectory, strrchr(szArchiveName, '\\'), sizeof(swInfo.szDestinationDirectory) - strlen(swInfo.szDestinationDirectory) - 1);
						if (! ::CreateDirectory(swInfo.szDestinationDirectory, NULL) && (::GetLastError() != ERROR_ALREADY_EXISTS || ::GetFileAttributes(swInfo.szDestinationDirectory) ^ FILE_ATTRIBUTE_DIRECTORY))
						{
							// ɎsꍇA255܂ō쐬sB
							for (int n = 0; n < 256; n++)
							{
								char szTemp[sizeof(swInfo.szDestinationDirectory)];
								sprintf(szTemp, "%s_%d",swInfo.szDestinationDirectory, n);
								strcpy(swInfo.szDestinationDirectory, szTemp);
								if (::CreateDirectory(swInfo.szDestinationDirectory, NULL) || (::GetLastError() == ERROR_ALREADY_EXISTS && ::GetFileAttributes(swInfo.szDestinationDirectory) ^ FILE_ATTRIBUTE_DIRECTORY))
								{
									// 쐬łIB
									break;
								}
							}
							// TODO : 255܂Ŏsꍇ̏ (^^;
						}
					}
				}
				strncat(swInfo.szDestinationDirectory, "\\",  sizeof(swInfo.szDestinationDirectory) - strlen(swInfo.szDestinationDirectory) - 1);
				int nErrorCode = tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, szArchiveName, NULL);
				::EnableWindow(hWnd, TRUE);
				::DestroyWindow(hDialog);
				if (nErrorCode != TPI_ERROR_SUCCESS)
				{
					ErrorCodeDialog(hWnd, nErrorCode);
					break;
				}

				// WJJB
				if (ediInfo.bOpenDirectory)
				{
					::ShellExecute(hWnd, NULL, swInfo.szDestinationDirectory, NULL, NULL, SW_SHOWNOACTIVATE);
				}

				// WJɃAvP[VIB
				if (ediInfo.bExitAfter)
				{
					::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(IDM_FI_EXIT, 0), 0);
				}
			}
			break;
		}
		case IDM_HE_ABOUT:
			::DialogBoxParam(g_hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, (DLGPROC) About, 0);
			break;
		case IDM_FI_EXIT:
			::DestroyWindow(hWnd);
			break;
		case IDM_VI_TOOLBAR:
			MenuBar_SetSomeBarStyle(hWnd, IDM_VI_TOOLBAR, IDO_MA_TOOLBAR);
			break;
		case IDM_VI_STATUSBAR:
			MenuBar_SetSomeBarStyle(hWnd, IDM_VI_STATUSBAR, IDO_MA_STATUSBAR);
			break;
		case IDM_VI_TILES:
			MenuBar_SetListViewStyle(hWnd, IDM_VI_TILES, 0x0004/*LV_VIEW_TILE*/);
			break;
		case IDM_VI_ICONS:
			MenuBar_SetListViewStyle(hWnd, IDM_VI_ICONS, LVS_ICON);
			break;
		case IDM_VI_LIST:
			MenuBar_SetListViewStyle(hWnd, IDM_VI_LIST, LVS_LIST);
			break;
		case IDM_VI_DETAILS:
			MenuBar_SetListViewStyle(hWnd, IDM_VI_DETAILS, LVS_REPORT);
			break;
		case IDM_VI_ALWAYSONTOP:
		{
			HMENU hMenu = ::GetMenu(hWnd);

			MENUITEMINFO mii;
			memset(& mii, 0, sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_STATE;
			::GetMenuItemInfo(hMenu, IDM_VI_ALWAYSONTOP, FALSE, & mii);

			// \Ăꍇ͔\ɁA邢͂̋tB
			::SetWindowPos(hWnd, mii.fState & MFS_CHECKED ? HWND_NOTOPMOST : HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
			mii.fState = mii.fState & MFS_CHECKED ? MFS_UNCHECKED : MFS_CHECKED;
			::SetMenuItemInfo(hMenu, IDM_VI_ALWAYSONTOP, FALSE, & mii);
			::DrawMenuBar(hWnd);
			break;
		}
		case IDM_VI_SELECTALL:
			ListView_SetItemState(::GetDlgItem(hWnd, IDO_MA_LISTVIEW), -1, LVIS_FOCUSED | LVIS_SELECTED, (unsigned) -1);
			::UpdateWindow(hWnd);
			break;
		default:
			return ::DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_NOTIFY:
	{
		// RRg[WM_COMMANDB
		NMHDR * nmHdr = (NMHDR *) lParam;
		switch (nmHdr->idFrom)
		{
		case IDO_MA_LISTVIEW:
		{
			NM_LISTVIEW * nmListView = (NM_LISTVIEW *) lParam;
			switch (nmHdr->code)
			{
			case LVN_COLUMNCLICK:
			{
				ListView_SortingWith(nmListView, NULL);
				break;
			}
			case NM_RCLICK:
			{
				POINT ptPnt;
				::GetCursorPos(& ptPnt);
				::TrackPopupMenu(s_hListViewPopupMenu, TPM_LEFTALIGN | TPM_LEFTBUTTON, ptPnt.x, ptPnt.y, 0, hWnd, NULL);
				break;
			}
			case NM_RETURN:
			case NM_DBLCLK:
			{
				// WJݒB
				TPI_SWITCHES swInfo;
				memset(& swInfo, 0, sizeof(TPI_SWITCHES));
				swInfo.fStoreDirectoryPathes = FALSE;
				swInfo.pCustomSwitches = NULL;
				::GetTempPath(sizeof(swInfo.szDestinationDirectory) - 1, swInfo.szDestinationDirectory);
				strncat(swInfo.szDestinationDirectory, "__tpi\\", sizeof(swInfo.szDestinationDirectory) - strlen(swInfo.szDestinationDirectory) - 1);
				::CreateDirectory(swInfo.szDestinationDirectory, NULL);

				// ɂ̃pX擾B
				char szArchiveName[MAX_PATH * 2 + 1];
				::SendDlgItemMessage(hWnd, IDO_MA_STATUSBAR, SB_GETTEXT, 5 | 0, (LPARAM) szArchiveName);

				// IACe̐sB
				// 񏈗s邩Axɏsɂ͈꒷Z肻B
				int nIndex = -1;
				while ((nIndex = ListView_GetNextItem(nmListView->hdr.hwndFrom, nIndex, LVNI_SELECTED)) != -1)
				{
					// IĂACẽpX擾B
					char szItemPath[MAX_PATH * 2 + 1], szItemText[MAX_PATH + 1];
					ListView_GetItemText(nmListView->hdr.hwndFrom, nIndex, 7, szItemPath, sizeof(szItemPath) - 1);
					ListView_GetItemText(nmListView->hdr.hwndFrom, nIndex, 0, szItemText, sizeof(szItemText) - 1);
					strncat(szItemPath, szItemText, sizeof(szItemPath) - strlen(szItemPath) - 1);


					// ɓWJ̊SȃpX쐬B
					char szDestination[MAX_PATH * 2 + 1];
					sprintf(szDestination, "%s%s", swInfo.szDestinationDirectory, szItemText);
					if (::GetFileAttributes(szDestination) != -1)
					{
						// WJɃt@C݂Ă΍폜B
						SHFILEOPSTRUCT shFileOp;
						memset(& shFileOp, 0, sizeof(SHFILEOPSTRUCT));
						shFileOp.wFunc  = FO_DELETE;
						shFileOp.pFrom  = szDestination;
						shFileOp.fFlags = FOF_NOERRORUI | FOF_NOCONFIRMATION | FOF_SILENT;
						::SHFileOperation(& shFileOp);
					}

					// ꎞtH_ɑIt@CWJB
					int nErrorCode = tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, szArchiveName, szItemPath);
					if (nErrorCode != TPI_ERROR_SUCCESS)
					{
						ErrorCodeDialog(hWnd, nErrorCode);
						continue;
					}

					// WJt@CJB
					if ((LONGLONG) ::ShellExecute(hWnd, NULL, szDestination, NULL, NULL, SW_SHOWNOACTIVATE) == SE_ERR_NOASSOC)
					{
						// ֘AtĂȂt@Cɑ΂Ă͑IB
						char szCmdLine[MAX_PATH * 2 + 1];
						sprintf(szCmdLine, "shell32.dll,OpenAs_RunDLL %s", szDestination);
						::ShellExecute(hWnd, NULL, "rundll32.exe", szCmdLine, NULL, SW_SHOWNOACTIVATE);
					}
				}
				break;
			}
			case LVN_BEGINDRAG:
			{
				// IĂt@C擾B
				int nSelectedCount = ListView_GetSelectedCount(nmListView->hdr.hwndFrom);

				// CDataObject쐬B
				CDataObject * cObject = new CDataObject();
				if (cObject == NULL || ! cObject->allocate(2))
				{
					break;
				}

				// DROPFILES쐬B
				HANDLE hObject = ::GlobalAlloc(GMEM_DDESHARE, sizeof(DROPFILES) + MAX_PATH * nSelectedCount + 1);
				if (! hObject)
				{
					break;
				}
				DROPFILES * lpDFiles = (DROPFILES *) ::GlobalLock(hObject);
				lpDFiles->pFiles = sizeof(DROPFILES);
				lpDFiles->fWide  = FALSE;

				// ꎞtH_쐬B
				char szTempDir[MAX_PATH + 1];
				::GetTempPath(sizeof(szTempDir) - 1, szTempDir);
				strncat(szTempDir, "__tpi\\", sizeof(szTempDir) - strlen(szTempDir) - 1);
				::CreateDirectory(szTempDir, NULL);

				// t@CƂ̏sB
				int nPos = sizeof(DROPFILES);
				LVITEM lvItem;
				lvItem.mask = LVIF_PARAM;
				lvItem.iItem = -1;
				lvItem.iSubItem = 0;
				for (int i = 0; i < nSelectedCount; i++)
				{
					lvItem.iItem = ListView_GetNextItem(nmListView->hdr.hwndFrom, lvItem.iItem, LVNI_ALL | LVNI_SELECTED);
					if (lvItem.iItem == -1)
					{
						break;
					}

					if (! ListView_GetItem(nmListView->hdr.hwndFrom, & lvItem))
					{
						continue;
					}

					char szFileName[MAX_PATH + 1];
					ListView_GetItemText(nmListView->hdr.hwndFrom, lvItem.iItem, 7, szFileName, sizeof(szFileName) - 1);
					int stLength = (int) strlen(szFileName);
					ListView_GetItemText(nmListView->hdr.hwndFrom, lvItem.iItem, 0, szFileName + stLength, sizeof(szFileName) - stLength - 1);
					nPos += sprintf(((char *) lpDFiles) + nPos, "%s%s", szTempDir, szFileName) + 1;
				}
				((TCHAR *) lpDFiles)[nPos] = 0;
				::GlobalUnlock(hObject);

				// FORMATETC쐬B
				FORMATETC fmtFormat;
				fmtFormat.cfFormat  = CF_HDROP;
				fmtFormat.dwAspect  = DVASPECT_CONTENT;
				fmtFormat.lindex    = -1;
				fmtFormat.ptd       = NULL;
				fmtFormat.tymed     = TYMED_HGLOBAL;

				// STGMEDIUM쐬B
				STGMEDIUM stgMedium;
				stgMedium.hGlobal   = hObject;
				stgMedium.tymed     = TYMED_HGLOBAL;
				stgMedium.pUnkForRelease = NULL;

				if (cObject->SetData(& fmtFormat, & stgMedium, TRUE) != S_OK)
				{
					break;
				}
				hObject = NULL;

				// ɖ擾B
				char szArchiveName[MAX_PATH * 2 + 1];
				::SendDlgItemMessage(hWnd, IDO_MA_STATUSBAR, SB_GETTEXT, 5 | 0, (LPARAM) szArchiveName);

				// CDropSource쐬B
				CDropSource * cSrc = new CDropSource(& tpi, szTempDir, szArchiveName, lpDFiles, hWnd);
				if (cSrc == NULL)
				{
					break;
				}

				// JnB
				DWORD dwEffect;
				::DragAcceptFiles(hWnd, FALSE);
				::DoDragDrop(cObject, cSrc, DROPEFFECT_COPY, & dwEffect);
				::DragAcceptFiles(hWnd, TRUE);

				// eB
				cObject->Release();
				cSrc->Release();
				break;
			}
			}
			break;
		}
		case IDO_MA_TREEVIEW:
		{
			switch (nmHdr->code)
			{
			case TVN_SELCHANGED:
			{
				// c[r[pX擾B
				char szNodePath[MAX_PATH + 1];
				TreeView_GetItemPath(nmHdr->hwndFrom, TreeView_GetSelection(nmHdr->hwndFrom), szNodePath, sizeof(szNodePath) - 1);

				// Xgr[B
				HWND hListView = ::GetDlgItem(hWnd, IDO_MA_LISTVIEW);
				ListView_DeleteAllItems(hListView);

				// ACRݒB
				HIMAGELIST
					hIconL = ::ImageList_Create(32, 32, ILC_COLOR16, g_asListViewItem.nItemCount + 2, 0),
					hIconS = ::ImageList_Create(16, 16, ILC_COLOR16, g_asListViewItem.nItemCount + 2, 0);
				ListView_SetImageList(hListView, hIconL, LVSIL_NORMAL);
				ListView_SetImageList(hListView, hIconS, LVSIL_SMALL);

				// ̍ڂƔrApXvȂΏB
				::LockWindowUpdate(hListView);
				for (int i = 0, nShow = 0; i < g_asListViewItem.nItemCount; i++)
				{
					TPI_FILEINFO fiInfo = ((TPI_FILEINFO *) g_asListViewItem.lpBuffer)[i];
					char szFilePath[MAX_PATH + 1];
					strcpy(szFilePath, fiInfo.szFileName);
					char * pLastSlash = strrchr(szFilePath, '/');
					if (pLastSlash == NULL)
					{
						szFilePath[0] = 0;
					}
					else
					{
						* ++pLastSlash = 0;
					}

					// pXrB
					if (strcmp(szNodePath, "*") == 0 || strcmp(szFilePath, szNodePath) == 0)
					{
						if (ListView_FileInfoToShow(hWnd, IDO_MA_LISTVIEW, nShow, fiInfo, hIconL, hIconS))
						{
							nShow++;
						}
					}
				}
				::LockWindowUpdate(NULL);

				// Xgr[\[gB
				ListView_SortingWith(NULL, hListView);
				break;
			}
			}
			break;
		}
		}
		break;
	}
	case WM_PAINT:
	{
		PAINTSTRUCT ps;
		::BeginPaint(hWnd, & ps);
		::EndPaint(hWnd, & ps);
		break;
	}
	case WM_LBUTTONDOWN:
	{
		// [Xvb^ : JnB

		// ܂Ac[r[ƃXgr[̊ԂɃ}EX邩mFB
		RECT rectTV;
		HWND hTreeView = ::GetDlgItem(hWnd, IDO_MA_TREEVIEW);
		::GetClientRect(hTreeView, & rectTV);
		if (::GetWindowLongPtr(hTreeView, GWL_STYLE) & WS_VSCROLL)
		{
			rectTV.right += ::GetSystemMetrics(SM_CXVSCROLL);
		}
		if (rectTV.right < LOWORD(lParam) && LOWORD(lParam) < rectTV.right + 3)
		{
			// ړJnB
			s_fSplitter = TRUE;
			::SetCapture(hWnd);
			::SetCursor((HCURSOR) ::LoadImage(NULL, MAKEINTRESOURCE(OCR_SIZEWE), IMAGE_CURSOR, 0, 0, LR_DEFAULTSIZE | LR_SHARED));
		}
		break;
	}
	case WM_LBUTTONUP:
		// [Xvb^ : IB
		if (s_fSplitter)
		{
			s_fSplitter = FALSE;
			::ReleaseCapture();
			::SetCursor((HCURSOR) ::LoadImage(NULL, MAKEINTRESOURCE(OCR_NORMAL), IMAGE_CURSOR, 0, 0, LR_DEFAULTSIZE | LR_SHARED));

			// ĕ`B
			RECT rectItem;
			::GetClientRect(hWnd, & rectItem);
			::SendMessage(hWnd, WM_SIZE, 0, MAKELPARAM(rectItem.right - rectItem.left, rectItem.bottom - rectItem.top));
		}
		break;
	case WM_MOUSEMOVE:
		// [Xvb^ : ړB
		{
			int nCurX = LOWORD(lParam);
			RECT rectItem;
			if (s_fSplitter)
			{
				int nToolBarHeight, nWindowWidth;

				// c[o[̃TCY擾B
				HWND hItem = ::GetDlgItem(hWnd, IDO_MA_TOOLBAR);
				::GetClientRect(hItem, & rectItem);
				nToolBarHeight = (::IsWindowVisible(hItem) ? rectItem.bottom - rectItem.top : 0) + 2;

				// c[r[̃TCYύXB
				hItem = ::GetDlgItem(hWnd, IDO_MA_TREEVIEW);
				::GetClientRect(hItem, & rectItem);
				::MoveWindow(hItem, 0, nToolBarHeight, nCurX, rectItem.bottom, TRUE);

				// EChE̕擾B
				::GetClientRect(hWnd, & rectItem);
				nWindowWidth = rectItem.right - rectItem.left;

				// Xgr[̃TCYύXB
				hItem = ::GetDlgItem(hWnd, IDO_MA_LISTVIEW);
				::GetClientRect(hItem, & rectItem);
				::MoveWindow(hItem, nCurX + 3, nToolBarHeight, nWindowWidth - (nCurX + 3), rectItem.bottom, TRUE);
			}
			else
			{
				// Eɂꍇɂ̓J[\ύXB
				HWND hTreeView = ::GetDlgItem(hWnd, IDO_MA_TREEVIEW);
				::GetClientRect(hTreeView, & rectItem);
				if (::GetWindowLongPtr(hTreeView, GWL_STYLE) & WS_VSCROLL)
				{
					rectItem.right += ::GetSystemMetrics(SM_CXVSCROLL);
				}
				::SetCursor((HCURSOR) ::LoadImage(NULL, MAKEINTRESOURCE((rectItem.right < nCurX && nCurX < rectItem.right + 3) ? OCR_SIZEWE : OCR_NORMAL), IMAGE_CURSOR, 0, 0, LR_DEFAULTSIZE | LR_SHARED));
			}
		}
		break;
	case WM_SIZE:
	{
		int nToolBarHeight, nStatusBarHeight, nTreeViewWidth, nTreeViewPreset;
		POINTS ptNow = MAKEPOINTS(lParam);

		// c[o[̃TCYύXB
		RECT rectItem;
		HWND hItem = ::GetDlgItem(hWnd, IDO_MA_TOOLBAR);
		::GetClientRect(hItem, & rectItem);
		nToolBarHeight = ::IsWindowVisible(hItem) ? rectItem.bottom - rectItem.top : 0;
		::SendMessage(hItem, WM_SIZE, 0, MAKELPARAM(0, 0));
		nToolBarHeight += 2;

		// Xe[^Xo[̃TCYύXB
		hItem = ::GetDlgItem(hWnd, IDO_MA_STATUSBAR);
		::GetClientRect(hItem, & rectItem);
		nStatusBarHeight = ::IsWindowVisible(hItem) ? rectItem.bottom - rectItem.top : 0;
		::SendMessage(hItem, WM_SIZE, 0, MAKELPARAM(0, 0));

		// c[r[̃TCYύXB
		hItem = ::GetDlgItem(hWnd, IDO_MA_TREEVIEW);
		::GetClientRect(hItem, & rectItem);
		nTreeViewWidth  = rectItem.right - rectItem.left;
		nTreeViewPreset = ::GetPrivateProfileInt(g_szAppTitle, "TreeView-Width", 100, g_szIniFileName);
		nTreeViewWidth  = nTreeViewWidth == 0 ? nTreeViewPreset == 0 ? 100 : nTreeViewPreset : nTreeViewWidth;
		if (::GetWindowLongPtr(hItem, GWL_STYLE) & WS_VSCROLL)
		{
			nTreeViewWidth += ::GetSystemMetrics(SM_CXVSCROLL);
		}
		::MoveWindow(hItem, 0, nToolBarHeight, nTreeViewWidth, ptNow.y - (nToolBarHeight + nStatusBarHeight), TRUE);

		// Xgr[̃TCYύXB
		::MoveWindow(GetDlgItem(hWnd, IDO_MA_LISTVIEW), nTreeViewWidth + 3, nToolBarHeight, ptNow.x - (nTreeViewWidth + 3), ptNow.y - (nToolBarHeight + nStatusBarHeight), TRUE);
		break;
	}
	case WM_DESTROY:
	{
		// eB
		::RevokeDragDrop(hWnd);
		::OleUninitialize();

		// ʒuۑB
		{
			RECT rcRect;
			::GetWindowRect(hWnd, & rcRect);

			// sȍW̏ꍇɂ͋L^ȂBŏ΍B
			if (rcRect.left != -32000 && rcRect.top != -32000)
			{
				WritePrivateProfileInt(g_szAppTitle, "Window-X", rcRect.left, g_szIniFileName);
				WritePrivateProfileInt(g_szAppTitle, "Window-Y", rcRect.top, g_szIniFileName);
				WritePrivateProfileInt(g_szAppTitle, "Window-Width", rcRect.right - rcRect.left, g_szIniFileName);
				WritePrivateProfileInt(g_szAppTitle, "Window-Height", rcRect.bottom - rcRect.top, g_szIniFileName);
			}
		}

		// j[o[֘AB
		HMENU hMenu = ::GetMenu(hWnd);
		MENUITEMINFO mii;
		memset(& mii, 0, sizeof(MENUITEMINFO));
		mii.cbSize = sizeof(MENUITEMINFO);
		mii.fMask = MIIM_STATE;

		// c[o[\邩B
		::GetMenuItemInfo(hMenu, IDM_VI_TOOLBAR, FALSE, & mii);
		WritePrivateProfileInt(g_szAppTitle, "ToolBar-Visible", mii.fState & MFS_CHECKED, g_szIniFileName);

		// Xe[^Xo[\邩B
		::GetMenuItemInfo(hMenu, IDM_VI_STATUSBAR, FALSE, & mii);
		WritePrivateProfileInt(g_szAppTitle, "StatusBar-Visible", mii.fState & MFS_CHECKED, g_szIniFileName);

		// EChEőOʂɕ\邩B
		::GetMenuItemInfo(hMenu, IDM_VI_ALWAYSONTOP, FALSE, & mii);
		WritePrivateProfileInt(g_szAppTitle, "Window-AlwaysOnTop", mii.fState & MFS_CHECKED, g_szIniFileName);

		// \`ۑB
		{
			int nCheckedItem = IDM_VI_DETAILS;
			::GetMenuItemInfo(hMenu, IDM_VI_TILES, FALSE, & mii);
			if (mii.fState & MFS_CHECKED)
			{
				nCheckedItem = IDM_VI_TILES;
			}
			::GetMenuItemInfo(hMenu, IDM_VI_ICONS, FALSE, & mii);
			if (mii.fState & MFS_CHECKED)
			{
				nCheckedItem = IDM_VI_ICONS;
			}
			::GetMenuItemInfo(hMenu, IDM_VI_LIST, FALSE, & mii);
			if (mii.fState & MFS_CHECKED)
			{
				nCheckedItem = IDM_VI_LIST;
			}
			::GetMenuItemInfo(hMenu, IDM_VI_DETAILS, FALSE, & mii);
			if (mii.fState & MFS_CHECKED)
			{
				nCheckedItem = IDM_VI_DETAILS;
			}

			WritePrivateProfileInt(g_szAppTitle, "ListView-Style", nCheckedItem, g_szIniFileName);
		}

		// c[o[̃ACRTCYۑB
		{
			int nToolBarIconSize;
			HIMAGELIST hToolBarIcon = (HIMAGELIST) SendDlgItemMessage(hWnd, IDO_MA_TOOLBAR, TB_GETIMAGELIST, 0, 0);
			::ImageList_GetIconSize(hToolBarIcon, & nToolBarIconSize, & nToolBarIconSize);
			::ImageList_Destroy(hToolBarIcon);
			WritePrivateProfileInt(g_szAppTitle, "ToolBar-IconSize", nToolBarIconSize, g_szIniFileName);
		}

		// \[g`ۑB
		WritePrivateProfileInt(g_szAppTitle, "ListView-SortingColumn",    g_eSortingColumn,    g_szIniFileName);
		WritePrivateProfileInt(g_szAppTitle, "ListView-SortingDirection", g_fSortingDirection, g_szIniFileName);

		// zFۑB
		{
			HWND hTemp = ::GetDlgItem(hWnd, IDO_MA_TREEVIEW);
			WritePrivateProfileInt(g_szAppTitle, "TreeView-BackGroundColor", TreeView_GetBkColor(hTemp),   g_szIniFileName);
			WritePrivateProfileInt(g_szAppTitle, "TreeView-TextColor",       TreeView_GetTextColor(hTemp), g_szIniFileName);

			hTemp = ::GetDlgItem(hWnd, IDO_MA_LISTVIEW);
			WritePrivateProfileInt(g_szAppTitle, "ListView-BackGroundColor", ListView_GetBkColor(hTemp),   g_szIniFileName);
			WritePrivateProfileInt(g_szAppTitle, "ListView-TextColor",       ListView_GetTextColor(hTemp), g_szIniFileName);
		}

		// c[r[̕ۑB
		{
			RECT rectItem;
			HWND hTreeView = ::GetDlgItem(hWnd, IDO_MA_TREEVIEW);
			::GetClientRect(hTreeView, & rectItem);
			if (::GetWindowLongPtr(hTreeView, GWL_STYLE) & WS_VSCROLL)
			{
				rectItem.right += ::GetSystemMetrics(SM_CXVSCROLL);
			}
			WritePrivateProfileInt(g_szAppTitle, "TreeView-Width", rectItem.right - rectItem.left, g_szIniFileName);
		}

		// ɂ鏈B
		::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(ID_CLOSE_ARCHIVE, 0), 0);

		// ԃfBNg폜B
		char szDestination[MAX_PATH * 2 + 1];
		::GetTempPath(sizeof(szDestination) - 1, szDestination);
		strncat(szDestination, "__tpi", sizeof(szDestination) - strlen(szDestination) - 1);
		SHFILEOPSTRUCT shFileOp;
		memset(& shFileOp, 0, sizeof(SHFILEOPSTRUCT));
		shFileOp.wFunc  = FO_DELETE;
		shFileOp.pFrom  = szDestination;
		shFileOp.fFlags = FOF_NOERRORUI | FOF_NOCONFIRMATION | FOF_SILENT;
		::SHFileOperation(& shFileOp);

		// e탁B
		::DestroyMenu(s_hListViewPopupMenu);

		::PostQuitMessage(0);
		break;
	}
	default:
		return ::DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

//******************************************************************************
//    _CAOvV[W
//******************************************************************************

LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM /*lParam*/)
{
	if (message == WM_COMMAND && LOWORD(wParam) == IDOK) 
	{
		::EndDialog(hDlg, TRUE);
		return TRUE;
	}
	return FALSE;
}
