// frontend
// $Id: functions.cpp,v 1.25 2006/09/17 12:53:33 sirakaba Exp $

/*******************************************************************************
Copyright (c) 2002-2006 Silky.

This software is provided 'as-is', without any express or implied warranty. In  
no event will the authors be held liable for any damages arising from the use of
this software.

Permission is granted to anyone to use this software for any purpose, including 
commercial applications, and to alter it and redistribute it freely, subject to 
the following restrictions:

  1. The origin of this software must not be misrepresented; you must not claim 
     that you wrote the original software. If you use this software in a product,
     an acknowledgment in the product documentation would be appreciated but is 
     not required.
  2. Altered source versions must be plainly marked as such, and must not be mis-
     represented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*******************************************************************************/

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "stdafx.h"
#include <io.h>
#include <math.h>
#include <objbase.h>
#include "Classes.h"
#include "..\common\header\plugin.h"
#include "..\common\handle\TPIHandle.h"
#include "frontend.h"
#include "functions.h"
#include "resource.h"

//******************************************************************************
//    O[oϐ
//******************************************************************************

// * (ExtractDialogInfo || CreateDialogInfo)
void * g_pdiInfo;

//******************************************************************************
//    Rg[n֐
//******************************************************************************

BOOL TreeView_CheckNewerItem(HWND hTreeView, HTREEITEM htiParent, const char * szDirPath)
{
	// szDirPath̓eRs[B
	BufferStream bsDirPath;
	bsDirPath.Allocate(strlen(szDirPath) + 1);
	strcpy(bsDirPath.lpBuffer, szDirPath);

	// Ώۂ̊Kw̃fBNgȍ~̃pXB
	char * pFirstSlash = strchr(bsDirPath.lpBuffer, '/');
	if (pFirstSlash != NULL)
	{
		* pFirstSlash = 0;
	}

	// ŏ̎qACe擾B
	HTREEITEM htiChild = TreeView_GetChild(hTreeView, htiParent);
	if (htiChild != NULL)
	{
		do
		{
			// ACeɂĂ̏擾B
			BufferStream bsDirName;
			bsDirName.Allocate(MAX_PATH + 1);
			TVITEM tiItem;
			tiItem.mask = TVIF_TEXT;
			tiItem.pszText = bsDirName.lpBuffer;
			tiItem.cchTextMax = (int) bsDirName.BufferSize;
			tiItem.hItem = htiChild;
			TreeView_GetItem(hTreeView, & tiItem);

			// 擾ACeƖOȂOKB
			if (strcmp(bsDirPath.lpBuffer, bsDirName.lpBuffer) == 0)
			{
				// ȉ̊KwꍇB
				if (pFirstSlash == NULL)
				{
					return TRUE;
				}

				// ܂KwLꍇAċAB
				return TreeView_CheckNewerItem(hTreeView, htiChild, strchr(szDirPath, '/') + 1);
			}
		}
		while ((htiChild = TreeView_GetNextSibling(hTreeView, htiChild)) != NULL);
	}

	// Ώۂꍇɂ͍쐬B
	if (strcmp(bsDirPath.lpBuffer, "") != 0)
	{
		TVINSERTSTRUCT tvisItem;
		tvisItem.hParent = htiParent;
		tvisItem.hInsertAfter = TVI_LAST;
		tvisItem.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		tvisItem.item.pszText = bsDirPath.lpBuffer;
		tvisItem.item.iImage = 1;
		tvisItem.item.iSelectedImage = 2;
		TreeView_InsertItem(hTreeView, & tvisItem);

		// eACeWJB
		TreeView_Expand(hTreeView, htiParent, TVE_EXPAND);
	}

	return FALSE;
}

BOOL TreeView_GetItemPath(HWND hTreeView, HTREEITEM htiItem, char * szNodePath, int nSize)
{
	// ̈mہB
	BufferStream bsItemName, bsTemp;
	bsItemName.Allocate(nSize);
	bsTemp.Allocate(nSize);

	// \̂B
	TVITEM tiItem;
	tiItem.mask = TVIF_TEXT;
	tiItem.pszText = bsItemName.lpBuffer;
	tiItem.cchTextMax = nSize - 1;
	tiItem.hItem = htiItem;
	memset(szNodePath, 0, nSize);

	// ACe̖O擾B
	while (TreeView_GetItem(hTreeView, & tiItem))
	{
		// [gȂ甲B
		if (strcmp(bsItemName.lpBuffer, "----") == 0)
		{
			return TRUE;
		}

		// pXɒǉB
		strcpy(bsTemp.lpBuffer, szNodePath);
		_snprintf(szNodePath, nSize - 1, "%s/%s", bsItemName.lpBuffer, bsTemp.lpBuffer);

		// eACeɑkB
		tiItem.hItem = TreeView_GetParent(hTreeView, tiItem.hItem);
		if (tiItem.hItem == NULL)
		{
			// ɂ̂͏ɓS\BȊO͒mȂw
			strncpy(szNodePath, "*", nSize - 1);
			break;
		}
	}

	return FALSE;
}

BOOL ListView_FileInfoToShow(HWND hWnd, int nListViewID, int nItemNum, TPI_FILEINFO fiInfo, HIMAGELIST hIconL, HIMAGELIST hIconS)
{
	// ACeB
	LVITEM lvItem;
	lvItem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
	lvItem.iItem  = nItemNum;
	lvItem.lParam = nItemNum;

	// eڂǉB
	lvItem.iSubItem = 0;
	char pPointer[256];
	lvItem.pszText = pPointer;
	char * pLastSlash = strrchr(fiInfo.szFileName, '/');
	if (pLastSlash != NULL && * (pLastSlash + 1) == 0)
	{
		return FALSE;
	}
	strcpy(lvItem.pszText, pLastSlash == NULL ? fiInfo.szFileName : strrchr(fiInfo.szFileName, '/') + 1);

	// ACRǂݍ݁B
	SHFILEINFO sfiInfo;
	::SHGetFileInfo(lvItem.pszText, FILE_ATTRIBUTE_NORMAL, & sfiInfo, sizeof(SHFILEINFO), SHGFI_USEFILEATTRIBUTES | SHGFI_ICON | SHGFI_LARGEICON);
	ImageList_AddIcon(hIconL, sfiInfo.hIcon);
	::SHGetFileInfo(lvItem.pszText, FILE_ATTRIBUTE_NORMAL, & sfiInfo, sizeof(SHFILEINFO), SHGFI_USEFILEATTRIBUTES | SHGFI_ICON | SHGFI_SMALLICON | SHGFI_TYPENAME);
	lvItem.iImage = ImageList_AddIcon(hIconS, sfiInfo.hIcon);

	HWND hListView = ::GetDlgItem(hWnd, nListViewID);
	ListView_InsertItem(hListView, & lvItem);
	lvItem.mask = LVIF_TEXT;
	lvItem.iSubItem = 1;
	_i64toa(fiInfo.llUnpackedSize, lvItem.pszText, 10);
	ListView_SetItem(hListView, & lvItem);
	lvItem.iSubItem = 2;
	_i64toa(fiInfo.llPackedSize, lvItem.pszText, 10);
	ListView_SetItem(hListView, & lvItem);
	lvItem.iSubItem = 3;
	sprintf(lvItem.pszText, "%3.1f%%", fiInfo.wCompressRatio / 10.0);
	ListView_SetItem(hListView, & lvItem);
	lvItem.iSubItem = 4;
	lvItem.pszText = fiInfo.szMethod;
	ListView_SetItem(hListView, & lvItem);
	lvItem.iSubItem = 5;
	char szAttribute[] = "---w-";
	AttributeToString(fiInfo.dwAttribute, szAttribute);
	lvItem.pszText = szAttribute;
	ListView_SetItem(hListView, & lvItem);
	lvItem.iSubItem = 6;
	WORD wDate = 0, wTime = 0;
	::FileTimeToDosDateTime(& fiInfo.ftModifiedTime, & wDate, & wTime);
	sprintf(lvItem.pszText, "%04u/%02u/%02u %02u:%02u:%02u", (wDate >> 9) + 1980, (wDate >> 5) & 0x0F, wDate & 0x1F, wTime >> 11, (wTime >> 5) & 0x3F, (wTime & 0x1F) * 2);
	ListView_SetItem(hListView, & lvItem);
	lvItem.iSubItem = 7;
	if (pLastSlash == NULL)
	{
		strcpy(lvItem.pszText, "");
	}
	else
	{
		* ++pLastSlash = 0;
		strcpy(lvItem.pszText, strchr(fiInfo.szFileName, '/') == fiInfo.szFileName ? fiInfo.szFileName + 1 : fiInfo.szFileName);
	}
	ListView_SetItem(hListView, & lvItem);
	lvItem.iSubItem = 8;
	strcpy(lvItem.pszText, sfiInfo.szTypeName);
	ListView_SetItem(hListView, & lvItem);
	lvItem.iSubItem = 9;
	itoa(nItemNum, lvItem.pszText, 10);
	ListView_SetItem(hListView, & lvItem);

	return TRUE;
}

BOOL ListView_SortingWith(NM_LISTVIEW * _pnmListView, HWND _hListView)
{
	// NM_LISTVIEW쐬B
	NM_LISTVIEW nmListView;
	if (_pnmListView == NULL)
	{
		nmListView.hdr.hwndFrom = _hListView;
		nmListView.iSubItem = g_eSortingColumn;
	}
	else
	{
		nmListView = * _pnmListView;

		// O[oϐɕۑB
		g_eSortingColumn    = nmListView.iSubItem;
		g_fSortingDirection = (g_eSortingColumn == nmListView.iSubItem && g_fSortingDirection) ? FALSE : TRUE;
	}

	// \[gsA\CB
	::LockWindowUpdate(nmListView.hdr.hwndFrom);
	ListView_SortItems(nmListView.hdr.hwndFrom, ListViewCompureProc, (WPARAM) & nmListView);
	::LockWindowUpdate(0);
	::SendMessage(nmListView.hdr.hwndFrom, LVM_FIRST + 140/*LVM_SETSELECTEDCOLUMN*/, g_eSortingColumn, 0);
	return TRUE;
}

BOOL MenuBar_SetListViewStyle(HWND _hWnd, int _nCheckMenuID, int _nListViewStyle)
{
	// j[o[ݒB
	HMENU hMenu = ::GetMenu(_hWnd);

	MENUITEMINFO mii;
	memset(& mii, 0, sizeof(MENUITEMINFO));
	mii.cbSize = sizeof(MENUITEMINFO);
	mii.fMask = MIIM_STATE;

	mii.fState = _nCheckMenuID == IDM_VI_LIST    ? MFS_CHECKED : MFS_UNCHECKED;
	::SetMenuItemInfo(hMenu, IDM_VI_LIST,  FALSE, & mii);
	mii.fState = _nCheckMenuID == IDM_VI_TILES   ? MFS_CHECKED : MFS_UNCHECKED;
	::SetMenuItemInfo(hMenu, IDM_VI_TILES,   FALSE, & mii);
	mii.fState = _nCheckMenuID == IDM_VI_ICONS   ? MFS_CHECKED : MFS_UNCHECKED;
	::SetMenuItemInfo(hMenu, IDM_VI_ICONS,   FALSE, & mii);
	mii.fState = _nCheckMenuID == IDM_VI_DETAILS ? MFS_CHECKED : MFS_UNCHECKED;
	::SetMenuItemInfo(hMenu, IDM_VI_DETAILS, FALSE, & mii);

	::DrawMenuBar(_hWnd);

	// LV_VIEW_****LVS_****͓łƂzB
	HWND hListView = ::GetDlgItem(_hWnd, IDO_MA_LISTVIEW);
	::SendMessage(hListView, LVM_FIRST + 142/*LVM_SETVIEW*/, _nListViewStyle, 0);
	if (_nListViewStyle != 0x0004)
	{
		::SetWindowLongPtr(hListView, GWL_STYLE, WS_CHILD | WS_VISIBLE | _nListViewStyle);
	}

	return TRUE;
}

BOOL MenuBar_SetSomeBarStyle(HWND _hWnd, int _nMenuItemID, int _nBarID)
{
	HMENU hMenu = ::GetMenu(_hWnd);

	MENUITEMINFO mii;
	memset(& mii, 0, sizeof(MENUITEMINFO));
	mii.cbSize = sizeof(MENUITEMINFO);
	mii.fMask = MIIM_STATE;
	::GetMenuItemInfo(hMenu, _nMenuItemID, FALSE, & mii);

	// \Ăꍇ͔\ɁA邢͂̋tB
	::ShowWindow(::GetDlgItem(_hWnd, _nBarID), mii.fState & MFS_CHECKED ? SW_HIDE : SW_SHOW);
	mii.fState = mii.fState & MFS_CHECKED ? MFS_UNCHECKED : MFS_CHECKED;
	::SetMenuItemInfo(hMenu, _nMenuItemID, FALSE, & mii);
	::DrawMenuBar(_hWnd);

	// ĕ`B
	RECT rcRect;
	::GetClientRect(_hWnd, & rcRect);
	::SendMessage(_hWnd, WM_SIZE, 0, MAKELPARAM(rcRect.right - rcRect.left, rcRect.bottom - rcRect.top));
	return TRUE;
}

//******************************************************************************
//    _CAOvV[W
//******************************************************************************

void DoEvents(void)
{
	for (MSG msg; PeekMessage(& msg, 0, 0, 0, PM_REMOVE); )
	{
		TranslateMessage(& msg);
		DispatchMessage(& msg);
	}
}

BOOL CALLBACK ConfigureDialogProc(HWND _hWnd, UINT _uMsg, WPARAM _wParam, LPARAM)
{
	switch (_uMsg)
	{
	case WM_INITDIALOG:
	{
		// J쐬B
		HWND hListView = ::GetDlgItem(_hWnd, IDO_CO_LISTVIEW);
		LV_COLUMN lvcCol;
		lvcCol.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		lvcCol.fmt = LVCFMT_LEFT;
		lvcCol.iSubItem = 0;
		lvcCol.cx = 150; lvcCol.pszText = "Name";   ListView_InsertColumn(hListView, 0, & lvcCol);
		lvcCol.cx = 90;  lvcCol.pszText = "Value";  ListView_InsertColumn(hListView, 1, & lvcCol);
		return TRUE;
	}
	case WM_COMMAND:
		switch (LOWORD(_wParam))
		{
		case IDOK:
		{
			// ݒt@CɕۑB
			EndDialog(_hWnd, TRUE);
			return TRUE;
		}
		case IDCANCEL:
			// ݒ𒆎~AύXۑȂB
			EndDialog(_hWnd, FALSE);
			return TRUE;
		}
		break;
	case WM_NOTIFY:
		if (_wParam != IDO_CO_LISTVIEW)
		{
			return FALSE;
		}
		return TRUE;
	}
	return FALSE;
}

char * g_szType[200];

BOOL CALLBACK CreateDialogProc(HWND _hWnd, UINT _uMsg, WPARAM _wParam, LPARAM _lParam)
{
	switch (_uMsg)
	{
	case WM_INITDIALOG:
	{
		// ރXgp̈mہB
		for (unsigned int u = 0; u < 200; u++)
		{
			g_szType[u] = (char *) malloc(200);
		}

		// ނ̕擾B
		{
			// fBNg̃tpX擾B
			char szWildCard[MAX_PATH * 2 + 1];
			::GetModuleFileName(g_hInst, (char *) & szWildCard, sizeof(szWildCard) - 1);
			* (strrchr(szWildCard, '\\') + 1) = 0;
			strncat(szWildCard, "lib\\*.dll", sizeof(szWildCard) - strlen(szWildCard) - 1);

			// CuB
			struct _finddata_t fdInfo;
			intptr_t nHandle = _findfirst(szWildCard, & fdInfo);
			if (nHandle != -1)
			{
				do
				{
					char szLibName[MAX_PATH + 1];
					sprintf(szLibName, "lib\\%s", fdInfo.name);
					if (! tpi.InitLibrary(szLibName, NULL, 0))
					{
						continue;
					}

					HWND hComboBoxType = ::GetDlgItem(_hWnd, IDO_CR_COMBOBOX_TYPE);
					char szType[255];
					for (unsigned int u = 0; tpi.GetPluginInformation(MAKELONG(TPI_INFO_SUPPORTED_TYPE, sizeof(szType)), u, szType) == TPI_ERROR_SUCCESS; u++)
					{
						if (strcmp(szType, "") != 0)
						{
							int nIndex = (int) ::SendMessage(hComboBoxType, CB_INSERTSTRING, (WPARAM) -1, (LPARAM) szType);
							::SendMessage(hComboBoxType, CB_SETITEMDATA, nIndex, u);
							strncpy(g_szType[nIndex], szLibName, 200 - 1);
						}
					}
					tpi.FreeLibrary();

					// ڐݒB
					::SendMessage(hComboBoxType, CB_SETCURSEL, 0, 0);
				}
				while (_findnext(nHandle, & fdInfo) == 0);
			}
			_findclose(nHandle);
		}

		return ExtractDialogProc(_hWnd, _uMsg, _wParam, _lParam);
	}
	case WM_COMMAND:
		switch (LOWORD(_wParam))
		{
		case IDOK:
		{
			// 쐬JnB
			CreateDialogInfo * cdiInfo = (CreateDialogInfo *) g_pdiInfo;
			::SendMessage(::GetWindow(::GetDlgItem(_hWnd, IDO_EX_COMBOBOX),      GW_CHILD), WM_GETTEXT, sizeof(cdiInfo->szDestinationPath) - 1, (LPARAM) cdiInfo->szDestinationPath);
			::SendMessage(::GetWindow(::GetDlgItem(_hWnd, IDO_CR_COMBOBOX_NAME), GW_CHILD), WM_GETTEXT, sizeof(cdiInfo->szArchiveName) - 1,     (LPARAM) cdiInfo->szArchiveName);

			// 쐬鏑ɂ̎ނ擾A֘AݒB
			HWND hComboBoxType = ::GetDlgItem(_hWnd, IDO_CR_COMBOBOX_TYPE);
			int nIndex = (int) ::SendMessage(hComboBoxType, CB_GETCURSEL, 0, 0);
			strncpy(cdiInfo->szLibName, g_szType[nIndex], sizeof(cdiInfo->szLibName) - 1);
			cdiInfo->eArchiveType  = (unsigned int) ::SendMessage(hComboBoxType, CB_GETITEMDATA, nIndex, 0);

			// ̑̐ݒB
			cdiInfo->bMakeSFX      = (BOOL) ::SendDlgItemMessage(_hWnd, IDO_CR_CHECK_SFX,      BM_GETCHECK, 0, 0);
			cdiInfo->bOpenDirectory= (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_CHECK_OPENDIR,  BM_GETCHECK, 0, 0);
			cdiInfo->bIgnorePath   = (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_CHECK_NOPATH,   BM_GETCHECK, 0, 0);
			cdiInfo->bExitAfter    = (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_CHECK_EXITAFTER,BM_GETCHECK, 0, 0);

			// ރXgB
			for (unsigned int u = 0; u < 200; u++)
			{
				free(g_szType[u]);
			}

			EndDialog(_hWnd, TRUE);
			return TRUE;
		}
		case IDO_CR_BUTTON_CONFIG:
			::DialogBoxParam(g_hInst, MAKEINTRESOURCE(IDD_CONFIGURE), _hWnd, ConfigureDialogProc, 0L);
			return TRUE;
		case IDCANCEL:
		case IDO_EX_BUTTON_BROWSE:
		case IDO_EX_BUTTON_DESKTOP:
		case IDO_EX_BUTTON_CURRENT:
			return ExtractDialogProc(_hWnd, _uMsg, _wParam, _lParam);
		}
		break;
	}
	return FALSE;
}

BOOL CALLBACK ExtractDialogProc(HWND _hWnd, UINT _uMsg, WPARAM _wParam, LPARAM _lParam)
{
	switch (_uMsg)
	{
	case WM_INITDIALOG:
		g_pdiInfo = (void *) _lParam;
		::SendDlgItemMessage(_hWnd, IDO_EX_RADIO_NOMAKE, BM_SETCHECK, BST_CHECKED, 0);

		char szBuffer[MAX_PATH + 1];
		strncpy(szBuffer, ((ExtractDialogInfo *) g_pdiInfo)->szDestinationPath, sizeof(szBuffer) - 1);
		* strrchr(szBuffer, '\\') = 0;
		{
			HWND hEditBox = ::GetWindow(::GetDlgItem(_hWnd, IDO_EX_COMBOBOX), GW_CHILD);
			::SendMessage(hEditBox, EM_SETLIMITTEXT, 0, 0);
			::SendMessage(hEditBox, WM_SETTEXT, 0, (LPARAM) szBuffer);
		}
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(_wParam))
		{
		case IDOK:
		{
			// WJJnB
			ExtractDialogInfo * ediInfo = (ExtractDialogInfo *) g_pdiInfo;
			::SendMessage(::GetWindow(::GetDlgItem(_hWnd, IDO_EX_COMBOBOX), GW_CHILD), WM_GETTEXT, sizeof(ediInfo->szDestinationPath) - 1, (LPARAM) ediInfo->szDestinationPath);
			ediInfo->eMakeDirectory = (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_RADIO_NOMAKE,    BM_GETCHECK, 0, 0) ? IDO_EX_RADIO_NOMAKE
									: (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_RADIO_MAKEBYNAME,BM_GETCHECK, 0, 0) ? IDO_EX_RADIO_MAKEBYNAME
									: (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_RADIO_IFNEEDED,  BM_GETCHECK, 0, 0) ? IDO_EX_RADIO_IFNEEDED
									: 0;
			ediInfo->bOpenDirectory = (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_CHECK_OPENDIR,  BM_GETCHECK, 0, 0);
			ediInfo->bIgnorePath    = (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_CHECK_NOPATH,   BM_GETCHECK, 0, 0);
			ediInfo->bExitAfter     = (BOOL) ::SendDlgItemMessage(_hWnd, IDO_EX_CHECK_EXITAFTER,BM_GETCHECK, 0, 0);
			EndDialog(_hWnd, TRUE);
			return TRUE;
		}
		case IDCANCEL:
			// WJ~B
			EndDialog(_hWnd, FALSE);
			return TRUE;
		case IDO_EX_BUTTON_BROWSE:
		{
			::CoInitialize(NULL);
			char szBuffer[MAX_PATH + 1];
			HWND hEditBox = ::GetWindow(::GetDlgItem(_hWnd, IDO_EX_COMBOBOX), GW_CHILD);
			::SendMessage(hEditBox, WM_GETTEXT, sizeof(szBuffer), (LPARAM) szBuffer);
			BROWSEINFO biInfo;
			memset(& biInfo, 0, sizeof(BROWSEINFO));
			biInfo.hwndOwner = _hWnd;
			biInfo.lParam = (LPARAM) szBuffer;
			biInfo.lpfn = & BrowseFolderDialogProc;
			biInfo.ulFlags = BIF_RETURNONLYFSDIRS | BIF_RETURNFSANCESTORS | BIF_EDITBOX | BIF_NEWDIALOGSTYLE | BIF_VALIDATE;
			if (::SHGetPathFromIDList(::SHBrowseForFolder(& biInfo), szBuffer))
			{
				::SendMessage(hEditBox, WM_SETTEXT, 0, (LPARAM) szBuffer);
			}
			return TRUE;
		}
		case IDO_EX_BUTTON_DESKTOP:
		{
			char szBuffer[MAX_PATH + 1];
			::SHGetSpecialFolderPath(_hWnd, szBuffer, CSIDL_DESKTOPDIRECTORY, FALSE);
			::SendMessage(::GetWindow(::GetDlgItem(_hWnd, IDO_EX_COMBOBOX), GW_CHILD), WM_SETTEXT, 0, (LPARAM) szBuffer);
			return TRUE;
		}
		case IDO_EX_BUTTON_CURRENT:
		{
			char szBuffer[MAX_PATH + 1];
			strncpy(szBuffer, ((ExtractDialogInfo *) g_pdiInfo)->szDestinationPath, sizeof(szBuffer) - 1);
			* strrchr(szBuffer, '\\') = 0;
			::SendMessage(::GetWindow(::GetDlgItem(_hWnd, IDO_EX_COMBOBOX), GW_CHILD), WM_SETTEXT, 0, (LPARAM) szBuffer);
			return TRUE;
		}
		}
		break;
	}
	return FALSE;
}

int CALLBACK BrowseFolderDialogProc(HWND _hWnd, UINT _uMsg, LPARAM _lParam, LPARAM _lpData)
{
	switch (_uMsg)
	{
    case BFFM_INITIALIZED:
		// tH_ݒB
		::SendMessage(_hWnd, BFFM_SETSELECTION, (WPARAM) TRUE, _lpData);
		return TRUE;
	case BFFM_SELCHANGED:
		char szBuffer[MAX_PATH + 1];
		::SendMessage(_hWnd, BFFM_ENABLEOK, 0, (LPARAM) ::SHGetPathFromIDList((ITEMIDLIST *) _lParam, szBuffer));
		return TRUE;
	case BFFM_VALIDATEFAILED:
		::SendMessage(_hWnd, BFFM_ENABLEOK, 0, (LPARAM) FALSE);
		return TRUE;
	}

	return FALSE;
}

HWND g_hProcessWnd;
BOOL g_Cancel;

int CALLBACK TPICallbackProc(unsigned int _uMsg, void * _pStructure)
{
	if (_uMsg != TPI_NOTIFY_COMMON)
	{
		return TPI_CALLBACK_UNSUPPORTED;
	}

	TPI_PROCESSINFO * piInfo = (TPI_PROCESSINFO *) _pStructure;
	if (piInfo == NULL || piInfo->uMessage != TPI_MESSAGE_STATUS)
	{
		return TPI_CALLBACK_CONTINUE;
	}

	switch (piInfo->uStatus)
	{
	case TPI_STATUS_OPENARCHIVE:
		::SendDlgItemMessage(g_hProcessWnd, IDO_PR_EDIT_ARCHIVE, WM_SETTEXT, 0, (LPARAM) piInfo->fiInfo.szFileName);
		break;
	case TPI_STATUS_BEGINPROCESS:
		::SendDlgItemMessage(g_hProcessWnd, IDO_PR_EDIT_TARGET, WM_SETTEXT, 0, (LPARAM) piInfo->fiInfo.szFileName);
		::SendDlgItemMessage(g_hProcessWnd, IDO_PR_PROGRESS, PBM_SETPOS, 0, 0);
		break;
	case TPI_STATUS_INPROCESS:
		::SendDlgItemMessage(g_hProcessWnd, IDO_PR_PROGRESS, PBM_SETPOS, int(piInfo->llProcessedSize / (piInfo->fiInfo.llUnpackedSize * 0.01)), 0);
		break;
	case TPI_STATUS_ENDPROCESS:
		::SendDlgItemMessage(g_hProcessWnd, IDO_PR_PROGRESS, PBM_SETPOS, 100, 0);
		break;
	}

	DoEvents();
	return g_Cancel ? TPI_CALLBACK_CANCEL : TPI_CALLBACK_CONTINUE;
}

BOOL CALLBACK ProcessDialogProc(HWND _hWnd, UINT _uMsg, WPARAM _wParam, LPARAM /* _lParam */)
{
	switch (_uMsg)
	{
	case WM_INITDIALOG:
		g_hProcessWnd = _hWnd;
		g_Cancel = FALSE;
		CenteringWindow(_hWnd, NULL);
		return TRUE;
	case WM_COMMAND:
	{
		switch (LOWORD(_wParam))
		{
		case IDCANCEL:
			g_Cancel = TRUE;
			::EndDialog(_hWnd, FALSE);
			return TRUE;
		}
	}
	}

	return FALSE;
}

int g_nTotalCount;
int g_nCall;
int CALLBACK ListViewCompureProc(LPARAM lp1, LPARAM lp2, LPARAM lp3)
{
	NM_LISTVIEW * nmListView = (NM_LISTVIEW *) lp3;
	char szBuffer1[MAX_PATH + 1], szBuffer2[MAX_PATH + 1];
	::SendDlgItemMessage(g_hProcessWnd, IDO_OP_PROGRESS, PBM_SETPOS, int(g_nCall++ / (g_nTotalCount * log((long double) g_nTotalCount))), 0);
	DoEvents();

	LV_FINDINFO lvfInfo;
	lvfInfo.flags = LVFI_PARAM;
	lvfInfo.lParam = lp1;
	ListView_GetItemText(nmListView->hdr.hwndFrom, ListView_FindItem(nmListView->hdr.hwndFrom, -1, & lvfInfo), nmListView->iSubItem, szBuffer1, sizeof(szBuffer1));
	lvfInfo.lParam = lp2;
	ListView_GetItemText(nmListView->hdr.hwndFrom, ListView_FindItem(nmListView->hdr.hwndFrom, -1, & lvfInfo), nmListView->iSubItem, szBuffer2, sizeof(szBuffer2));

	return (g_fSortingDirection ? 1 : -1) * ((
		nmListView->iSubItem == 1 ||
		nmListView->iSubItem == 2 ||
		nmListView->iSubItem == 9
		) ? (
			atoi(szBuffer1) > atoi(szBuffer2) ?  1 :
			atoi(szBuffer1) < atoi(szBuffer2) ? -1 : 0
		) : (nmListView->iSubItem == 3) ?
			atof(szBuffer1) > atof(szBuffer2) ?  1 :
			atof(szBuffer1) < atof(szBuffer2) ? -1 : 0
		: stricmp(szBuffer1, szBuffer2));
}

BOOL CALLBACK OpenDialogProc(HWND _hWnd, UINT _uMsg, WPARAM _wParam, LPARAM /* _lParam */)
{
	switch (_uMsg)
	{
	case WM_INITDIALOG:
		CenteringWindow(_hWnd, NULL);
		return TRUE;
	case WM_COMMAND:
	{
		switch (LOWORD(_wParam))
		{
		case IDCANCEL:
			::EndDialog(_hWnd, FALSE);
			return TRUE;
		}
	}
	}

	return FALSE;
}

//******************************************************************************
//    ֐
//******************************************************************************

int LoadArchive(HWND hWnd, const char * szFileName, TPIHandle & tpi, int nTreeViewID)
{
	// _CAO\B
	HWND hDlg = ::CreateDialogParam(g_hInst, MAKEINTRESOURCE(IDD_OPENING), hWnd, (DLGPROC) OpenDialogProc, 0);
	char szString[256];
	::LoadString(g_hInst, IDS_OP_FILELOAD, szString, sizeof(szString) - 1);
	::SendDlgItemMessage(hDlg, IDO_OP_STATIC, WM_SETTEXT, 0, (LPARAM) szString);
	DoEvents();

	// UIB
	::SendMessage(hWnd, WM_COMMAND, MAKEWPARAM(ID_CLOSE_ARCHIVE, 0), 0);

	char * szArchiveName = (char *) malloc(strlen(szFileName) + 1);
	strcpy(szArchiveName, szFileName);
	// DnDł̓pX؂肪"/"œn悤Ȃ̂ŁȂ΍B
	SlashToBackSlash(szArchiveName);

	// Cu[hAΉĂ邩mFB
	int nFileCount = -1;
	{
		// fBNg̃tpX擾B
		char szWildCard[MAX_PATH * 2 + 1];
		::GetModuleFileName(g_hInst, (char *) & szWildCard, sizeof(szWildCard) - 1);
		* (strrchr(szWildCard, '\\') + 1) = 0;
		strncat(szWildCard, "lib\\*.dll", sizeof(szWildCard) - strlen(szWildCard) - 1);

		// CuB
		struct _finddata_t fdInfo;
		intptr_t nHandle = _findfirst(szWildCard, & fdInfo);
		if (nHandle != -1)
		{
			do
			{
				char szLibName[MAX_PATH + 1];
				sprintf(szLibName, "lib\\%s", fdInfo.name);
				if (! tpi.InitLibrary(szLibName, szArchiveName, 0) || tpi.CheckArchive(szArchiveName, & nFileCount) != TPI_ERROR_SUCCESS || nFileCount == -1)
				{
					tpi.FreeLibrary();
					continue;
				}
				break;
			}
			while (_findnext(nHandle, & fdInfo) == 0);
		}
		_findclose(nHandle);
	}
	if (nFileCount == -1)
	{
		::MessageBox(hDlg, "Fault : No plug-in supporting the archive was found!", NULL, MB_OK);
		::DestroyWindow(hDlg);
		return FALSE;
	}

	// XgACei[̈쐬B
	g_asListViewItem.Allocate(nFileCount, sizeof(TPI_FILEINFO));

	// ɂJB
	HANDLE hArc = NULL;
	if (tpi.OpenArchive(szArchiveName, & hArc) != TPI_ERROR_SUCCESS || hArc == NULL)
	{
		::MessageBox(hDlg, "Fault : OpenArchive()!", NULL, MB_OK);
		::DestroyWindow(hDlg);
		return FALSE;
	}

	// c[r[̃C[WXg쐬B
	HIMAGELIST hIconT = ::ImageList_Create(16, 16, ILC_COLOR16 | ILC_MASK, 3, 0);
	HWND hTreeView = ::GetDlgItem(hWnd, nTreeViewID);
	TreeView_SetImageList(hTreeView, hIconT, TVSIL_NORMAL);

	// Ƀ[g쐬B
	TV_INSERTSTRUCT tv;
	memset(& tv, 0, sizeof(TV_INSERTSTRUCT));
	tv.hInsertAfter = TVI_LAST;
	tv.hParent = TVI_ROOT;
	tv.item.mask = TVIF_TEXT | TVIF_IMAGE;

	// ɂ̃ACR擾B
	SHFILEINFO sfiInfo;
	::SHGetFileInfo(szArchiveName, FILE_ATTRIBUTE_NORMAL, & sfiInfo, sizeof(SHFILEINFO), SHGFI_USEFILEATTRIBUTES | SHGFI_ICON | SHGFI_SMALLICON);
	tv.item.iImage = ::ImageList_AddIcon(hIconT, sfiInfo.hIcon);

	{
		char * pLastSlash = (char *) strrchr(szArchiveName, '\\');
		tv.item.pszText = pLastSlash == NULL ? szArchiveName : pLastSlash + 1;
	}

	// Ƀ[g쐬B
	HTREEITEM htiArchive = TreeView_InsertItem(hTreeView, & tv);

	// [gfBNg쐬B
	tv.item.mask |= TVIF_SELECTEDIMAGE;
	tv.item.pszText = "----";
	tv.item.iImage         = ::ImageList_AddIcon(hIconT, (HICON) ::LoadImage(g_hInst, MAKEINTRESOURCE(IDI_FOLDER_CLOSED), IMAGE_ICON, 0, 0, LR_DEFAULTSIZE | LR_SHARED));
	tv.item.iSelectedImage = ::ImageList_AddIcon(hIconT, (HICON) ::LoadImage(g_hInst, MAKEINTRESOURCE(IDI_FOLDER_OPEN),   IMAGE_ICON, 0, 0, LR_DEFAULTSIZE | LR_SHARED));
	HTREEITEM htiRoot = TreeView_InsertItem(hTreeView, & tv);

	// t@C[h
	TPI_FILEINFO fiInfo;
	memset(& fiInfo, 0, sizeof(TPI_FILEINFO));
	int i = 0;
	if (tpi.GetFileInformation(hArc, & fiInfo, TRUE) == TPI_ERROR_SUCCESS)
	{
		do
		{
			DoEvents();
			::SendDlgItemMessage(hDlg, IDO_OP_PROGRESS, PBM_SETPOS, int(i / (nFileCount * 0.01)), 0);

			BackSlashToSlash(fiInfo.szFileName);

			// fBNg܂ނ̂ɂĂ͏B
			if (fiInfo.dwAttribute & FILE_ATTRIBUTE_DIRECTORY)
			{
				continue;
			}

			// ۑăJEgAbvB
			memcpy(& ((TPI_FILEINFO *) g_asListViewItem.lpBuffer)[i++], & fiInfo, g_asListViewItem.BufferSize);

			// c[r[ɔfB
			char * pLastSlash = strrchr(fiInfo.szFileName, '/');
			if (pLastSlash != NULL)
			{
				* ++pLastSlash = 0;
				TreeView_CheckNewerItem(hTreeView, htiRoot, fiInfo.szFileName);
			}
		}
		while (tpi.GetFileInformation(hArc, & fiInfo, FALSE) == TPI_ERROR_SUCCESS);

		// ǉłȂo݂ƂɁAACe̐␳B
		g_asListViewItem.nItemCount = i;
	}

	// ɂ̏擾B
	{
		TPI_ARCHIVEINFO aiInfo;
		memset(& aiInfo, 0, sizeof(TPI_ARCHIVEINFO));
		if (tpi.GetArchiveInformation(hArc, & aiInfo) != TPI_ERROR_SUCCESS)
		{
			::MessageBox(hDlg, "Fault : GetArchiveInformation()!", NULL, MB_OK);
			::DestroyWindow(hDlg);
			return FALSE;
		}

		char szBuffer[1024], szBuffer2[1024];
		SIZE sSize;
		int nStatusBarParts[] = {40, 0, 0, 0, 0, 0}, nStrLen;
		HWND hStatusBar = ::GetDlgItem(hWnd, IDO_MA_STATUSBAR);
		HDC hDC = ::GetDC(hStatusBar);
		HGDIOBJ hOldFont = ::SelectObject(hDC, ::GetStockObject(DEFAULT_GUI_FONT));

		::LoadString(g_hInst, IDS_SP_FILECOUNT, szBuffer, sizeof(szBuffer) - 1);
		nStrLen = sprintf(szBuffer2, szBuffer, i);
		::SendMessage(hStatusBar, SB_SETTEXT, 1 | 0, (LPARAM) szBuffer2);
		::GetTextExtentPoint32(hDC, szBuffer2, nStrLen, & sSize);
		nStatusBarParts[1] = sSize.cx + nStatusBarParts[0] + 15;

		::LoadString(g_hInst, IDS_SP_UNPACKED, szBuffer, sizeof(szBuffer) - 1);
		nStrLen = sprintf(szBuffer2, szBuffer, aiInfo.llUnpackedSize);
		::SendMessage(hStatusBar, SB_SETTEXT, 2 | 0, (LPARAM) szBuffer2);
		::GetTextExtentPoint32(hDC, szBuffer2, nStrLen, & sSize);
		nStatusBarParts[2] = sSize.cx + nStatusBarParts[1] + 15;

		::LoadString(g_hInst, IDS_SP_PACKED, szBuffer, sizeof(szBuffer) - 1);
		nStrLen = sprintf(szBuffer2, szBuffer, aiInfo.llPackedSize);
		::SendMessage(hStatusBar, SB_SETTEXT, 3 | 0, (LPARAM) szBuffer2);
		::GetTextExtentPoint32(hDC, szBuffer2, nStrLen, & sSize);
		nStatusBarParts[3] = sSize.cx + nStatusBarParts[2] + 15;

		::LoadString(g_hInst, IDS_SP_RATIO, szBuffer, sizeof(szBuffer) - 1);
		nStrLen = sprintf(szBuffer2, szBuffer, aiInfo.wCompressRatio / 10.0);
		::SendMessage(hStatusBar, SB_SETTEXT, 4 | 0, (LPARAM) szBuffer2);
		::GetTextExtentPoint32(hDC, szBuffer2, nStrLen, & sSize);
		nStatusBarParts[4] = sSize.cx + nStatusBarParts[3] + 15;

		::SendMessage(hStatusBar, SB_SETTEXT, 5 | 0, (LPARAM) szArchiveName);
		::GetTextExtentPoint32(hDC, szArchiveName, (signed) strlen(szArchiveName), & sSize);
		nStatusBarParts[5] = sSize.cx + nStatusBarParts[4] + 15;

		// TCYݒB
		::SelectObject(hDC, hOldFont);
		::ReleaseDC(hStatusBar, hDC);
		::SendMessage(hStatusBar, SB_SETPARTS, (WPARAM) 6, (LPARAM) nStatusBarParts);
		::SendMessage(hStatusBar, SB_SIMPLE, FALSE, 0);
	}
	free(szArchiveName);

	// ɂB
	if (tpi.CloseArchive(hArc) != TPI_ERROR_SUCCESS)
	{
		::MessageBox(hWnd, "Fault : CloseArchive()!", NULL, MB_OK);
	}

	// sƂ̃R[obN֐ݒB
	if (tpi.SetCallbackProc(TPICallbackProc) != TPI_ERROR_SUCCESS)
	{
		::MessageBox(hWnd, "Fault : SetCallbackProc()!", NULL, MB_OK);
	}

	// c[r[烊Xgr[ɔfB
	::LoadString(g_hInst, IDS_OP_FILELOAD, szString, sizeof(szString) - 1);
	::SendDlgItemMessage(hDlg, IDO_OP_STATIC, WM_SETTEXT, 0, (LPARAM) szString);
	DoEvents();
	g_nCall = 0;
	g_nTotalCount = i;
	g_hProcessWnd = hDlg;
	TreeView_SelectItem(hTreeView, htiArchive);
	g_nCall = 0;
	g_nTotalCount = 0;
	g_hProcessWnd = NULL;

	// UIeݒB
	{
		// c[o[ݒB
		HWND hToolBar = ::GetDlgItem(hWnd, IDO_MA_TOOLBAR);
		::SendMessage(hToolBar, TB_SETSTATE, ID_CLOSE_ARCHIVE,   (LPARAM) MAKELONG(TBSTATE_ENABLED, 0));
		::SendMessage(hToolBar, TB_SETSTATE, ID_EXTRACT_ARCHIVE, (LPARAM) MAKELONG(TBSTATE_ENABLED, 0));

		// j[ݒB
		HMENU hMenu = ::GetMenu(hWnd);
		MENUITEMINFO mii;
		memset(& mii, 0, sizeof(MENUITEMINFO));
		mii.cbSize = sizeof(MENUITEMINFO);
		mii.fMask = MIIM_STATE;
		mii.fState = MFS_ENABLED;
		::SetMenuItemInfo(hMenu, ID_CLOSE_ARCHIVE,   FALSE, & mii);
		::SetMenuItemInfo(hMenu, ID_EXTRACT_ARCHIVE, FALSE, & mii);
	}

	::DestroyWindow(hDlg);
	return TRUE;
}

BOOL AttributeToString(DWORD dwAttribute, char * szBuffer)
{
	szBuffer[0] = dwAttribute & FILE_ATTRIBUTE_DIRECTORY ? 'd' : dwAttribute & FILE_ATTRIBUTE_ARCHIVE ? 'a' : '-';
	szBuffer[1] = dwAttribute & FILE_ATTRIBUTE_SYSTEM    ? 's' : '-';
	szBuffer[2] = dwAttribute & FILE_ATTRIBUTE_HIDDEN    ? 'h' : '-';
	szBuffer[3] = dwAttribute & FILE_ATTRIBUTE_READONLY  ? 'r' : 'w';
	szBuffer[4] = dwAttribute & FILE_ATTRIBUTE_ENCRYPTED ? 'g' : '-';

	return TRUE;
}

#define jms1(c) (((((BYTE)(c)) >= 0x81) && (((BYTE)(c)) <= 0x9F)) || ((((BYTE)(c)) >= 0xE0) && (((BYTE)(c)) <= 0xFC)))
#define jms2(c)  ((((BYTE)(c)) != 0x7F) && (((BYTE)(c)) >= 0x40)  &&  (((BYTE)(c)) <= 0xFC))

int isJMS(const char *str, size_t nPos){
	int state = 0;
	for(size_t i = 0; i < strlen(str); i++){
		state = ((state == 0) && (jms1(*(str + i))) ? 1
			:	((state == 1) && (jms2(*(str + i))) ? 2
			:	((state == 2) && (jms1(*(str + i))) ? 1
			:	0)));
		if(i == nPos) return state;
	}
	return 0;
}

int cmdline2array(char **argv, const char *cmdline){
	int len = 0, r, argc = 0;
	char src[10000], temp[512];
	strncpy(src, cmdline, sizeof(src) - 1);
	for (size_t i = 0; i < strlen(src); i++)
	{
		if (isJMS(src, i) == 0 && src[i] == '\\')
		{
			src[i] = '/';
		}
	}
	while(isJMS(src, len) == 0 && src[len] != '\0'){
		while(isJMS(src, len) == 0 && (src[len] == ' ' || src[len] == '\n' || src[len] == '\r')) len++;
		if(isJMS(src,len) == 0 && src[len] == '\0'){
			argv[argc] = "\0";
			return argc;
		}
		if(isJMS(src, len) == 0 && src[len] == '\"'){
			len++;
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argv[argc] = "\0";
				return argc;
			}
			r = 0;
			while(src[len] != '\"' && src[len] != '\0'){
r1:
				temp[r] = src[len];
				len++;
				r++;
			}
			if(isJMS(src, len) != 0) goto r1;
			temp[r] = '\0';
			argv[argc] = strdup(temp);
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argc++;
				argv[argc] = "\0";
				return argc;
			}
			len++;
		}else{
			r = 0;
			while(src[len] != ' ' && src[len] != '\n' && src[len] != '\r' && src[len] != '\0'){
r2:
				temp[r] = src[len];
				len++;
				r++;
			}
			if(isJMS(src, len) != 0) goto r2;
			temp[r] = '\0';
			argv[argc] = strdup(temp);
			if(isJMS(src, len) == 0 && src[len] == '\0'){
				argc++;
				argv[argc] = "\0";
				return argc;
			}
		}
		argc++;
	}
	argv[argc] = "\0";
	return argc;
}

void CenteringWindow(HWND _hwnd, HWND _hwParent)
{
	if (_hwParent == NULL)
	{
		_hwParent = ::GetDesktopWindow();
	}
	RECT rc;
	::GetWindowRect(_hwnd, & rc);
	int nWidth = rc.right - rc.left, nHeight = rc.bottom - rc.top;
	::GetWindowRect(_hwParent, & rc);
	::MoveWindow(_hwnd, ((rc.right + rc.left) - nWidth) / 2, ((rc.bottom + rc.top) - nHeight) / 2, nWidth, nHeight, TRUE);
	::ShowWindow(_hwnd, SW_SHOW);
	DoEvents();
}

BOOL BackSlashToSlash(char * _szString)
{
	// "\""/"ɕϊB
	for (unsigned int u = 0; u <= strlen(_szString); u++)
	{
		if (_szString[u] == '\\')
		{
			_szString[u] = '/';
		}
	}
	return TRUE;
}

BOOL SlashToBackSlash(char * _szString)
{
	// "/""\"ɕϊB
	for (unsigned int u = 0; u <= strlen(_szString); u++)
	{
		if (_szString[u] == '/')
		{
			_szString[u] = '\\';
		}
	}
	return TRUE;
}

// WritePrivateProfileStringintŁB
BOOL WritePrivateProfileInt(const char * lpAppName, const char * lpKeyName, int nInt, const char * lpFileName)
{
	char szTemp[30];
	itoa(nInt, szTemp, 10);
	return ::WritePrivateProfileString(lpAppName, lpKeyName, szTemp, lpFileName);
}

void ErrorCodeDialog(HWND hWnd, int nErrorCode)
{
	char szMsg[100];
	sprintf(szMsg, "Fault : Command()!\nErrorCode:%d", nErrorCode);
	::MessageBox(hWnd, szMsg, NULL, MB_OK);
}
