// frontend
// $Id: interface.cpp,v 1.4 2006/08/08 05:49:50 sirakaba Exp $
// This code is diverted from http://hp.vector.co.jp/authors/VA016117/

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "stdafx.h"
#include "Classes.h"
#include "..\common\header\plugin.h"
#include "..\common\handle\TPIHandle.h"
#include "interface.h"
#include "frontend.h"
#include "functions.h"
#include "resource.h"

//******************************************************************************
//    C^[tFCX (IDropSource)
//******************************************************************************

HRESULT __stdcall CDropSource::QueryInterface(const IID & iid, void * * ppv)
{
	HRESULT hr;

	if (iid == IID_IDropSource || iid == IID_IUnknown)
	{
		hr = S_OK;
		* ppv = (void *) this;
		AddRef();
	}
	else
	{
		hr = E_NOINTERFACE;
		* ppv = 0;
	}

	return hr;
}

ULONG __stdcall CDropSource::AddRef()
{
	::InterlockedIncrement(& _RefCount);
	return (unsigned) _RefCount;
}

ULONG __stdcall CDropSource::Release()
{
	if (::InterlockedDecrement(& _RefCount) == 0)
	{
		delete this;
	}

	return (unsigned) _RefCount;
}

HRESULT __stdcall CDropSource::QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState)
{
	if (fEscapePressed || (MK_LBUTTON | MK_RBUTTON) == (grfKeyState & (MK_LBUTTON | MK_RBUTTON)))
	{
		return DRAGDROP_S_CANCEL;
	}
	else if ((grfKeyState & (MK_LBUTTON | MK_RBUTTON)) == 0)
	{
		if (this->_dwEffect != DROPEFFECT_NONE)
		{
			// WJR[hB
			TPI_SWITCHES swInfo;
			memset(& swInfo, 0, sizeof(TPI_SWITCHES));
			swInfo.fStoreDirectoryPathes = TRUE;
			swInfo.pCustomSwitches = NULL;
			strncpy(swInfo.szDestinationDirectory, this->_szCopyFrom, min(sizeof(swInfo.szDestinationDirectory), strlen(this->_szCopyFrom) + 1) - 1);

			// _CAO쐬B
			HWND hDialog = ::CreateDialogParam(g_hInst, MAKEINTRESOURCE(IDD_PROCESS), this->_hParent, ProcessDialogProc, 0L);

			// IACe̐sB
			// 񏈗s邩Axɏsɂ͈꒷Z肻B
			char * pNextChar = ((char *) this->_lpDFiles) + sizeof(DROPFILES);
			while (pNextChar[0] != NULL)
			{
				if (::GetFileAttributes(pNextChar) != -1)
				{
					// WJɃt@C݂Ă΍폜B
					SHFILEOPSTRUCT shFileOp;
					memset(& shFileOp, 0, sizeof(SHFILEOPSTRUCT));
					shFileOp.wFunc  = FO_DELETE;
					shFileOp.pFrom  = pNextChar;
					shFileOp.fFlags = FOF_NOERRORUI | FOF_NOCONFIRMATION | FOF_SILENT;
					::SHFileOperation(& shFileOp);
				}

				// WJpXi[pX擾B
				pNextChar += strlen(this->_szCopyFrom);
				char * szTargetFile = pNextChar;
				pNextChar += strlen(pNextChar) + 1;

				// ꎞtH_ɑIt@CWJB
				if (this->_tpi->Command(TPI_COMMAND_EXTRACT, & swInfo, this->_szArchiveName, szTargetFile) != TPI_ERROR_SUCCESS)
				{
					continue;
				}
			}

			// _CAOjB
			::DestroyWindow(hDialog);
		}
		return DRAGDROP_S_DROP;
	}
	else
	{
		return S_OK;
	}
}

HRESULT __stdcall CDropSource::GiveFeedback(DWORD _dwEffect)
{
	this->_dwEffect = _dwEffect;
	return DRAGDROP_S_USEDEFAULTCURSORS;
}

//******************************************************************************
//    C^[tFCX (IDataObject)
//******************************************************************************

HRESULT __stdcall CDataObject::QueryInterface(const IID & iid, void * * ppv)
{
	HRESULT hr;

	if (iid == IID_IDataObject || iid == IID_IUnknown)
	{
		hr = S_OK;
		* ppv = (void *) this;
		AddRef();
	}
	else
	{
		hr = E_NOINTERFACE;
		* ppv = 0;
	}

	return hr;
}


ULONG __stdcall CDataObject::AddRef()
{
	::InterlockedIncrement(& _RefCount);
	return (unsigned) _RefCount;
}


ULONG __stdcall CDataObject::Release()
{
	if (::InterlockedDecrement(& _RefCount) == 0)
	{
		delete this;
	}

	return (unsigned) _RefCount;
}

HRESULT __stdcall CDataObject::GetData(FORMATETC * pFormatetc, STGMEDIUM * pmedium)
{
	if (pFormatetc == NULL || pmedium == NULL)
	{
		return E_INVALIDARG;
	}

	if (! (DVASPECT_CONTENT & pFormatetc->dwAspect))
	{
		return DV_E_DVASPECT;
	}

	for (int i = 0; i < _num; ++i)
	{
		if (_Objects[i].fmt.cfFormat == pFormatetc->cfFormat && (_Objects[i].fmt.tymed & pFormatetc->tymed) != 0)
		{
 			return (! STGMediumDup(pmedium, & _Objects[i].fmt, & _Objects[i].medium)) ? E_OUTOFMEMORY : S_OK;
		}
	}

	return DV_E_FORMATETC;
}

HRESULT __stdcall CDataObject::GetDataHere(FORMATETC *, STGMEDIUM *)
{
	return E_NOTIMPL;
}

HRESULT __stdcall CDataObject::QueryGetData(FORMATETC * pFormatetc)
{
	if (pFormatetc == NULL)
	{
		return E_INVALIDARG;
	}

	if (! (DVASPECT_CONTENT & pFormatetc->dwAspect))
	{
		return DV_E_DVASPECT;
	}

	for (int i = 0; i < _num; ++i)
	{
		if (_Objects[i].fmt.cfFormat == pFormatetc->cfFormat && (_Objects[i].fmt.tymed & pFormatetc->tymed) != 0)
		{
 			return S_OK;
		}
	}

	return DV_E_FORMATETC;
}

HRESULT __stdcall CDataObject::EnumFormatEtc(DWORD dwDirection, IEnumFORMATETC **ppenumFormatetc)
{
	if (ppenumFormatetc == NULL)
	{
		return E_INVALIDARG;
	}
	
	* ppenumFormatetc = NULL;
	switch (dwDirection)
	{
	case DATADIR_GET:
	{
		CEnumFORMATETC * pfmt = new CEnumFORMATETC;
		if (pfmt == NULL)
		{
			return E_OUTOFMEMORY;
		}

		if (! pfmt->allocate(_Objects.size()))
		{
			delete pfmt;
			return E_OUTOFMEMORY;
		}

		for (int i = 0; i < _num; ++i)
		{
			pfmt->SetFormat(& _Objects[i].fmt);
		}

		* ppenumFormatetc = pfmt;
		break;
	}
	default:
		return E_NOTIMPL;
	}

	return S_OK;
}

HRESULT __stdcall CDataObject::SetData(FORMATETC * pFormatetc, STGMEDIUM * pmedium, BOOL fRelease)
{
	if (pFormatetc == NULL || pmedium == NULL)
	{
		return E_INVALIDARG;
	}

	if (_num >= _Objects.size() || ! _Objects[_num].Set(pFormatetc, pmedium, fRelease))
	{
		return E_OUTOFMEMORY;
	}

	_num++;
	return S_OK;
}

HRESULT __stdcall CDataObject::GetCanonicalFormatEtc(FORMATETC *, FORMATETC *)
{
	return E_NOTIMPL;
}

HRESULT __stdcall CDataObject::DAdvise(FORMATETC *, DWORD, IAdviseSink *, DWORD *)
{
	return OLE_E_ADVISENOTSUPPORTED;
}

HRESULT __stdcall CDataObject::DUnadvise(DWORD)
{
	return OLE_E_ADVISENOTSUPPORTED;
}

HRESULT __stdcall CDataObject::EnumDAdvise(IEnumSTATDATA * *)
{
	return OLE_E_ADVISENOTSUPPORTED;
}

BOOL CDataObject::allocate(int num)
{
	return	_Objects.allocate(num);
}

//******************************************************************************
//    C^[tFCX (IEnumFORMATETC)
//******************************************************************************

HRESULT __stdcall CEnumFORMATETC::QueryInterface(const IID & iid, void * * ppv)
{
	HRESULT hr;

	if (iid == IID_IEnumFORMATETC || iid == IID_IUnknown)
	{
		hr = S_OK;
		* ppv = (void *) this;
		AddRef();
	}
	else
	{
		hr = E_NOINTERFACE;
		* ppv = 0;
	}

	return hr;
}

ULONG __stdcall CEnumFORMATETC::AddRef()
{
	::InterlockedIncrement(& _RefCount);
	return (unsigned) _RefCount;
}

ULONG __stdcall CEnumFORMATETC::Release()
{
	if (::InterlockedDecrement(& _RefCount) == 0)
	{
		delete this;
	}

	return (unsigned) _RefCount;
}

HRESULT __stdcall CEnumFORMATETC::Next(ULONG celt, FORMATETC * rgelt, ULONG * pceltFetched)
{
	ULONG n = celt;
	
	if (pceltFetched != NULL)
	{
		* pceltFetched = 0;
	}

	if (celt <= 0 || rgelt == NULL || _current >= _num)
	{
		return S_FALSE;
	}

	if (pceltFetched == NULL && celt != 1)
	{
		return S_FALSE;
	}

	while (_current < _num && n > 0)
	{
		* rgelt++ = _fmt[_current].fmt;
		++_current;
		--n;
	}
	if (pceltFetched != NULL)
	{
		* pceltFetched = celt - n;
	}

	return n == 0 ? S_OK : S_FALSE;
}

HRESULT __stdcall CEnumFORMATETC::Skip(ULONG celt)
{
	while (_current < _num && celt > 0)
	{
		++_current;
		--celt;
	}
	return celt == 0 ? S_OK : S_FALSE;
}

HRESULT __stdcall CEnumFORMATETC::Reset(void)
{
	_current = 0;
	return S_OK;
}

HRESULT __stdcall CEnumFORMATETC::Clone(IEnumFORMATETC * * ppenum)
{
	if (ppenum == NULL)
	{
		return E_POINTER;
	}

	CEnumFORMATETC * pfmt = new CEnumFORMATETC;
	if (pfmt == NULL)
	{
		return E_OUTOFMEMORY;
	}

	if (! pfmt->allocate(_num))
	{
		delete pfmt;
		return E_OUTOFMEMORY;
	}

	for (int i = 0; i < _num; ++i)
	{
		pfmt->SetFormat(& _fmt[i].fmt);
	}

	pfmt->_current = _current;
	* ppenum = pfmt;

	return S_OK;
}

BOOL CEnumFORMATETC::SetFormat(FORMATETC * fmt)
{
	FMTLIST::iterator obj;
	if (fmt == NULL)
	{
		return FALSE;
	}

	if (_num >= _fmt.size())
	{
		return E_OUTOFMEMORY;
	}

	_fmt[_num].fmt = * fmt;
	_num++;
	return	TRUE;
}

BOOL CEnumFORMATETC::allocate(int num)
{
	return _fmt.allocate(num);
}

//******************************************************************************
//    ֐`
//******************************************************************************

BOOL STGMediumDup(STGMEDIUM * pdest, const FORMATETC * pFormatetc, const STGMEDIUM * pmedium)
{
	HANDLE	hVoid;

	switch (pmedium->tymed)
	{
	case TYMED_HGLOBAL:
		hVoid = ::OleDuplicateData(pmedium->hGlobal, pFormatetc->cfFormat, NULL);
		pdest->hGlobal = (HGLOBAL) hVoid;
		break;
	case TYMED_GDI:
		hVoid = ::OleDuplicateData(pmedium->hBitmap, pFormatetc->cfFormat, NULL);
		pdest->hBitmap = (HBITMAP) hVoid;
		break;
	case TYMED_MFPICT:
		hVoid = ::OleDuplicateData(pmedium->hMetaFilePict, pFormatetc->cfFormat, NULL);
		pdest->hMetaFilePict = (HMETAFILEPICT) hVoid;
		break;
	case TYMED_ENHMF:
		hVoid = ::OleDuplicateData(pmedium->hEnhMetaFile, pFormatetc->cfFormat, NULL);
		pdest->hEnhMetaFile = (HENHMETAFILE) hVoid;
		break;
	case TYMED_FILE:
		hVoid = ::OleDuplicateData(pmedium->lpszFileName, pFormatetc->cfFormat, NULL);
		pdest->lpszFileName = (LPOLESTR) hVoid;
		break;
	case TYMED_NULL:
		hVoid = (HANDLE) 1;
		break;
	case TYMED_ISTREAM:
	case TYMED_ISTORAGE:
	default:
		hVoid = NULL;
		break;
	}

	if(hVoid == NULL)
	{
		return FALSE;
	}

	pdest->tymed = pmedium->tymed;
	pdest->pUnkForRelease = pmedium->pUnkForRelease;
	if (pmedium->pUnkForRelease != NULL)
	{
		pmedium->pUnkForRelease->AddRef();
	}
	return TRUE;
}
