// frontend
// $Id: interface.h,v 1.2 2006/06/04 05:30:45 sirakaba Exp $
// This code is diverted from http://hp.vector.co.jp/authors/VA016117/

//******************************************************************************
//    ev[g (CMyDArray)
//******************************************************************************

template<typename T>
class CMyDArray
{
	protected:
		typedef T node;

	public:
		class iterator
		{
			private:
				node * _ptr;
			public:
				iterator()
				{
				}

				iterator(node * ptr) : _ptr(ptr)
				{
				}
				
				iterator & operator++()
				{
					_ptr++;
					return (* this);
				}

				iterator operator++(int)
				{
					iterator _Tmp = * this;
					++(* this);
					return (_Tmp);
				}

				iterator & operator--()
				{
					_ptr--;
					return (*this);
				}

				iterator operator--(int)
				{
					iterator _Tmp = * this;
					--(* this);
					return (_Tmp);
				}

				iterator & operator+=(int _N)
				{
					_ptr += _N;
					return (*this);
				}

				iterator & operator-=(int _N)
				{
					return (*this += -_N);
				}
				iterator operator+(int _N) const
				{
					iterator _Tmp = * this;
					return (_Tmp += _N);
				}
				iterator operator-(int _N) const
				{
					iterator _Tmp = * this;
					return (_Tmp -= _N);
				}

				T & operator*()
				{
					return * _ptr;
				}

				T * operator->() const
				{
					return (_ptr);
				}

				bool operator==(const iterator & x) const
				{
					return (_ptr == x._ptr);
				}
				bool operator!=(const iterator & x) const
				{
					return (! (* this == x));
				}

				T * operator[](int _N) const
				{
					return (* (* this + _N));
				}

				node * node(void)
				{
					return _ptr;
				}
		};
	protected:
		node * _array;
		int _maxnum;
	public:
		CMyDArray()
		{
			_maxnum = 0;
			_array = NULL;
		}

		CMyDArray(int num)
		{
			_array = new T[num];
			_maxnum = (_array) num : 0;
		}

		~CMyDArray()
		{
			clear();
		}

		BOOL allocate(int num)
		{
			clear();
			_array = new T[num];

			if (_array == NULL)
			{
				return FALSE;
			}
			_maxnum = num;
			return TRUE;
		}

		int max_size(void)
		{
			return _maxnum;
		}

		int size(void)
		{
			return _maxnum;
		}

		iterator begin(void)
		{
			return iterator(_array);
		}

		iterator end(void)
		{
			return iterator(_array + _maxnum);
		}

		void clear()
		{
			delete[] _array;
			_array = NULL;
		}

		T & operator[](int i)
		{
			return (* (begin() + i));
		}
};

//******************************************************************************
//    ֐`
//******************************************************************************

BOOL STGMediumDup(STGMEDIUM * pdest, const FORMATETC * pFormatetc, const STGMEDIUM * pmedium);

//******************************************************************************
//    C^[tFCX (IDropSource)
//******************************************************************************

class CDropSource : public IDropSource
{
	private:
		LONG _RefCount;
		DWORD _dwEffect;
		TPIHandle * _tpi;
		const char * _szCopyFrom;
		const char * _szArchiveName;
		DROPFILES * _lpDFiles;
		HWND _hParent;

	public:
		CDropSource(TPIHandle * tpi, const char * szCopyFrom, const char * szArchiveName, DROPFILES * lpDFiles, HWND hParent) : _RefCount(1)
		{
			this->_tpi = tpi;
			this->_szCopyFrom = szCopyFrom;
			this->_szArchiveName = szArchiveName;
			this->_lpDFiles = lpDFiles;
			this->_hParent = hParent;
		};
		~CDropSource()
		{
		};

		// IUnknown
		virtual HRESULT __stdcall QueryInterface(const IID &, void * *);
		virtual ULONG __stdcall AddRef(void);
		virtual ULONG __stdcall Release(void);

		virtual HRESULT __stdcall QueryContinueDrag(BOOL, DWORD);
		virtual HRESULT __stdcall GiveFeedback(DWORD);
};

//******************************************************************************
//    C^[tFCX (IDataObject)
//******************************************************************************

class CDataObject : public IDataObject
{
	public:
		CDataObject() : _RefCount(1)
		{
			_num = 0;
		};
		~CDataObject()
		{
		};

		// IUnknown
		virtual HRESULT __stdcall QueryInterface(const IID &, void * *);
		virtual ULONG __stdcall AddRef(void);
		virtual ULONG __stdcall Release(void);

		virtual HRESULT __stdcall GetData(FORMATETC *, STGMEDIUM *);
		virtual HRESULT __stdcall GetDataHere(FORMATETC *, STGMEDIUM *);
		virtual HRESULT __stdcall QueryGetData(FORMATETC *);
		virtual HRESULT __stdcall GetCanonicalFormatEtc(FORMATETC *, FORMATETC *);
		virtual HRESULT __stdcall SetData(FORMATETC *, STGMEDIUM *, BOOL);
		virtual HRESULT __stdcall EnumFormatEtc(DWORD, IEnumFORMATETC * *);
		virtual HRESULT __stdcall DAdvise(FORMATETC *, DWORD, IAdviseSink *, DWORD *);
		virtual HRESULT __stdcall DUnadvise(DWORD);
		virtual HRESULT __stdcall EnumDAdvise(IEnumSTATDATA * *);

		BOOL allocate(int);

	protected:
		class CObject
		{
			public:
				FORMATETC fmt;
				STGMEDIUM medium;

				CObject()
				{
					medium.tymed = TYMED_NULL;
				}

				~CObject()
				{
					if (medium.tymed != TYMED_NULL)
					{
						::ReleaseStgMedium(& medium);
					}
				}

				BOOL Set(FORMATETC * pf, STGMEDIUM * pm, BOOL fRelease)
				{
					fmt = * pf;
					if (fRelease)
					{
						medium = * pm;
						return TRUE;
					}
					else
					{
						return STGMediumDup(& medium, pf, pm);
					}
				}
		};

		typedef CMyDArray<CObject> OBJLIST;
		LONG _RefCount;
		OBJLIST _Objects;
		int _num;
};

//******************************************************************************
//    C^[tFCX (IEnumFORMATETC)
//******************************************************************************

class CEnumFORMATETC : public IEnumFORMATETC
{
	friend class CEnumFORMATETC;
	public:
		CEnumFORMATETC() : _RefCount(1)
		{
			_current = 0;
			_num = 0;
		};
		~CEnumFORMATETC()
		{
		};

		// IUnknown
		virtual HRESULT __stdcall QueryInterface(const IID &, void * *);
		virtual ULONG __stdcall AddRef(void);
		virtual ULONG __stdcall Release(void);

		virtual HRESULT __stdcall Next(ULONG, FORMATETC *, ULONG *);
		virtual HRESULT __stdcall Skip(ULONG);
		virtual HRESULT __stdcall Reset(void);
		virtual HRESULT __stdcall Clone(IEnumFORMATETC * *);

		BOOL allocate(int);
		BOOL SetFormat(FORMATETC *);
	private:
		LONG _RefCount;
	protected:
		class CData
		{
			public:
				FORMATETC	fmt;
		};
		typedef	CMyDArray<CData> FMTLIST;
		FMTLIST _fmt;
		int _current, _num;
};
