/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: functions.h,v 1.4 2006/07/16 06:18:57 sirakaba Exp $
*******************************************************************************/

#include "frontend-wx.h"

#include "dlg_make.h"
#include "dlg_extract.h"
#include "frm_main.h"

#include <wx/dirdlg.h>

//******************************************************************************
// ExtractDialog
//******************************************************************************

ExtractDialog::ExtractDialog(): wxDialog()
{
}

//******************************************************************************
// Event Table.
//******************************************************************************

BEGIN_EVENT_TABLE(ExtractDialog, wxDialog)
	EVT_INIT_DIALOG(                 ExtractDialog::OnInit)
	EVT_BUTTON(XRCID("btnDefault"),  ExtractDialog::OnBtnDefault)
	EVT_BUTTON(XRCID("btnDesktop"),  ExtractDialog::OnBtnDesktop)
	EVT_BUTTON(XRCID("btnCurrent"),  ExtractDialog::OnBtnCurrent)
	EVT_BUTTON(XRCID("btnBrowse"),   ExtractDialog::OnBtnBrowse)
	EVT_BUTTON(XRCID("btnOK"),       ExtractDialog::OnBtnOK)
	EVT_BUTTON(XRCID("btnCancel"),   ExtractDialog::OnBtnCancel)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void ExtractDialog::OnInit(wxInitDialogEvent&)
{
	// XRCƌтB
	this->combo_box_1       = XRCCTRL(* this, "combo_box_1",  wxComboBox);
	this->cbOpenAfter       = XRCCTRL(* this, "cbOpenAfter",  wxCheckBox);
	this->cbIgnorePath      = XRCCTRL(* this, "cbIgnorePath", wxCheckBox);
	this->cbExitAfter       = XRCCTRL(* this, "cbExitAfter",  wxCheckBox);

	// lݒB
	this->combo_box_1->SetValue(((MainFrame *) this->GetParent())->statusbar->GetStatusText(5).BeforeLast('/'));
	::wxXmlResource::Get()->Unload(wxT("../share/frontend/xrc/dlg_extract.xrc"));
}

void ExtractDialog::OnBtnDefault(wxCommandEvent&)
{
}

void ExtractDialog::OnBtnDesktop(wxCommandEvent&)
{
	wxStandardPaths p;
	this->combo_box_1->SetValue(p.GetDocumentsDir().BeforeLast('\\').Append(wxT("\\Desktop")));
}

void ExtractDialog::OnBtnCurrent(wxCommandEvent&)
{
	this->combo_box_1->SetValue(((MainFrame *) this->GetParent())->statusbar->GetStatusText(5).BeforeLast('/'));
}

void ExtractDialog::OnBtnBrowse(wxCommandEvent&)
{
	wxDirDialog dd(this, wxDirSelectorPromptStr, this->combo_box_1->GetValue());
	if (dd.ShowModal() == wxID_OK)
	{
		wxString s = dd.GetPath();
		s.Replace(wxT("\\"), wxT("/"));
		this->combo_box_1->SetValue(s);
	}
}

void ExtractDialog::OnBtnOK(wxCommandEvent&)
{
	this->EndModal(wxID_OK);
}

void ExtractDialog::OnBtnCancel(wxCommandEvent&)
{
	this->EndModal(wxID_CANCEL);
}
