/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: frontend.cpp,v 1.36 2006/09/17 13:03:17 sirakaba Exp $
*******************************************************************************/

#include "frontend-wx.h"

#include "frm_main.h"
#include "cls_filedroptarget.h"
#include "dlg_make.h"
#include "dlg_extract.h"
#include "dlg_process.h"
#include "functions.h"

#include <wx/imaglist.h>
#include <wx/fileconf.h>
#include <wx/dynarray.h>
#include <wx/arrstr.h>
#include <wx/arrimpl.cpp>

WX_DEFINE_OBJARRAY(ArrayTPI_FILEINFO);

#define SetMenuToolState(id, state) this->toolbar->EnableTool(XRCID(id), state); this->menubar->Enable(XRCID(id), state)

//******************************************************************************
//    O[oϐ
//******************************************************************************

wxImageList g_hIconT(16, 16), g_hIconLL(32, 32), g_hIconLS(16, 16);

//******************************************************************************
// MainFrame
//******************************************************************************

MainFrame::MainFrame(): wxFrame()
{
}

MainFrame::~MainFrame()
{
	wxCommandEvent e;
	this->OnArcClose(e);

	// ݒL^B
	wxFileConfig fc(wxEmptyString, wxEmptyString, ::wxGetCwd() + wxT("/frontend.conf"), wxEmptyString, wxCONFIG_USE_LOCAL_FILE);
	int a, b;
	this->GetSize(& a, & b);
	fc.Write(wxT("Window-Width"), a);
	fc.Write(wxT("Window-Height"), b);
	this->GetPosition(& a, & b);
	fc.Write(wxT("Window-X"), a);
	fc.Write(wxT("Window-Y"), b);
	fc.Write(wxT("Splitter-Pos"), this->window_splitter->GetSashPosition());
	fc.Write(wxT("ListView-IconMode"), this->menubar->IsChecked(XRCID("Exe_View_Icons")));
	fc.Write(wxT("ListView-SortingColumn"), this->nSortingColumn);

	this->Close(true);
}

//******************************************************************************
// Event Table.
//******************************************************************************

BEGIN_EVENT_TABLE(MainFrame, wxFrame)
	EVT_INIT_DIALOG(      MainFrame::OnInit)
	// Menu
	EVT_MENU(XRCID("Arc_Create"),  MainFrame::OnArcCreate)
	EVT_MENU(XRCID("Arc_Open"),    MainFrame::OnArcOpen)
	EVT_MENU(XRCID("Arc_Close"),   MainFrame::OnArcClose)
	EVT_MENU(XRCID("Arc_Add"),     MainFrame::OnArcAdd)
	EVT_MENU(XRCID("Arc_SFX"),     MainFrame::OnArcSFX)
	EVT_MENU(XRCID("Arc_UnSFX"),   MainFrame::OnArcUnSFX)
	EVT_MENU(XRCID("Exe_Exit"),    MainFrame::OnExit)
	EVT_MENU(XRCID("Arc_Extract"), MainFrame::OnArcExtract)
	EVT_MENU(XRCID("Arc_Delete"),  MainFrame::OnArcDelete)
	EVT_MENU(XRCID("Arc_Test"),    MainFrame::OnArcTest)
	EVT_MENU(XRCID("Arc_Repair"),  MainFrame::OnArcRepair)
	EVT_MENU(XRCID("Exe_View_Icons"),  MainFrame::OnViewMode)
	EVT_MENU(XRCID("Exe_View_Details"),MainFrame::OnViewMode)
	EVT_MENU(XRCID("Exe_View_SelectAll"),MainFrame::OnSelectAll)
	// TreeView
	EVT_TREE_SEL_CHANGED(XRCID("TreeView"), MainFrame::OnTreeChanged)
	// ListView
	EVT_LIST_COL_CLICK(XRCID("ListView"), MainFrame::OnListColClick)
	EVT_LIST_ITEM_ACTIVATED(XRCID("ListView"), MainFrame::OnListItemDClick)
	EVT_LIST_BEGIN_DRAG(XRCID("ListView"), MainFrame::OnListBeginDrag)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void MainFrame::OnInit(wxInitDialogEvent&)
{
	// XRCƌтB
	this->menubar    = this->GetMenuBar();
	this->toolbar    = this->GetToolBar();
	this->statusbar = XRCCTRL(* this, "statusbar", wxStatusBar);
	this->tree_ctrl = XRCCTRL(* this, "TreeView", wxTreeCtrl);
	this->list_ctrl = XRCCTRL(* this, "ListView", wxListCtrl);
	this->window_splitter = XRCCTRL(* this, "window_splitter", wxSplitterWindow);

	// ݒǂݍ݁B
	wxFileConfig fc(wxEmptyString, wxEmptyString, ::wxGetCwd() + wxT("/frontend.conf"), wxEmptyString, wxCONFIG_USE_LOCAL_FILE);
	this->SetSize(fc.Read(wxT("Window-X"), 0l), fc.Read(wxT("Window-Y"), 0l), fc.Read(wxT("Window-Width"), 800), fc.Read(wxT("Window-Height"), 400));

	// lݒB
	{
		wxIcon icon;
		icon.CopyFromBitmap(wxBitmap(wxT("../share/frontend/ico/app.png"), wxBITMAP_TYPE_ANY));
		this->SetIcon(icon);
	}

	wxCommandEvent e;
	e.SetId(fc.Read(wxT("ListView-IconMode"), 0l) ? XRCID("Exe_View_Icons") : XRCID("Exe_View_Details"));
	this->OnArcClose(e);
	this->OnViewMode(e);
	this->window_splitter->SetSashPosition(fc.Read(wxT("Splitter-Pos"), 200));
	this->list_ctrl->InsertColumn(0, wxT("Filename"),      wxLIST_FORMAT_LEFT,  140);
	this->list_ctrl->InsertColumn(1, wxT("Unpacked"),      wxLIST_FORMAT_RIGHT,  80);
	this->list_ctrl->InsertColumn(2, wxT("Packed"),        wxLIST_FORMAT_RIGHT,  80);
	this->list_ctrl->InsertColumn(3, wxT("Ratio"),         wxLIST_FORMAT_RIGHT,  50);
	this->list_ctrl->InsertColumn(4, wxT("Method"),        wxLIST_FORMAT_LEFT,   60);
	this->list_ctrl->InsertColumn(5, wxT("Attr"),          wxLIST_FORMAT_LEFT,   50);
	this->list_ctrl->InsertColumn(6, wxT("Last modified"), wxLIST_FORMAT_RIGHT, 140);
	this->list_ctrl->InsertColumn(7, wxT("Path"),          wxLIST_FORMAT_LEFT,  100);
	this->list_ctrl->InsertColumn(8, wxT("Type"),          wxLIST_FORMAT_LEFT,  100);
	this->list_ctrl->InsertColumn(9, wxT("No."),           wxLIST_FORMAT_LEFT,   35);
	this->nSortingColumn = fc.Read(wxT("ListView-SortingColumn"), 9);

	this->list_ctrl->SetDropTarget(new myFileDropTarget(this));

	int nStatusBarParts[] = {40, 60, 120, 120, 90, 1000};
	this->statusbar->SetFieldsCount(6, nStatusBarParts);

	// R}hCǂݍ݁B
	this->cmdLine.SetSwitchChars(wxT("-"));
	this->cmdLine.AddSwitch(wxT("x"), wxEmptyString, wxT("(command) Extract filenames in archive."));
	this->cmdLine.AddSwitch(wxT("l"), wxEmptyString, wxT("(command) List archive(default)."));
	this->cmdLine.AddSwitch(wxT("r"), wxEmptyString, wxT("Use stored pathes(recommend)."));
	this->cmdLine.AddParam(wxT("archive"),   wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL);
	this->cmdLine.AddParam(wxT("filenames"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL | wxCMD_LINE_PARAM_MULTIPLE);
	if (this->cmdLine.Parse() == 0)
	{
		if (this->cmdLine.GetParamCount() == 0)
		{
			return;
		}

		if (this->cmdLine.Found(wxT("x")))
		{
			// ɂWJB
		}
		else
		{
			// ɂJB
			wxString archive = this->cmdLine.GetParam(0);
			if (! ::wxIsAbsolutePath(archive))
			{
				archive = this->szCurrentPath + archive;
			}
			this->LoadArc(archive);
		}
	}
}

// MenuBar

void MainFrame::OnExit(wxCommandEvent&)
{
	this->Close(true);
}

void MainFrame::OnArcCreate(wxCommandEvent&)
{
	// Ώۂ̃t@CIB
	wxArrayString files;
	wxFileDialog fdDlg(this, wxT("Choose files to compress"), wxEmptyString, wxEmptyString, wxFileSelectorDefaultWildcardStr, wxFD_OPEN | wxFD_FILE_MUST_EXIST | wxFD_MULTIPLE);
	if (fdDlg.ShowModal() == wxID_CANCEL)
	{
		return;
	}
	fdDlg.GetFilenames(files);
	for (size_t i = 0 ; i < files.GetCount(); i++)
	{
		files[i].Replace(wxT("\\"), wxT("/"));
	}

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.szDestinationDirectory = fdDlg.GetDirectory().Append('/');
	swInfo.pCustomSwitches = NULL;
	swInfo.szDestinationDirectory.Replace(wxT("\\"), wxT("/"));
	this->statusbar->SetStatusText(swInfo.szDestinationDirectory, 5);

	// 쐬_CAOݒB
	MakeDialog mkDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_make.xrc"));
	::wxXmlResource::Get()->LoadDialog(& mkDlg, this, wxT("dlg_make"));	
	mkDlg.InitDialog();
	mkDlg.cbDir->SetValue(swInfo.szDestinationDirectory);

	// ɖ̓t@C̊gqOA̓fBNgB
	wxString szFileName;
	if (files.GetCount() == 1)
	{
		wxFileName fn(files[0]);
		szFileName = fn.GetName();
	}
	else
	{
		szFileName = swInfo.szDestinationDirectory.AfterLast('/');
	}
	mkDlg.cbFileName->SetValue(szFileName);

	// _CAO\B
	if (mkDlg.ShowModal() == wxID_CANCEL)
	{
		this->statusbar->SetStatusText(wxEmptyString, 5);
		return;
	}
	this->statusbar->SetStatusText(wxEmptyString, 5);

	// eݒB
	swInfo.fStoreDirectoryPathes = ! mkDlg.cbIgnorePath->IsChecked();
	swInfo.fMakeSFX = mkDlg.cbMakeSFX->IsChecked();

	// TPIǂݍ݁B
	int nSelected = mkDlg.choice->GetSelection();
	szFileName = mkDlg.cbDir->GetValue().Append('/') + mkDlg.cbFileName->GetValue() + (swInfo.fMakeSFX ? wxT(".exe") : mkDlg.defext[nSelected]);
	if (! tpi.InitLibrary(mkDlg.libname[nSelected], szFileName, nSelected))
	{
		::wxMessageBox(wxT("Fault: InitLibrary()!"));
		return;
	}

	// sB
	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	if (this->ErrorCheck(tpi.Command(TPI_COMMAND_ADD, & swInfo, szFileName, files)) != TPI_ERROR_SUCCESS)
	{
		procDlg.Show(false);
		return;
	}
	tpi.FreeLibrary();

	if (mkDlg.cbOpenAfter->IsChecked())
	{
		// WJJB
#ifdef __WINDOWS__
		swInfo.szDestinationDirectory.Replace(wxT("/"), wxT("\\"));
		::wxExecute(wxT("explorer ") + swInfo.szDestinationDirectory);
#endif
	}

	if (mkDlg.cbExitAfter->IsChecked())
	{
		// IB
		this->Close(true);
	}

	// IȂꍇ͏ɂJB
	this->LoadArc(szFileName);
}

void MainFrame::OnArcOpen(wxCommandEvent&)
{
	// ɂIB
	this->LoadArc(::wxFileSelector(wxT("Choose the file to open")));
}

void MainFrame::OnArcClose(wxCommandEvent&)
{
	// c[r[EXgr[ݒB
	this->tree_ctrl->DeleteAllItems();
	this->list_ctrl->DeleteAllItems();

	// c[o[Ej[o[ݒB
	SetMenuToolState("Arc_Create",  true);
	SetMenuToolState("Arc_Open",    true);
	SetMenuToolState("Arc_Close",   false);
	SetMenuToolState("Arc_Add",     false);
	SetMenuToolState("Arc_SFX",     false);
	SetMenuToolState("Arc_UnSFX",   false);
	SetMenuToolState("Arc_Extract", false);
	SetMenuToolState("Arc_Delete",  false);
	SetMenuToolState("Arc_Test",    false);
	SetMenuToolState("Arc_Repair",  false);

	for (int i = 0; i < this->statusbar->GetFieldsCount(); i++)
	{
		this->statusbar->SetStatusText(wxEmptyString, i);
	}
	this->fileinfo.Clear();
	g_hIconT.RemoveAll();
	g_hIconLL.RemoveAll();
	g_hIconLS.RemoveAll();
	this->tpi.FreeLibrary();
}

void MainFrame::OnArcAdd(wxCommandEvent&)
{
}

void MainFrame::OnArcSFX(wxCommandEvent&)
{
	// ۑq˂B
	wxFileName fnArchive(this->statusbar->GetStatusText(5));
	wxString szSFXName = fnArchive.GetName() + wxT(".exe");
	szSFXName = ::wxFileSelector(wxT("Save as SFX"), fnArchive.GetPath(wxPATH_GET_VOLUME).c_str(), szSFXName.c_str(), wxT(".exe"), wxT("*.*"), wxFD_SAVE | wxFD_OVERWRITE_PROMPT, this);
	if (szSFXName.IsEmpty())
	{
		return;
	}

	wxArrayString files;
	files.Add(szSFXName);

	TPI_SWITCHES swInfo;
	wxChar cSep = fnArchive.GetPathSeparator();
	swInfo.fMakeSFX = true;
	swInfo.szDestinationDirectory = szSFXName.BeforeLast(cSep) + cSep;

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_SFX, & swInfo, fnArchive.GetFullPath(), files));
	procDlg.Show(false);
}

void MainFrame::OnArcUnSFX(wxCommandEvent&)
{
	// ۑq˂B
	wxFileName fnArchive(this->statusbar->GetStatusText(5));
	wxString szTargetName = fnArchive.GetName();
	szTargetName = ::wxFileSelector(wxT("Save as normal archive"), fnArchive.GetPath(wxPATH_GET_VOLUME).c_str(), szTargetName.c_str(), wxT(""), wxT("*.*"), wxFD_SAVE | wxFD_OVERWRITE_PROMPT, this);
	if (szTargetName.IsEmpty())
	{
		return;
	}

	wxArrayString files;
	files.Add(szTargetName);

	TPI_SWITCHES swInfo;
	wxChar cSep = fnArchive.GetPathSeparator();
	swInfo.fMakeSFX = true;
	swInfo.szDestinationDirectory = szTargetName.BeforeLast(cSep) + cSep;

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_UNSFX, & swInfo, fnArchive.GetFullPath(), files));
	procDlg.Show(false);
}

void MainFrame::OnArcExtract(wxCommandEvent&)
{
	// WJ_CAO쐬B
	ExtractDialog extDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_extract.xrc"));
	::wxXmlResource::Get()->LoadDialog(& extDlg, this, wxT("dlg_extract"));	
	if (extDlg.ShowModal() == wxID_CANCEL)
	{
		return;
	}

	// eݒB
	wxArrayString files = MakeTargetFileList(this);
	TPI_SWITCHES swInfo;
	swInfo.fStoreDirectoryPathes = ! extDlg.cbIgnorePath->IsChecked();
	swInfo.szDestinationDirectory = extDlg.combo_box_1->GetValue();
	swInfo.pCustomSwitches = NULL;

	// KvȂ珑ɖŃfBNg쐬B
	bool fMakeDirByName = XRCCTRL(extDlg, "rbMakeDirByName", wxRadioButton)->GetValue();
	if (XRCCTRL(extDlg, "rbMakeDirIfNeeded", wxRadioButton)->GetValue())
	{
		// [gɃfBNgƃt@C킹2ȏ゠ƂAfBNg쐬B
		switch (this->tree_ctrl->GetChildrenCount(this->tree_ctrl->GetLastChild(this->tree_ctrl->GetRootItem()), false))
		{
		case 0:
		{
			// fBNgȂ̂ŁA[gɃt@C2ȏ゠邩ǂ𔻒B
			bool fFlag = false;
			for (size_t i = 0; i < this->fileinfo.GetCount(); i++)
			{
				if (this->fileinfo[i].szFileName.Find('/') == wxNOT_FOUND)
				{
					// "/"ȂA܂t@C̓[gɂB
					if (fFlag)
					{
						fMakeDirByName = true;
						break;
					}

					fFlag = true;
				}
			}
			break;
		}
		case 1:
			// fBNg1Ȃ̂ŁA[gɃt@CȂǂ𔻒B
			for (size_t i = 0; i < this->fileinfo.GetCount(); i++)
			{
				if (this->fileinfo[i].szFileName.Find('/') == wxNOT_FOUND)
				{
					fMakeDirByName = true;
					break;
				}
			}
			break;
		default:
			// fBNg2ȏ゠̂ŁAIɓWJfBNg쐬B
			fMakeDirByName = true;
			break;
		}
	}

	swInfo.szDestinationDirectory += '/';
	if (fMakeDirByName)
	{
		swInfo.szDestinationDirectory = MakeDirPath(swInfo.szDestinationDirectory + this->statusbar->GetStatusText(5).AfterLast('/'));
		if (swInfo.szDestinationDirectory.IsEmpty())
		{
			::wxMessageBox(wxT("Fault: Unable to make the destination directory!"));
			return;
		}
	}

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, this->statusbar->GetStatusText(5), files));
	procDlg.Show(false);

	if (extDlg.cbOpenAfter->IsChecked())
	{
		// WJJB
#ifdef __WINDOWS__
		swInfo.szDestinationDirectory.Replace(wxT("/"), wxT("\\"));
		::wxExecute(wxT("explorer ") + swInfo.szDestinationDirectory);
#endif
	}

	if (extDlg.cbExitAfter->IsChecked())
	{
		// IB
		this->Close(true);
	}
}

void MainFrame::OnArcDelete(wxCommandEvent&)
{
	// St@C폜͊댯ł͂ȂƁB
	if (this->list_ctrl->GetSelectedItemCount() == 0)
	{
		return;
	}

	if (::wxMessageBox(wxT("Are you sure to delete selected files?"), wxMessageBoxCaptionStr, wxYES_NO | wxICON_EXCLAMATION, this) == wxNO)
	{
		return;
	}

	// eݒB
	TPI_SWITCHES swInfo;
	wxString szArcName = this->statusbar->GetStatusText(5);
	wxArrayString files = MakeTargetFileList(this);

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_DELETE, & swInfo, szArcName, files));
	procDlg.Show(false);	

	// ɂēǂݍ݂B
	wxCommandEvent e;
	this->OnArcClose(e);
	this->LoadArc(szArcName);
}

void MainFrame::OnArcTest(wxCommandEvent&)
{
	// eݒB
	wxArrayString files = MakeTargetFileList(this);
	TPI_SWITCHES swInfo;

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	if (this->ErrorCheck(this->tpi.Command(TPI_COMMAND_TEST, & swInfo, this->statusbar->GetStatusText(5), files)) == TPI_ERROR_SUCCESS)
	{
		::wxMessageBox(wxT("This is a correct archive."), wxT("Frontend"), wxOK | wxCENTRE | wxICON_INFORMATION, this);
	}
	procDlg.Show(false);
}

void MainFrame::OnArcRepair(wxCommandEvent&)
{
	// eݒB
	wxArrayString files = MakeTargetFileList(this);
	TPI_SWITCHES swInfo;

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_REPAIR, & swInfo, this->statusbar->GetStatusText(5), files));
	procDlg.Show(false);	
}

void MainFrame::OnViewMode(wxCommandEvent & e)
{
	int n = e.GetId();
	this->menubar->Check(n, true);
	this->list_ctrl->SetSingleStyle(wxLC_REPORT, n == XRCID("Exe_View_Details"));
	this->list_ctrl->SetSingleStyle(wxLC_ICON,   n == XRCID("Exe_View_Icons"));
}

void MainFrame::OnSelectAll(wxCommandEvent & WXUNUSED(event))
{
	for (int i = 0; i < this->list_ctrl->GetItemCount(); i++)
	{
		this->list_ctrl->SetItemState(i, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
	}
}

// TreeView

void MainFrame::OnTreeChanged(wxTreeEvent& e)
{
	// c[r[pX擾B
	wxString szNodePath = TreeView_GetItemPath(this->tree_ctrl, e.GetItem());
	// Xgr[B
	this->list_ctrl->DeleteAllItems();

	// ACRݒB
	this->list_ctrl->SetImageList(& g_hIconLL, wxIMAGE_LIST_NORMAL);
	this->list_ctrl->SetImageList(& g_hIconLS, wxIMAGE_LIST_SMALL);

	// tH_ǉB
	// TODO : \[g@\ȂB
	int nShow = 0;
/*
	wxTreeItemIdValue idv;
	wxTreeItemId idChild = this->tree_ctrl->GetFirstChild(e.GetItem(), idv);
	if (idChild.IsOk())
	{
		wxIcon icon;
		icon.CopyFromBitmap(wxBitmap(wxT("../share/frontend/ico/folder_closed.png"), wxBITMAP_TYPE_ANY));
		int nId = g_hIconLL.Add(icon);
		g_hIconLS.Add(icon);
		do
		{
			// TODO : fBNgȍ𔽉fB
			this->list_ctrl->InsertItem(nShow, this->tree_ctrl->GetItemText(idChild), nId);
			this->list_ctrl->SetItem(nShow, 1, wxT("0"));
			this->list_ctrl->SetItem(nShow, 2, wxT("0"));
			this->list_ctrl->SetItem(nShow, 3, wxT("0.0%"));
			this->list_ctrl->SetItem(nShow, 4, wxEmptyString);
			this->list_ctrl->SetItem(nShow, 5, wxT("d--w-"));
			this->list_ctrl->SetItem(nShow, 6, wxT("0000/00/00 00:00:00"));
			this->list_ctrl->SetItem(nShow, 7, TreeView_GetItemPath(this->tree_ctrl, idChild).BeforeLast('\\'));
			this->list_ctrl->SetItem(nShow, 8, wxT("File Folder"));
			this->list_ctrl->SetItem(nShow, 9, wxT("-1"));
			this->list_ctrl->SetItemPtrData(nShow++, NULL);

			idChild = this->tree_ctrl->GetNextChild(e.GetItem(), idv);
		}
		while (idChild.IsOk());
	}
*/
	// zƔrApXvȂΏB
	for (size_t i = 0; i < this->fileinfo.GetCount(); i++)
	{
		wxFileName fn(this->fileinfo[i].szFileName);

		// pXrB
		if (szNodePath == wxT("*") || szNodePath == fn.GetPath(0))
		{
			// ڂtH_łȂ疳B
			if (fn.IsDir())
			{
				continue;
			}

			// ACR擾B
			int nId = -1;
			wxMimeTypesManager mimeFile;
			wxIconLocation ilFile;
			wxFileType * ftFile = mimeFile.GetFileTypeFromExtension(fn.GetExt());
			wxIcon icon;
			if (ftFile && ftFile->GetIcon(& ilFile))
			{
				if (ilFile.GetFileName() == wxT("%1") || ilFile.GetFileName() == wxT("\"%1\""))
				{
					icon.CopyFromBitmap(wxBitmap(wxT("../share/frontend/ico/exe.png"), wxBITMAP_TYPE_ANY));
				}
				else
				{
					wxIcon i(ilFile);
					icon = i;
				}
			}
			else
			{
				icon.CopyFromBitmap(wxBitmap(wxT("../share/frontend/ico/file.png"), wxBITMAP_TYPE_ANY));
			}
			nId = g_hIconLL.Add(icon);
			g_hIconLS.Add(icon);

			// Xgr[ɍڂǉB
			wxString szTemp;
			this->list_ctrl->InsertItem(nShow, fn.GetFullName(), nId);
			this->list_ctrl->SetItem(nShow, 1, this->fileinfo[i].llUnpackedSize.ToString());
			this->list_ctrl->SetItem(nShow, 2, this->fileinfo[i].llPackedSize.ToString());
			szTemp.Printf(wxT("%3.1f%%"), this->fileinfo[i].wCompressRatio / 10.0);
			this->list_ctrl->SetItem(nShow, 3, szTemp);
			this->list_ctrl->SetItem(nShow, 4, this->fileinfo[i].szMethod);
			szTemp = wxT("---w-");
			szTemp[0] = this->fileinfo[i].dwAttribute & TPI_ATTRIBUTE_DIRECTORY ? 'd' : 
			            this->fileinfo[i].dwAttribute & TPI_ATTRIBUTE_ARCHIVE   ? 'a' : '-';
			szTemp[1] = this->fileinfo[i].dwAttribute & TPI_ATTRIBUTE_SYSTEM    ? 's' : '-';
			szTemp[2] = this->fileinfo[i].dwAttribute & TPI_ATTRIBUTE_HIDDEN    ? 'h' : '-';
			szTemp[3] = this->fileinfo[i].dwAttribute & TPI_ATTRIBUTE_READONLY  ? 'r' : 'w';
			szTemp[4] = this->fileinfo[i].dwAttribute & TPI_ATTRIBUTE_ENCRYPTED ? 'g' : '-';
			this->list_ctrl->SetItem(nShow, 5, szTemp);
			this->list_ctrl->SetItem(nShow, 6, this->fileinfo[i].tmModified.Format(wxT("%Y/%m/%d %H:%M:%S")));
			this->list_ctrl->SetItem(nShow, 7, fn.GetPath(0));
			szTemp = fn.GetExt();
			if (szTemp != wxEmptyString)
			{
				szTemp += wxT(" ");
			}
			szTemp += wxT("file");
			if (ftFile)
			{
				ftFile->GetDescription(& szTemp);
			}
			this->list_ctrl->SetItem(nShow, 8, szTemp);

			szTemp.Printf(wxT("%d"), i);
			this->list_ctrl->SetItem(nShow, 9, szTemp);
			this->list_ctrl->SetItemPtrData(nShow++, (wxUIntPtr) & this->fileinfo[i]);
		}
	}

	// \[gB
	this->list_ctrl->SortItems(ListViewCompareProc, this->nSortingColumn);
}

// ListView

void MainFrame::OnListColClick(wxListEvent& e)
{
	this->nSortingColumn = e.GetColumn();
	this->list_ctrl->SortItems(ListViewCompareProc, this->nSortingColumn);
}

void MainFrame::OnListItemDClick(wxListEvent&)
{
	// WJΏۂB
	wxArrayString files;
	for (int i = 0; i < this->list_ctrl->GetItemCount(); i++)
	{
		// Pt@ĈݑΉB
		if (this->list_ctrl->GetItemState(i, wxLIST_STATE_SELECTED) & wxLIST_STATE_SELECTED)
		{
			wxListItem item;
			item.SetId(i);
			item.SetColumn(9);
			item.SetMask(wxLIST_MASK_TEXT);
			this->list_ctrl->GetItem(item);
			long l = 0;
			item.GetText().ToLong(& l);
			files.Add(this->fileinfo[l].szFileName);
			break;
		}
	}

	// R}h擾B
	wxMimeTypesManager mimeFile;
	wxFileType * ftFile = mimeFile.GetFileTypeFromExtension(files[0].Find('.') == wxNOT_FOUND ? wxT("") : files[0].AfterLast('.').MakeUpper());
	if (! ftFile)
	{
		::wxMessageBox(wxT("Fault: Unable to get the file type!"));
		return;
	}

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.fStoreDirectoryPathes = false;
	swInfo.pCustomSwitches = NULL;
	swInfo.szDestinationDirectory = MakeDirPath(::wxGetCwd() + wxT("/tpi_tmp"));
	if (swInfo.szDestinationDirectory.IsEmpty())
	{
		::wxMessageBox(wxT("Fault: Unable to make the temporary directory!"));
		return;
	}

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, this->statusbar->GetStatusText(5), files));
	procDlg.Show(false);

	// R}hsB
	swInfo.szDestinationDirectory.Replace(wxT("/"), wxT("\\"));
	wxString s = swInfo.szDestinationDirectory + files[0].AfterLast('/');
	::wxExecute(ftFile->GetOpenCommand(s), wxEXEC_SYNC);

	// ꎞfBNg폜B
	::wxRemoveFile(s);
	::wxRmdir(swInfo.szDestinationDirectory.BeforeLast('\\'));
}

void MainFrame::OnListBeginDrag(wxListEvent&)
{
	if (this->list_ctrl->GetSelectedItemCount() == 0)
	{
		// ACeIhbO悤ƂꍇB
		return;
	}

	wxFileDataObject objFile;

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.fStoreDirectoryPathes = false;
	swInfo.pCustomSwitches = NULL;
	swInfo.szDestinationDirectory = MakeDirPath(::wxGetCwd() + wxT("/tpi_tmp"));
	if (swInfo.szDestinationDirectory.IsEmpty())
	{
		::wxMessageBox(wxT("Fault: Unable to make the temporary directory!"));
		return;
	}

	// WJΏۂB
	wxArrayString files;
	for (int i = 0; i < this->list_ctrl->GetItemCount() && files.GetCount() < (unsigned) this->list_ctrl->GetSelectedItemCount(); i++)
	{
		if (this->list_ctrl->GetItemState(i, wxLIST_STATE_SELECTED) & wxLIST_STATE_SELECTED)
		{
			wxListItem item;
			item.SetId(i);
			item.SetColumn(9);
			item.SetMask(wxLIST_MASK_TEXT);
			this->list_ctrl->GetItem(item);
			long l = 0;
			item.GetText().ToLong(& l);
			files.Add(this->fileinfo[l].szFileName);

			// XgɒǉB
			objFile.AddFile(swInfo.szDestinationDirectory + this->fileinfo[l].szFileName.AfterLast('/'));
		}
	}

	this->ErrorCheck(tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, this->statusbar->GetStatusText(5), files));

	wxDropSource dropSource;
	dropSource.SetData(objFile);
	if (dropSource.DoDragDrop() != wxDragMove)
	{
		// ꎞfBNg폜B
		wxArrayString szFileNames = objFile.GetFilenames();
		for (size_t i = 0; i < szFileNames.GetCount(); i++)
		{
			::wxRemoveFile(szFileNames[i]);
		}
		::wxRmdir(swInfo.szDestinationDirectory);
	}
}

// CxgnhȊOB

void MainFrame::LoadArc(wxString szFileName)
{
	if (szFileName.IsEmpty())
	{
		return;
	}
	szFileName.Replace(wxT("\\"), wxT("/"));

	// i_CAO\B
	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(wxT("../share/frontend/xrc/dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);

	// ŏ̃R[obN𑗐MB
	TPI_PROCESSINFO piInfo;
	piInfo.uMessage = TPI_MESSAGE_STATUS;
	piInfo.uStatus = 0x1000;
	piInfo.fiInfo.szFileName = szFileName;
	TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo);

	// TPIǂݍ݁B
	wxFileSystem fs;
	fs.ChangePathTo(wxT("lib/"), true);
	wxString szTPIName = fs.FindFirst(wxT("*" TPI_EXT), wxFILE);
	int nFileCount = -1;
	while (! szTPIName.IsEmpty())
	{
		// ΉmFB
		if (! tpi.InitLibrary(szTPIName, szFileName, 0) || ! tpi.CheckArchive(szFileName, & nFileCount) || nFileCount < 0)
		{
			tpi.FreeLibrary();
			szTPIName = fs.FindNext();
			continue;
		}
		break;
	}
	if (nFileCount == -1)
	{
		procDlg.Show(false);
		tpi.FreeLibrary();
		::wxMessageBox(wxT("Fault : No plug-in supporting this archive was found!"));
		return;
	}

	// t@CR[obNB
	piInfo.uStatus = 0x1001;
	piInfo.fiInfo.llUnpackedSize = nFileCount;
	TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo);

	// ɂJB
	void * hArc = NULL;
	if (tpi.OpenArchive(szFileName, & hArc) != TPI_ERROR_SUCCESS)
	{
		procDlg.Show(false);
		tpi.FreeLibrary();
		::wxMessageBox(wxT("Fault : OpenArchive()!"));
		return;
	}

	// 摜Xg쐬B
	this->tree_ctrl->SetImageList(& g_hIconT);
	this->tree_ctrl->AddRoot(wxEmptyString);

	// ɂ̃ACR擾AɃ[g쐬B
	wxFileName fn(szFileName);
	wxMimeTypesManager mimeArchive;
	wxIconLocation ilArchive;
	wxIcon icon;
	wxFileType * ftArchive = mimeArchive.GetFileTypeFromExtension(fn.GetExt());
	if (ftArchive && ftArchive->GetIcon(& ilArchive))
	{
		if (ilArchive.GetFileName() == wxT("%1"))
		{
			icon.CopyFromBitmap(wxBitmap(wxT("../share/frontend/ico/exe.png"), wxBITMAP_TYPE_ANY));
		}
		else
		{
			wxIcon i(ilArchive);
			icon = i;
		}
	}
	else
	{
		icon.CopyFromBitmap(wxBitmap(wxT("../share/frontend/ico/archive.png"), wxBITMAP_TYPE_ANY));
	}
	wxTreeItemId idRoot = this->tree_ctrl->GetRootItem();
	wxTreeItemId idArchive = this->tree_ctrl->InsertItem(idRoot, idRoot, fn.GetFullName(), g_hIconT.Add(icon), -1);

	// [gfBNg쐬B
	wxTreeItemId idArcRoot = this->tree_ctrl->InsertItem(idRoot, idArchive, wxT("-----"), g_hIconT.Add(wxBitmap(wxT("../share/frontend/ico/Folder_closed.png"), wxBITMAP_TYPE_ANY)), -1);

	// z̃TCYmہB
	this->fileinfo.Alloc(nFileCount);

	// t@C[hB
	TPI_FILEINFO fiInfo;
	if (tpi.GetFileInformation(hArc, & fiInfo, true) == TPI_ERROR_SUCCESS)
	{
		do
		{
			piInfo.uStatus = 0x1002;
			piInfo.fiInfo.szFileName = fiInfo.szFileName;
			piInfo.llProcessedSize = this->fileinfo.GetCount();
			TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo);

			// c[r[ɔfB
			TreeView_CheckNewerItem(this->tree_ctrl, idArcRoot, fiInfo.szFileName.BeforeLast('/'));

			// fBNg܂ނ̂ɂĂ͏B
			if (fiInfo.dwAttribute & TPI_ATTRIBUTE_DIRECTORY)
			{
				continue;
			}

			// ۑăJEgAbvB
			this->fileinfo.Add(fiInfo);
			piInfo.uStatus = 0x1003;
			TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo);
		}
		while (tpi.GetFileInformation(hArc, & fiInfo, false) == TPI_ERROR_SUCCESS);
		this->tree_ctrl->ExpandAll();
	}
	this->fileinfo.Shrink();

	// ɂ̏擾B
	TPI_ARCHIVEINFO aiInfo;
	if (tpi.GetArchiveInformation(hArc, & aiInfo) != TPI_ERROR_SUCCESS)
	{
		procDlg.Show(false);
		tpi.FreeLibrary();
		::wxMessageBox(wxT("Fault : GetArchiveInformation()!"));
		return;
	}

	wxString szStatusText;
	this->statusbar->SetStatusText(wxEmptyString, 0);
	szStatusText.Printf(wxT("%d file(s)"), nFileCount);
	this->statusbar->SetStatusText(szStatusText, 1);
	this->statusbar->SetStatusText(wxT("Unpacked: ") + aiInfo.llUnpackedSize.ToString() + wxT(" B"), 2);
	this->statusbar->SetStatusText(wxT("Packed: ")   + aiInfo.llPackedSize.ToString()   + wxT(" B"), 3);
	szStatusText.Printf(wxT("Ratio: %3.1f%%"), aiInfo.wCompressRatio / 10.0);
	this->statusbar->SetStatusText(szStatusText, 4);
	this->statusbar->SetStatusText(szFileName, 5);

	// ɂB
	if (tpi.CloseArchive(hArc) != TPI_ERROR_SUCCESS)
	{
		::wxMessageBox(wxT("Fault : CloseArchive()!"));
	}

	// R[obN֐ݒB
	if (tpi.SetCallbackProc(TPICallbackProc) != TPI_ERROR_SUCCESS)
	{
		::wxMessageBox(wxT("Fault : SetCallbackProc()!"));
	}

	// UIeݒB
	{
		// c[o[Ej[o[ݒB
		SetMenuToolState("Arc_Create",  false);
		SetMenuToolState("Arc_Open",    false);
		SetMenuToolState("Arc_Close",   true);
		SetMenuToolState("Arc_Add",     true);
		SetMenuToolState("Arc_SFX",     aiInfo.nSFXType == 0);
		SetMenuToolState("Arc_UnSFX",   aiInfo.nSFXType != 0);
		SetMenuToolState("Arc_Extract", true);
		SetMenuToolState("Arc_Delete",  true);
		SetMenuToolState("Arc_Test",    true);
		SetMenuToolState("Arc_Repair",  true);
	}

	procDlg.Show(false);
}

int MainFrame::ErrorCheck(int nErrorCode)
{
	wxString s;
	switch (nErrorCode)
	{
	case TPI_ERROR_SUCCESS:
		return TPI_ERROR_SUCCESS;
	case TPI_ERROR_D_UNSUPPORTED:
		s.Printf(wxT("Sorry, this functions is not supported yet."), nErrorCode);
		break;
	case TPI_ERROR_D_SKIPPED:
		s.Printf(wxT("This operation is canceled by the user."), nErrorCode);
		break;
	default:
		s.Printf(wxT("ErrorCode:%d"), nErrorCode);
	}
	::wxMessageBox(s, wxT("Frontend"), wxOK | wxCENTRE | wxICON_ERROR, this);
	return nErrorCode;
}
