// cuiWrapper
// $Id: calLibrary.cpp,v 1.13 2006/08/20 13:22:27 sirakaba Exp $

/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*******************************************************************************/


//******************************************************************************
//    Includes
//******************************************************************************

#include "../../common/header/plugin.h"
#include "../../common/header/plugin-extra.h"
#include <wx/file.h>
#include <wx/filename.h>
#include <wx/config.h>
#include <wx/wfstream.h>
#include <wx/stdpaths.h>
#include <wx/xml/xml.h>
#include <windows.h>
#include "cuiWrapper.h"

//******************************************************************************
//    Global varients
//******************************************************************************

struct g_LibInfo
{
	wxString szLibName;
	wxString szSuffix;
	unsigned int nLibIndex;
}	g_LibInfo;

TPI_PROC g_prProc;
wxString g_szAppPath;

//******************************************************************************
//    Entry
//******************************************************************************

#ifdef __LINUX__
void __attribute__((constructor)) Attach(void)
{
	wxStandardPaths p;
	g_szAppPath = wxPathOnly(p.GetExecutablePath());
}

void __attribute__((destructor)) Detach(void)
{
}
#else
BOOL __stdcall DllMain(HMODULE, DWORD fdwReason, void *)
{
	switch (fdwReason)
	{
	case DLL_PROCESS_ATTACH:
	{
		wxStandardPaths p;
		g_szAppPath = wxPathOnly(p.GetExecutablePath());
		break;
	}
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}
#endif

//******************************************************************************
//    Callback Wrapper
//******************************************************************************

BOOL __stdcall CallbackProc(HWND, unsigned int _uMsg, unsigned int _uState, void * _lpEis)
{
	return FALSE;
//	return g_prProc(TPI_NOTIFY_COMMON, & piInfo) != TPI_CALLBACK_CANCEL;
}

//******************************************************************************
//    Inside Functions
//******************************************************************************

int MakeCommandLine(int _uCommand, TPI_SWITCHES * _swInfo, wxString _szArcName, wxArrayString _szFiles, wxString & szCommandLineSend)
{
	// IniR}hC擾B
	wxString szPath, szCommandLine;
	// xml͊JnB
	wxXmlDocument config(g_szAppPath + wxT("/lib/cuiWrapper.xml"));
	// Cɐ擪̃Cȕ擾B
	wxXmlNode * xmlLibrary = config.GetRoot()->GetChildren();

	// KȈʒu܂ňړB
	for (unsigned int i = 0; i < g_LibInfo.nLibIndex && xmlLibrary != NULL; i++)
	{
		xmlLibrary = xmlLibrary->GetNext();
	}
	if (xmlLibrary->GetName() != wxT("library"))
	{
		// xml@G[B
		return TPI_ERROR_UNDEFINED;
	}

	if (! xmlLibrary->GetPropVal(
		_uCommand == TPI_COMMAND_ADD     ? wxT("add") :
		_uCommand == TPI_COMMAND_EXTRACT ? wxT("extract") : 
		_uCommand == TPI_COMMAND_DELETE  ? wxT("delete") : 
		_uCommand == TPI_COMMAND_UPDATE  ? wxT("update") : 
		_uCommand == TPI_COMMAND_TEST    ? wxT("test") : 
		_uCommand == TPI_COMMAND_REPAIR  ? wxT("repair") : 
		_uCommand == TPI_COMMAND_MOVE    ? wxT("move") : 
		_uCommand == TPI_COMMAND_SFX     ? wxT("sfx") : 
		_uCommand == TPI_COMMAND_UNSFX   ? wxT("unsfx") : wxEmptyString, & szCommandLine))
	{
		return TPI_ERROR_D_UNSUPPORTED;
	}

	// R}hCϐւB
	for (size_t i = 0; i < szCommandLine.Len(); i++)
	{
		if (szCommandLine[i] == '%')
		{
			// ϐ͊JnB
			switch (szCommandLine[++i])
			{
			case '-':
				// ꕶB
				szCommandLineSend += szCommandLine[++i];
				break;
			case '9':
				switch (szCommandLine[++i])
				{
				case '0':
				{
					// ɖB
					wxString s = _szArcName;
					s.Replace(wxT("/"), wxT("\\"));
					szCommandLineSend += s;
					break;
				}
				case '1':
				{
					// o͐B
					wxString s = _swInfo->szDestinationDirectory;
					s.Replace(wxT("/"), wxT("\\"));
					szCommandLineSend += s;
					break;
				}
				case '2':
					// X|Xt@CB
					szCommandLineSend += ::wxGetCwd() + wxT("\\__callib__listfile");
					break;
				case '3':
					// t@CXgB
					for (size_t j = 0; j < _szFiles.GetCount(); j++)
					{
						szCommandLineSend += wxT("\"") + _szFiles[j] + wxT("\" ");
					}
					break;
				}
				break;
			case 'a':
				switch (szCommandLine[++i])
				{
				case '0':
					// pXLɂ邩B
					if (szCommandLine[++i] == '{')
					{
						// ʁB
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != '|'; i++)
						{
							if (_swInfo->fStoreDirectoryPathes)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != '}'; i++)
						{
							if (! _swInfo->fStoreDirectoryPathes)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
					}
					else
					{
						// boollԋpB
						szCommandLineSend += _swInfo->fStoreDirectoryPathes ? '1' : '0';
						i--;
					}
					break;
				case '1':
					// SFX쐬邩B
					if (szCommandLine[++i] == '{')
					{
						// ʁB
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != '|'; i++)
						{
							if (_swInfo->fMakeSFX)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != '}'; i++)
						{
							if (! _swInfo->fMakeSFX)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
					}
					else
					{
						// boollԋpB
						szCommandLineSend += _swInfo->fMakeSFX ? '1' : '0';
						i--;
					}
					break;
				}
				break;
			}
		}
		else
		{
			szCommandLineSend += szCommandLine[i];
		}
	}
	return TPI_ERROR_SUCCESS;
}

//******************************************************************************
//    Functions
//******************************************************************************

#ifdef __cplusplus
extern "C"
{
#endif

int __stdcall GetPluginInformation
(
	unsigned int _uInfoId,
	wxULongLong _llSubOption,
	void * _pPtr
)
{
	// pXݒBTODO : 폜B
	wxStandardPaths p;
	g_szAppPath = wxPathOnly(p.GetExecutablePath());

	if (_pPtr == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	switch (LOWORD(_uInfoId))
	{
	case TPI_INFO_VERSION_MAJOR:
	case TPI_INFO_VERSION_MINOR:
		* (int *) _pPtr = 0;
		break;
	case TPI_INFO_VERSION_API:
		* (int *) _pPtr = 2;
		break;
	case TPI_INFO_SUPPORTED_TYPE:
	case TPI_INFO_SUPPORTED_SUFFIX:
	{
		// xml͊JnB
		wxXmlDocument config(g_szAppPath + wxT("/lib/cuiWrapper.xml"));
		// Cɐ擪̃Cȕ擾B
		wxXmlNode * xmlLibrary = config.GetRoot()->GetChildren();

		// KȈʒu܂ňړB
		for (unsigned int i = 0; i < _llSubOption && xmlLibrary != NULL; i++)
		{
			xmlLibrary = xmlLibrary->GetNext();
		}
		if (xmlLibrary == NULL || xmlLibrary->GetName() != wxT("library"))
		{
			// xml@G[B
			return TPI_ERROR_UNDEFINED;
		}

		* (wxString *) _pPtr = xmlLibrary->GetPropVal(LOWORD(_uInfoId) == TPI_INFO_SUPPORTED_TYPE ? wxT("typename") : wxT("suffix"), wxEmptyString);
		break;
	}
	default:
		return TPI_ERROR_D_UNSUPPORTED;
	}
	return TPI_ERROR_SUCCESS;
}

int __stdcall LoadPlugin
(
	const wxString & _szArcName,
	wxULongLong _llSubOption
)
{
	// pXݒB
	wxStandardPaths p;
	g_szAppPath = wxPathOnly(p.GetExecutablePath());

	// xml͊JnB
	wxXmlDocument config(g_szAppPath + wxT("/lib/cuiWrapper.xml"));
	if (! config.IsOk())
	{
		return TPI_ERROR_UNDEFINED;
	}
	// Cɐ擪̃Cȕ擾B
	wxXmlNode * xmlLibrary = config.GetRoot()->GetChildren();

	// Ώۂ݂ȂΑΉ郉Cu𒲍A
	// Ώۂ݂ȂȂΎwꂽCu[hB
	if (! ::wxFileExists(_szArcName))
	{
		// KȈʒu܂ňړB
		int u = 0;
		for (unsigned int i = 0; i < _llSubOption && xmlLibrary != NULL; u++)
		{
			xmlLibrary = xmlLibrary->GetNext();
			if (xmlLibrary != NULL && xmlLibrary->HasProp(wxT("suffix")))
			{
				i++;
			}
		}
		g_LibInfo.nLibIndex = u;
		if (xmlLibrary == NULL || xmlLibrary->GetName() != wxT("library"))
		{
			// xml@G[B
			return TPI_ERROR_UNDEFINED;
		}

		g_LibInfo.szLibName = xmlLibrary->GetPropVal(wxT("name"),   wxEmptyString);
		g_LibInfo.szSuffix  = xmlLibrary->GetPropVal(wxT("suffix"), wxEmptyString);

		// t@C̑݊mFB
		return ::wxFileExists(g_LibInfo.szLibName) ? TPI_ERROR_SUCCESS : TPI_ERROR_U_LOAD_LIBRARY;
	}

	// [vɊׂȂ悤ݒB
	for (g_LibInfo.nLibIndex = 0; g_LibInfo.nLibIndex < 300 && xmlLibrary != NULL; g_LibInfo.nLibIndex++)
	{
		g_LibInfo.szLibName = xmlLibrary->GetPropVal(wxT("name"),   wxEmptyString);
		g_LibInfo.szSuffix  = xmlLibrary->GetPropVal(wxT("suffix"), wxEmptyString);

		// ɂɑΉĂ邩`FbNB
		if (CheckArchive(_szArcName, NULL) == TPI_ERROR_SUCCESS)
		{
			// ΉĂΏIB
			return TPI_ERROR_SUCCESS;
		}

		xmlLibrary = xmlLibrary->GetNext();
	}

	return TPI_ERROR_U_LOAD_LIBRARY;
}

int __stdcall FreePlugin
(
	void *
)
{
	return TPI_ERROR_SUCCESS;
}

int __stdcall CheckArchive
(
	const wxString & _szArcName,
	int * _nFileCount
)
{
	// gqŔB
	wxFileName fnArchive(_szArcName);
	wxString szRemainList = g_LibInfo.szSuffix, szExt = fnArchive.GetExt();
	while (! szRemainList.IsEmpty())
	{
		if (szRemainList.BeforeFirst(';') == szExt)
		{
			// t@CԂȂ̂łƂ肠0B
			* _nFileCount = 0;
			return TPI_ERROR_SUCCESS;
		}
		szRemainList = szRemainList.AfterFirst(';');
	}

	return TPI_ERROR_D_UNSUPPORTED;
}

int __stdcall OpenArchive
(
	const wxString & _szArcName,
	void * * _hArchive
)
{
	// o͕nhƂĎgpB
	wxArrayString asOutput, asError;
	long lErrorCode = wxExecute(g_LibInfo.szLibName, asOutput, asError);

	_hArchive = (void * *) & asOutput;
	return lErrorCode == 0 ? TPI_ERROR_SUCCESS : TPI_ERROR_UNDEFINED;
}

int __stdcall CloseArchive
(
	void * _hArchive
)
{
	return TPI_ERROR_SUCCESS;
}

int __stdcall GetFileInformation
(
	void * _hArchive,
	TPI_FILEINFO * _fiInfo,
	bool _bFirst
)
{
	static unsigned int s_uFileID;
	int nResult;

	if (_bFirst)
	{
		// ŏ̍s܂ŐiށB

		s_uFileID = 0;
	}

//	nResult = CalErrorCodeConvert(nResult);
//	if (nResult == TPI_ERROR_SUCCESS)
	{
/*
		if ((signed) _fiInfo->dwAttribute == -1)
		{
			_fiInfo->dwAttribute = 0;
		}

		wxString szFileName(iiInfo.szFileName, wxConvLibc), szMethod(iiInfo.szMode, wxConvLibc);
		szFileName.Replace(wxT("\\"), wxT("/"));
		_fiInfo->dwCRC32        = iiInfo.dwCRC;
		_fiInfo->uOSType        = iiInfo.uOSType;
		_fiInfo->llPackedSize   = iiInfo.dwCompressedSize;
		_fiInfo->llUnpackedSize = iiInfo.dwOriginalSize;
		_fiInfo->llFileID       = s_uFileID++;
		_fiInfo->ftAccessTime   = 0;
		_fiInfo->ftCreateTime   = 0;
		_fiInfo->tmModified.SetFromDOS(MAKELONG(iiInfo.wTime, iiInfo.wDate));
		_fiInfo->szFileName     = szFileName;
		_fiInfo->szMethod       = szMethod;
		_fiInfo->wCompressRatio = iiInfo.wRatio;
*/
	}
	return TPI_ERROR_SUCCESS;

//	return nResult;
}

int __stdcall GetArchiveInformation
(
	void * _hArchive,
	TPI_ARCHIVEINFO * _aiInfo
)
{
	return TPI_ERROR_SUCCESS;
}

int __stdcall Command
(
	unsigned int _uCommand,
	TPI_SWITCHES * _swInfo,
	const wxString & _szArcName,
	const wxArrayString & _szFiles
)
{
	// IniR}hC擾B
	wxString szPath, szCommandLine, szCommandLineSend;
	// xml͊JnB
	wxXmlDocument config(g_szAppPath + wxT("/lib/cuiWrapper.xml"));
	// Cɐ擪̃Cȕ擾B
	wxXmlNode * xmlLibrary = config.GetRoot()->GetChildren();

	// KȈʒu܂ňړB
	for (unsigned int i = 0; i < g_LibInfo.nLibIndex && xmlLibrary != NULL; i++)
	{
		xmlLibrary = xmlLibrary->GetNext();
	}
	if (xmlLibrary->GetName() != wxT("library"))
	{
		// xml@G[B
		return TPI_ERROR_UNDEFINED;
	}

	if (! xmlLibrary->GetPropVal(
		_uCommand == TPI_COMMAND_ADD     ? wxT("add") :
		_uCommand == TPI_COMMAND_EXTRACT ? wxT("extract") : 
		_uCommand == TPI_COMMAND_DELETE  ? wxT("delete") : 
		_uCommand == TPI_COMMAND_UPDATE  ? wxT("update") : 
		_uCommand == TPI_COMMAND_TEST    ? wxT("test") : 
		_uCommand == TPI_COMMAND_REPAIR  ? wxT("repair") : 
		_uCommand == TPI_COMMAND_MOVE    ? wxT("move") : 
		_uCommand == TPI_COMMAND_SFX     ? wxT("sfx") : 
		_uCommand == TPI_COMMAND_UNSFX   ? wxT("unsfx") : wxEmptyString, & szCommandLine))
	{
		return TPI_ERROR_D_UNSUPPORTED;
	}

	// R}hCϐւB
	for (size_t i = 0; i < szCommandLine.Len(); i++)
	{
		if (szCommandLine[i] == '%')
		{
			// ϐ͊JnB
			switch (szCommandLine[++i])
			{
			case '-':
				// ꕶB
				szCommandLineSend += szCommandLine[++i];
				break;
			case '9':
				switch (szCommandLine[++i])
				{
				case '0':
				{
					// ɖB
					wxString s = _szArcName;
					s.Replace(wxT("/"), wxT("\\"));
					szCommandLineSend += s;
					break;
				}
				case '1':
				{
					// o͐B
					wxString s = _swInfo->szDestinationDirectory;
					s.Replace(wxT("/"), wxT("\\"));
					szCommandLineSend += s;
					break;
				}
				case '2':
					// X|Xt@CB
					szCommandLineSend += ::wxGetCwd() + wxT("\\__callib__listfile");
					break;
				case '3':
					// t@CXgB
					for (size_t j = 0; j < _szFiles.GetCount(); j++)
					{
						szCommandLineSend += wxT("\"") + _szFiles[j] + wxT("\" ");
					}
					break;
				}
				break;
			case 'a':
				switch (szCommandLine[++i])
				{
				case '0':
					// pXLɂ邩B
					if (szCommandLine[++i] == '{')
					{
						// ʁB
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != '|'; i++)
						{
							if (_swInfo->fStoreDirectoryPathes)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != '}'; i++)
						{
							if (! _swInfo->fStoreDirectoryPathes)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
					}
					else
					{
						// boollԋpB
						szCommandLineSend += _swInfo->fStoreDirectoryPathes ? '1' : '0';
						i--;
					}
					break;
				case '1':
					// SFX쐬邩B
					if (szCommandLine[++i] == '{')
					{
						// ʁB
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != '|'; i++)
						{
							if (_swInfo->fMakeSFX)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
						for (i++; i < szCommandLine.Len() && szCommandLine[i] != '}'; i++)
						{
							if (! _swInfo->fMakeSFX)
							{
								szCommandLineSend += szCommandLine[i];
							}
						}
					}
					else
					{
						// boollԋpB
						szCommandLineSend += _swInfo->fMakeSFX ? '1' : '0';
						i--;
					}
					break;
				}
				break;
			}
		}
		else
		{
			szCommandLineSend += szCommandLine[i];
		}
	}

	// 蔲X|Xt@CB
	wxFile fListFile;
	if (! fListFile.Create(::wxGetCwd() + wxT("/__callib__listfile"), true))
	{
		return TPI_ERROR_UNDEFINED;
	}

	// t@CXgݏB
	if (_szFiles.GetCount() == 0)
	{
		fListFile.Write(wxT("*"));
	}
	else
	{
		// pŊďB
		for (size_t i = 0; i < _szFiles.GetCount(); i++)
		{
			fListFile.Write(wxT("\"") + _szFiles[i] + wxT("\"\r\n"));
		}
	}
	fListFile.Close();

	// R}hCsB
	wxArrayString asOutput, asError;
	int nErrorCode = wxExecute(szCommandLineSend, asOutput, asError);
	if (nErrorCode != 0)
	{
//		wxString sz(szOutput, *wxConvCurrent);
//		szPath.Printf(wxT("Error :\n%x\n\nCommandLine:\n%s\n\nOutput:\n%s"), nErrorCode, szCommandLineSend.c_str(), sz.c_str());
//		::wxMessageBox(szPath);
//		MessageBox(NULL, szPath.c_str(), NULL, 0);
	}

	// X|Xt@C폜B
	::wxRemoveFile(::wxGetCwd() + wxT("/__callib__listfile"));

	return nErrorCode == 0 ? TPI_ERROR_SUCCESS : TPI_ERROR_UNDEFINED;
}

int __stdcall SetCallbackProc
(
	TPI_PROC _prArcProc
)
{
	// TODO : stdout/stderrĎB
	return TPI_ERROR_SUCCESS;
}

#ifdef __cplusplus
}
#endif
