// calLibrary - winecaller
// $Id: calLibrary.cpp,v 1.13 2006/08/20 13:22:27 sirakaba Exp $

/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include <windows.h>
#include <stdio.h>
#include "libwinecaller.h"

//******************************************************************************
//    Global varients
//******************************************************************************

struct g_LibInfo
{
	HMODULE hLib;
	char szLibName[513];
	char szPrefix[20];
	unsigned int nLibIndex;
}	g_LibInfo;

//******************************************************************************
//    Substitute APIs
//******************************************************************************

int WINAPI CommandP(const HWND, const char * szCmdLine, char *, const DWORD)
{
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, g_LibInfo.szPrefix);
	return ((int (WINAPI *)(const HWND, const char *, char *, DWORD)) fpProc)(NULL, szCmdLine, NULL, 0);
}

BOOL WINAPI CheckArchiveP(const char * szArcName, const int)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sCheckArchive", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);

	return ((BOOL (WINAPI *)(const char *, const int)) fpProc)(szArcName, 0);
}

int WINAPI GetFileCount(const char * szArcName)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetFileCount", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((int (WINAPI *)(const char *)) fpProc)(szArcName);
}

void * WINAPI OpenArchiveP(const HWND, const char * szArcName, const DWORD)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sOpenArchive", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((void * (WINAPI *)(const HWND, LPCSTR, const DWORD)) fpProc)(NULL, szArcName, 0);
}

int WINAPI CloseArchive(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sCloseArchive", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((int (WINAPI *)(void *)) fpProc)(hArc);
}

int WINAPI FindFirst(void * hArc, LPCSTR szFileName, void * iiInfo)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sFindFirst", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((int (WINAPI *)(void *, LPCSTR, void *)) fpProc)(hArc, szFileName, iiInfo);
}

int WINAPI FindNext(void * hArc, void * iiInfo)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sFindNext", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((int (WINAPI *)(void *, void *)) fpProc)(hArc, iiInfo);
}

int WINAPI GetArcFileName(void * hArc, char * szArcName, const int nBuffer)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcFileName", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((int (WINAPI *)(void *, char *, const int)) fpProc)(hArc, szArcName, nBuffer);
}

DWORD WINAPI GetArcFileSize(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcFileSize", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((DWORD (WINAPI *)(void *)) fpProc)(hArc);
}

BOOL WINAPI GetArcFileSizeEx(void * hArc, LONGLONG * ll)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcFileSizeEx", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(void *, LONGLONG *)) fpProc)(hArc, ll);
}

DWORD WINAPI GetArcOriginalSize(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcOriginalSize", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((DWORD (WINAPI *)(void *)) fpProc)(hArc);
}

BOOL WINAPI GetArcOriginalSizeEx(void * hArc, LONGLONG * ll)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcOriginalSizeEx", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(void *, LONGLONG *)) fpProc)(hArc, ll);
}

DWORD WINAPI GetArcCompressedSize(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcCompressedSize", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((DWORD (WINAPI *)(void *)) fpProc)(hArc);
}

BOOL WINAPI GetArcCompressedSizeEx(void * hArc, LONGLONG * ll)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcCompressedSizeEx", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(void *, LONGLONG *)) fpProc)(hArc, ll);
}

WORD WINAPI GetArcRatio(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcRatio", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((WORD (WINAPI *)(void *)) fpProc)(hArc);
}

BOOL WINAPI GetArcCreateTimeEx(void * hArc, FILETIME * ft)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcCreateTimeEx", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(void *, FILETIME *)) fpProc)(hArc, ft);
}

BOOL WINAPI GetArcAccessTimeEx(void * hArc, FILETIME * ft)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcAccessTimeEx", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(void *, FILETIME *)) fpProc)(hArc, ft);
}

BOOL WINAPI GetArcWriteTimeEx(void * hArc, FILETIME * ft)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcWriteTimeEx", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(void *, FILETIME *)) fpProc)(hArc, ft);
}

UINT WINAPI GetArcOSType(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcOSType", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((UINT (WINAPI *)(void *)) fpProc)(hArc);
}

int WINAPI IsSFXFile(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sIsSFXFile", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((int (WINAPI *)(void *)) fpProc)(hArc);
}

DWORD WINAPI GetArcReadSize(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcReadSize", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((DWORD (WINAPI *)(void *)) fpProc)(hArc);
}

BOOL WINAPI GetArcReadSizeEx(void * hArc, LONGLONG * ll)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetArcReadSizeEx", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(void *, LONGLONG *)) fpProc)(hArc, ll);
}

int WINAPI GetAttribute(void * hArc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sGetAttribute", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((int (WINAPI *)(void *)) fpProc)(hArc);
}

BOOL WINAPI SetOwnerWindowEx(HWND hWnd, FARPROC lpArcProc)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sSetOwnerWindowEx", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(HWND, FARPROC)) fpProc)(hWnd, lpArcProc);
}

BOOL WINAPI SetOwnerWindowEx64(HWND hWnd, FARPROC lpArcProc, DWORD dw)
{
	char szAPIName[50];
	sprintf(szAPIName, "%sSetOwnerWindowEx64", g_LibInfo.szPrefix);
	FARPROC fpProc = ::GetProcAddress(g_LibInfo.hLib, szAPIName);
	return ((BOOL (WINAPI *)(HWND, FARPROC, DWORD)) fpProc)(hWnd, lpArcProc, dw);
}


//******************************************************************************
//    Functions
//******************************************************************************

extern "C" void init_pthread_functions(void);
extern "C" void __wine_process_init(void);

HMODULE WINAPI LoadLibraryP(LPCSTR szLibName, LPCSTR szPrefix)
{
	init_pthread_functions();
	__wine_process_init();
	strncpy(g_LibInfo.szLibName, szLibName, sizeof(g_LibInfo.szLibName) - 1);
	strncpy(g_LibInfo.szPrefix,  szPrefix,  sizeof(g_LibInfo.szPrefix)  - 1);
	g_LibInfo.hLib = ::LoadLibrary(szLibName);
	return g_LibInfo.hLib;
}

BOOL WINAPI FreeLibraryP(HMODULE)
{
	return ::FreeLibrary(g_LibInfo.hLib);
}

FARPROC WINAPI GetProcAddressP(HMODULE hModule, LPCSTR lpProcName)
{
	LPCSTR pAPIName = lpProcName + lstrlen(g_LibInfo.szPrefix);
	return
		lstrcmp(pAPIName, "CheckArchive")           == 0 ? (FARPROC) CheckArchiveP :
		lstrcmp(pAPIName, "GetFileCount")           == 0 ? (FARPROC) GetFileCount :
		lstrcmp(pAPIName, "OpenArchive")            == 0 ? (FARPROC) OpenArchiveP :
		lstrcmp(pAPIName, "CloseArchive")           == 0 ? (FARPROC) CloseArchive :
		lstrcmp(pAPIName, "FindFirst")              == 0 ? (FARPROC) FindFirst :
		lstrcmp(pAPIName, "FindNext")               == 0 ? (FARPROC) FindNext :
		lstrcmp(pAPIName, "GetAttribute")           == 0 ? (FARPROC) GetAttribute :
		lstrcmp(pAPIName, "GetArcFileName")         == 0 ? (FARPROC) GetArcFileName :
		lstrcmp(pAPIName, "GetArcFileSizeEx")       == 0 ? (FARPROC) GetArcFileSizeEx :
		lstrcmp(pAPIName, "GetArcFileSize")         == 0 ? (FARPROC) GetArcFileSize :
		lstrcmp(pAPIName, "GetArcOriginalSizeEx")   == 0 ? (FARPROC) GetArcOriginalSizeEx :
		lstrcmp(pAPIName, "GetArcOriginalSize")     == 0 ? (FARPROC) GetArcOriginalSize :
		lstrcmp(pAPIName, "GetArcCompressedSizeEx") == 0 ? (FARPROC) GetArcCompressedSizeEx :
		lstrcmp(pAPIName, "GetArcCompressedSize")   == 0 ? (FARPROC) GetArcCompressedSize :
		lstrcmp(pAPIName, "GetArcReadSizeEx")       == 0 ? (FARPROC) GetArcReadSizeEx :
		lstrcmp(pAPIName, "GetArcReadSize")         == 0 ? (FARPROC) GetArcReadSizeEx :
		lstrcmp(pAPIName, "GetArcRatio")            == 0 ? (FARPROC) GetArcRatio :
		lstrcmp(pAPIName, "GetArcAccessTimeEx")     == 0 ? (FARPROC) GetArcAccessTimeEx :
		lstrcmp(pAPIName, "GetArcCreateTimeEx")     == 0 ? (FARPROC) GetArcCreateTimeEx :
		lstrcmp(pAPIName, "GetArcWriteTimeEx")      == 0 ? (FARPROC) GetArcWriteTimeEx :
		lstrcmp(pAPIName, "GetArcOSType")           == 0 ? (FARPROC) GetArcOSType :
		lstrcmp(pAPIName, "IsSFXFile")              == 0 ? (FARPROC) IsSFXFile :
		lstrcmp(pAPIName, "SetOwnerWindowEx64")     == 0 ? (FARPROC) SetOwnerWindowEx64 :
		lstrcmp(pAPIName, "SetOwnerWindowEx")       == 0 ? (FARPROC) SetOwnerWindowEx :
		(FARPROC) CommandP;
}

UINT RegisterWindowMessageP(LPCSTR lpString)
{
	return ::RegisterWindowMessage(lpString);
}
