/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: dlg_make.cpp,v 1.9 2009/08/12 12:26:49 sirakaba Exp $
*******************************************************************************/

#include "frontend-wx.h"

#include "dlg_make.h"
#include "frm_main.h"
#include "functions.h"

#include <wx/dirdlg.h>

//******************************************************************************
// MakeDialog
//******************************************************************************

MakeDialog::MakeDialog(): wxDialog()
{
	this->bIsMake = true;
}

//******************************************************************************
// Event Table.
//******************************************************************************

BEGIN_EVENT_TABLE(MakeDialog, wxDialog)
	EVT_INIT_DIALOG(                 MakeDialog::OnInit)
	EVT_BUTTON(XRCID("btnDefault"),  MakeDialog::OnBtnDefault)
	EVT_BUTTON(XRCID("btnDesktop"),  MakeDialog::OnBtnDesktop)
	EVT_BUTTON(XRCID("btnCurrent"),  MakeDialog::OnBtnCurrent)
	EVT_BUTTON(XRCID("btnBrowse"),   MakeDialog::OnBtnBrowse)
	EVT_BUTTON(XRCID("btnBrowseKF"), MakeDialog::OnBtnBrowseKF)
	EVT_BUTTON(XRCID("btnOK"),       MakeDialog::OnBtnOK)
	EVT_BUTTON(XRCID("btnCancel"),   MakeDialog::OnBtnCancel)
	EVT_CHECKBOX(XRCID("cbUnmask"),  MakeDialog::OnCbUnmask)
	EVT_NOTEBOOK_PAGE_CHANGED(XRCID("nbTabs"), MakeDialog::OnTabChanged)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void MakeDialog::OnInit(wxInitDialogEvent&)
{
	// XRCƌтB
	// "General"^u
	this->cbDir             = XRCCTRL(* this, "cbDir",        wxComboBox);
	this->cbFileName        = XRCCTRL(* this, "cbFileName",   wxComboBox);
	this->cbOpenAfter       = XRCCTRL(* this, "cbOpenAfter",  wxCheckBox);
	this->cbIgnorePath      = XRCCTRL(* this, "cbIgnorePath", wxCheckBox);
	this->cbExitAfter       = XRCCTRL(* this, "cbExitAfter",  wxCheckBox);
	this->chType            = XRCCTRL(* this, "chType",       wxChoice);
	this->chDirMake         = XRCCTRL(* this, "chDirMake",    wxChoice);
	// "Config"^u
	this->scLevel           = XRCCTRL(* this, "scLevel",      wxSpinCtrl);
	this->scRR              = XRCCTRL(* this, "scRR",         wxSpinCtrl);
	this->tcPassword        = XRCCTRL(* this, "tcPassword",   wxTextCtrl);
	this->tcKeyfile         = XRCCTRL(* this, "tcKeyfile",    wxTextCtrl);
	this->cbSplitSize       = XRCCTRL(* this, "cbSplitSize",  wxComboBox);
	this->cbUnmask          = XRCCTRL(* this, "cbUnmask",     wxCheckBox);
	this->cbEncryptHeader   = XRCCTRL(* this, "cbEncryptHeader", wxCheckBox);
	this->cbSolid           = XRCCTRL(* this, "cbSolid",      wxCheckBox);
	this->cbMMOptimize      = XRCCTRL(* this, "cbMMOptimize", wxCheckBox);
	this->cbMakeSFX         = XRCCTRL(* this, "cbMakeSFX",    wxCheckBox);
	// "Comment"^u
	this->tcComment         = XRCCTRL(* this, "tcComment",    wxTextCtrl);
	// "Files"^u
	this->lcFiles           = XRCCTRL(* this, "lcFiles",      wxListCtrl);

	if (! this->cbDir->GetValue().IsEmpty())
	{
		return;
	}

	// ListCtrlɗǉB
	this->lcFiles->InsertColumn(0, wxT("Input"),  wxLIST_FORMAT_LEFT,  150);
	this->lcFiles->InsertColumn(1, wxT("Output"), wxLIST_FORMAT_LEFT,  300);

	::wxXmlResource::Get()->Unload(FE_DIR_S_XRC wxT("dlg_make.xrc"));

	// WJ͊eRg[̏ԂύXB
	if (! this->bIsMake)
	{
		this->cbFileName->Disable();
		this->chType->Disable();
		this->chDirMake->Enable();
		this->scLevel->Disable();
		this->scRR->Disable();
		this->cbSplitSize->Disable();
		this->cbEncryptHeader->Disable();
		this->cbSolid->Disable();
		this->cbMMOptimize->Disable();
		this->cbMakeSFX->Disable();
		this->tcComment->SetEditable(false);

		// lݒB
		wxFileName fnArchive(((MainFrame *) this->GetParent())->statusbar->GetStatusText(5));
		this->cbDir->SetValue(fnArchive.GetPath());
		this->cbFileName->SetValue(fnArchive.GetFullName());

		// t@CXgǉB
		for (size_t i = 0; i < this->files.Count(); i++)
		{
			this->lcFiles->InsertItem(i, this->files[i]);
		}

		return;
	}

	// CuB
	TPIHandle tpi;
	wxFileSystem fs;
	fs.ChangePathTo(FE_DIR_B_LIB, true);
	wxString szTPIName = fs.FindFirst(wxT("*" TPI_EXT), wxFILE);
	while (! szTPIName.IsEmpty())
	{
		// [hB
		if (tpi.InitLibrary(szTPIName, wxEmptyString, 0))
		{
			// Ή`擾B
			wxString type;
			for (wxULongLong i = 0; tpi.GetPluginInformation(TPI_INFO_SUPPORTED_TYPE, i, & type) == TPI_ERROR_SUCCESS; i++)
			{
				if (! type.IsEmpty())
				{
					this->libname.Add(szTPIName);
					this->chType->Append(type);
					tpi.GetPluginInformation(TPI_INFO_SUPPORTED_SUFFIX, i, & type);
					this->defext.Add(type.BeforeFirst(wxT(';')));
				}
			}

			tpi.FreeLibrary();
		}
		szTPIName = fs.FindNext();
	}
	this->chType->SetSelection(0);
}

void MakeDialog::OnBtnDefault(wxCommandEvent&)
{
}

void MakeDialog::OnBtnDesktop(wxCommandEvent&)
{
	wxFileName fn(wxFileName::GetHomeDir(), wxT("Desktop"));
	this->cbDir->SetValue(fn.GetFullPath());
}

void MakeDialog::OnBtnCurrent(wxCommandEvent&)
{
	this->cbDir->SetValue(wxFileName::FileName(((MainFrame *) this->GetParent())->statusbar->GetStatusText(5)).GetPath());
}

void MakeDialog::OnBtnBrowse(wxCommandEvent&)
{
	wxDirDialog dd(this, wxDirSelectorPromptStr, this->cbDir->GetValue());
	if (dd.ShowModal() == wxID_OK)
	{
		this->cbDir->SetValue(dd.GetPath());
	}
}

void MakeDialog::OnBtnBrowseKF(wxCommandEvent&)
{
	wxFileDialog fd(this, wxFileSelectorPromptStr);
	if (fd.ShowModal() == wxID_OK)
	{
		this->tcKeyfile->SetValue(fd.GetPath());
	}
}

void MakeDialog::OnBtnOK(wxCommandEvent&)
{
	this->EndModal(wxID_OK);
}

void MakeDialog::OnBtnCancel(wxCommandEvent&)
{
	this->EndModal(wxID_CANCEL);
}

void MakeDialog::OnCbUnmask(wxCommandEvent&)
{
	this->tcPassword->SetWindowStyle(this->tcPassword->GetWindowStyle() & (this->cbUnmask->IsChecked() ? ~ wxTE_PASSWORD : wxTE_PASSWORD));
	this->tcPassword->Refresh();
}

void MakeDialog::OnTabChanged(wxNotebookEvent& e)
{
	// "Files"^ûƂ͏B
	if (! this->bIsMake && e.GetSelection() == 3)
	{
		// t@C̏o͐𐄑B
		wxString szOutputRootDir = WillMakeDirByArcName((MainFrame *) this->GetParent(), this) ? MakeDirPath(wxFileName::DirName(this->cbDir->GetValue()), this->cbFileName->GetValue(), false).GetPath() : this->cbDir->GetValue();

		// et@CɃpXtB
		for (size_t i = 0; i < this->files.Count(); i++)
		{
			wxString szOutputFile = szOutputRootDir + wxFileName::GetPathSeparator();
			wxFileName fnStored(this->files[i]);
			if (! this->cbIgnorePath->IsChecked())
			{
				szOutputFile += fnStored.GetPathWithSep();
			}
			szOutputFile += fnStored.GetFullName();
			wxFileName fnOutput(szOutputFile);
			this->lcFiles->SetItem(i, 1, fnOutput.GetFullPath());
		}
	}
}
